"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const utils_fs_1 = require("@ionic/utils-fs");
const path = require("path");
const __1 = require("../");
const npm_1 = require("../../utils/npm");
const config_1 = require("./config");
class Integration extends __1.BaseIntegration {
    constructor() {
        super(...arguments);
        this.name = 'capacitor';
        this.summary = `Target native iOS and Android with Capacitor, Ionic's new native layer`;
        this.archiveUrl = undefined;
    }
    add(details, handlers = {}) {
        const _super = Object.create(null, {
            add: { get: () => super.add }
        });
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            let name = this.e.project.config.get('name');
            let packageId = 'io.ionic.starter';
            if (details.enableArgs) {
                if (details.enableArgs[0]) {
                    name = details.enableArgs[0];
                }
                if (details.enableArgs[1]) {
                    packageId = details.enableArgs[1];
                }
            }
            yield this.installCapacitorCore();
            yield this.installCapacitorCLI();
            yield utils_fs_1.mkdirp(details.root);
            yield this.e.shell.run('capacitor', ['init', name, packageId], { cwd: details.root });
            yield _super.add.call(this, details, handlers);
        });
    }
    installCapacitorCore() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [manager, ...managerArgs] = yield npm_1.pkgManagerArgs(this.e.config.get('npmClient'), { command: 'install', pkg: '@capacitor/core' });
            yield this.e.shell.run(manager, managerArgs, { cwd: this.e.project.directory });
        });
    }
    installCapacitorCLI() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [manager, ...managerArgs] = yield npm_1.pkgManagerArgs(this.e.config.get('npmClient'), { command: 'install', pkg: '@capacitor/cli' });
            yield this.e.shell.run(manager, managerArgs, { cwd: this.e.project.directory });
        });
    }
    personalize({ name, packageId }) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const conf = new config_1.CapacitorConfig(path.resolve(this.e.project.directory, config_1.CAPACITOR_CONFIG_FILE));
            conf.set('appName', name);
            if (packageId) {
                conf.set('appId', packageId);
            }
        });
    }
    getInfo() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [[capacitorCorePkg, capacitorCorePkgPath], capacitorCLIVersion,] = yield Promise.all([
                this.e.project.getPackageJson('@capacitor/core'),
                this.getCapacitorCLIVersion(),
            ]);
            const info = [
                { group: 'capacitor', key: 'capacitor', flair: 'Capacitor CLI', value: capacitorCLIVersion || 'not installed' },
                { group: 'capacitor', key: '@capacitor/core', value: capacitorCorePkg ? capacitorCorePkg.version : 'not installed', path: capacitorCorePkgPath },
            ];
            return info;
        });
    }
    getCapacitorCLIVersion() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return this.e.shell.cmdinfo('capacitor', ['--version'], { cwd: this.e.project.directory });
        });
    }
}
exports.Integration = Integration;
