"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const utils_fs_1 = require("@ionic/utils-fs");
const path = require("path");
function getAndroidSdkToolsVersion() {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const androidHome = yield locateSDKHome();
        if (androidHome) {
            try {
                const f = yield utils_fs_1.readFile(path.join(androidHome, 'tools', 'source.properties'), { encoding: 'utf8' });
                return `${yield parseSDKVersion(f)} (${androidHome})`;
            }
            catch (e) {
                if (e.code !== 'ENOENT') {
                    throw e;
                }
            }
        }
    });
}
exports.getAndroidSdkToolsVersion = getAndroidSdkToolsVersion;
function locateSDKHome() {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return process.env.ANDROID_HOME || process.env.ANDROID_SDK_ROOT;
    });
}
exports.locateSDKHome = locateSDKHome;
function parseSDKVersion(contents) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        for (const l of contents.split('\n')) {
            const [a, b] = l.split('=');
            if (a === 'Pkg.Revision') {
                return b;
            }
        }
    });
}
exports.parseSDKVersion = parseSDKVersion;
