import * as et from 'elementtree';
import { ProjectIntegration, ResourcesPlatform } from '../../../definitions';
export interface PlatformEngine {
    name: string;
    spec: string;
    [key: string]: string;
}
export declare class ConfigXml {
    readonly filePath: string;
    protected _doc?: et.ElementTree;
    protected _sessionid?: string;
    protected saving: boolean;
    constructor(filePath: string);
    readonly doc: et.ElementTree;
    readonly sessionid: string;
    static load(filePath: string): Promise<ConfigXml>;
    reload(): Promise<void>;
    save(): Promise<void>;
    setName(name: string): void;
    setBundleId(bundleId: string): void;
    getBundleId(): string | undefined;
    /**
     * Update config.xml content src to be a dev server url. As part of this
     * backup the original content src for a reset to occur at a later time.
     */
    writeContentSrc(newSrc: string): void;
    /**
     * Set config.xml src url back to its original url
     */
    resetContentSrc(): void;
    getPreference(prefName: string): string | undefined;
    getProjectInfo(): {
        id: string;
        name: string;
        version: string;
    };
    getPlatformEngines(): PlatformEngine[];
    getPlatformEngine(platform: string): PlatformEngine | undefined;
    ensurePlatformImages(platform: string, resourcesPlatform: ResourcesPlatform): Promise<void>;
    ensureSplashScreenPreferences(): Promise<void>;
    protected write(): string;
    protected engineElementToPlatformEngine(engine: et.Element): PlatformEngine;
}
export declare function loadConfigXml(integration: Required<ProjectIntegration>): Promise<ConfigXml>;
