import { BaseIntegration } from '../';
import { InfoItem, IntegrationName, ProjectPersonalizationDetails } from '../../../definitions';
export declare class Integration extends BaseIntegration {
    readonly name: IntegrationName;
    readonly summary = "Target native iOS and Android with Apache Cordova";
    readonly archiveUrl = "https://d2ql0qc7j8u4b2.cloudfront.net/integration-cordova.tar.gz";
    getInfo(): Promise<InfoItem[]>;
    personalize({ name, packageId }: ProjectPersonalizationDetails): Promise<void>;
    getCordovaVersion(): Promise<string | undefined>;
    getCordovaPlatformVersions(): Promise<string>;
    getCordovaPluginVersions(): Promise<string>;
    getXcodebuildVersion(): Promise<string | undefined>;
    getIOSDeployVersion(): Promise<string | undefined>;
    getIOSSimVersion(): Promise<string | undefined>;
}
