"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const array_1 = require("@ionic/cli-framework/utils/array");
const utils_fs_1 = require("@ionic/utils-fs");
const path = require("path");
function getPlatforms(projectDir) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const platformsDir = path.resolve(projectDir, 'platforms');
        const contents = yield utils_fs_1.readdirSafe(platformsDir);
        const platforms = yield array_1.filter(contents, (file) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const stat = yield utils_fs_1.statSafe(path.join(platformsDir, file));
            return !file.startsWith('.') && typeof stat !== 'undefined' && stat.isDirectory();
        }));
        return platforms;
    });
}
exports.getPlatforms = getPlatforms;
