"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cli_framework_1 = require("@ionic/cli-framework");
/**
 * Filter and gather arguments from command line to be passed to Cordova
 */
function filterArgumentsForCordova(metadata, options) {
    const m = Object.assign({}, metadata);
    if (!m.options) {
        m.options = [];
    }
    const globalCordovaOpts = [
        {
            name: 'verbose',
            summary: '',
            type: Boolean,
            groups: ['cordova-cli'],
        },
        {
            name: 'nosave',
            summary: '',
            type: Boolean,
            groups: ['cordova-cli'],
        },
    ];
    m.options.push(...globalCordovaOpts);
    const results = cli_framework_1.filterCommandLineOptionsByGroup(m.options, options, 'cordova-cli');
    const args = cli_framework_1.unparseArgs(results, { useEquals: false, allowCamelCase: true });
    const i = args.indexOf('--');
    if (i >= 0) {
        args.splice(i, 1); // join separated args onto main args, use them verbatim
    }
    return [m.name, ...args];
}
exports.filterArgumentsForCordova = filterArgumentsForCordova;
function generateOptionsForCordovaBuild(metadata, inputs, options) {
    const [platform] = inputs;
    const includesAppScriptsGroup = cli_framework_1.OptionFilters.includesGroups('app-scripts');
    const excludesCordovaGroup = cli_framework_1.OptionFilters.excludesGroups('cordova-cli');
    const results = cli_framework_1.filterCommandLineOptions(metadata.options ? metadata.options : [], options, o => excludesCordovaGroup(o) || includesAppScriptsGroup(o));
    return Object.assign({}, results, { externalAddressRequired: options['native-run'] ? false : true, nobrowser: true, engine: 'cordova', platform: platform ? platform : (options['platform'] ? String(options['platform']) : undefined) });
}
exports.generateOptionsForCordovaBuild = generateOptionsForCordovaBuild;
