import { IConfig, IIntegration, ILogger, IProject, IShell, InfoItem, IntegrationAddDetails, IntegrationAddHandlers, IntegrationName, ProjectPersonalizationDetails } from '../../definitions';
import * as ζcapacitor from './capacitor';
import * as ζcordova from './cordova';
export { INTEGRATION_NAMES } from '../../guards';
export interface IntegrationOptions {
    quiet?: boolean;
}
export interface IntegrationDeps {
    readonly config: IConfig;
    readonly shell: IShell;
    readonly project: IProject;
    readonly log: ILogger;
}
export declare abstract class BaseIntegration implements IIntegration {
    protected readonly e: IntegrationDeps;
    abstract readonly name: IntegrationName;
    abstract readonly summary: string;
    abstract readonly archiveUrl?: string;
    constructor(e: IntegrationDeps);
    static createFromName(deps: IntegrationDeps, name: 'capacitor'): Promise<ζcapacitor.Integration>;
    static createFromName(deps: IntegrationDeps, name: 'cordova'): Promise<ζcordova.Integration>;
    static createFromName(deps: IntegrationDeps, name: IntegrationName): Promise<IIntegration>;
    getInfo(): Promise<InfoItem[]>;
    enable(): Promise<void>;
    disable(): Promise<void>;
    personalize(details: ProjectPersonalizationDetails): Promise<void>;
    add(details: IntegrationAddDetails, handlers?: IntegrationAddHandlers): Promise<void>;
}
