"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const Debug = require("debug");
const debug = Debug('ionic:lib:open');
function open(target, options = {}) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const opn = yield Promise.resolve().then(() => require('opn'));
        const p = yield opn(target, Object.assign({}, options, { wait: false }));
        p.on('error', err => {
            debug('Error during open: %O', err);
        });
    });
}
exports.open = open;
