"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const build_1 = require("../../build");
const NG_BUILD_OPTIONS = [
    {
        name: 'configuration',
        aliases: ['c'],
        summary: 'Specify the configuration to use.',
        type: String,
        groups: [cli_framework_1.OptionGroup.Advanced],
        hint: chalk_1.default.dim('[ng]'),
        spec: { value: 'conf' },
    },
];
class AngularBuildRunner extends build_1.BuildRunner {
    constructor(e) {
        super();
        this.e = e;
    }
    getCommandMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                groups: [cli_framework_1.CommandGroup.Beta],
                description: `
${chalk_1.default.green('ionic build')} uses the Angular CLI. Use ${chalk_1.default.green('ng build --help')} to list all Angular CLI options for building your app. See the ${chalk_1.default.green('ng build')} docs[^ng-build-docs] for explanations. Options not listed below are considered advanced and can be passed to the ${chalk_1.default.green('ng')} CLI using the ${chalk_1.default.green('--')} separator after the Ionic CLI arguments. See the examples.
`,
                footnotes: [
                    {
                        id: 'ng-build-docs',
                        url: 'https://angular.io/cli/build',
                    },
                ],
                options: [
                    {
                        name: 'prod',
                        summary: `Flag to use the ${chalk_1.default.green('production')} configuration`,
                        type: Boolean,
                        hint: chalk_1.default.dim('[ng]'),
                    },
                    {
                        name: 'source-map',
                        summary: 'Output source maps',
                        type: Boolean,
                        groups: [cli_framework_1.OptionGroup.Advanced],
                        hint: chalk_1.default.dim('[ng]'),
                    },
                    ...NG_BUILD_OPTIONS,
                    {
                        name: 'cordova-assets',
                        summary: 'Do not bundle Cordova assets during Cordova build',
                        type: Boolean,
                        groups: [cli_framework_1.OptionGroup.Hidden],
                        default: true,
                    },
                ],
                exampleCommands: [
                    '--prod',
                ],
            };
        });
    }
    createOptionsFromCommandLine(inputs, options) {
        const baseOptions = super.createBaseOptionsFromCommandLine(inputs, options);
        const prod = options['prod'] ? Boolean(options['prod']) : undefined;
        const configuration = options['configuration'] ? String(options['configuration']) : (prod ? 'production' : undefined);
        const sourcemaps = typeof options['source-map'] === 'boolean' ? Boolean(options['source-map']) : undefined;
        const cordovaAssets = typeof options['cordova-assets'] === 'boolean' ? Boolean(options['cordova-assets']) : undefined;
        return Object.assign({}, baseOptions, { configuration,
            sourcemaps,
            cordovaAssets, type: 'angular' });
    }
    buildProject(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const ng = new AngularBuildCLI(this.e);
            yield ng.build(options);
        });
    }
}
exports.AngularBuildRunner = AngularBuildRunner;
class AngularBuildCLI extends build_1.BuildCLI {
    constructor() {
        super(...arguments);
        this.name = 'Angular CLI';
        this.pkg = '@angular/cli';
        this.program = 'ng';
        this.prefix = 'ng';
        this.script = build_1.BUILD_SCRIPT;
    }
    buildArgs(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { pkgManagerArgs } = yield Promise.resolve().then(() => require('../../utils/npm'));
            const args = yield this.buildOptionsToNgArgs(options);
            if (this.resolvedProgram === this.program) {
                return [...this.buildArchitectCommand(options), ...args];
            }
            else {
                const [, ...pkgArgs] = yield pkgManagerArgs(this.e.config.get('npmClient'), { command: 'run', script: this.script, scriptArgs: [...args] });
                return pkgArgs;
            }
        });
    }
    buildOptionsToNgArgs(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const args = {
                _: [],
                'source-map': options.sourcemaps !== false ? options.sourcemaps : 'false',
                'cordova-assets': options.cordovaAssets !== false ? undefined : 'false',
            };
            const projectArgs = [];
            let separatedArgs = options['--'];
            if (options.engine === 'cordova') {
                const integration = this.e.project.requireIntegration('cordova');
                args.platform = options.platform;
                if (this.e.project.rootDirectory !== integration.root) {
                    args.cordovaBasePath = integration.root;
                }
                separatedArgs = [];
            }
            if (this.resolvedProgram !== this.program) {
                if (options.configuration) {
                    projectArgs.push(`--configuration=${options.configuration}`);
                }
                if (options.project) {
                    projectArgs.push(`--project=${options.project}`);
                }
            }
            return [...cli_framework_1.unparseArgs(args), ...projectArgs, ...separatedArgs];
        });
    }
    buildArchitectCommand(options) {
        const cmd = options.engine === 'cordova' ? 'ionic-cordova-build' : 'build';
        const project = options.project ? options.project : 'app';
        return ['run', `${project}:${cmd}${options.configuration ? `:${options.configuration}` : ''}`];
    }
}
exports.AngularBuildCLI = AngularBuildCLI;
