import { Project } from '../';
import { IAilmentRegistry, InfoItem } from '../../../definitions';
import * as ζbuild from './build';
import * as ζgenerate from './generate';
import * as ζserve from './serve';
export declare class AngularProject extends Project {
    readonly type: 'angular';
    getInfo(): Promise<InfoItem[]>;
    detected(): Promise<boolean>;
    requireBuildRunner(): Promise<ζbuild.AngularBuildRunner>;
    requireServeRunner(): Promise<ζserve.AngularServeRunner>;
    requireGenerateRunner(): Promise<ζgenerate.AngularGenerateRunner>;
    registerAilments(registry: IAilmentRegistry): Promise<void>;
}
