"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const Debug = require("debug");
const lodash = require("lodash");
const __1 = require("../");
const debug = Debug('ionic:lib:project:angular');
class AngularProject extends __1.Project {
    constructor() {
        super(...arguments);
        this.type = 'angular';
    }
    getInfo() {
        const _super = Object.create(null, {
            getInfo: { get: () => super.getInfo }
        });
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [[ionicAngularPkg, ionicAngularPkgPath], [ionicAngularToolkitPkg, ionicAngularToolkitPkgPath], [angularCLIPkg, angularCLIPkgPath], [angularDevKitBuildAngularPkg, angularDevKitBuildAngularPkgPath], [angularDevKitSchematicsPkg, angularDevKitSchematicsPkgPath],] = yield Promise.all([
                this.getPackageJson('@ionic/angular'),
                this.getPackageJson('@ionic/angular-toolkit'),
                this.getPackageJson('@angular/cli'),
                this.getPackageJson('@angular-devkit/build-angular'),
                this.getPackageJson('@angular-devkit/schematics'),
            ]);
            return [
                ...(yield _super.getInfo.call(this)),
                { group: 'ionic', key: 'Ionic Framework', value: ionicAngularPkg ? `@ionic/angular ${ionicAngularPkg.version}` : 'not installed', path: ionicAngularPkgPath },
                { group: 'ionic', key: '@ionic/angular-toolkit', value: ionicAngularToolkitPkg ? ionicAngularToolkitPkg.version : 'not installed', path: ionicAngularToolkitPkgPath },
                { group: 'ionic', key: '@angular/cli', value: angularCLIPkg ? angularCLIPkg.version : 'not installed', path: angularCLIPkgPath },
                { group: 'ionic', key: '@angular-devkit/build-angular', value: angularDevKitBuildAngularPkg ? angularDevKitBuildAngularPkg.version : 'not installed', path: angularDevKitBuildAngularPkgPath },
                { group: 'ionic', key: '@angular-devkit/schematics', value: angularDevKitSchematicsPkg ? angularDevKitSchematicsPkg.version : 'not installed', path: angularDevKitSchematicsPkgPath },
            ];
        });
    }
    detected() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const pkg = yield this.requirePackageJson();
                const deps = lodash.assign({}, pkg.dependencies, pkg.devDependencies);
                if (typeof deps['@ionic/angular'] === 'string') {
                    debug(`${chalk_1.default.bold('@ionic/angular')} detected in ${chalk_1.default.bold('package.json')}`);
                    return true;
                }
            }
            catch (e) {
                // ignore
            }
            return false;
        });
    }
    requireBuildRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { AngularBuildRunner } = yield Promise.resolve().then(() => require('./build'));
            const deps = Object.assign({}, this.e, { project: this });
            return new AngularBuildRunner(deps);
        });
    }
    requireServeRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { AngularServeRunner } = yield Promise.resolve().then(() => require('./serve'));
            const deps = Object.assign({}, this.e, { project: this });
            return new AngularServeRunner(deps);
        });
    }
    requireGenerateRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { AngularGenerateRunner } = yield Promise.resolve().then(() => require('./generate'));
            const deps = Object.assign({}, this.e, { project: this });
            return new AngularGenerateRunner(deps);
        });
    }
    registerAilments(registry) {
        const _super = Object.create(null, {
            registerAilments: { get: () => super.registerAilments }
        });
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield _super.registerAilments.call(this, registry);
            // TODO: register angular project ailments
        });
    }
}
exports.AngularProject = AngularProject;
