"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const __1 = require("../");
const errors_1 = require("../../errors");
class BareProject extends __1.Project {
    constructor() {
        super(...arguments);
        this.type = 'bare';
    }
    detected() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    requireBuildRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            throw new errors_1.RunnerNotFoundException(`Cannot perform build for bare projects.\n` +
                `The Ionic CLI doesn't know how to build bare projects.`);
        });
    }
    requireServeRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            throw new errors_1.RunnerNotFoundException(`Cannot perform serve for bare projects.\n` +
                `The Ionic CLI doesn't know how to serve bare projects.`);
        });
    }
    requireGenerateRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            throw new errors_1.RunnerNotFoundException(`Cannot perform generate for bare projects.\n` +
                `The Ionic CLI doesn't know how to generate framework components for bare projects.`);
        });
    }
}
exports.BareProject = BareProject;
