"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const utils_network_1 = require("@ionic/utils-network");
const chalk_1 = require("chalk");
const Debug = require("debug");
const errors_1 = require("../errors");
const debug = Debug('ionic:lib:project:common');
/**
 * Convenience function for finding open ports of old-style projects.
 *
 * For `ionic-angular` and `ionic1`, Ionic provides the livereload server and
 * "dev logger" server.
 */
function findOpenIonicPorts(address, ports) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        try {
            const [port, livereloadPort, notificationPort] = yield Promise.all([
                utils_network_1.findClosestOpenPort(ports.port),
                utils_network_1.findClosestOpenPort(ports.livereloadPort),
                utils_network_1.findClosestOpenPort(ports.notificationPort),
            ]);
            if (ports.port !== port) {
                debug(`Port ${chalk_1.default.bold(String(ports.port))} taken, using ${chalk_1.default.bold(String(port))}.`);
                ports.port = port;
            }
            if (ports.livereloadPort !== livereloadPort) {
                debug(`Port ${chalk_1.default.bold(String(ports.livereloadPort))} taken, using ${chalk_1.default.bold(String(livereloadPort))}.`);
                ports.livereloadPort = livereloadPort;
            }
            if (ports.notificationPort !== notificationPort) {
                debug(`Port ${chalk_1.default.bold(String(ports.notificationPort))} taken, using ${chalk_1.default.bold(String(notificationPort))}.`);
                ports.notificationPort = notificationPort;
            }
            return { port, livereloadPort, notificationPort };
        }
        catch (e) {
            if (e.code !== 'EADDRNOTAVAIL') {
                throw e;
            }
            throw new errors_1.FatalException(`${chalk_1.default.green(address)} is not available--cannot bind.`);
        }
    });
}
exports.findOpenIonicPorts = findOpenIonicPorts;
