"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const build_1 = require("../../build");
const errors_1 = require("../../errors");
class CustomBuildRunner extends build_1.BuildRunner {
    constructor(e) {
        super();
        this.e = e;
    }
    getCommandMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {};
        });
    }
    createOptionsFromCommandLine(inputs, options) {
        const baseOptions = super.createBaseOptionsFromCommandLine(inputs, options);
        return Object.assign({}, baseOptions, { type: 'custom' });
    }
    buildProject(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const cli = this.getPkgManagerBuildCLI();
            if (!(yield cli.resolveScript())) {
                throw new errors_1.RunnerException(`Cannot perform build.\n` +
                    `Since you're using the ${chalk_1.default.bold('custom')} project type, you must provide the ${chalk_1.default.green(cli.script)} npm script so the Ionic CLI can build your project.`);
            }
            yield cli.build(options);
        });
    }
}
exports.CustomBuildRunner = CustomBuildRunner;
