"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const __1 = require("../");
const errors_1 = require("../../errors");
class CustomProject extends __1.Project {
    constructor() {
        super(...arguments);
        this.type = 'custom';
    }
    /**
     * We can't detect custom project types. We don't know what they look like!
     */
    detected() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return false;
        });
    }
    requireBuildRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { CustomBuildRunner } = yield Promise.resolve().then(() => require('./build'));
            const deps = Object.assign({}, this.e, { project: this });
            return new CustomBuildRunner(deps);
        });
    }
    requireServeRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { CustomServeRunner } = yield Promise.resolve().then(() => require('./serve'));
            const deps = Object.assign({}, this.e, { project: this });
            return new CustomServeRunner(deps);
        });
    }
    requireGenerateRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            throw new errors_1.RunnerNotFoundException(`Cannot perform generate for custom projects.\n` +
                `Since you're using the ${chalk_1.default.bold('custom')} project type, this command won't work. The Ionic CLI doesn't know how to generate framework components for custom projects.`);
        });
    }
}
exports.CustomProject = CustomProject;
