"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const utils_network_1 = require("@ionic/utils-network");
const chalk_1 = require("chalk");
const errors_1 = require("../../errors");
const serve_1 = require("../../serve");
class CustomServeRunner extends serve_1.ServeRunner {
    constructor(e) {
        super();
        this.e = e;
    }
    getCommandMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {};
        });
    }
    modifyOpenURL(url, options) {
        return url;
    }
    serveProject(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const cli = this.getPkgManagerServeCLI();
            if (!(yield cli.resolveScript())) {
                throw new errors_1.RunnerException(`Cannot perform serve.\n` +
                    `Since you're using the ${chalk_1.default.bold('custom')} project type, you must provide the ${chalk_1.default.green(cli.script)} npm script so the Ionic CLI can serve your project.`);
            }
            const [externalIP, availableInterfaces] = yield this.selectExternalIP(options);
            const port = options.port = yield utils_network_1.findClosestOpenPort(options.port);
            yield cli.serve(options);
            return {
                custom: true,
                protocol: 'http',
                localAddress: 'localhost',
                externalAddress: externalIP,
                externalNetworkInterfaces: availableInterfaces,
                port,
                externallyAccessible: ![serve_1.BIND_ALL_ADDRESS, ...serve_1.LOCAL_ADDRESSES].includes(externalIP),
            };
        });
    }
}
exports.CustomServeRunner = CustomServeRunner;
