"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const semver = require("semver");
const build_1 = require("../../build");
const doctor_1 = require("../../doctor");
const serve_1 = require("../../serve");
const npm_1 = require("../../utils/npm");
const build_2 = require("./build");
const serve_2 = require("./serve");
class IonicAngularAilment extends doctor_1.Ailment {
    constructor(deps) {
        super(deps);
        this.projects = ['ionic-angular'];
        this.project = deps.project;
    }
}
exports.IonicAngularAilment = IonicAngularAilment;
class IonicAngularUpdateAvailable extends IonicAngularAilment {
    constructor() {
        super(...arguments);
        this.id = 'ionic-angular-update-available';
    }
    getVersionPair() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!this.currentVersion || !this.latestVersion) {
                const [currentPkg] = yield this.project.getPackageJson('ionic-angular');
                const latestPkg = yield npm_1.pkgFromRegistry(this.config.get('npmClient'), { pkg: 'ionic-angular' });
                this.currentVersion = currentPkg ? currentPkg.version : undefined;
                this.latestVersion = latestPkg ? latestPkg.version : undefined;
            }
            if (!this.currentVersion || !this.latestVersion) {
                return ['0.0.0', '0.0.0'];
            }
            return [this.currentVersion, this.latestVersion];
        });
    }
    getMessage() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [currentVersion, latestVersion] = yield this.getVersionPair();
            return (`Update available for Ionic Framework.\n` +
                `An update is available for ${chalk_1.default.bold('ionic-angular')} (${chalk_1.default.cyan(currentVersion)} => ${chalk_1.default.cyan(latestVersion)}).\n`).trim();
        });
    }
    detected() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [currentVersion, latestVersion] = yield this.getVersionPair();
            const diff = semver.diff(currentVersion, latestVersion);
            return diff === 'minor' || diff === 'patch';
        });
    }
    getTreatmentSteps() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [, latestVersion] = yield this.getVersionPair();
            const args = yield npm_1.pkgManagerArgs(this.config.get('npmClient'), { command: 'install', pkg: `ionic-angular@${latestVersion ? latestVersion : 'latest'}` });
            return [
                { message: `Visit ${chalk_1.default.bold('https://github.com/ionic-team/ionic/releases')} for each upgrade's instructions` },
                { message: `If no instructions, run: ${chalk_1.default.green(args.join(' '))}` },
                { message: `Watch for npm warnings about peer dependencies--they may need manual updating` },
            ];
        });
    }
}
exports.IonicAngularUpdateAvailable = IonicAngularUpdateAvailable;
class IonicAngularMajorUpdateAvailable extends IonicAngularAilment {
    constructor() {
        super(...arguments);
        this.id = 'ionic-angular-major-update-available';
    }
    getVersionPair() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!this.currentVersion || !this.latestVersion) {
                const [currentPkg] = yield this.project.getPackageJson('ionic-angular');
                const latestPkg = yield npm_1.pkgFromRegistry(this.config.get('npmClient'), { pkg: 'ionic-angular' });
                this.currentVersion = currentPkg ? currentPkg.version : undefined;
                this.latestVersion = latestPkg ? latestPkg.version : undefined;
            }
            if (!this.currentVersion || !this.latestVersion) {
                return ['0.0.0', '0.0.0'];
            }
            return [this.currentVersion, this.latestVersion];
        });
    }
    getMessage() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [currentVersion, latestVersion] = yield this.getVersionPair();
            return (`Major update available for Ionic Framework.\n` +
                `A major update is available for ${chalk_1.default.bold('ionic-angular')} (${chalk_1.default.cyan(currentVersion)} => ${chalk_1.default.cyan(latestVersion)}).\n`).trim();
        });
    }
    detected() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [currentVersion, latestVersion] = yield this.getVersionPair();
            const diff = semver.diff(currentVersion, latestVersion);
            return diff === 'major';
        });
    }
    getTreatmentSteps() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return [
                { message: `Visit ${chalk_1.default.bold('https://blog.ionicframework.com')} and ${chalk_1.default.bold('https://github.com/ionic-team/ionic/releases')} for upgrade instructions` },
            ];
        });
    }
}
exports.IonicAngularMajorUpdateAvailable = IonicAngularMajorUpdateAvailable;
class AppScriptsUpdateAvailable extends IonicAngularAilment {
    constructor() {
        super(...arguments);
        this.id = 'app-scripts-update-available';
        this.treatable = true;
    }
    getVersionPair() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!this.currentVersion || !this.latestVersion) {
                const [currentPkg] = yield this.project.getPackageJson('@ionic/app-scripts');
                const latestPkg = yield npm_1.pkgFromRegistry(this.config.get('npmClient'), { pkg: '@ionic/app-scripts' });
                this.currentVersion = currentPkg ? currentPkg.version : undefined;
                this.latestVersion = latestPkg ? latestPkg.version : undefined;
            }
            if (!this.currentVersion || !this.latestVersion) {
                return ['0.0.0', '0.0.0'];
            }
            return [this.currentVersion, this.latestVersion];
        });
    }
    getMessage() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [currentVersion, latestVersion] = yield this.getVersionPair();
            return (`Update available for ${chalk_1.default.bold('@ionic/app-scripts')}.\n` +
                `An update is available for ${chalk_1.default.bold('@ionic/app-scripts')} (${chalk_1.default.cyan(currentVersion)} => ${chalk_1.default.cyan(latestVersion)}).\n`).trim();
        });
    }
    detected() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [currentVersion, latestVersion] = yield this.getVersionPair();
            const diff = semver.diff(currentVersion, latestVersion);
            return diff === 'minor' || diff === 'patch';
        });
    }
    getTreatmentSteps() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [, latestVersion] = yield this.getVersionPair();
            const [manager, ...managerArgs] = yield npm_1.pkgManagerArgs(this.config.get('npmClient'), { command: 'install', pkg: `@ionic/app-scripts@${latestVersion ? latestVersion : 'latest'}`, saveDev: true });
            return [
                {
                    message: `Run: ${chalk_1.default.green(manager + ' ' + managerArgs.join(' '))}`,
                    treat: () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        yield this.shell.run(manager, managerArgs, {});
                    }),
                },
            ];
        });
    }
}
exports.AppScriptsUpdateAvailable = AppScriptsUpdateAvailable;
class AppScriptsMajorUpdateAvailable extends IonicAngularAilment {
    constructor() {
        super(...arguments);
        this.id = 'app-scripts-major-update-available';
    }
    getVersionPair() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!this.currentVersion || !this.latestVersion) {
                const [currentPkg] = yield this.project.getPackageJson('@ionic/app-scripts');
                const latestPkg = yield npm_1.pkgFromRegistry(this.config.get('npmClient'), { pkg: '@ionic/app-scripts' });
                this.currentVersion = currentPkg ? currentPkg.version : undefined;
                this.latestVersion = latestPkg ? latestPkg.version : undefined;
            }
            if (!this.currentVersion || !this.latestVersion) {
                return ['0.0.0', '0.0.0'];
            }
            return [this.currentVersion, this.latestVersion];
        });
    }
    getMessage() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [currentVersion, latestVersion] = yield this.getVersionPair();
            return (`Major update available for ${chalk_1.default.bold('@ionic/app-scripts')}.\n` +
                `A major update is available for ${chalk_1.default.bold('@ionic/app-scripts')} (${chalk_1.default.cyan(currentVersion)} => ${chalk_1.default.cyan(latestVersion)}).\n`).trim();
        });
    }
    detected() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [currentVersion, latestVersion] = yield this.getVersionPair();
            const diff = semver.diff(currentVersion, latestVersion);
            return diff === 'major';
        });
    }
    getTreatmentSteps() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return [
                { message: `Visit ${chalk_1.default.bold('https://github.com/ionic-team/ionic-app-scripts/releases')} for upgrade instructions` },
            ];
        });
    }
}
exports.AppScriptsMajorUpdateAvailable = AppScriptsMajorUpdateAvailable;
class IonicAngularPackageJsonHasDefaultIonicBuildCommand extends IonicAngularAilment {
    constructor() {
        super(...arguments);
        this.id = 'ionic-angular-package-json-has-default-ionic-build-command';
    }
    getMessage() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return (`The ${chalk_1.default.bold(build_1.BUILD_SCRIPT)} npm script is unchanged.\n` +
                `The Ionic CLI now looks for the ${chalk_1.default.bold(build_1.BUILD_SCRIPT)} npm script in ${chalk_1.default.bold('package.json')} for a custom build script to run instead of the default (${chalk_1.default.green(build_2.DEFAULT_BUILD_SCRIPT_VALUE)}). If you don't use it, it's considered quicker and cleaner to just remove it.`).trim();
        });
    }
    detected() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const pkg = yield this.project.requirePackageJson();
            if (pkg.scripts && pkg.scripts[build_1.BUILD_SCRIPT] === build_2.DEFAULT_BUILD_SCRIPT_VALUE) {
                return true;
            }
            return false;
        });
    }
    getTreatmentSteps() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return [
                { message: `Remove the ${chalk_1.default.bold(build_1.BUILD_SCRIPT)} npm script from ${chalk_1.default.bold('package.json')}` },
                { message: `Continue using ${chalk_1.default.green('ionic build')} normally` },
            ];
        });
    }
}
exports.IonicAngularPackageJsonHasDefaultIonicBuildCommand = IonicAngularPackageJsonHasDefaultIonicBuildCommand;
class IonicAngularPackageJsonHasDefaultIonicServeCommand extends IonicAngularAilment {
    constructor() {
        super(...arguments);
        this.id = 'ionic-angular-package-json-has-default-ionic-serve-command';
    }
    getMessage() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return (`The ${chalk_1.default.bold(serve_1.SERVE_SCRIPT)} npm script is unchanged.\n` +
                `The Ionic CLI now looks for the ${chalk_1.default.bold(serve_1.SERVE_SCRIPT)} npm script in ${chalk_1.default.bold('package.json')} for a custom serve script to run instead of the default (${chalk_1.default.green(serve_2.DEFAULT_SERVE_SCRIPT_VALUE)}). If you don't use it, it's considered quicker and cleaner to just remove it.`).trim();
        });
    }
    detected() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const pkg = yield this.project.requirePackageJson();
            if (pkg.scripts && pkg.scripts[serve_1.SERVE_SCRIPT] === serve_2.DEFAULT_SERVE_SCRIPT_VALUE) {
                return true;
            }
            return false;
        });
    }
    getTreatmentSteps() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return [
                { message: `Remove the ${chalk_1.default.bold(serve_1.SERVE_SCRIPT)} npm script from ${chalk_1.default.bold('package.json')}` },
                { message: `Continue using ${chalk_1.default.green('ionic serve')} normally` },
            ];
        });
    }
}
exports.IonicAngularPackageJsonHasDefaultIonicServeCommand = IonicAngularPackageJsonHasDefaultIonicServeCommand;
