"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const node_1 = require("@ionic/cli-framework/utils/node");
const chalk_1 = require("chalk");
const Debug = require("debug");
const debug = Debug('ionic:lib:project:ionic-angular:app-scripts');
function importAppScripts(projectDir) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const pkg = '@ionic/app-scripts';
        debug('Importing %s', pkg);
        const p = node_1.resolve(pkg, { paths: node_1.compileNodeModulesPaths(projectDir) });
        const m = require(p);
        debug('fin');
        return m;
    });
}
exports.importAppScripts = importAppScripts;
exports.APP_SCRIPTS_OPTIONS = [
    {
        name: 'prod',
        summary: 'Build the application for production',
        type: Boolean,
        groups: ['app-scripts'],
        hint: chalk_1.default.dim('[app-scripts]'),
    },
    {
        name: 'aot',
        summary: 'Perform ahead-of-time compilation for this build',
        type: Boolean,
        groups: [cli_framework_1.OptionGroup.Advanced, 'app-scripts'],
        hint: chalk_1.default.dim('[app-scripts]'),
    },
    {
        name: 'minifyjs',
        summary: 'Minify JS for this build',
        type: Boolean,
        groups: [cli_framework_1.OptionGroup.Advanced, 'app-scripts'],
        hint: chalk_1.default.dim('[app-scripts]'),
    },
    {
        name: 'minifycss',
        summary: 'Minify CSS for this build',
        type: Boolean,
        groups: [cli_framework_1.OptionGroup.Advanced, 'app-scripts'],
        hint: chalk_1.default.dim('[app-scripts]'),
    },
    {
        name: 'optimizejs',
        summary: 'Perform JS optimizations for this build',
        type: Boolean,
        groups: [cli_framework_1.OptionGroup.Advanced, 'app-scripts'],
        hint: chalk_1.default.dim('[app-scripts]'),
    },
    {
        name: 'env',
        summary: '',
        groups: [cli_framework_1.OptionGroup.Hidden, cli_framework_1.OptionGroup.Advanced, 'app-scripts'],
        hint: chalk_1.default.dim('[app-scripts]'),
    },
];
