"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const Debug = require("debug");
const build_1 = require("../../build");
const app_scripts_1 = require("./app-scripts");
const debug = Debug('ionic:lib:project:ionic-angular:build');
exports.DEFAULT_PROGRAM = 'ionic-app-scripts';
exports.DEFAULT_BUILD_SCRIPT_VALUE = `${exports.DEFAULT_PROGRAM} build`;
class IonicAngularBuildRunner extends build_1.BuildRunner {
    constructor(e) {
        super();
        this.e = e;
    }
    getCommandMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                description: `
${chalk_1.default.green('ionic build')} uses ${chalk_1.default.bold('@ionic/app-scripts')}. See the project's ${chalk_1.default.bold('README.md')}[^app-scripts-readme] for documentation. Options not listed below are considered advanced and can be passed to the ${chalk_1.default.green('ionic-app-scripts')} CLI using the ${chalk_1.default.green('--')} separator after the Ionic CLI arguments. See the examples.
      `,
                footnotes: [
                    {
                        id: 'app-scripts-readme',
                        url: 'https://github.com/ionic-team/ionic-app-scripts/blob/master/README.md',
                    },
                ],
                options: [
                    {
                        name: 'source-map',
                        summary: 'Output sourcemaps',
                        type: Boolean,
                        groups: [cli_framework_1.OptionGroup.Advanced],
                        hint: chalk_1.default.dim('[app-scripts]'),
                    },
                    ...app_scripts_1.APP_SCRIPTS_OPTIONS,
                ],
                exampleCommands: [
                    '--prod',
                ],
            };
        });
    }
    createOptionsFromCommandLine(inputs, options) {
        const baseOptions = super.createBaseOptionsFromCommandLine(inputs, options);
        const sourcemaps = typeof options['source-map'] === 'boolean' ? Boolean(options['source-map']) : undefined;
        return Object.assign({}, baseOptions, { type: 'ionic-angular', prod: options['prod'] ? true : false, sourcemaps, aot: options['aot'] ? true : false, minifyjs: options['minifyjs'] ? true : false, minifycss: options['minifycss'] ? true : false, optimizejs: options['optimizejs'] ? true : false, env: options['env'] ? String(options['env']) : undefined });
    }
    buildProject(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const appscripts = new IonicAngularBuildCLI(this.e);
            yield appscripts.build(options);
        });
    }
}
exports.IonicAngularBuildRunner = IonicAngularBuildRunner;
class IonicAngularBuildCLI extends build_1.BuildCLI {
    constructor() {
        super(...arguments);
        this.name = 'Ionic App Scripts';
        this.pkg = '@ionic/app-scripts';
        this.program = exports.DEFAULT_PROGRAM;
        this.prefix = 'app-scripts';
        this.script = build_1.BUILD_SCRIPT;
    }
    buildOptionsToAppScriptsArgs(options) {
        const minimistArgs = {
            _: [],
            prod: options.prod ? true : false,
            aot: options.aot ? true : false,
            minifyjs: options.minifyjs ? true : false,
            minifycss: options.minifycss ? true : false,
            optimizejs: options.optimizejs ? true : false,
            generateSourceMap: typeof options.sourcemaps !== 'undefined' ? options.sourcemaps ? 'true' : 'false' : undefined,
            target: options.engine === 'cordova' ? 'cordova' : undefined,
            platform: options.platform,
            env: options.env,
        };
        return [...cli_framework_1.unparseArgs(minimistArgs, { allowCamelCase: true, useEquals: false }), ...options['--']];
    }
    buildArgs(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { pkgManagerArgs } = yield Promise.resolve().then(() => require('../../utils/npm'));
            const args = this.buildOptionsToAppScriptsArgs(options);
            if (this.resolvedProgram === this.program) {
                return ['build', ...args];
            }
            else {
                const [, ...pkgArgs] = yield pkgManagerArgs(this.e.config.get('npmClient'), { command: 'run', script: this.script, scriptArgs: [...args] });
                return pkgArgs;
            }
        });
    }
    resolveProgram() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (typeof this.script !== 'undefined') {
                debug(`Looking for ${chalk_1.default.cyan(this.script)} npm script.`);
                const pkg = yield this.e.project.requirePackageJson();
                if (pkg.scripts && pkg.scripts[this.script]) {
                    if (pkg.scripts[this.script] === exports.DEFAULT_BUILD_SCRIPT_VALUE) {
                        debug(`Found ${chalk_1.default.cyan(this.script)}, but it is the default. Not running.`);
                    }
                    else {
                        debug(`Using ${chalk_1.default.cyan(this.script)} npm script.`);
                        return this.e.config.get('npmClient');
                    }
                }
            }
            return this.program;
        });
    }
}
exports.IonicAngularBuildCLI = IonicAngularBuildCLI;
