"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const Debug = require("debug");
const lodash = require("lodash");
const __1 = require("../");
const debug = Debug('ionic:lib:project:ionic-angular');
class IonicAngularProject extends __1.Project {
    constructor() {
        super(...arguments);
        this.type = 'ionic-angular';
    }
    getInfo() {
        const _super = Object.create(null, {
            getInfo: { get: () => super.getInfo }
        });
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [[ionicAngularPkg], [appScriptsPkg],] = yield Promise.all([
                this.getPackageJson('ionic-angular'),
                this.getPackageJson('@ionic/app-scripts'),
            ]);
            return [
                ...(yield _super.getInfo.call(this)),
                { group: 'ionic', key: 'Ionic Framework', value: ionicAngularPkg ? `ionic-angular ${ionicAngularPkg.version}` : 'not installed' },
                { group: 'ionic', key: '@ionic/app-scripts', value: appScriptsPkg ? appScriptsPkg.version : 'not installed' },
            ];
        });
    }
    getDocsUrl() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return 'https://ion.link/v3-docs';
        });
    }
    registerAilments(registry) {
        const _super = Object.create(null, {
            registerAilments: { get: () => super.registerAilments }
        });
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield _super.registerAilments.call(this, registry);
            const ailments = yield Promise.resolve().then(() => require('./ailments'));
            const deps = Object.assign({}, this.e, { project: this });
            registry.register(new ailments.IonicAngularUpdateAvailable(deps));
            registry.register(new ailments.IonicAngularMajorUpdateAvailable(deps));
            registry.register(new ailments.AppScriptsUpdateAvailable(deps));
            registry.register(new ailments.AppScriptsMajorUpdateAvailable(deps));
            registry.register(new ailments.IonicAngularPackageJsonHasDefaultIonicBuildCommand(deps));
            registry.register(new ailments.IonicAngularPackageJsonHasDefaultIonicServeCommand(deps));
        });
    }
    detected() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const pkg = yield this.requirePackageJson();
                const deps = lodash.assign({}, pkg.dependencies, pkg.devDependencies);
                if (typeof deps['ionic-angular'] === 'string') {
                    debug(`${chalk_1.default.bold('ionic-angular')} detected in ${chalk_1.default.bold('package.json')}`);
                    return true;
                }
            }
            catch (e) {
                // ignore
            }
            return false;
        });
    }
    requireBuildRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { IonicAngularBuildRunner } = yield Promise.resolve().then(() => require('./build'));
            const deps = Object.assign({}, this.e, { project: this });
            return new IonicAngularBuildRunner(deps);
        });
    }
    requireServeRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { IonicAngularServeRunner } = yield Promise.resolve().then(() => require('./serve'));
            const deps = Object.assign({}, this.e, { project: this });
            return new IonicAngularServeRunner(deps);
        });
    }
    requireGenerateRunner() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { IonicAngularGenerateRunner } = yield Promise.resolve().then(() => require('./generate'));
            const deps = Object.assign({}, this.e, { project: this });
            return new IonicAngularGenerateRunner(deps);
        });
    }
}
exports.IonicAngularProject = IonicAngularProject;
