"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const build_1 = require("../../build");
class Ionic1BuildRunner extends build_1.BuildRunner {
    constructor(e) {
        super();
        this.e = e;
    }
    getCommandMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {};
        });
    }
    createOptionsFromCommandLine(inputs, options) {
        const baseOptions = super.createBaseOptionsFromCommandLine(inputs, options);
        return Object.assign({}, baseOptions, { type: 'ionic1' });
    }
    buildProject(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const v1 = new Ionic1BuildCLI(this.e);
            yield v1.build(options);
        });
    }
}
exports.Ionic1BuildRunner = Ionic1BuildRunner;
class Ionic1BuildCLI extends build_1.BuildCLI {
    constructor() {
        super(...arguments);
        this.name = 'Ionic 1 Toolkit';
        this.pkg = '@ionic/v1-toolkit';
        this.program = 'ionic-v1';
        this.prefix = 'v1';
        this.script = build_1.BUILD_SCRIPT;
    }
    buildArgs(options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { pkgManagerArgs } = yield Promise.resolve().then(() => require('../../utils/npm'));
            if (this.resolvedProgram === this.program) {
                return ['build'];
            }
            else {
                const [, ...pkgArgs] = yield pkgManagerArgs(this.e.config.get('npmClient'), { command: 'run', script: this.script });
                return pkgArgs;
            }
        });
    }
}
