import { Project } from '../';
import { InfoItem } from '../../../definitions';
import * as ζbuild from './build';
import * as ζserve from './serve';
export declare const ERROR_INVALID_BOWER_JSON = "INVALID_BOWER_JSON";
export interface BowerJson {
    name: string;
    dependencies?: {
        [key: string]: string | undefined;
    };
    devDependencies?: {
        [key: string]: string | undefined;
    };
}
export declare class Ionic1Project extends Project {
    readonly type: 'ionic1';
    protected bowerJsonFile?: BowerJson;
    getInfo(): Promise<InfoItem[]>;
    detected(): Promise<boolean>;
    getSourceDir(): Promise<string>;
    getDocsUrl(): Promise<string>;
    getFrameworkVersion(): Promise<string | undefined>;
    loadBowerJson(): Promise<BowerJson>;
    requireBuildRunner(): Promise<ζbuild.Ionic1BuildRunner>;
    requireServeRunner(): Promise<ζserve.Ionic1ServeRunner>;
    requireGenerateRunner(): Promise<never>;
}
