"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const chalk_1 = require("chalk");
function createOnFallback({ flags: { confirm }, log }) {
    return (question) => {
        if (question.type === 'confirm') {
            if (confirm) {
                log.msg(`${chalk_1.default.green('--confirm')}: ${chalk_1.default.dim(question.message)} ${chalk_1.default.cyan('Yes')}`);
                return true;
            }
            else {
                log.msg(`${chalk_1.default.green('--no-confirm')}: ${chalk_1.default.dim(question.message)} ${chalk_1.default.cyan('No')}`);
                return false;
            }
        }
    };
}
exports.createOnFallback = createOnFallback;
