"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const guards_1 = require("../guards");
const http_1 = require("./http");
class SecurityClient extends http_1.ResourceClient {
    constructor({ client, token }) {
        super();
        this.client = client;
        this.token = token;
    }
    load(tag) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { req } = yield this.client.make('GET', `/security/profiles/${tag}`);
            this.applyAuthentication(req, this.token);
            req.query({}).send();
            const res = yield this.client.do(req);
            if (!guards_1.isSecurityProfileResponse(res)) {
                throw http_1.createFatalAPIFormat(req, res);
            }
            return res.data;
        });
    }
}
exports.SecurityClient = SecurityClient;
