"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const guards_1 = require("../guards");
const http_1 = require("./http");
class SnapshotClient extends http_1.ResourceClient {
    constructor({ client, app, token }) {
        super();
        this.client = client;
        this.token = token;
        this.app = app;
    }
    load(id) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { req } = yield this.client.make('GET', `/apps/${this.app.id}/snapshots/${id}`);
            this.applyAuthentication(req, this.token);
            const res = yield this.client.do(req);
            if (!guards_1.isSnapshotResponse(res)) {
                throw http_1.createFatalAPIFormat(req, res);
            }
            return res.data;
        });
    }
    paginate(args = {}) {
        return this.client.paginate({
            reqgen: () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                const { req } = yield this.client.make('GET', `/apps/${this.app.id}/snapshots`);
                this.applyAuthentication(req, this.token);
                return { req };
            }),
            guard: guards_1.isSnapshotListResponse,
        });
    }
}
exports.SnapshotClient = SnapshotClient;
