"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const utils_fs_1 = require("@ionic/utils-fs");
const chalk_1 = require("chalk");
const guards_1 = require("../guards");
const emoji_1 = require("./utils/emoji");
const http_1 = require("./utils/http");
exports.STARTER_BASE_URL = 'https://d2ql0qc7j8u4b2.cloudfront.net';
function readStarterManifest(p) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        try {
            const manifest = yield utils_fs_1.readJson(p);
            if (!guards_1.isStarterManifest(manifest)) {
                throw new Error(`${p} is not a valid starter manifest.`);
            }
            return manifest;
        }
        catch (e) {
            if (e.code === 'ENOENT') {
                throw new Error(`${p} not found`);
            }
            else if (e instanceof SyntaxError) {
                throw new Error(`${p} is not valid JSON.`);
            }
            throw e;
        }
    });
}
exports.readStarterManifest = readStarterManifest;
const advertisementSeparator = '─';
function getIonicDevAppText() {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const msg = `
     ${chalk_1.default.bold(`${emoji_1.emoji('✨', '*')}   IONIC  DEVAPP   ${emoji_1.emoji('✨', '*')}`)}\n
 Speed up development with the ${chalk_1.default.bold('Ionic DevApp')}, our fast, on-device testing mobile app\n
  -  ${emoji_1.emoji('🔑', '')}   Test on iOS and Android without Native SDKs
  -  ${emoji_1.emoji('🚀', '')}   LiveReload for instant style and JS updates\n
 -->    Install DevApp: ${chalk_1.default.bold('https://bit.ly/ionic-dev-app')}    <--
`;
        return `${msg}\n${advertisementSeparator.repeat(60)}\n\n`;
    });
}
exports.getIonicDevAppText = getIonicDevAppText;
function getIonicProText() {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const msg = `
     ${chalk_1.default.bold(`${emoji_1.emoji('🔥', '*')}   IONIC  APPFLOW   ${emoji_1.emoji('🔥', '*')}`)}\n
 Supercharge your Ionic development with the ${chalk_1.default.bold('Ionic Appflow')} SDK\n
  -  ${emoji_1.emoji('📲', '')}  Push remote updates and skip the app store queue\n
 Learn more about Ionic Appflow: ${chalk_1.default.bold('https://ion.link/appflow')}
`;
        return `${msg}\n${advertisementSeparator.repeat(60)}\n\n`;
    });
}
exports.getIonicProText = getIonicProText;
function getStarterList(config, tag = 'latest') {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const { req } = yield http_1.createRequest('GET', `${exports.STARTER_BASE_URL}/${tag === 'latest' ? '' : `${tag}/`}starters.json`, config.getHTTPConfig());
        const res = yield req;
        // TODO: typecheck
        return res.body;
    });
}
exports.getStarterList = getStarterList;
exports.STARTER_TEMPLATES = [
    {
        name: 'blank',
        type: 'angular',
        description: 'A blank starter project',
        id: 'angular-official-blank',
    },
    {
        name: 'sidemenu',
        type: 'angular',
        description: 'A starting project with a side menu with navigation in the content area',
        id: 'angular-official-sidemenu',
    },
    {
        name: 'tabs',
        type: 'angular',
        description: 'A starting project with a simple tabbed interface',
        id: 'angular-official-tabs',
    },
    {
        name: 'tabs',
        type: 'ionic-angular',
        description: 'A starting project with a simple tabbed interface',
        id: 'ionic-angular-official-tabs',
    },
    {
        name: 'blank',
        type: 'ionic-angular',
        description: 'A blank starter project',
        id: 'ionic-angular-official-blank',
    },
    {
        name: 'sidemenu',
        type: 'ionic-angular',
        description: 'A starting project with a side menu with navigation in the content area',
        id: 'ionic-angular-official-sidemenu',
    },
    {
        name: 'super',
        type: 'ionic-angular',
        description: 'A starting project complete with pre-built pages, providers and best practices for Ionic development.',
        id: 'ionic-angular-official-super',
    },
    {
        name: 'tutorial',
        type: 'ionic-angular',
        description: 'A tutorial based project that goes along with the Ionic documentation',
        id: 'ionic-angular-official-tutorial',
    },
    {
        name: 'aws',
        type: 'ionic-angular',
        description: 'AWS Mobile Hub Starter',
        id: 'ionic-angular-official-aws',
    },
    {
        name: 'tabs',
        type: 'ionic1',
        description: 'A starting project for Ionic using a simple tabbed interface',
        id: 'ionic1-official-tabs',
    },
    {
        name: 'blank',
        type: 'ionic1',
        description: 'A blank starter project for Ionic',
        id: 'ionic1-official-blank',
    },
    {
        name: 'sidemenu',
        type: 'ionic1',
        description: 'A starting project for Ionic using a side menu with navigation in the content area',
        id: 'ionic1-official-sidemenu',
    },
    {
        name: 'maps',
        type: 'ionic1',
        description: 'An Ionic starter project using Google Maps and a side menu',
        id: 'ionic1-official-maps',
    },
];
