/// <reference types="node" />
import * as ζsuperagent from 'superagent';
import { CreateRequestOptions, HttpMethod } from '../../definitions';
export declare const PROXY_ENVIRONMENT_VARIABLES: ReadonlyArray<string>;
export declare function createRequest(method: HttpMethod, url: string, { proxy, ssl }: CreateRequestOptions): Promise<{
    req: ζsuperagent.SuperAgentRequest;
}>;
/**
 * Initiate a request, downloading the contents to a writable stream.
 *
 * @param req The request to download to the writable stream.
 * @param ws Must be a dedicated writable stream that calls the 'close' event.
 */
export declare function download(req: ζsuperagent.SuperAgentRequest, ws: NodeJS.WritableStream, { progress }: {
    progress?: (loaded: number, total: number) => void;
}): Promise<void>;
