"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
class Logger extends cli_framework_1.Logger {
    ok(msg) {
        this.log(Object.assign({}, this.createRecord(`${chalk_1.default.dim('[')}${chalk_1.default.bold.green('OK')}${chalk_1.default.dim(']')} ${msg}`), { format: false }));
    }
    rawmsg(msg) {
        this.log(Object.assign({}, this.createRecord(msg), { format: false }));
    }
}
exports.Logger = Logger;
function createFormatter(options = {}) {
    const prefix = process.argv.includes('--log-timestamps') ? () => `${chalk_1.default.dim('[' + new Date().toISOString() + ']')}` : '';
    return cli_framework_1.createTaggedFormatter(Object.assign({ prefix, titleize: true, wrap: true }, options));
}
exports.createFormatter = createFormatter;
function createDefaultLoggerHandlers(formatter = createFormatter()) {
    return new Set([...cli_framework_1.DEFAULT_LOGGER_HANDLERS].map(handler => handler.clone({ formatter })));
}
exports.createDefaultLoggerHandlers = createDefaultLoggerHandlers;
