# is-dotfile [![NPM version](https://badge.fury.io/js/is-dotfile.svg)](http://badge.fury.io/js/is-dotfile)

> Return true if a file path is (or has) a dotfile.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i is-dotfile --save
```

## Usage

```js
var isDotfile = require('is-dotfile');

isDotfile('a/b/c.js');
//=> false

isDotfile('a/b/.gitignore');
//=> true

isDotfile('.gitignore');
//=> true

isDotfile('/.gitignore');
//=> true

isDotfile('/.gitignore/foo');
//=> false
```

## Related projects

* [dotfile-regex](https://github.com/regexps/dotfile-regex): Regular expresson for matching dotfiles.
* [is-glob](https://github.com/jonschlinkert/is-glob): Returns `true` if the given string looks like a glob pattern.
* [micromatch](https://github.com/jonschlinkert/micromatch): Glob matching for javascript/node.js. A drop-in replacement and faster alternative to minimatch and multimatch. Just… [more](https://github.com/jonschlinkert/micromatch)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/is-dotfile/issues/new)

## Authors

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on May 25, 2015._