'use strict';

var isStream = module.exports = function (stream) {
	return stream !== null && typeof stream === 'object' && typeof stream.pipe === 'function';
};

isStream.writable = function (stream) {
	return isStream(stream) && typeof stream._write == 'function' && typeof stream._writableState == 'object';
};

isStream.readable = function (stream) {
	return isStream(stream) && typeof stream._read == 'function' && typeof stream._readableState == 'object';
};

isStream.duplex = function (stream) {
	return isStream.writable(stream) && isStream.readable(stream);
};
