# isobject [![NPM version](https://badge.fury.io/js/isobject.svg)](http://badge.fury.io/js/isobject)

> Returns true if the value is an object and not an array or null.

Use [is-plain-object](https://github.com/jonschlinkert/is-plain-object) if you want only objects that are created by the `Object` constructor.

## Install
```bash
npm i isobject --save
```

## Usage

```js
var isObject = require('isobject');
```

**True**

```js
isObject({});
//=> true

isObject(Object.create({}));
//=> true

isObject(Object.create(Object.prototype));
//=> true

isObject(Object.create(null));
//=> true

isObject({});
//=> true

isObject(new Foo);
//=> true

isObject(/foo/);
//=> true
```

**False**

```js
isObject(function () {});
//=> false

isObject(1);
//=> false

isObject([]);
//=> false

isObject(null);
//=> false
```

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2015 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb](https://github.com/assemble/verb) on February 25, 2015._
