'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var _regeneratorRuntime = _interopDefault(require('babel-runtime/regenerator'));
var _asyncToGenerator = _interopDefault(require('babel-runtime/helpers/asyncToGenerator'));
var path = _interopDefault(require('path'));
var managers_js = require('./managers.js');
var models_js = require('./models.js');
var _getIterator = _interopDefault(require('babel-runtime/core-js/get-iterator'));
var _objectWithoutProperties = _interopDefault(require('babel-runtime/helpers/objectWithoutProperties'));
var _Map = _interopDefault(require('babel-runtime/core-js/map'));
var _Promise = _interopDefault(require('babel-runtime/core-js/promise'));
var _Number$isNaN = _interopDefault(require('babel-runtime/core-js/number/is-nan'));
var buffer = require('buffer');
var stream = require('stream');
var through2 = _interopDefault(require('through2'));
var listpack = _interopDefault(require('git-list-pack'));
var peek = _interopDefault(require('buffer-peek-stream'));
var applyDelta = _interopDefault(require('git-apply-delta'));
var marky = _interopDefault(require('marky'));
var pify = _interopDefault(require('pify'));
var concat = _interopDefault(require('simple-concat'));
var split2 = _interopDefault(require('split2'));
var utils_js = require('./utils.js');
var _extends = _interopDefault(require('babel-runtime/helpers/extends'));
var _Set = _interopDefault(require('babel-runtime/core-js/set'));
var _toConsumableArray = _interopDefault(require('babel-runtime/helpers/toConsumableArray'));
var pad = _interopDefault(require('pad'));
var pako = _interopDefault(require('pako'));
var createHash = _interopDefault(require('sha.js'));

/**
 * @external {FSModule} http://ghub.io/browserfs
 */

/**
 * Add a file to the git index (aka staging area)
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} args.filepath - The path to the file to add to the index.
 * @returns {Promise<void>} - Resolves successfully once the git index has been updated.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * await new Promise((resolve, reject) => fs.writeFile(
 *   '<@README.md@>',
 *   `<<@# TEST@>>`,
 *   (err) => err ? reject(err) : resolve()
 * ))
 * await git.add({...repo, filepath: '<@README.md@>'})
 * console.log('done')
 */
var add = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        filepath = _ref.filepath;
    var fs, type, object, oid;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            type = 'blob';
            _context2.next = 4;
            return fs.read(path.join(dir, filepath));

          case 4:
            object = _context2.sent;

            if (!(object === null)) {
              _context2.next = 7;
              break;
            }

            throw new Error('Could not read file \'' + filepath + '\'');

          case 7:
            _context2.next = 9;
            return managers_js.GitObjectManager.write({ fs: fs, gitdir: gitdir, type: type, object: object });

          case 9:
            oid = _context2.sent;
            _context2.next = 12;
            return managers_js.GitIndexManager.acquire({ fs: fs, filepath: gitdir + '/index' }, function () {
              var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(index) {
                var stats;
                return _regeneratorRuntime.wrap(function _callee$(_context) {
                  while (1) {
                    switch (_context.prev = _context.next) {
                      case 0:
                        _context.next = 2;
                        return fs._lstat(path.join(dir, filepath));

                      case 2:
                        stats = _context.sent;

                        index.insert({ filepath: filepath, stats: stats, oid: oid });

                      case 4:
                      case 'end':
                        return _context.stop();
                    }
                  }
                }, _callee, this);
              }));

              return function (_x2) {
                return _ref3.apply(this, arguments);
              };
            }());

          case 12:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, this);
  }));

  return function add(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * Initialize a new repository
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @returns {Promise<void>} - Resolves successfully when filesystem operations are complete.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * await git.init(repo)
 * console.log('done')
 */
var init = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs;

    var fs, folders, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, folder;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            folders = ['hooks', 'info', 'objects/info', 'objects/pack', 'refs/heads', 'refs/tags'];

            folders = folders.map(function (dir) {
              return gitdir + '/' + dir;
            });
            _iteratorNormalCompletion = true;
            _didIteratorError = false;
            _iteratorError = undefined;
            _context.prev = 6;
            _iterator = _getIterator(folders);

          case 8:
            if (_iteratorNormalCompletion = (_step = _iterator.next()).done) {
              _context.next = 15;
              break;
            }

            folder = _step.value;
            _context.next = 12;
            return fs.mkdir(folder);

          case 12:
            _iteratorNormalCompletion = true;
            _context.next = 8;
            break;

          case 15:
            _context.next = 21;
            break;

          case 17:
            _context.prev = 17;
            _context.t0 = _context['catch'](6);
            _didIteratorError = true;
            _iteratorError = _context.t0;

          case 21:
            _context.prev = 21;
            _context.prev = 22;

            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }

          case 24:
            _context.prev = 24;

            if (!_didIteratorError) {
              _context.next = 27;
              break;
            }

            throw _iteratorError;

          case 27:
            return _context.finish(24);

          case 28:
            return _context.finish(21);

          case 29:
            _context.next = 31;
            return fs.write(gitdir + '/config', '[core]\n' + '\trepositoryformatversion = 0\n' + '\tfilemode = false\n' + '\tbare = false\n' + '\tlogallrefupdates = true\n' + '\tsymlinks = false\n' + '\tignorecase = true\n');

          case 31:
            _context.next = 33;
            return fs.write(gitdir + '/HEAD', 'ref: refs/heads/master\n');

          case 33:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this, [[6, 17, 21, 29], [22,, 24, 28]]);
  }));

  return function init(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * Read and/or write to the git config file(s)
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} args.path -  The key of the git config entry.
 * @param {string} [args.value] - A value to store at that path.
 * @returns {Promise<any>} - Resolves with the config value
 *
 * If no `value` is provided, it does a read.
 * If a `value` is provided, it does a write.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 *
 * // Write config value
 * await git.config({
 *   ...repo,
 *   path: '<@user.name@>',
 *   value: '<@Mr. Test@>'
 * })
 *
 * // Read config value
 * let value = await git.config({
 *   ...repo,
 *   path: '<@user.name@>'
 * })
 * console.log(value)
 */
var config = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        args = _objectWithoutProperties(_ref, ['dir', 'gitdir', 'fs']);

    var fs, path$$1, value, config, _value;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            path$$1 = args.path, value = args.value;
            _context.next = 4;
            return managers_js.GitConfigManager.get({ fs: fs, gitdir: gitdir });

          case 4:
            config = _context.sent;

            if (!(value === undefined && !args.hasOwnProperty('value'))) {
              _context.next = 12;
              break;
            }

            _context.next = 8;
            return config.get(path$$1);

          case 8:
            _value = _context.sent;
            return _context.abrupt('return', _value);

          case 12:
            _context.next = 14;
            return config.set(path$$1, value);

          case 14:
            _context.next = 16;
            return managers_js.GitConfigManager.save({ fs: fs, gitdir: gitdir, config: config });

          case 16:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function config(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var fetchPackfile = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(_ref3) {
    var _this = this;

    var gitdir = _ref3.gitdir,
        _fs = _ref3.fs,
        ref = _ref3.ref,
        remote = _ref3.remote,
        url = _ref3.url,
        authUsername = _ref3.authUsername,
        authPassword = _ref3.authPassword,
        _ref3$depth = _ref3.depth,
        depth = _ref3$depth === undefined ? null : _ref3$depth,
        _ref3$since = _ref3.since,
        since = _ref3$since === undefined ? null : _ref3$since,
        _ref3$exclude = _ref3.exclude,
        exclude = _ref3$exclude === undefined ? [] : _ref3$exclude,
        _ref3$relative = _ref3.relative,
        relative = _ref3$relative === undefined ? false : _ref3$relative,
        _ref3$tags = _ref3.tags,
        tags = _ref3$tags === undefined ? false : _ref3$tags;

    var fs, remoteHTTP, want, capabilities, packstream, oids, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, oid, _iteratorNormalCompletion2, _didIteratorError2, _iteratorError2, _iterator2, _step2, x, have, response;

    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);

            if (!(depth !== null)) {
              _context3.next = 5;
              break;
            }

            if (!_Number$isNaN(parseInt(depth))) {
              _context3.next = 4;
              break;
            }

            throw new Error('Invalid value for depth argument: ' + depth);

          case 4:
            depth = parseInt(depth);

          case 5:
            remote = remote || 'origin';

            if (!(url === undefined)) {
              _context3.next = 10;
              break;
            }

            _context3.next = 9;
            return config({
              fs: fs,
              gitdir: gitdir,
              path: 'remote.' + remote + '.url'
            });

          case 9:
            url = _context3.sent;

          case 10:
            remoteHTTP = new managers_js.GitRemoteHTTP(url);

            if (authUsername !== undefined && authPassword !== undefined) {
              remoteHTTP.auth = {
                username: authUsername,
                password: authPassword
              };
            }
            _context3.next = 14;
            return remoteHTTP.preparePull();

          case 14:
            if (!(depth !== null && !remoteHTTP.capabilities.has('shallow'))) {
              _context3.next = 16;
              break;
            }

            throw new Error('Remote does not support shallow fetches');

          case 16:
            if (!(since !== null && !remoteHTTP.capabilities.has('deepen-since'))) {
              _context3.next = 18;
              break;
            }

            throw new Error('Remote does not support shallow fetches by date');

          case 18:
            if (!(exclude.length > 0 && !remoteHTTP.capabilities.has('deepen-not'))) {
              _context3.next = 20;
              break;
            }

            throw new Error('Remote does not support shallow fetches excluding commits reachable by refs');

          case 20:
            if (!(relative === true && !remoteHTTP.capabilities.has('deepen-relative'))) {
              _context3.next = 22;
              break;
            }

            throw new Error('Remote does not support shallow fetches relative to the current shallow depth');

          case 22:
            _context3.next = 24;
            return managers_js.GitRefManager.updateRemoteRefs({
              fs: fs,
              gitdir: gitdir,
              remote: remote,
              refs: remoteHTTP.refs,
              symrefs: remoteHTTP.symrefs,
              tags: tags
            });

          case 24:
            _context3.next = 26;
            return managers_js.GitRefManager.resolve({
              fs: fs,
              gitdir: gitdir,
              ref: 'refs/remotes/' + remote + '/' + ref
            });

          case 26:
            want = _context3.sent;

            // Note: I removed "ofs-delta" from the capabilities list and now
            // Github uses all ref-deltas when I fetch packfiles instead of all ofs-deltas. Nice!
            capabilities = 'multi_ack_detailed no-done side-band-64k thin-pack ofs-delta agent=git/' + utils_js.pkg.name + '@' + utils_js.pkg.version + (relative ? ' deepen-relative' : '');
            packstream = new stream.PassThrough();

            packstream.write(models_js.GitPktLine.encode('want ' + want + ' ' + capabilities + '\n'));
            _context3.next = 32;
            return managers_js.GitShallowManager.read({ fs: fs, gitdir: gitdir });

          case 32:
            oids = _context3.sent;

            if (!(oids.size > 0 && remoteHTTP.capabilities.has('shallow'))) {
              _context3.next = 53;
              break;
            }

            _iteratorNormalCompletion = true;
            _didIteratorError = false;
            _iteratorError = undefined;
            _context3.prev = 37;

            for (_iterator = _getIterator(oids); !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
              oid = _step.value;

              packstream.write(models_js.GitPktLine.encode('shallow ' + oid + '\n'));
            }
            _context3.next = 45;
            break;

          case 41:
            _context3.prev = 41;
            _context3.t0 = _context3['catch'](37);
            _didIteratorError = true;
            _iteratorError = _context3.t0;

          case 45:
            _context3.prev = 45;
            _context3.prev = 46;

            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }

          case 48:
            _context3.prev = 48;

            if (!_didIteratorError) {
              _context3.next = 51;
              break;
            }

            throw _iteratorError;

          case 51:
            return _context3.finish(48);

          case 52:
            return _context3.finish(45);

          case 53:
            if (depth !== null) {
              packstream.write(models_js.GitPktLine.encode('deepen ' + depth + '\n'));
            }
            if (since !== null) {
              packstream.write(models_js.GitPktLine.encode('deepen-since ' + Math.floor(since.valueOf() / 1000) + '\n'));
            }
            _iteratorNormalCompletion2 = true;
            _didIteratorError2 = false;
            _iteratorError2 = undefined;
            _context3.prev = 58;
            for (_iterator2 = _getIterator(exclude); !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
              x = _step2.value;

              packstream.write(models_js.GitPktLine.encode('deepen-not ' + x + '\n'));
            }
            _context3.next = 66;
            break;

          case 62:
            _context3.prev = 62;
            _context3.t1 = _context3['catch'](58);
            _didIteratorError2 = true;
            _iteratorError2 = _context3.t1;

          case 66:
            _context3.prev = 66;
            _context3.prev = 67;

            if (!_iteratorNormalCompletion2 && _iterator2.return) {
              _iterator2.return();
            }

          case 69:
            _context3.prev = 69;

            if (!_didIteratorError2) {
              _context3.next = 72;
              break;
            }

            throw _iteratorError2;

          case 72:
            return _context3.finish(69);

          case 73:
            return _context3.finish(66);

          case 74:
            packstream.write(models_js.GitPktLine.flush());
            have = null;
            _context3.prev = 76;
            _context3.next = 79;
            return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: ref });

          case 79:
            have = _context3.sent;
            _context3.next = 84;
            break;

          case 82:
            _context3.prev = 82;
            _context3.t2 = _context3['catch'](76);

          case 84:
            if (have) {
              packstream.write(models_js.GitPktLine.encode('have ' + have + '\n'));
              packstream.write(models_js.GitPktLine.flush());
            }
            packstream.end(models_js.GitPktLine.encode('done\n'));
            _context3.next = 88;
            return remoteHTTP.pull(packstream);

          case 88:
            response = _context3.sent;

            response.packetlines.pipe(through2(function () {
              var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(data, enc, next) {
                var line, _oid, _oid2;

                return _regeneratorRuntime.wrap(function _callee2$(_context2) {
                  while (1) {
                    switch (_context2.prev = _context2.next) {
                      case 0:
                        line = data.toString('utf8');

                        if (!line.startsWith('shallow')) {
                          _context2.next = 10;
                          break;
                        }

                        _oid = line.slice(-41).trim();

                        if (!(_oid.length !== 40)) {
                          _context2.next = 5;
                          break;
                        }

                        throw new Error('non-40 character \'shallow\' oid: ' + _oid);

                      case 5:
                        oids.add(_oid);
                        _context2.next = 8;
                        return managers_js.GitShallowManager.write({ fs: fs, gitdir: gitdir, oids: oids });

                      case 8:
                        _context2.next = 17;
                        break;

                      case 10:
                        if (!line.startsWith('unshallow')) {
                          _context2.next = 17;
                          break;
                        }

                        _oid2 = line.slice(-41).trim();

                        if (!(_oid2.length !== 40)) {
                          _context2.next = 14;
                          break;
                        }

                        throw new Error('non-40 character \'shallow\' oid: ' + _oid2);

                      case 14:
                        oids.delete(_oid2);
                        _context2.next = 17;
                        return managers_js.GitShallowManager.write({ fs: fs, gitdir: gitdir, oids: oids });

                      case 17:
                        next(null, data);

                      case 18:
                      case 'end':
                        return _context2.stop();
                    }
                  }
                }, _callee2, _this);
              }));

              return function (_x3, _x4, _x5) {
                return _ref5.apply(this, arguments);
              };
            }()));
            return _context3.abrupt('return', response);

          case 91:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, this, [[37, 41, 45, 53], [46,, 48, 52], [58, 62, 66, 74], [67,, 69, 73], [76, 82]]);
  }));

  return function fetchPackfile(_x2) {
    return _ref4.apply(this, arguments);
  };
}();

/**
 * Fetch commits
 *
 * @link https://isomorphic-git.github.io/docs/fetch.html
 */
var fetch = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        emitter = _ref.emitter,
        _ref$ref = _ref.ref,
        ref = _ref$ref === undefined ? 'HEAD' : _ref$ref,
        remote = _ref.remote,
        url = _ref.url,
        authUsername = _ref.authUsername,
        authPassword = _ref.authPassword,
        depth = _ref.depth,
        since = _ref.since,
        exclude = _ref.exclude,
        relative = _ref.relative,
        tags = _ref.tags,
        onprogress = _ref.onprogress;
    var fs, response, packfile, packfileSha;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            if (onprogress !== undefined) {
              console.warn('The `onprogress` callback has been deprecated. Please use the more generic `emitter` EventEmitter argument instead.');
            }
            fs = new models_js.FileSystem(_fs);
            _context.next = 4;
            return fetchPackfile({
              gitdir: gitdir,
              fs: fs,
              ref: ref,
              remote: remote,
              url: url,
              authUsername: authUsername,
              authPassword: authPassword,
              depth: depth,
              since: since,
              exclude: exclude,
              relative: relative,
              tags: tags
            });

          case 4:
            response = _context.sent;

            // Note: progress messages are designed to be written directly to the terminal,
            // so they are often sent with just a carriage return to overwrite the last line of output.
            // But there are also messages delimited with newlines.
            // I also include CRLF just in case.
            response.progress.pipe(split2(/(\r\n)|\r|\n/)).on('data', function (line) {
              if (emitter) {
                emitter.emit('message', line.trim());
              }
              var matches = line.match(/\((\d+?)\/(\d+?)\)/);
              if (matches && emitter) {
                emitter.emit('progress', {
                  loaded: parseInt(matches[1], 10),
                  total: parseInt(matches[2], 10),
                  lengthComputable: true
                });
              }
            });
            _context.next = 8;
            return pify(concat)(response.packfile);

          case 8:
            packfile = _context.sent;
            packfileSha = packfile.slice(-20).toString('hex');
            _context.next = 12;
            return fs.write(path.join(gitdir, 'objects/pack/pack-' + packfileSha + '.pack'), packfile);

          case 12:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function fetch(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var types = {
  1: 'commit',
  2: 'tree',
  3: 'blob',
  4: 'tag',
  6: 'ofs-delta',
  7: 'ref-delta'
};

function parseVarInt(buffer$$1 /*: Buffer */) {
  var n = 0;
  for (var i = 0; i < buffer$$1.byteLength; i++) {
    n = (buffer$$1[i] & 127) + (n << 7);
    if ((buffer$$1[i] & 128) === 0) {
      if (i !== buffer$$1.byteLength - 1) throw new Error('Invalid varint buffer');
      return n;
    }
  }
  throw new Error('Invalid varint buffer');
}

/**
 * @ignore
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {ReadableStream} args.inputStream
 * @param {Function} args.onprogress
 */
var unpack = function () {
  var _ref7 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(_ref6) {
    var dir = _ref6.dir,
        _ref6$gitdir = _ref6.gitdir,
        gitdir = _ref6$gitdir === undefined ? path.join(dir, '.git') : _ref6$gitdir,
        _fs = _ref6.fs,
        inputStream = _ref6.inputStream,
        emitter = _ref6.emitter,
        onprogress = _ref6.onprogress;
    var fs;
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            if (onprogress !== undefined) {
              console.warn('The `onprogress` callback has been deprecated. Please use the more generic `emitter` EventEmitter argument instead.');
            }
            fs = new models_js.FileSystem(_fs);
            return _context5.abrupt('return', new _Promise(function (resolve, reject) {
              var _this2 = this;

              // Read header
              peek(inputStream, 12, function (err, data, inputStream) {
                if (err) return reject(err);
                var iden = data.slice(0, 4).toString('utf8');
                if (iden !== 'PACK') {
                  throw new Error('Packfile started with \'' + iden + '\'. Expected \'PACK\'');
                }
                var ver = data.slice(4, 8).toString('hex');
                if (ver !== '00000002') {
                  throw new Error('Unknown packfile version \'' + ver + '\'. Expected 00000002.');
                }
                // Read a 4 byte (32-bit) int
                var numObjects = data.readInt32BE(8);
                if (emitter) {
                  emitter.emit('progress', {
                    loaded: 0,
                    total: numObjects,
                    lengthComputable: true
                  });
                }
                if (numObjects === 0) return resolve();
                // And on our merry way
                var totalTime = 0;
                var totalApplyDeltaTime = 0;
                var totalWriteFileTime = 0;
                var totalReadFileTime = 0;
                var offsetMap = new _Map();
                inputStream.pipe(listpack()).pipe(through2.obj(function () {
                  var _ref9 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(_ref8, enc, next) {
                    var data = _ref8.data,
                        type = _ref8.type,
                        reference = _ref8.reference,
                        offset = _ref8.offset,
                        num = _ref8.num;

                    var oid, _ref10, object, _type, result, newoid, absoluteOffset, referenceOid, _ref11, _type2, _object, _result, _oid3, _oid4, perfentry;

                    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
                      while (1) {
                        switch (_context4.prev = _context4.next) {
                          case 0:
                            type = types[type];
                            marky.mark(type + ' #' + num + ' ' + data.length + 'B');

                            if (!(type === 'ref-delta')) {
                              _context4.next = 28;
                              break;
                            }

                            oid = buffer.Buffer.from(reference).toString('hex');
                            _context4.prev = 4;

                            marky.mark('readFile');
                            _context4.next = 8;
                            return managers_js.GitObjectManager.read({
                              fs: fs,
                              gitdir: gitdir,
                              oid: oid
                            });

                          case 8:
                            _ref10 = _context4.sent;
                            object = _ref10.object;
                            _type = _ref10.type;

                            totalReadFileTime += marky.stop('readFile').duration;
                            marky.mark('applyDelta');
                            result = applyDelta(data, object);

                            totalApplyDeltaTime += marky.stop('applyDelta').duration;
                            marky.mark('writeFile');
                            _context4.next = 18;
                            return managers_js.GitObjectManager.write({
                              fs: fs,
                              gitdir: gitdir,
                              type: _type,
                              object: result
                            });

                          case 18:
                            newoid = _context4.sent;

                            totalWriteFileTime += marky.stop('writeFile').duration;
                            // console.log(`${type} ${newoid} ref-delta ${oid}`)
                            offsetMap.set(offset, newoid);
                            _context4.next = 26;
                            break;

                          case 23:
                            _context4.prev = 23;
                            _context4.t0 = _context4['catch'](4);
                            throw new Error('Could not find object ' + reference + ' ' + oid + ' that is referenced by a ref-delta object in packfile at byte offset ' + offset + '.');

                          case 26:
                            _context4.next = 49;
                            break;

                          case 28:
                            if (!(type === 'ofs-delta')) {
                              _context4.next = 43;
                              break;
                            }

                            // Note: this might be not working because offsets might not be
                            // guaranteed to be on object boundaries? In which case we'd need
                            // to write the packfile to disk first, I think.
                            // For now I've "solved" it by simply not advertising ofs-delta as a capability
                            // during the HTTP request, so Github will only send ref-deltas not ofs-deltas.
                            absoluteOffset = offset - parseVarInt(reference);
                            referenceOid = offsetMap.get(absoluteOffset);
                            // console.log(`${offset} ofs-delta ${absoluteOffset} ${referenceOid}`)

                            _context4.next = 33;
                            return managers_js.GitObjectManager.read({
                              fs: fs,
                              gitdir: gitdir,
                              oid: referenceOid
                            });

                          case 33:
                            _ref11 = _context4.sent;
                            _type2 = _ref11.type;
                            _object = _ref11.object;
                            _result = applyDelta(data, _object);
                            _context4.next = 39;
                            return managers_js.GitObjectManager.write({
                              fs: fs,
                              gitdir: gitdir,
                              type: _type2,
                              object: _result
                            });

                          case 39:
                            _oid3 = _context4.sent;

                            // console.log(`${offset} ${type} ${oid} ofs-delta ${referenceOid}`)
                            offsetMap.set(offset, _oid3);
                            _context4.next = 49;
                            break;

                          case 43:
                            marky.mark('writeFile');
                            _context4.next = 46;
                            return managers_js.GitObjectManager.write({
                              fs: fs,
                              gitdir: gitdir,
                              type: type,
                              object: data
                            });

                          case 46:
                            _oid4 = _context4.sent;

                            totalWriteFileTime += marky.stop('writeFile').duration;
                            // console.log(`${offset} ${type} ${oid}`)
                            offsetMap.set(offset, _oid4);

                          case 49:
                            if (emitter) {
                              emitter.emit('progress', {
                                loaded: numObjects - num,
                                total: numObjects,
                                lengthComputable: true
                              });
                            }
                            perfentry = marky.stop(type + ' #' + num + ' ' + data.length + 'B');

                            totalTime += perfentry.duration;

                            if (!(num === 0)) {
                              _context4.next = 58;
                              break;
                            }

                            utils_js.log('Total time unpacking objects: ' + totalTime);
                            utils_js.log('Total time applying deltas: ' + totalApplyDeltaTime);
                            utils_js.log('Total time reading files: ' + totalReadFileTime);
                            utils_js.log('Total time writing files: ' + totalWriteFileTime);
                            return _context4.abrupt('return', resolve());

                          case 58:
                            next(null);

                          case 59:
                          case 'end':
                            return _context4.stop();
                        }
                      }
                    }, _callee4, _this2, [[4, 23]]);
                  }));

                  return function (_x7, _x8, _x9) {
                    return _ref9.apply(this, arguments);
                  };
                }())).on('error', reject).on('finish', resolve);
              });
            }));

          case 3:
          case 'end':
            return _context5.stop();
        }
      }
    }, _callee5, this);
  }));

  return function unpack(_x6) {
    return _ref7.apply(this, arguments);
  };
}();

var writeTreeToDisk = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var _fs = _ref.fs,
        dir = _ref.dir,
        gitdir = _ref.gitdir,
        index = _ref.index,
        prefix = _ref.prefix,
        tree = _ref.tree;

    var fs, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, entry, _ref3, type, object, entrypath, filepath, stats, _tree;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            _iteratorNormalCompletion = true;
            _didIteratorError = false;
            _iteratorError = undefined;
            _context.prev = 4;
            _iterator = _getIterator(tree);

          case 6:
            if (_iteratorNormalCompletion = (_step = _iterator.next()).done) {
              _context.next = 33;
              break;
            }

            entry = _step.value;
            _context.next = 10;
            return managers_js.GitObjectManager.read({
              fs: fs,
              gitdir: gitdir,
              oid: entry.oid
            });

          case 10:
            _ref3 = _context.sent;
            type = _ref3.type;
            object = _ref3.object;
            entrypath = prefix === '' ? entry.path : prefix + '/' + entry.path;
            filepath = path.join(dir, prefix, entry.path);
            _context.t0 = type;
            _context.next = _context.t0 === 'blob' ? 18 : _context.t0 === 'tree' ? 25 : 29;
            break;

          case 18:
            _context.next = 20;
            return fs.write(filepath, object);

          case 20:
            _context.next = 22;
            return fs._lstat(filepath);

          case 22:
            stats = _context.sent;

            index.insert({
              filepath: entrypath,
              stats: stats,
              oid: entry.oid
            });
            return _context.abrupt('break', 30);

          case 25:
            _tree = models_js.GitTree.from(object);
            _context.next = 28;
            return writeTreeToDisk({
              fs: fs,
              dir: dir,
              gitdir: gitdir,
              index: index,
              prefix: entrypath,
              tree: _tree
            });

          case 28:
            return _context.abrupt('break', 30);

          case 29:
            throw new Error('Unexpected object type ' + type + ' found in tree for \'' + entrypath + '\'');

          case 30:
            _iteratorNormalCompletion = true;
            _context.next = 6;
            break;

          case 33:
            _context.next = 39;
            break;

          case 35:
            _context.prev = 35;
            _context.t1 = _context['catch'](4);
            _didIteratorError = true;
            _iteratorError = _context.t1;

          case 39:
            _context.prev = 39;
            _context.prev = 40;

            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }

          case 42:
            _context.prev = 42;

            if (!_didIteratorError) {
              _context.next = 45;
              break;
            }

            throw _iteratorError;

          case 45:
            return _context.finish(42);

          case 46:
            return _context.finish(39);

          case 47:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this, [[4, 35, 39, 47], [40,, 42, 46]]);
  }));

  return function writeTreeToDisk(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * Checkout a branch
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} [args.remote='origin'] - What to name the remote that is created. The default is 'origin'.
 * @param {string} [args.ref=undefined] - Which branch to clone. By default this is the designated "main branch" of the repository.
 * @returns {Promise<void>} - Resolves successfully when filesystem operations are complete.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * await git.checkout({...repo, ref: '<@master@>'})
 * console.log('done')
 */


var checkout = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(_ref4) {
    var dir = _ref4.dir,
        _ref4$gitdir = _ref4.gitdir,
        gitdir = _ref4$gitdir === undefined ? path.join(dir, '.git') : _ref4$gitdir,
        _fs = _ref4.fs,
        remote = _ref4.remote,
        ref = _ref4.ref;

    var fs, oid, remoteRef, commit, comm, sha, _ref6, type, object, tree;

    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            // Get tree oid

            oid = void 0;

            if (!remote) {
              _context3.next = 19;
              break;
            }

            remoteRef = void 0;

            if (!(ref === undefined)) {
              _context3.next = 11;
              break;
            }

            _context3.next = 7;
            return managers_js.GitRefManager.resolve({
              fs: fs,
              gitdir: gitdir,
              ref: remote + '/HEAD',
              depth: 2
            });

          case 7:
            remoteRef = _context3.sent;

            ref = path.basename(remoteRef);
            _context3.next = 12;
            break;

          case 11:
            remoteRef = remote + '/' + ref;

          case 12:
            _context3.next = 14;
            return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: remoteRef });

          case 14:
            oid = _context3.sent;
            _context3.next = 17;
            return fs.write(gitdir + '/refs/heads/' + ref, oid + '\n');

          case 17:
            _context3.next = 24;
            break;

          case 19:
            if (!(ref === undefined)) {
              _context3.next = 21;
              break;
            }

            throw new Error('Cannot checkout ref "undefined"');

          case 21:
            _context3.next = 23;
            return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: ref });

          case 23:
            oid = _context3.sent;

          case 24:
            _context3.next = 26;
            return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: oid });

          case 26:
            commit = _context3.sent;

            if (!(commit.type !== 'commit')) {
              _context3.next = 29;
              break;
            }

            throw new Error('Unexpected type: ' + commit.type);

          case 29:
            comm = models_js.GitCommit.from(commit.object.toString('utf8'));
            sha = comm.headers().tree;
            // Get top-level tree

            _context3.next = 33;
            return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: sha });

          case 33:
            _ref6 = _context3.sent;
            type = _ref6.type;
            object = _ref6.object;

            if (!(type !== 'tree')) {
              _context3.next = 38;
              break;
            }

            throw new Error('Unexpected type: ' + type);

          case 38:
            tree = models_js.GitTree.from(object);
            // Acquire a lock on the index

            _context3.next = 41;
            return managers_js.GitIndexManager.acquire({ fs: fs, filepath: gitdir + '/index' }, function () {
              var _ref7 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(index) {
                var _iteratorNormalCompletion2, _didIteratorError2, _iteratorError2, _iterator2, _step2, entry;

                return _regeneratorRuntime.wrap(function _callee2$(_context2) {
                  while (1) {
                    switch (_context2.prev = _context2.next) {
                      case 0:
                        // TODO: Big optimization possible here.
                        // Instead of deleting and rewriting everything, only delete files
                        // that are not present in the new branch, and only write files that
                        // are not in the index or are in the index but have the wrong SHA.
                        _iteratorNormalCompletion2 = true;
                        _didIteratorError2 = false;
                        _iteratorError2 = undefined;
                        _context2.prev = 3;
                        _iterator2 = _getIterator(index);

                      case 5:
                        if (_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done) {
                          _context2.next = 17;
                          break;
                        }

                        entry = _step2.value;
                        _context2.prev = 7;
                        _context2.next = 10;
                        return fs.rm(path.join(dir, entry.path));

                      case 10:
                        _context2.next = 14;
                        break;

                      case 12:
                        _context2.prev = 12;
                        _context2.t0 = _context2['catch'](7);

                      case 14:
                        _iteratorNormalCompletion2 = true;
                        _context2.next = 5;
                        break;

                      case 17:
                        _context2.next = 23;
                        break;

                      case 19:
                        _context2.prev = 19;
                        _context2.t1 = _context2['catch'](3);
                        _didIteratorError2 = true;
                        _iteratorError2 = _context2.t1;

                      case 23:
                        _context2.prev = 23;
                        _context2.prev = 24;

                        if (!_iteratorNormalCompletion2 && _iterator2.return) {
                          _iterator2.return();
                        }

                      case 26:
                        _context2.prev = 26;

                        if (!_didIteratorError2) {
                          _context2.next = 29;
                          break;
                        }

                        throw _iteratorError2;

                      case 29:
                        return _context2.finish(26);

                      case 30:
                        return _context2.finish(23);

                      case 31:
                        index.clear();
                        // Write files. TODO: Write them atomically
                        _context2.next = 34;
                        return writeTreeToDisk({ fs: fs, gitdir: gitdir, dir: dir, index: index, prefix: '', tree: tree });

                      case 34:
                        _context2.next = 36;
                        return fs.write(gitdir + '/HEAD', 'ref: refs/heads/' + ref);

                      case 36:
                      case 'end':
                        return _context2.stop();
                    }
                  }
                }, _callee2, this, [[3, 19, 23, 31], [7, 12], [24,, 26, 30]]);
              }));

              return function (_x3) {
                return _ref7.apply(this, arguments);
              };
            }());

          case 41:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, this);
  }));

  return function checkout(_x2) {
    return _ref5.apply(this, arguments);
  };
}();

/**
 * Clone a repository
 *
 * @link https://isomorphic-git.github.io/docs/clone.html
 */
var clone = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        emitter = _ref.emitter,
        url = _ref.url,
        ref = _ref.ref,
        remote = _ref.remote,
        authUsername = _ref.authUsername,
        authPassword = _ref.authPassword,
        depth = _ref.depth,
        since = _ref.since,
        exclude = _ref.exclude,
        relative = _ref.relative,
        onprogress = _ref.onprogress;
    var fs;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            if (onprogress !== undefined) {
              console.warn('The `onprogress` callback has been deprecated. Please use the more generic `emitter` EventEmitter argument instead.');
            }
            fs = new models_js.FileSystem(_fs);

            remote = remote || 'origin';
            _context.next = 5;
            return init({ gitdir: gitdir, fs: fs });

          case 5:
            _context.next = 7;
            return config({
              gitdir: gitdir,
              fs: fs,
              path: 'remote.' + remote + '.url',
              value: url
            });

          case 7:
            _context.next = 9;
            return fetch({
              gitdir: gitdir,
              fs: fs,
              emitter: emitter,
              ref: ref,
              remote: remote,
              authUsername: authUsername,
              authPassword: authPassword,
              depth: depth,
              since: since,
              exclude: exclude,
              relative: relative
            });

          case 9:
            _context.next = 11;
            return checkout({
              dir: dir,
              gitdir: gitdir,
              fs: fs,
              ref: ref,
              remote: remote
            });

          case 11:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function clone(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var constructTree = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var fs = _ref.fs,
        gitdir = _ref.gitdir,
        inode = _ref.inode;

    var children, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, _inode, entries, tree, oid;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            // use depth first traversal
            children = inode.children;
            _iteratorNormalCompletion = true;
            _didIteratorError = false;
            _iteratorError = undefined;
            _context.prev = 4;
            _iterator = _getIterator(children);

          case 6:
            if (_iteratorNormalCompletion = (_step = _iterator.next()).done) {
              _context.next = 16;
              break;
            }

            _inode = _step.value;

            if (!(_inode.type === 'tree')) {
              _context.next = 13;
              break;
            }

            _inode.metadata.mode = '040000';
            _context.next = 12;
            return constructTree({ fs: fs, gitdir: gitdir, inode: _inode });

          case 12:
            _inode.metadata.oid = _context.sent;

          case 13:
            _iteratorNormalCompletion = true;
            _context.next = 6;
            break;

          case 16:
            _context.next = 22;
            break;

          case 18:
            _context.prev = 18;
            _context.t0 = _context['catch'](4);
            _didIteratorError = true;
            _iteratorError = _context.t0;

          case 22:
            _context.prev = 22;
            _context.prev = 23;

            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }

          case 25:
            _context.prev = 25;

            if (!_didIteratorError) {
              _context.next = 28;
              break;
            }

            throw _iteratorError;

          case 28:
            return _context.finish(25);

          case 29:
            return _context.finish(22);

          case 30:
            entries = children.map(function (inode) {
              return {
                mode: inode.metadata.mode,
                path: inode.basename,
                oid: inode.metadata.oid,
                type: inode.type
              };
            });
            tree = models_js.GitTree.from(entries);
            _context.next = 34;
            return managers_js.GitObjectManager.write({
              fs: fs,
              gitdir: gitdir,
              type: 'tree',
              object: tree.toObject()
            });

          case 34:
            oid = _context.sent;
            return _context.abrupt('return', oid);

          case 36:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this, [[4, 18, 22, 30], [23,, 25, 29]]);
  }));

  return function constructTree(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * Create a new commit
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} args.message - The commit message to use.
 * @param {Object} [args.author] - The details about the commit author.
 * @param {string} [args.author.name=undefined] - Default is `user.name` config.
 * @param {string} [args.author.email=undefined] - Default is `user.email` config.
 * @param {Date} [args.author.date=new Date()] - Set the author timestamp field. Default is the current date.
 * @param {number} [args.author.timestamp=undefined] - Set the author timestamp field. This is an alternative to using `date` using an integer number of seconds since the Unix epoch instead of a JavaScript date object.
 * @param {Object} [args.committer=author] - The details about the commit committer, in the same format as the author parameter. If not specified, the author details are used.
 * @returns {Promise<string>} - The object ID of the newly created commit.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * let sha = await git.commit({
 *   ...repo,
 *   author: {
 *     name: '<@Mr. Test@>',
 *     email: '<@mrtest@example.com@>'
 *   },
 *   message: '<@Added the a.txt file@>'
 * })
 * console.log(sha)
 */


var commit = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(_ref3) {
    var dir = _ref3.dir,
        _ref3$gitdir = _ref3.gitdir,
        gitdir = _ref3$gitdir === undefined ? path.join(dir, '.git') : _ref3$gitdir,
        _fs = _ref3.fs,
        message = _ref3.message,
        author = _ref3.author,
        committer = _ref3.committer;
    var fs, authorDateTime, committerDateTime, oid;
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            // Fill in missing arguments with default values

            if (author === undefined) author = {};

            if (!(author.name === undefined)) {
              _context3.next = 6;
              break;
            }

            _context3.next = 5;
            return config({ fs: fs, gitdir: gitdir, path: 'user.name' });

          case 5:
            author.name = _context3.sent;

          case 6:
            if (!(author.email === undefined)) {
              _context3.next = 10;
              break;
            }

            _context3.next = 9;
            return config({ fs: fs, gitdir: gitdir, path: 'user.email' });

          case 9:
            author.email = _context3.sent;

          case 10:
            committer = committer || author;
            authorDateTime = author.date || new Date();
            committerDateTime = committer.date || authorDateTime;
            oid = void 0;
            _context3.next = 16;
            return managers_js.GitIndexManager.acquire({ fs: fs, filepath: gitdir + '/index' }, function () {
              var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(index) {
                var inode, treeRef, parents, parent, comm, branch;
                return _regeneratorRuntime.wrap(function _callee2$(_context2) {
                  while (1) {
                    switch (_context2.prev = _context2.next) {
                      case 0:
                        inode = utils_js.flatFileListToDirectoryStructure(index.entries);
                        _context2.next = 3;
                        return constructTree({ fs: fs, gitdir: gitdir, inode: inode });

                      case 3:
                        treeRef = _context2.sent;
                        parents = void 0;
                        _context2.prev = 5;
                        _context2.next = 8;
                        return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: 'HEAD' });

                      case 8:
                        parent = _context2.sent;

                        parents = [parent];
                        _context2.next = 15;
                        break;

                      case 12:
                        _context2.prev = 12;
                        _context2.t0 = _context2['catch'](5);

                        // Probably an initial commit
                        parents = [];

                      case 15:
                        comm = models_js.GitCommit.from({
                          tree: treeRef,
                          parent: parents,
                          author: {
                            name: author.name,
                            email: author.email,
                            timestamp: author.timestamp || Math.floor(authorDateTime.valueOf() / 1000),
                            timezoneOffset: author.timezoneOffset || 0
                          },
                          committer: {
                            name: committer.name,
                            email: committer.email,
                            timestamp: committer.timestamp || Math.floor(committerDateTime.valueOf() / 1000),
                            timezoneOffset: committer.timezoneOffset || 0
                          },
                          message: message
                        });
                        _context2.next = 18;
                        return managers_js.GitObjectManager.write({
                          fs: fs,
                          gitdir: gitdir,
                          type: 'commit',
                          object: comm.toObject()
                        });

                      case 18:
                        oid = _context2.sent;
                        _context2.next = 21;
                        return managers_js.GitRefManager.resolve({
                          fs: fs,
                          gitdir: gitdir,
                          ref: 'HEAD',
                          depth: 2
                        });

                      case 21:
                        branch = _context2.sent;
                        _context2.next = 24;
                        return fs.write(path.join(gitdir, branch), oid + '\n');

                      case 24:
                      case 'end':
                        return _context2.stop();
                    }
                  }
                }, _callee2, this, [[5, 12]]);
              }));

              return function (_x3) {
                return _ref5.apply(this, arguments);
              };
            }());

          case 16:
            return _context3.abrupt('return', oid);

          case 17:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, this);
  }));

  return function commit(_x2) {
    return _ref4.apply(this, arguments);
  };
}();

/**
 * List all the tracked files in a repo
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @returns {Promise<string[]>} - Resolves successfully with an array of file paths.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * let files = await git.listFiles(repo)
 * console.log(files)
 */
var listFiles = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs;
    var fs, filenames;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            filenames = void 0;
            _context2.next = 4;
            return managers_js.GitIndexManager.acquire({ fs: fs, filepath: gitdir + '/index' }, function () {
              var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(index) {
                return _regeneratorRuntime.wrap(function _callee$(_context) {
                  while (1) {
                    switch (_context.prev = _context.next) {
                      case 0:
                        filenames = index.entries.map(function (x) {
                          return x.path;
                        });

                      case 1:
                      case 'end':
                        return _context.stop();
                    }
                  }
                }, _callee, this);
              }));

              return function (_x2) {
                return _ref3.apply(this, arguments);
              };
            }());

          case 4:
            return _context2.abrupt('return', filenames);

          case 5:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, this);
  }));

  return function listFiles(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * List branches
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} [remote=undefined] - If specified, lists the branches for that remote. Otherwise lists local branches.
 * @returns {Promise<string[]>} - Resolves successfully with an array of branch names.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * let branches = await git.listBranches(repo)
 * console.log(branches)
 */
var listBranches = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        _ref$remote = _ref.remote,
        remote = _ref$remote === undefined ? undefined : _ref$remote;
    var fs;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            return _context.abrupt('return', managers_js.GitRefManager.listBranches({ fs: fs, gitdir: gitdir, remote: remote }));

          case 2:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function listBranches(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * List all local tags
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @returns {Promise<string[]>} - Resolves successfully with an array of branch names.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * let tags = await git.listTags(repo)
 * console.log(tags)
 */
var listTags = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs;
    var fs;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            return _context.abrupt('return', managers_js.GitRefManager.listTags({ fs: fs, gitdir: gitdir }));

          case 2:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function listTags(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * @typedef {Object} CommitDescription
 * @property {string} oid - SHA1 object id of this commit
 * @property {string} message - Commit message
 * @property {string} tree - SHA1 object id of corresponding file tree
 * @property {string[]} parent - an array of zero or more SHA1 oids
 * @property {Object} author
 * @property {string} author.name
 * @property {string} author.email
 * @property {number} author.timestamp - UTC Unix timestamp in seconds
 * @property {number} author.timezoneOffset - Timezone difference from UTC in minutes
 * @property {Object} committer
 * @property {string} committer.name
 * @property {string} committer.email
 * @property {number} committer.timestamp - UTC Unix timestamp in seconds
 * @property {number} committer.timezoneOffset - Timezone difference from UTC in minutes
 * @property {string} [gpgsig] - PGP signature (if present)
 */

/**
 * Get commit descriptions from the git history
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {number} [args.depth=undefined] - Limit the number of commits returned. No limit by default.
 * @param {Date} [args.since=undefined] - Return history newer than the given date. Can be combined with `depth` to get whichever is shorter.
 * @param {string} [args.ref=HEAD] - The commit to begin walking backwards through the history from.
 * @returns {Promise<CommitDescription[]>} - Resolves to an array of {@link CommitDescription} objects
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * let commits = await git.log({...repo, depth: 5, ref: '<@master@>'})
 * console.log(commits)
 */
var log$1 = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        _ref$ref = _ref.ref,
        ref = _ref$ref === undefined ? 'HEAD' : _ref$ref,
        depth = _ref.depth,
        since = _ref.since;

    var fs, sinceTimestamp, commits, start, _ref3, type, object, currentCommit, oid, gitobject, _gitobject, _type, _object;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            sinceTimestamp = since === undefined ? undefined : Math.floor(since.valueOf() / 1000);
            // TODO: In the future, we may want to have an API where we return a
            // async iterator that emits commits.

            commits = [];
            _context.next = 5;
            return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: ref });

          case 5:
            start = _context.sent;
            _context.next = 8;
            return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: start });

          case 8:
            _ref3 = _context.sent;
            type = _ref3.type;
            object = _ref3.object;

            if (!(type !== 'commit')) {
              _context.next = 13;
              break;
            }

            throw new Error('The given ref ' + ref + ' did not resolve to a commit but to a ' + type);

          case 13:
            currentCommit = _extends({ oid: start }, models_js.GitCommit.from(object).parse());

            commits.push(currentCommit);

          case 15:
            

            if (!(depth !== undefined && commits.length === depth)) {
              _context.next = 18;
              break;
            }

            return _context.abrupt('break', 42);

          case 18:
            if (!(currentCommit.parent.length === 0)) {
              _context.next = 20;
              break;
            }

            return _context.abrupt('break', 42);

          case 20:
            oid = currentCommit.parent[0];
            gitobject = void 0;
            _context.prev = 22;
            _context.next = 25;
            return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: oid });

          case 25:
            gitobject = _context.sent;
            _context.next = 32;
            break;

          case 28:
            _context.prev = 28;
            _context.t0 = _context['catch'](22);

            commits.push({
              oid: oid,
              error: _context.t0
            });
            return _context.abrupt('break', 42);

          case 32:
            _gitobject = gitobject, _type = _gitobject.type, _object = _gitobject.object;

            if (!(_type !== 'commit')) {
              _context.next = 36;
              break;
            }

            commits.push({
              oid: oid,
              error: new Error('Invalid commit parent ' + oid + ' is of type ' + _type)
            });
            return _context.abrupt('break', 42);

          case 36:
            currentCommit = _extends({ oid: oid }, models_js.GitCommit.from(_object).parse());

            if (!(sinceTimestamp !== undefined && currentCommit.author.timestamp <= sinceTimestamp)) {
              _context.next = 39;
              break;
            }

            return _context.abrupt('break', 42);

          case 39:
            commits.push(currentCommit);
            _context.next = 15;
            break;

          case 42:
            return _context.abrupt('return', commits);

          case 43:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this, [[22, 28]]);
  }));

  return function log$$1(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var types$1 = {
  commit: 16,
  tree: 32,
  blob: 48,
  tag: 64,
  ofs_delta: 96,
  ref_delta: 112

  /**
   *
   * If there were no errors, then there will be no `errors` property.
   * There can be a mix of `ok` messages and `errors` messages.
   *
   * @typedef {Object} PushResponse
   * @property {Array<string>} [ok] - The first item is "unpack" if the overall operation was successful. The remaining items are the names of refs that were updated successfully.
   * @property {Array<string>} [errors] - If the overall operation threw and error, the first item will be "unpack {Overall error message}". The remaining items are individual refs that failed to be updated in the format "{ref name} {error message}".
   */

  /**
   * Push a branch
   *
   * @param {Object} args - Arguments object
   * @param {FSModule} args.fs - The filesystem holding the git repo
   * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
   * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
   * @param {string} [args.ref=undefined] - Which branch to push. By default this is the currently checked out branch of the repository.
   * @param {string} [args.remote='origin'] - If URL is not specified, determines which remote to use.
   * @param {string} [args.url=undefined] - The URL of the remote git server. The default is the value set in the git config for that remote.
   * @param {string} [args.authUsername=undefined] - The username to use with Basic Auth
   * @param {string} [args.authPassword=undefined] - The password to use with Basic Auth
   * @returns {Promise<PushResponse>} - Resolves successfully when push completes with a detailed description of the operation from the server.
   *
   * @example
   * let repo = {fs, dir: '<@.@>'}
   * let pushResponse = await git.push({
   *   ...repo,
   *   remote: '<@origin@>',
   *   ref: '<@master@>',
   *   authUsername: <@process.env.GITHUB_TOKEN@>,
   *   authPassword: <@process.env.GITHUB_TOKEN@>
   * })
   * console.log(pushResponse)
   */
};var push = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var _fs = _ref.fs,
        dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        ref = _ref.ref,
        _ref$remote = _ref.remote,
        remote = _ref$remote === undefined ? 'origin' : _ref$remote,
        url = _ref.url,
        authUsername = _ref.authUsername,
        authPassword = _ref.authPassword;
    var fs, fullRef, oid, httpRemote, commits, objects, packstream, oldoid, response;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            // TODO: Figure out how pushing tags works. (This only works for branches.)

            if (!(url === undefined)) {
              _context.next = 5;
              break;
            }

            _context.next = 4;
            return config({ fs: fs, gitdir: gitdir, path: 'remote.' + remote + '.url' });

          case 4:
            url = _context.sent;

          case 5:
            fullRef = ref.startsWith('refs/') ? ref : 'refs/heads/' + ref;
            _context.next = 8;
            return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: ref });

          case 8:
            oid = _context.sent;
            httpRemote = new managers_js.GitRemoteHTTP(url);

            if (authUsername !== undefined && authPassword !== undefined) {
              httpRemote.auth = {
                username: authUsername,
                password: authPassword
              };
            }
            _context.next = 13;
            return httpRemote.preparePush();

          case 13:
            _context.next = 15;
            return listCommits({
              fs: fs,
              gitdir: gitdir,
              start: [oid],
              finish: httpRemote.refs.values()
            });

          case 15:
            commits = _context.sent;
            _context.next = 18;
            return listObjects({ fs: fs, gitdir: gitdir, oids: commits });

          case 18:
            objects = _context.sent;
            packstream = new stream.PassThrough();
            oldoid = httpRemote.refs.get(fullRef) || '0000000000000000000000000000000000000000';

            packstream.write(models_js.GitPktLine.encode(oldoid + ' ' + oid + ' ' + fullRef + '\0 report-status\n'));
            packstream.write(models_js.GitPktLine.flush());
            pack({
              fs: fs,
              gitdir: gitdir,
              oids: [].concat(_toConsumableArray(objects)),
              outputStream: packstream
            });
            _context.next = 26;
            return httpRemote.push(packstream);

          case 26:
            response = _context.sent;
            return _context.abrupt('return', response);

          case 28:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function push(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/** @ignore */
var listCommits = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(_ref3) {

    // Because git commits are named by their hash, there is no
    // way to construct a cycle. Therefore we won't worry about
    // setting a default recursion limit.
    var walk = function () {
      var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(oid) {
        var _ref7, type, object, commit, parents, _iteratorNormalCompletion3, _didIteratorError3, _iteratorError3, _iterator3, _step3;

        return _regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                visited.add(oid);
                _context2.next = 3;
                return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: oid });

              case 3:
                _ref7 = _context2.sent;
                type = _ref7.type;
                object = _ref7.object;

                if (!(type !== 'commit')) {
                  _context2.next = 8;
                  break;
                }

                throw new Error('Expected type commit but type is ' + type);

              case 8:
                commit = models_js.GitCommit.from(object);
                parents = commit.headers().parent;
                _iteratorNormalCompletion3 = true;
                _didIteratorError3 = false;
                _iteratorError3 = undefined;
                _context2.prev = 13;
                _iterator3 = _getIterator(parents);

              case 15:
                if (_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done) {
                  _context2.next = 23;
                  break;
                }

                oid = _step3.value;

                if (!(!finishingSet.has(oid) && !visited.has(oid))) {
                  _context2.next = 20;
                  break;
                }

                _context2.next = 20;
                return walk(oid);

              case 20:
                _iteratorNormalCompletion3 = true;
                _context2.next = 15;
                break;

              case 23:
                _context2.next = 29;
                break;

              case 25:
                _context2.prev = 25;
                _context2.t0 = _context2['catch'](13);
                _didIteratorError3 = true;
                _iteratorError3 = _context2.t0;

              case 29:
                _context2.prev = 29;
                _context2.prev = 30;

                if (!_iteratorNormalCompletion3 && _iterator3.return) {
                  _iterator3.return();
                }

              case 32:
                _context2.prev = 32;

                if (!_didIteratorError3) {
                  _context2.next = 35;
                  break;
                }

                throw _iteratorError3;

              case 35:
                return _context2.finish(32);

              case 36:
                return _context2.finish(29);

              case 37:
              case 'end':
                return _context2.stop();
            }
          }
        }, _callee2, this, [[13, 25, 29, 37], [30,, 32, 36]]);
      }));

      return function walk(_x3) {
        return _ref6.apply(this, arguments);
      };
    }();

    // Let's go walking!


    var dir = _ref3.dir,
        _ref3$gitdir = _ref3.gitdir,
        gitdir = _ref3$gitdir === undefined ? path.join(dir, '.git') : _ref3$gitdir,
        _fs = _ref3.fs,
        start = _ref3.start,
        finish = _ref3.finish;

    var fs, startingSet, finishingSet, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, ref, _iteratorNormalCompletion2, _didIteratorError2, _iteratorError2, _iterator2, _step2, _ref5, _oid, visited, _iteratorNormalCompletion4, _didIteratorError4, _iteratorError4, _iterator4, _step4, oid;

    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            startingSet = new _Set();
            finishingSet = new _Set();
            _iteratorNormalCompletion = true;
            _didIteratorError = false;
            _iteratorError = undefined;
            _context3.prev = 6;
            _iterator = _getIterator(start);

          case 8:
            if (_iteratorNormalCompletion = (_step = _iterator.next()).done) {
              _context3.next = 18;
              break;
            }

            ref = _step.value;
            _context3.t0 = startingSet;
            _context3.next = 13;
            return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: ref });

          case 13:
            _context3.t1 = _context3.sent;

            _context3.t0.add.call(_context3.t0, _context3.t1);

          case 15:
            _iteratorNormalCompletion = true;
            _context3.next = 8;
            break;

          case 18:
            _context3.next = 24;
            break;

          case 20:
            _context3.prev = 20;
            _context3.t2 = _context3['catch'](6);
            _didIteratorError = true;
            _iteratorError = _context3.t2;

          case 24:
            _context3.prev = 24;
            _context3.prev = 25;

            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }

          case 27:
            _context3.prev = 27;

            if (!_didIteratorError) {
              _context3.next = 30;
              break;
            }

            throw _iteratorError;

          case 30:
            return _context3.finish(27);

          case 31:
            return _context3.finish(24);

          case 32:
            _iteratorNormalCompletion2 = true;
            _didIteratorError2 = false;
            _iteratorError2 = undefined;
            _context3.prev = 35;
            _iterator2 = _getIterator(finish);

          case 37:
            if (_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done) {
              _context3.next = 51;
              break;
            }

            _ref5 = _step2.value;
            _context3.prev = 39;
            _context3.next = 42;
            return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: _ref5 });

          case 42:
            _oid = _context3.sent;

            finishingSet.add(_oid);
            _context3.next = 48;
            break;

          case 46:
            _context3.prev = 46;
            _context3.t3 = _context3['catch'](39);

          case 48:
            _iteratorNormalCompletion2 = true;
            _context3.next = 37;
            break;

          case 51:
            _context3.next = 57;
            break;

          case 53:
            _context3.prev = 53;
            _context3.t4 = _context3['catch'](35);
            _didIteratorError2 = true;
            _iteratorError2 = _context3.t4;

          case 57:
            _context3.prev = 57;
            _context3.prev = 58;

            if (!_iteratorNormalCompletion2 && _iterator2.return) {
              _iterator2.return();
            }

          case 60:
            _context3.prev = 60;

            if (!_didIteratorError2) {
              _context3.next = 63;
              break;
            }

            throw _iteratorError2;

          case 63:
            return _context3.finish(60);

          case 64:
            return _context3.finish(57);

          case 65:
            visited /*: Set<string> */ = new _Set();
            _iteratorNormalCompletion4 = true;
            _didIteratorError4 = false;
            _iteratorError4 = undefined;
            _context3.prev = 69;
            _iterator4 = _getIterator(startingSet);

          case 71:
            if (_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done) {
              _context3.next = 78;
              break;
            }

            oid = _step4.value;
            _context3.next = 75;
            return walk(oid);

          case 75:
            _iteratorNormalCompletion4 = true;
            _context3.next = 71;
            break;

          case 78:
            _context3.next = 84;
            break;

          case 80:
            _context3.prev = 80;
            _context3.t5 = _context3['catch'](69);
            _didIteratorError4 = true;
            _iteratorError4 = _context3.t5;

          case 84:
            _context3.prev = 84;
            _context3.prev = 85;

            if (!_iteratorNormalCompletion4 && _iterator4.return) {
              _iterator4.return();
            }

          case 87:
            _context3.prev = 87;

            if (!_didIteratorError4) {
              _context3.next = 90;
              break;
            }

            throw _iteratorError4;

          case 90:
            return _context3.finish(87);

          case 91:
            return _context3.finish(84);

          case 92:
            return _context3.abrupt('return', visited);

          case 93:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, this, [[6, 20, 24, 32], [25,, 27, 31], [35, 53, 57, 65], [39, 46], [58,, 60, 64], [69, 80, 84, 92], [85,, 87, 91]]);
  }));

  return function listCommits(_x2) {
    return _ref4.apply(this, arguments);
  };
}();

/** @ignore */
var listObjects = function () {
  var _ref9 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(_ref8) {

    // We don't do the purest simplest recursion, because we can
    // avoid reading Blob objects entirely since the Tree objects
    // tell us which oids are Blobs and which are Trees.
    var walk = function () {
      var _ref10 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(oid) {
        var _ref11, type, object, commit, tree, _tree, _iteratorNormalCompletion5, _didIteratorError5, _iteratorError5, _iterator5, _step5, entry;

        return _regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                visited.add(oid);
                _context4.next = 3;
                return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: oid });

              case 3:
                _ref11 = _context4.sent;
                type = _ref11.type;
                object = _ref11.object;

                if (!(type === 'commit')) {
                  _context4.next = 13;
                  break;
                }

                commit = models_js.GitCommit.from(object);
                tree = commit.headers().tree;
                _context4.next = 11;
                return walk(tree);

              case 11:
                _context4.next = 43;
                break;

              case 13:
                if (!(type === 'tree')) {
                  _context4.next = 43;
                  break;
                }

                _tree = models_js.GitTree.from(object);
                _iteratorNormalCompletion5 = true;
                _didIteratorError5 = false;
                _iteratorError5 = undefined;
                _context4.prev = 18;
                _iterator5 = _getIterator( /*: TreeEntry */_tree);

              case 20:
                if (_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done) {
                  _context4.next = 29;
                  break;
                }

                entry = _step5.value;

                visited.add(entry.oid);
                // only recurse for trees

                if (!(entry.type === 'tree')) {
                  _context4.next = 26;
                  break;
                }

                _context4.next = 26;
                return walk(entry.oid);

              case 26:
                _iteratorNormalCompletion5 = true;
                _context4.next = 20;
                break;

              case 29:
                _context4.next = 35;
                break;

              case 31:
                _context4.prev = 31;
                _context4.t0 = _context4['catch'](18);
                _didIteratorError5 = true;
                _iteratorError5 = _context4.t0;

              case 35:
                _context4.prev = 35;
                _context4.prev = 36;

                if (!_iteratorNormalCompletion5 && _iterator5.return) {
                  _iterator5.return();
                }

              case 38:
                _context4.prev = 38;

                if (!_didIteratorError5) {
                  _context4.next = 41;
                  break;
                }

                throw _iteratorError5;

              case 41:
                return _context4.finish(38);

              case 42:
                return _context4.finish(35);

              case 43:
              case 'end':
                return _context4.stop();
            }
          }
        }, _callee4, this, [[18, 31, 35, 43], [36,, 38, 42]]);
      }));

      return function walk(_x5) {
        return _ref10.apply(this, arguments);
      };
    }();

    // Let's go walking!


    var dir = _ref8.dir,
        _ref8$gitdir = _ref8.gitdir,
        gitdir = _ref8$gitdir === undefined ? path.join(dir, '.git') : _ref8$gitdir,
        _fs = _ref8.fs,
        oids = _ref8.oids;

    var fs, visited, _iteratorNormalCompletion6, _didIteratorError6, _iteratorError6, _iterator6, _step6, oid;

    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            visited /*: Set<string> */ = new _Set();
            _iteratorNormalCompletion6 = true;
            _didIteratorError6 = false;
            _iteratorError6 = undefined;
            _context5.prev = 5;
            _iterator6 = _getIterator(oids);

          case 7:
            if (_iteratorNormalCompletion6 = (_step6 = _iterator6.next()).done) {
              _context5.next = 14;
              break;
            }

            oid = _step6.value;
            _context5.next = 11;
            return walk(oid);

          case 11:
            _iteratorNormalCompletion6 = true;
            _context5.next = 7;
            break;

          case 14:
            _context5.next = 20;
            break;

          case 16:
            _context5.prev = 16;
            _context5.t0 = _context5['catch'](5);
            _didIteratorError6 = true;
            _iteratorError6 = _context5.t0;

          case 20:
            _context5.prev = 20;
            _context5.prev = 21;

            if (!_iteratorNormalCompletion6 && _iterator6.return) {
              _iterator6.return();
            }

          case 23:
            _context5.prev = 23;

            if (!_didIteratorError6) {
              _context5.next = 26;
              break;
            }

            throw _iteratorError6;

          case 26:
            return _context5.finish(23);

          case 27:
            return _context5.finish(20);

          case 28:
            return _context5.abrupt('return', visited);

          case 29:
          case 'end':
            return _context5.stop();
        }
      }
    }, _callee5, this, [[5, 16, 20, 28], [21,, 23, 27]]);
  }));

  return function listObjects(_x4) {
    return _ref9.apply(this, arguments);
  };
}();

/** @ignore */
var pack = function () {
  var _ref13 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee6(_ref12) {
    var dir = _ref12.dir,
        _ref12$gitdir = _ref12.gitdir,
        gitdir = _ref12$gitdir === undefined ? path.join(dir, '.git') : _ref12$gitdir,
        _fs = _ref12.fs,
        oids = _ref12.oids,
        outputStream = _ref12.outputStream;

    var fs, hash, write, writeObject, _iteratorNormalCompletion7, _didIteratorError7, _iteratorError7, _iterator7, _step7, oid, _ref15, type, object, digest;

    return _regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            writeObject = function writeObject(_ref14) {
              var stype = _ref14.stype,
                  object = _ref14.object;

              var lastFour = void 0,
                  multibyte = void 0,
                  length = void 0;
              // Object type is encoded in bits 654
              var type = types$1[stype];
              if (type === undefined) throw new Error('Unrecognized type: ' + stype);
              // The length encoding get complicated.
              length = object.length;
              // Whether the next byte is part of the variable-length encoded number
              // is encoded in bit 7
              multibyte = length > 15 ? 128 : 0;
              // Last four bits of length is encoded in bits 3210
              lastFour = length & 15;
              // Discard those bits
              length = length >>> 4;
              // The first byte is then (1-bit multibyte?), (3-bit type), (4-bit least sig 4-bits of length)
              var byte = (multibyte | type | lastFour).toString(16);
              write(byte, 'hex');
              // Now we keep chopping away at length 7-bits at a time until its zero,
              // writing out the bytes in what amounts to little-endian order.
              while (multibyte) {
                multibyte = length > 127 ? 128 : 0;
                byte = multibyte | length & 127;
                write(pad(2, byte.toString(16), '0'), 'hex');
                length = length >>> 7;
              }
              // Lastly, we can compress and write the object.
              write(buffer.Buffer.from(pako.deflate(object)));
            };

            write = function write(chunk, enc) {
              outputStream.write(chunk, enc);
              hash.update(chunk, enc);
            };

            fs = new models_js.FileSystem(_fs);
            hash = createHash('sha1');


            write('PACK');
            write('00000002', 'hex');
            // Write a 4 byte (32-bit) int
            write(pad(8, oids.length.toString(16), '0'), 'hex');
            _iteratorNormalCompletion7 = true;
            _didIteratorError7 = false;
            _iteratorError7 = undefined;
            _context6.prev = 10;
            _iterator7 = _getIterator(oids);

          case 12:
            if (_iteratorNormalCompletion7 = (_step7 = _iterator7.next()).done) {
              _context6.next = 23;
              break;
            }

            oid = _step7.value;
            _context6.next = 16;
            return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: oid });

          case 16:
            _ref15 = _context6.sent;
            type = _ref15.type;
            object = _ref15.object;

            writeObject({ write: write, object: object, stype: type });

          case 20:
            _iteratorNormalCompletion7 = true;
            _context6.next = 12;
            break;

          case 23:
            _context6.next = 29;
            break;

          case 25:
            _context6.prev = 25;
            _context6.t0 = _context6['catch'](10);
            _didIteratorError7 = true;
            _iteratorError7 = _context6.t0;

          case 29:
            _context6.prev = 29;
            _context6.prev = 30;

            if (!_iteratorNormalCompletion7 && _iterator7.return) {
              _iterator7.return();
            }

          case 32:
            _context6.prev = 32;

            if (!_didIteratorError7) {
              _context6.next = 35;
              break;
            }

            throw _iteratorError7;

          case 35:
            return _context6.finish(32);

          case 36:
            return _context6.finish(29);

          case 37:
            // Write SHA1 checksum
            digest = hash.digest();

            outputStream.end(digest);
            return _context6.abrupt('return', outputStream);

          case 40:
          case 'end':
            return _context6.stop();
        }
      }
    }, _callee6, this, [[10, 25, 29, 37], [30,, 32, 36]]);
  }));

  return function pack(_x6) {
    return _ref13.apply(this, arguments);
  };
}();

/**
 * Remove a file from the git index (aka staging area)
 *
 * Note that this does NOT delete the file in the working directory.
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} args.filepath - The path to the file to remove to the index.
 * @returns {Promise<void>} - Resolves successfully once the git index has been updated.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * await git.remove({...repo, filepath: '<@README.md@>'})
 * console.log('done')
 */
var remove = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        filepath = _ref.filepath;
    var fs;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            _context2.next = 3;
            return managers_js.GitIndexManager.acquire({ fs: fs, filepath: gitdir + '/index' }, function () {
              var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(index) {
                return _regeneratorRuntime.wrap(function _callee$(_context) {
                  while (1) {
                    switch (_context.prev = _context.next) {
                      case 0:
                        index.delete({ filepath: filepath });

                      case 1:
                      case 'end':
                        return _context.stop();
                    }
                  }
                }, _callee, this);
              }));

              return function (_x2) {
                return _ref3.apply(this, arguments);
              };
            }());

          case 3:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, this);
  }));

  return function remove(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * Verify a signed commit
 *
 * It is up to you to figure out what the commit's public key *should* be.
 * I would use the "author" or "committer" name and email, and look up
 * that person's public key from a trusted source such as the Github API.
 *
 * The function returns false if any of the signatures on a signed git commit are invalid.
 * Otherwise, it returns an array of the key ids that were used to sign it.
 *
 * The {@link publicKeys} argument is a single string in ASCII armor format. However, it is plural "keys" because
 * you can technically have multiple public keys in a single ASCII armor string. While I haven't tested it, it
 * should support verifying a single commit signed with multiple keys. Hence why the returned result is an array of key ids.
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} args.ref - A reference to the commit to verify
 * @param {string} args.publicKeys - A PGP public key in ASCII armor format.
 * @returns {Promise<false|Array<string>>} - The key ids used to sign the commit, in hex format.
 *
 * @example
 * let repo = {fs, dir: '.'}
 * let keyids = await git.verify({
 *   ...repo,
 *   ref: '<@HEAD@>',
 *   publicKeys: `<<@
 * -----BEGIN PGP PUBLIC KEY BLOCK-----
 * ...
 * @>>`
 * })
 * console.log(keyids)
 */
var verify = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        ref = _ref.ref,
        publicKeys = _ref.publicKeys,
        openpgp = _ref.openpgp;

    var fs, oid, _ref3, type, object, commit, keys, validity;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            _context.next = 3;
            return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: ref });

          case 3:
            oid = _context.sent;
            _context.next = 6;
            return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: oid });

          case 6:
            _ref3 = _context.sent;
            type = _ref3.type;
            object = _ref3.object;

            if (!(type !== 'commit')) {
              _context.next = 11;
              break;
            }

            throw new Error('\'ref\' is not pointing to a \'commit\' object but a \'' + type + '\' object');

          case 11:
            commit = models_js.SignedGitCommit.from(object);
            _context.next = 14;
            return commit.listSigningKeys(openpgp);

          case 14:
            keys = _context.sent;
            _context.next = 17;
            return commit.verify(openpgp, publicKeys);

          case 17:
            validity = _context.sent;

            if (validity) {
              _context.next = 20;
              break;
            }

            return _context.abrupt('return', false);

          case 20:
            return _context.abrupt('return', keys);

          case 21:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function verify(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var getOidAtPath = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref2) {
    var fs = _ref2.fs,
        gitdir = _ref2.gitdir,
        tree = _ref2.tree,
        path$$1 = _ref2.path;

    var dirname, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, entry, _ref4, type, object, _tree;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            if (typeof path$$1 === 'string') path$$1 = path$$1.split('/');
            dirname = path$$1.shift();
            _iteratorNormalCompletion = true;
            _didIteratorError = false;
            _iteratorError = undefined;
            _context.prev = 5;
            _iterator = _getIterator(tree);

          case 7:
            if (_iteratorNormalCompletion = (_step = _iterator.next()).done) {
              _context.next = 25;
              break;
            }

            entry = _step.value;

            if (!(entry.path === dirname)) {
              _context.next = 22;
              break;
            }

            if (!(path$$1.length === 0)) {
              _context.next = 12;
              break;
            }

            return _context.abrupt('return', entry.oid);

          case 12:
            _context.next = 14;
            return managers_js.GitObjectManager.read({
              fs: fs,
              gitdir: gitdir,
              oid: entry.oid
            });

          case 14:
            _ref4 = _context.sent;
            type = _ref4.type;
            object = _ref4.object;

            if (!(type === 'tree')) {
              _context.next = 20;
              break;
            }

            _tree = models_js.GitTree.from(object);
            return _context.abrupt('return', getOidAtPath({ fs: fs, gitdir: gitdir, tree: _tree, path: path$$1 }));

          case 20:
            if (!(type === 'blob')) {
              _context.next = 22;
              break;
            }

            throw new Error('Blob found where tree expected.');

          case 22:
            _iteratorNormalCompletion = true;
            _context.next = 7;
            break;

          case 25:
            _context.next = 31;
            break;

          case 27:
            _context.prev = 27;
            _context.t0 = _context['catch'](5);
            _didIteratorError = true;
            _iteratorError = _context.t0;

          case 31:
            _context.prev = 31;
            _context.prev = 32;

            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }

          case 34:
            _context.prev = 34;

            if (!_didIteratorError) {
              _context.next = 37;
              break;
            }

            throw _iteratorError;

          case 37:
            return _context.finish(34);

          case 38:
            return _context.finish(31);

          case 39:
            return _context.abrupt('return', null);

          case 40:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this, [[5, 27, 31, 39], [32,, 34, 38]]);
  }));

  return function getOidAtPath(_x) {
    return _ref3.apply(this, arguments);
  };
}();

var getHeadTree = function () {
  var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(_ref5) {
    var fs = _ref5.fs,
        gitdir = _ref5.gitdir;

    var oid, _ref7, cobject, commit, _ref8, tobject, tree;

    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: 'HEAD' });

          case 2:
            oid = _context2.sent;
            _context2.next = 5;
            return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: oid });

          case 5:
            _ref7 = _context2.sent;
            cobject = _ref7.object;
            commit = models_js.GitCommit.from(cobject);
            _context2.next = 10;
            return managers_js.GitObjectManager.read({
              fs: fs,
              gitdir: gitdir,
              oid: commit.parseHeaders().tree
            });

          case 10:
            _ref8 = _context2.sent;
            tobject = _ref8.object;
            tree = models_js.GitTree.from(tobject).entries();
            return _context2.abrupt('return', tree);

          case 14:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, this);
  }));

  return function getHeadTree(_x2) {
    return _ref6.apply(this, arguments);
  };
}();

/**
 * Tell whether a file has been changed
 *
 * The possible resolve values are:
 *
 * - `"ignored"` file ignored by a .gitignore rule
 * - `"unmodified"` file unchanged from HEAD commit
 * - `"*modified"` file has modifications, not yet staged
 * - `"*deleted"` file has been removed, but the removal is not yet staged
 * - `"*added"` file is untracked, not yet staged
 * - `"absent"` file not present in HEAD commit, staging area, or working dir
 * - `"modified"` file has modifications, staged
 * - `"deleted"` file has been removed, staged
 * - `"added"` previously untracked file, staged
 * - `"*unmodified"` working dir and HEAD commit match, but index differs
 * - `"*absent"` file not present in working dir or HEAD commit, but present in the index
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} args.filepath - The path to the file to query.
 * @returns {Promise<string>} - Resolves successfully with the file's git status.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * let status = await git.status({...repo, filepath: '<@README.md@>'})
 * console.log(status)
 */


/*::
import type { Stats } from 'fs'
import type { CacheEntry } from '../models/GitIndex'
*/

function cacheIsStale(_ref /*: {
                           entry: CacheEntry,
                           stats: Stats
                           } */
) {
  var entry = _ref.entry,
      stats = _ref.stats;

  // Comparison based on the description in Paragraph 4 of
  // https://www.kernel.org/pub/software/scm/git/docs/technical/racy-git.txt
  return entry.mode !== stats.mode || entry.mtime.valueOf() !== stats.mtime.valueOf() || entry.ctime.valueOf() !== stats.ctime.valueOf() || entry.uid !== stats.uid || entry.gid !== stats.gid || entry.ino !== stats.ino >> 0 || entry.size !== stats.size;
}

var status = function () {
  var _ref10 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(_ref9) {
    var _this = this;

    var dir = _ref9.dir,
        _ref9$gitdir = _ref9.gitdir,
        gitdir = _ref9$gitdir === undefined ? path.join(dir, '.git') : _ref9$gitdir,
        _fs = _ref9.fs,
        filepath = _ref9.filepath;

    var fs, ignored, headTree, treeOid, indexEntry, stats, H, I, W, getWorkdirOid, workdirOid, _workdirOid, _workdirOid2;

    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            _context5.next = 3;
            return managers_js.GitIgnoreManager.isIgnored({
              gitdir: gitdir,
              dir: dir,
              filepath: filepath,
              fs: fs
            });

          case 3:
            ignored = _context5.sent;

            if (!ignored) {
              _context5.next = 6;
              break;
            }

            return _context5.abrupt('return', 'ignored');

          case 6:
            _context5.next = 8;
            return getHeadTree({ fs: fs, gitdir: gitdir });

          case 8:
            headTree = _context5.sent;
            _context5.next = 11;
            return getOidAtPath({
              fs: fs,
              gitdir: gitdir,
              tree: headTree,
              path: filepath
            });

          case 11:
            treeOid = _context5.sent;
            indexEntry = null;
            // Acquire a lock on the index

            _context5.next = 15;
            return managers_js.GitIndexManager.acquire({ fs: fs, filepath: gitdir + '/index' }, function () {
              var _ref11 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(index) {
                var _iteratorNormalCompletion2, _didIteratorError2, _iteratorError2, _iterator2, _step2, entry;

                return _regeneratorRuntime.wrap(function _callee3$(_context3) {
                  while (1) {
                    switch (_context3.prev = _context3.next) {
                      case 0:
                        _iteratorNormalCompletion2 = true;
                        _didIteratorError2 = false;
                        _iteratorError2 = undefined;
                        _context3.prev = 3;
                        _iterator2 = _getIterator(index);

                      case 5:
                        if (_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done) {
                          _context3.next = 13;
                          break;
                        }

                        entry = _step2.value;

                        if (!(entry.path === filepath)) {
                          _context3.next = 10;
                          break;
                        }

                        indexEntry = entry;
                        return _context3.abrupt('break', 13);

                      case 10:
                        _iteratorNormalCompletion2 = true;
                        _context3.next = 5;
                        break;

                      case 13:
                        _context3.next = 19;
                        break;

                      case 15:
                        _context3.prev = 15;
                        _context3.t0 = _context3['catch'](3);
                        _didIteratorError2 = true;
                        _iteratorError2 = _context3.t0;

                      case 19:
                        _context3.prev = 19;
                        _context3.prev = 20;

                        if (!_iteratorNormalCompletion2 && _iterator2.return) {
                          _iterator2.return();
                        }

                      case 22:
                        _context3.prev = 22;

                        if (!_didIteratorError2) {
                          _context3.next = 25;
                          break;
                        }

                        throw _iteratorError2;

                      case 25:
                        return _context3.finish(22);

                      case 26:
                        return _context3.finish(19);

                      case 27:
                      case 'end':
                        return _context3.stop();
                    }
                  }
                }, _callee3, this, [[3, 15, 19, 27], [20,, 22, 26]]);
              }));

              return function (_x4) {
                return _ref11.apply(this, arguments);
              };
            }());

          case 15:
            stats = null;
            _context5.prev = 16;
            _context5.next = 19;
            return fs._lstat(path.join(dir, filepath));

          case 19:
            stats = _context5.sent;
            _context5.next = 26;
            break;

          case 22:
            _context5.prev = 22;
            _context5.t0 = _context5['catch'](16);

            if (!(_context5.t0.code !== 'ENOENT')) {
              _context5.next = 26;
              break;
            }

            throw _context5.t0;

          case 26:
            H = treeOid !== null; // head

            I = indexEntry !== null; // index

            W = stats !== null; // working dir

            getWorkdirOid = function () {
              var _ref12 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4() {
                var object, workdirOid;
                return _regeneratorRuntime.wrap(function _callee4$(_context4) {
                  while (1) {
                    switch (_context4.prev = _context4.next) {
                      case 0:
                        if (!(I && !cacheIsStale({ entry: indexEntry, stats: stats }))) {
                          _context4.next = 4;
                          break;
                        }

                        return _context4.abrupt('return', indexEntry.oid);

                      case 4:
                        _context4.next = 6;
                        return fs.read(path.join(dir, filepath));

                      case 6:
                        object = _context4.sent;
                        _context4.next = 9;
                        return managers_js.GitObjectManager.hash({
                          gitdir: gitdir,
                          type: 'blob',
                          object: object
                        });

                      case 9:
                        workdirOid = _context4.sent;
                        return _context4.abrupt('return', workdirOid);

                      case 11:
                      case 'end':
                        return _context4.stop();
                    }
                  }
                }, _callee4, _this);
              }));

              return function getWorkdirOid() {
                return _ref12.apply(this, arguments);
              };
            }();

            if (!(!H && !W && !I)) {
              _context5.next = 32;
              break;
            }

            return _context5.abrupt('return', 'absent');

          case 32:
            if (!(!H && !W && I)) {
              _context5.next = 34;
              break;
            }

            return _context5.abrupt('return', '*absent');

          case 34:
            if (!(!H && W && !I)) {
              _context5.next = 36;
              break;
            }

            return _context5.abrupt('return', '*added');

          case 36:
            if (!(!H && W && I)) {
              _context5.next = 41;
              break;
            }

            _context5.next = 39;
            return getWorkdirOid();

          case 39:
            workdirOid = _context5.sent;
            return _context5.abrupt('return', workdirOid === indexEntry.oid ? 'added' : '*added');

          case 41:
            if (!(H && !W && !I)) {
              _context5.next = 43;
              break;
            }

            return _context5.abrupt('return', 'deleted');

          case 43:
            if (!(H && !W && I)) {
              _context5.next = 45;
              break;
            }

            return _context5.abrupt('return', treeOid === indexEntry.oid ? '*deleted' : '*deleted');

          case 45:
            if (!(H && W && !I)) {
              _context5.next = 50;
              break;
            }

            _context5.next = 48;
            return getWorkdirOid();

          case 48:
            _workdirOid = _context5.sent;
            return _context5.abrupt('return', _workdirOid === treeOid ? '*undeleted' : '*undeletemodified');

          case 50:
            if (!(H && W && I)) {
              _context5.next = 59;
              break;
            }

            _context5.next = 53;
            return getWorkdirOid();

          case 53:
            _workdirOid2 = _context5.sent;

            if (!(_workdirOid2 === treeOid)) {
              _context5.next = 58;
              break;
            }

            return _context5.abrupt('return', _workdirOid2 === indexEntry.oid ? 'unmodified' : '*unmodified');

          case 58:
            return _context5.abrupt('return', _workdirOid2 === indexEntry.oid ? 'modified' : '*modified');

          case 59:
          case 'end':
            return _context5.stop();
        }
      }
    }, _callee5, this, [[16, 22]]);
  }));

  return function status(_x3) {
    return _ref10.apply(this, arguments);
  };
}();

var _findRoot = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(fs, filepath) {
    var parent;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return fs.exists(path.join(filepath, '.git'));

          case 2:
            if (!_context2.sent) {
              _context2.next = 6;
              break;
            }

            return _context2.abrupt('return', filepath);

          case 6:
            parent = path.dirname(filepath);

            if (!(parent === filepath)) {
              _context2.next = 9;
              break;
            }

            throw new Error('Unable to find git root');

          case 9:
            return _context2.abrupt('return', _findRoot(fs, parent));

          case 10:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, this);
  }));

  return function _findRoot(_x2, _x3) {
    return _ref3.apply(this, arguments);
  };
}();

/**
 * Find the root git directory
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.filepath - The file directory to start searching in.
 * @returns {Promise<string>} - a directory name
 * @throws {Error} - Error('Unable to find git root')
 *
 * Starting at `filepath`, will walk upwards until it finds a directory that contains a directory called '.git'.
 *
 * @example
 * let gitroot = await git.findRoot({
 *   fs,
 *   filepath: '<@/path/to/some/gitrepo/path/to/some/file.txt@>'
 * })
 * console.log(gitroot) // '/path/to/some/gitrepo'
 */
var findRoot = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var _fs = _ref.fs,
        filepath = _ref.filepath;
    var fs;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            return _context.abrupt('return', _findRoot(fs, filepath));

          case 2:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function findRoot(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var version = "0.0.0-development";

/**
 * Return the version number of 'isomorphic-git'
 *
 * I don't know why you might need this. I added it just so I could check that I was getting
 * the correct version of the library and not a cached version.
 *
 * TODO: Semantic-release broke this, now it always says '0.0.0-development'. Need to add a
 * prepublishOnly script to find & replace that with the actual version number.
 *
 * @returns {string} version - the version string taken from package.json at publication time
 * @example
 * console.log(git.version())
 */
function version$1() {
  return version;
}

/**
 * Create the .idx file for a given .pack file
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} args.filepath - The path to the .pack file to index.
 * @returns {Promise<void>} - Resolves successfully once the .idx file been written.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * await git.indexPack({...repo, filepath: '<@pack-9cbd243a1caa4cb4bef976062434a958d82721a9.pack@>'})
 */
var indexPack = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        filepath = _ref.filepath;
    var fs, pack, idx;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            _context.next = 3;
            return fs.read(path.join(dir, filepath));

          case 3:
            pack = _context.sent;
            _context.next = 6;
            return models_js.GitPackIndex.fromPack({ pack: pack });

          case 6:
            idx = _context.sent;
            _context.next = 9;
            return fs.write(filepath.replace(/\.pack$/, '.idx'), idx.toBuffer());

          case 9:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function indexPack(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * Create a signed commit
 *
 * OpenPGP.js is a huge library and if you don't need to create or verify signed commits
 * you shouldn't be forced to include that weighty feature in your bundle. That's why this
 * is its own function.
 *
 * It creates a signed version of whatever commit HEAD currently points to, and then updates the current branch,
 * leaving the original commit dangling.
 *
 * The {@link privateKeys} argument is a single string in ASCII armor format. However, it is plural "keys" because
 * you can technically have multiple private keys in a single ASCII armor string. The openpgp.sign() function accepts
 * multiple keys, so while I haven't tested it, it should support signing a single commit with multiple keys.
 *
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} args.privateKeys - A PGP private key in ASCII armor format.
 * @returns {Promise<string>} - The object ID of the newly created commit.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * let sha = await git.sign({
 *   ...repo,
 *   privateKeys: `<<@
 * -----BEGIN PGP PRIVATE KEY BLOCK-----
 * ...
 * @>>`
 * })
 * console.log(sha)
 */
var sign = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        privateKeys = _ref.privateKeys,
        openpgp = _ref.openpgp;

    var fs, oid, _ref3, type, object, commit, newOid, branch;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            _context.next = 3;
            return managers_js.GitRefManager.resolve({ fs: fs, gitdir: gitdir, ref: 'HEAD' });

          case 3:
            oid = _context.sent;
            _context.next = 6;
            return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: oid });

          case 6:
            _ref3 = _context.sent;
            type = _ref3.type;
            object = _ref3.object;

            if (!(type !== 'commit')) {
              _context.next = 11;
              break;
            }

            throw new Error('HEAD is not pointing to a \'commit\' object but a \'' + type + '\' object');

          case 11:
            commit = models_js.SignedGitCommit.from(object);
            _context.next = 14;
            return commit.sign(openpgp, privateKeys);

          case 14:
            commit = _context.sent;
            _context.next = 17;
            return managers_js.GitObjectManager.write({
              fs: fs,
              gitdir: gitdir,
              type: 'commit',
              object: commit.toObject()
            });

          case 17:
            newOid = _context.sent;
            _context.next = 20;
            return managers_js.GitRefManager.resolve({
              fs: fs,
              gitdir: gitdir,
              ref: 'HEAD',
              depth: 2
            });

          case 20:
            branch = _context.sent;
            _context.next = 23;
            return fs.write(path.join(gitdir, branch), newOid + '\n');

          case 23:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function sign(_x) {
    return _ref2.apply(this, arguments);
  };
}();

/**
 * Get the value of a symbolic ref or resolve a ref to its object id.
 * @param {Object} args - Arguments object
 * @param {FSModule} args.fs - The filesystem holding the git repo
 * @param {string} args.dir - The path to the [working tree](index.html#dir-vs-gitdir) directory
 * @param {string} [args.gitdir=path.join(dir, '.git')] - The path to the [git directory](index.html#dir-vs-gitdir)
 * @param {string} args.ref - Which ref to resolve.
 * @param {number} [args.depth=undefined] - How many symbolic references to follow before returning.
 * @returns {Promise<string>} - Resolves successfully with the SHA, or the value of another symbolic ref.
 *
 * @example
 * let repo = {fs, dir: '<@.@>'}
 * let currentCommit = await git.resolveRef({...repo, ref: '<@HEAD@>'})
 * console.log(currentCommit)
 * let currentBranch = await git.resolveRef({...repo, ref: '<@HEAD@>', depth: 1})
 * console.log(currentBranch)
 */
var resolveRef = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        ref = _ref.ref,
        depth = _ref.depth;
    var fs;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            return _context.abrupt('return', managers_js.GitRefManager.resolve({
              fs: fs,
              gitdir: gitdir,
              ref: ref,
              depth: depth
            }));

          case 2:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function resolveRef(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var readObject = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(_ref) {
    var dir = _ref.dir,
        _ref$gitdir = _ref.gitdir,
        gitdir = _ref$gitdir === undefined ? path.join(dir, '.git') : _ref$gitdir,
        _fs = _ref.fs,
        oid = _ref.oid,
        _ref$format = _ref.format,
        format = _ref$format === undefined ? 'parsed' : _ref$format;

    var fs, _format, result;

    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            fs = new models_js.FileSystem(_fs);
            // GitObjectManager does not know how to parse content, so we tweak that parameter before passing it.

            _format = format === 'parsed' ? 'content' : format;
            _context.next = 4;
            return managers_js.GitObjectManager.read({ fs: fs, gitdir: gitdir, oid: oid, format: _format });

          case 4:
            result = _context.sent;

            if (!(format === 'parsed')) {
              _context.next = 17;
              break;
            }

            _context.t0 = result.type;
            _context.next = _context.t0 === 'commit' ? 9 : _context.t0 === 'tree' ? 11 : _context.t0 === 'blob' ? 13 : _context.t0 === 'tag' ? 14 : 15;
            break;

          case 9:
            result.object = models_js.GitCommit.from(result.object).parse();
            return _context.abrupt('break', 16);

          case 11:
            result.object = { entries: models_js.GitTree.from(result.object).entries() };
            return _context.abrupt('break', 16);

          case 13:
            return _context.abrupt('break', 16);

          case 14:
            throw new Error('TODO: Parsing annotated tag objects still needs to be implemented!!');

          case 15:
            throw new Error('Unrecognized git object type: \'' + result.type + '\'');

          case 16:
            result.format = 'parsed';

          case 17:
            return _context.abrupt('return', result);

          case 18:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function readObject(_x) {
    return _ref2.apply(this, arguments);
  };
}();

exports.add = add;
exports.clone = clone;
exports.checkout = checkout;
exports.commit = commit;
exports.fetch = fetch;
exports.init = init;
exports.listFiles = listFiles;
exports.listBranches = listBranches;
exports.listTags = listTags;
exports.log = log$1;
exports.push = push;
exports.remove = remove;
exports.config = config;
exports.verify = verify;
exports.status = status;
exports.findRoot = findRoot;
exports.version = version$1;
exports.indexPack = indexPack;
exports.sign = sign;
exports.resolveRef = resolveRef;
exports.readObject = readObject;
//# sourceMappingURL=commands.js.map
