'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var _getIterator = _interopDefault(require('babel-runtime/core-js/get-iterator'));
var _Map = _interopDefault(require('babel-runtime/core-js/map'));
var path = _interopDefault(require('path'));
var _regeneratorRuntime = _interopDefault(require('babel-runtime/regenerator'));
var _Promise = _interopDefault(require('babel-runtime/core-js/promise'));
var _asyncToGenerator = _interopDefault(require('babel-runtime/helpers/asyncToGenerator'));
var debug = _interopDefault(require('debug'));

// @flow
/*::
type Node = {
  type: string,
  fullpath: string,
  basename: string,
  metadata: Object, // mode, oid
  parent?: Node,
  children: Array<Node>
}
*/

/** @ignore */
function flatFileListToDirectoryStructure(files /*: Array<{path: string}> */
) /*: Node|void */{
  var inodes /*: Map<string, Node> */ = new _Map();
  var mkdir = function mkdir(name) /*: Node|void */{
    if (!inodes.has(name)) {
      var dir /*: Node */ = {
        type: 'tree',
        fullpath: name,
        basename: path.basename(name),
        metadata: {},
        children: []
      };
      inodes.set(name, dir);
      // This recursively generates any missing parent folders.
      // We do it after we've added the inode to the set so that
      // we don't recurse infinitely trying to create the root '.' dirname.
      dir.parent = mkdir(path.dirname(name));
      if (dir.parent && dir.parent !== dir) dir.parent.children.push(dir);
    }
    return inodes.get(name);
  };

  var mkfile = function mkfile(name, metadata) /*: Node|void */{
    if (!inodes.has(name)) {
      var file /*: Node */ = {
        type: 'blob',
        fullpath: name,
        basename: path.basename(name),
        metadata: metadata,
        // This recursively generates any missing parent folders.
        parent: mkdir(path.dirname(name)),
        children: []
      };
      if (file.parent) file.parent.children.push(file);
      inodes.set(name, file);
    }
    return inodes.get(name);
  };

  mkdir('.');
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = _getIterator(files), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var file = _step.value;

      mkfile(file.path, file);
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return inodes.get('.');
}

/** @ignore */
var sleep = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(ms) {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            return _context.abrupt("return", new _Promise(function (resolve, reject) {
              return setTimeout(resolve, ms);
            }));

          case 1:
          case "end":
            return _context.stop();
        }
      }
    }, _callee, this);
  }));

  return function sleep(_x) {
    return _ref.apply(this, arguments);
  };
}();

var name = "isomorphic-git";
var version = "0.0.0-development";
var description = "A pure JavaScript implementation of git for node and browsers!";
var typings = "./src/index.d.ts";
var main = "dist/for-node/";
var browser = "dist/for-browserify/";
var module$1 = "dist/for-future/";
var unpkg = "dist/bundle.umd.min.js";
var bin = { "isogit": "./cli.js" };
var engines = { "node": ">=7.6.0" };
var scripts = { "start": "nps", "test": "nps test", "precommit": "nps format toc", "prepush": "nps lint", "semantic-release": "semantic-release", "travis-deploy-once": "travis-deploy-once" };
var repository = { "type": "git", "url": "https://github.com/isomorphic-git/isomorphic-git.git" };
var keywords = ["git", "isomorphic"];
var author = "William Hilton <wmhilton@gmail.com>";
var license = "Unlicense";
var bugs = { "url": "https://github.com/isomorphic-git/isomorphic-git/issues" };
var homepage = "https://isomorphic-git.github.io/";
var files = ["dist", "cli.js"];
var dependencies = { "async-lock": "^1.1.0", "babel-runtime": "^6.26.0", "buffer": "^5.0.8", "buffer-peek-stream": "^1.0.1", "buffercursor": "0.0.12", "crc": "^3.5.0", "debug": "^3.1.0", "diff-lines": "^1.1.0", "git-apply-delta": "0.0.7", "git-list-pack": "0.0.10", "ignore": "^3.3.7", "ini": "^1.3.5", "lodash.get": "^4.4.2", "lodash.set": "^4.3.2", "lodash.sortby": "^4.7.0", "lodash.unset": "^4.5.2", "marky": "^1.2.0", "minimisted": "^2.0.0", "pad": "^2.0.3", "pako": "^1.0.6", "pify": "^3.0.0", "sha.js": "^2.4.9", "shasum": "^1.0.2", "simple-concat": "^1.0.0", "simple-get": "^2.7.0", "split2": "^2.2.0", "through2": "^2.0.3" };
var devDependencies = { "babel-plugin-external-helpers": "^6.22.0", "babel-plugin-transform-es2015-modules-commonjs": "^6.26.0", "babel-plugin-transform-object-rest-spread": "^6.26.0", "babel-plugin-transform-runtime": "^6.23.0", "babel-preset-env": "^1.6.1", "babel-preset-flow": "^6.23.0", "ban-sensitive-files": "^1.9.2", "browserify": "^15.1.0", "browserify-shim": "^3.8.14", "codecov": "^3.0.0", "cross-env": "^5.1.3", "doctoc": "^1.3.0", "husky": "^0.14.3", "jasmine-core": "^2.9.1", "jasmine-snapshot": "^1.7.8", "jest": "^22.0.4", "jest-fixtures": "^0.6.0", "jsonfile": "^4.0.0", "karma": "^2.0.0", "karma-browserify": "^5.1.3", "karma-chrome-launcher": "^2.2.0", "karma-firefox-launcher": "^1.1.0", "karma-jasmine": "^1.1.1", "karma-sauce-launcher": "^1.2.0", "karma-verbose-reporter": "0.0.6", "nock": "^9.1.5", "npm-run-all": "^4.1.2", "nps": "^5.7.1", "nps-utils": "^1.5.0", "openpgp": "^2.6.1", "parse-header-stream": "^1.1.1", "prettier-standard": "^8.0.0", "pretty-format": "^22.1.0", "rollup": "^0.54.0", "rollup-plugin-babel": "^3.0.3", "rollup-plugin-json": "^2.3.0", "semantic-release": "^12.2.2", "standard": "^10.0.3", "stream-equal": "^1.1.0", "travis-deploy-once": "^4.3.1", "uglify-es": "^3.3.4", "watch": "^1.0.2", "watchify": "^3.9.0" };
var ava = { "source": ["dist/for-node/*"] };
var browserify = { "transform": ["browserify-shim"] };
var testling = { "files": "testling/basic-test.js", "browsers": ["chrome/latest", "firefox/latest", "ie/latest"] };
var jest = { "testRegex": "/__tests__/test-(?!.*\\.(spec)\\.js).*\\.js", "testEnvironment": "node" };
var _package = {
	name: name,
	version: version,
	description: description,
	typings: typings,
	main: main,
	browser: browser,
	module: module$1,
	unpkg: unpkg,
	bin: bin,
	engines: engines,
	scripts: scripts,
	repository: repository,
	keywords: keywords,
	author: author,
	license: license,
	bugs: bugs,
	homepage: homepage,
	files: files,
	dependencies: dependencies,
	devDependencies: devDependencies,
	ava: ava,
	browserify: browserify,
	testling: testling,
	jest: jest,
	"browserify-shim": { "fs": "global:fs" }
};

var _package$1 = Object.freeze({
	name: name,
	version: version,
	description: description,
	typings: typings,
	main: main,
	browser: browser,
	module: module$1,
	unpkg: unpkg,
	bin: bin,
	engines: engines,
	scripts: scripts,
	repository: repository,
	keywords: keywords,
	author: author,
	license: license,
	bugs: bugs,
	homepage: homepage,
	files: files,
	dependencies: dependencies,
	devDependencies: devDependencies,
	ava: ava,
	browserify: browserify,
	testling: testling,
	jest: jest,
	default: _package
});

/**
 *
 * Use with {@link push} and {@link fetch} to set Basic Authentication headers.
 * This for is for *actual* OAuth2 tokens (not "personal access tokens").
 * Unfortunately, all the major git hosting companies have chosen different conventions!
 * Lucky for you, I already looked up and codified it for you.
 *
 * - oauth2('github', token) - Github uses `token` as the username, and 'x-oauth-basic' as the password.
 * - oauth2('bitbucket', token) - Bitbucket uses 'x-token-auth' as the username, and `token` as the password.
 * - oauth2('gitlab', token) - Gitlab uses 'oauth2' as the username, and `token` as the password.
 *
 * I will gladly accept pull requests for more companies' conventions.
 *
 * @param {string} company
 * @param {string} token
 * @returns {{username: string, password: string}}
 *
 */
function oauth2(company, token) {
  switch (company) {
    case 'github':
      return {
        username: token,
        password: 'x-oauth-basic'
      };
    case 'bitbucket':
      return {
        username: 'x-token-auth',
        password: token
      };
    case 'gitlab':
      return {
        username: 'oauth2',
        password: token
      };
    default:
      throw new Error('I don\'t know how ' + company + ' expects its Basic Auth headers to be formatted for OAuth2 usage. If you do, you can use the regular \'.auth(username, password)\' to set the basic auth header yourself.');
  }
}

/**
 *
 * Use with {@link push} and {@link fetch} to set Basic Authentication headers.
 * This works for basic username / password auth, or the newer username / token auth
 * that is often required if 2FA is enabled.
 *
 * Authentication is normally required for pushing to a git repository.
 * It may also be required to clone or fetch from a private repository.
 * Git does all its authentication using HTTPS Basic Authentication.
 * Usually this is straightforward, but there are some things to watch out for.
 *
 * If you have two-factor authentication (2FA) enabled on your account, you
 * probably cannot push or pull using your regular username and password.
 * Instead, you may have to create a Personal Access Token (or an App
 * Password in Bitbucket lingo) and use that to authenticate.
 *
 * @param {string} username
 * @param {string} password
 * @returns {{username: string, password: string}}
 *
 * @example
 * let {username, password} = auth('username', 'password')
 *
 * // a one-argument version is also supported
 * let {username, password} = auth('username:password')
 *
 * // Personal Access Token Authentication
 * // (note Bitbucket calls theirs App Passwords instead for some reason)
 * let {username, password} = auth('username', 'personal access token')
 * let {username, password} = auth('username', 'app password')
 * let {username, password} = auth('personal access token') // Github (only) lets you leave out the username
 */
function auth(username, password) {
  // Allow specifying it as one argument (mostly for CLI inputability)
  if (password === undefined) {
    var i = username.indexOf(':');
    if (i > -1) {
      password = username.slice(i + 1);
      username = username.slice(0, i);
    } else {
      password = ''; // Enables the .auth(GITHUB_TOKEN) no-username shorthand
    }
  }
  return { username: username, password: password };
}

var log = debug('isomorphic-git');

log.log = console.log.bind(console);

exports.flatFileListToDirectoryStructure = flatFileListToDirectoryStructure;
exports.sleep = sleep;
exports.pkg = _package$1;
exports.oauth2 = oauth2;
exports.auth = auth;
exports.log = log;
//# sourceMappingURL=utils.js.map
