## Special Functions

### betafn( x, y )

Evaluates the Beta function at (x,y).

### betaln( x, y )

Evaluates the log Beta function at (x,y).

### betacf( x, a, b )

Returns the continued fraction for the incomplete Beta function with parameters a and b modified by Lentz's method evaluated at x.

### ibetainv( p, a, b)

Returns the inverse of the incomplete Beta function evaluated at (p,a,b).

### ibeta( x, a, b)

Returns the incomplete Beta function evaluated at (x,a,b).

### gammafn( x )

Returns the Gamma function evaluated at x. This is sometimes called the 'complete' gamma function.

This function is tested against Mathematica's Gamma[x].

### gammaln( x )

Returns the Log-Gamma function evaluated at x.

### gammap( a, x )

Returns the lower incomplete gamma function evaluated at (a,x).
This function is usually written with a lower case greek gamma character, and is one of the two [incomplete gamma functions](http://mathworld.wolfram.com/IncompleteGammaFunction.html).

This function is tested against Mathematica's Gamma[a, 0, x].
It is additionally tested against gammainc(a,x)'s 'lowinc' output from teh 'pracma' library for R.

### lowRegGamma(a, x)

Returns the lower regularized incomplete gamma function evaluated at (a,x).
It is defined as the quotient of the lower incomplete gamma function evaluated at (a, x) and the upper incomplete gamma function ('the gamma function') evaluated at (a).
This function is usually written as P(x, a); and is one of the two [regularized gamma functions](http://mathworld.wolfram.com/RegularizedGammaFunction.html).

This function is tested against gammainc(x, a)'s 'reginc' output from the 'pracma' library for R. Note that R and jStat switch the order of operators for this function.

### gammapinv( p, a )

Returns the inverse of the lower regularized incomplete Gamma function evaluated at (p,a).
This function is the inverse of lowerRegularizedGamma(x, a).

### factorialln( n )

Returns the natural log factorial of n.

### factorial( n )

Returns the factorial of n.

### combination( n, m )

Returns the number of combinations of n, m.

### permutation( n, m )

Returns the number of permutations of n, m.


### erf( x )

Returns the error function evaluated at x.

### erfc( x )

Returns the complementary error function evaluated at x.

### erfcinv( p )

Returns the inverse of the complementary error function evaluated at p.

### randn( n, m )

Returns a normal deviate (mean 0 and standard deviation 1).

### randg( shape, n, m )

Returns a Gamma deviate by the method of Marsaglia and Tsang.

