"use strict";
const asyncawait_1 = require("asyncawait");
let promising = (action) => (done) => asyncawait_1.async(action)().then(() => done(), done.fail);
let itWithPromise = (expectation, assertion, timeout) => {
    it(expectation, promising(assertion), timeout);
};
exports.it = itWithPromise;
let beforeEachWithPromise = (action, timeout) => {
    beforeEach(promising(action), timeout);
};
exports.beforeEach = beforeEachWithPromise;
let afterEachWithPromise = (action, timeout) => {
    afterEach(promising(action), timeout);
};
exports.afterEach = afterEachWithPromise;
let beforeAllWithPromise = (action, timeout) => {
    beforeAll(promising(action), timeout);
};
exports.beforeAll = beforeAllWithPromise;
let afterAllWithPromise = (action, timeout) => {
    afterAll(promising(action), timeout);
};
exports.afterAll = afterAllWithPromise;
let invert = (promise) => promise.then(resolution => Promise.reject(new Error(`Promise should be rejected, but it is resolved with: ${resolution}`)), err => err);
exports.invert = invert;
var asyncawait_2 = require("asyncawait");
exports.await = asyncawait_2.await;
//# sourceMappingURL=index.js.map