# jasmine-expect

Write Beautiful Specs with Custom Matchers

## Installation

This is a [Node.js](https://nodejs.org/) module available through the 
[npm registry](https://www.npmjs.com/). It can be installed using the 
[`npm`](https://docs.npmjs.com/getting-started/installing-npm-packages-locally)
or 
[`yarn`](https://yarnpkg.com/en/)
command line tools.

```sh
npm install jasmine-expect --save
```

## Tests

```sh
npm install
npm test
```

## Dependencies

- [add-matchers](http://ghub.io/add-matchers): Write useful test matchers compatible with Jest and Jasmine.

## Dev Dependencies

- [babel-core](http://ghub.io/babel-core): Babel compiler core.
- [babel-preset-env](http://ghub.io/babel-preset-env): A Babel preset for each environment.
- [babelify](http://ghub.io/babelify): Babel browserify transform
- [browserify](http://ghub.io/browserify): browser-side require() the node way
- [codeclimate-test-reporter](http://ghub.io/codeclimate-test-reporter): Code Climate test reporter client for javascript projects
- [cz-conventional-changelog](http://ghub.io/cz-conventional-changelog): Commitizen adapter following the conventional-changelog format.
- [gulp](http://ghub.io/gulp): The streaming build system
- [husky](http://ghub.io/husky): Prevents bad commit or push (git hooks, pre-commit/precommit, pre-push/prepush, post-merge/postmerge and all that stuff...)
- [jasmine-core](http://ghub.io/jasmine-core): Official packaging of Jasmine&#39;s core files for use by Node.js projects.
- [jest](http://ghub.io/jest): Delightful JavaScript Testing.
- [karma](http://ghub.io/karma): Spectacular Test Runner for JavaScript.
- [karma-browserstack-launcher](http://ghub.io/karma-browserstack-launcher): A Karma plugin. Launch any browser on BrowserStack!
- [karma-chrome-launcher](http://ghub.io/karma-chrome-launcher): A Karma plugin. Launcher for Chrome and Chrome Canary.
- [karma-cli](http://ghub.io/karma-cli): The Karma command line interface.
- [karma-coverage](http://ghub.io/karma-coverage): A Karma plugin. Generate code coverage.
- [karma-firefox-launcher](http://ghub.io/karma-firefox-launcher): A Karma plugin. Launcher for Firefox.
- [karma-jasmine](http://ghub.io/karma-jasmine): A Karma plugin - adapter for Jasmine testing framework.
- [karma-nested-reporter](http://ghub.io/karma-nested-reporter): Easier to read test output with nested describe and it blocks.
- [saucelabs](http://ghub.io/saucelabs): A wrapper around Sauce Labs REST API
- [validate-commit-msg](http://ghub.io/validate-commit-msg): Script to validate a commit message follows the conventional changelog standard
- [vinyl-source-stream](http://ghub.io/vinyl-source-stream): Use conventional text streams at the start of your gulp or vinyl pipelines
- [xo](http://ghub.io/xo): JavaScript happiness style linter ❤️

## License

MIT