function requireGlobal(packageName) {
    var childProcess = require('child_process');
    var path = require('path');
    var fs = require('fs');

    var globalNodeModules = childProcess.execSync('npm root -g').toString().trim();
    var packageDir = path.join(globalNodeModules, packageName);
    if (!fs.existsSync(packageDir))
        packageDir = path.join(globalNodeModules, 'npm/node_modules', packageName); //find package required by old npm

    if (!fs.existsSync(packageDir))
        throw new Error('Cannot find global module \'' + packageName + '\'');

    var packageMeta = JSON.parse(fs.readFileSync(path.join(packageDir, 'package.json')).toString());
    var main = path.join(packageDir, packageMeta.main);

    return require(main);
}

var Benchmark = requireGlobal('benchmark');
var chance = require('chance');
var suite = new Benchmark.Suite;
var _ = require('lodash');
const JavaScriptObfuscator = require("../../dist/index");

var generator = new chance();

var shuffle1 = () => {
    return generator.floating({
        min: 0,
        max: 1,
        fixed: 7
    }) > 0.5;
};

var shuffle2 = () => {
    return generator.integer({
        min: 0,
        max: 100
    }) > (0.5 * 100);
}

var shuffle3 = () => {
    return Math.random() > 0.5
}

var shuffle4 = () => {
    return generator.integer({
        min: 0,
        max: 100
    }) / 100 > 0.5;
}


var array = [1, 2, 3, 4, 5, 6, 7];

suite.add('func1', function() {
    shuffle1()
})
.add('func2', function() {
    shuffle2()
})
.add('func3', function() {
    shuffle3()
})
.add('func4', function() {
    shuffle4()
})
// add listeners
.on('cycle', function(event) {
    console.log(String(event.target));
})
.on('complete', function() {
    console.log('Fastest is ' + this.filter('fastest').map('name'));
})
// run async
.run();