'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.getValues = getValues;
exports.validationCondition = validationCondition;
exports.multipleValidOptions = multipleValidOptions;
/**
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */

const toString = Object.prototype.toString;

const MULTIPLE_VALID_OPTIONS_SYMBOL = Symbol('JEST_MULTIPLE_VALID_OPTIONS');

function validationConditionSingle(option, validOption) {
  return (
    option === null ||
    option === undefined ||
    toString.call(option) === toString.call(validOption)
  );
}

function getValues(validOption) {
  if (
    Array.isArray(validOption) &&
    validOption[MULTIPLE_VALID_OPTIONS_SYMBOL]
  ) {
    return validOption;
  }
  return [validOption];
}

function validationCondition(option, validOption) {
  return getValues(validOption).some(e => validationConditionSingle(option, e));
}

function multipleValidOptions() {
  for (
    var _len = arguments.length, args = Array(_len), _key = 0;
    _key < _len;
    _key++
  ) {
    args[_key] = arguments[_key];
  }

  const options = [].concat(args);
  // $FlowFixMe
  options[MULTIPLE_VALID_OPTIONS_SYMBOL] = true;
  return options;
}
