'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.errorMessage = undefined;

var _chalk;

function _load_chalk() {
  return (_chalk = _interopRequireDefault(require('chalk')));
}

var _jestGetType;

function _load_jestGetType() {
  return (_jestGetType = _interopRequireDefault(require('jest-get-type')));
}

var _utils;

function _load_utils() {
  return (_utils = require('./utils'));
}

var _condition;

function _load_condition() {
  return (_condition = require('./condition'));
}

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

const errorMessage = (exports.errorMessage = (
  option,
  received,
  defaultValue,
  options,
  path
) => {
  const conditions = (0, (_condition || _load_condition()).getValues)(
    defaultValue
  );
  const validTypes = Array.from(
    new Set(conditions.map((_jestGetType || _load_jestGetType()).default))
  );

  const message = `  Option ${(_chalk || _load_chalk()).default.bold(
    `"${path && path.length > 0 ? path.join('.') + '.' : ''}${option}"`
  )} must be of type:
    ${validTypes
      .map(e => (_chalk || _load_chalk()).default.bold.green(e))
      .join(' or ')}
  but instead received:
    ${(_chalk || _load_chalk()).default.bold.red(
      (0, (_jestGetType || _load_jestGetType()).default)(received)
    )}

  Example:
${formatExamples(option, conditions)}`;

  const comment = options.comment;
  const name =
    (options.title && options.title.error) || (_utils || _load_utils()).ERROR;

  throw new (_utils || _load_utils()).ValidationError(name, message, comment);
});
/**
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */

function formatExamples(option, examples) {
  return examples.map(
    e => `  {
    ${(_chalk || _load_chalk()).default.bold(`"${option}"`)}: ${(
      _chalk || _load_chalk()
    ).default.bold((0, (_utils || _load_utils()).formatPrettyObject)(e))}
  }`
  ).join(`

  or

`);
}
