import Input from './Input';

class FormValidator {

  /**
   * @param {jQuery} $form
   * @param {FormValidatorOptions} config
   */
  constructor($form, config) {
    this.$form = $form;
    this.config = config;
  }

  validate(callback) {
    const validationPromises = [];
    this.$form.find(this.config.validationRuleAttribute).each((i, $input) => {
      if (this.shouldValidateInput($input)) {
        const input = new Input($input);
        validationPromises.push(input.validate());
      }
    });
    Promise.all(validationPromises, callback);
  }

  /**
   * @param {jQuery} $input
   * @return {boolean}
   */
  shouldValidateInput($input) {

  }

}

export default FormValidator;
