
class FormValidatorOptions {

  /**
   * @param {Object} [overridingData]
   */
  constructor(overridingData) {
    this.form = 'form';
    this.validateOnEvent = false;
    this.validateOnBlur = true;
    this.validateCheckboxRadioOnClick = true;
    this.showHelpOnFocus = true;
    this.addSuggestions = true;
    this.modules = '';
    this.onModulesLoaded = null;
    this.language = false;
    this.onSuccess = false;
    this.onError = false;
    this.onElementValidate = false;
    this.validationRuleAttribute = 'data-validation';
    this.addValidClassOnAll = false;
    (overridingData || []).forEach((key, val) => {
      this[key] = val;
    })
  }
}

export default FormValidatorOptions;
