import FormValidatorEvents from './FormValidatorEvents';
import ModuleLoader from './ModuleLoader';

(function($) {

  const moduleLoader = new ModuleLoader($),
    $window = $(window);

  $.formUtils = $.formUtils || {};
  $.formUtils.moduleLoader = moduleLoader;

  /**
   * @param {Object} [opts]
   */
  $.validate = function(opts) {
    const options = new FormValidatorOptions(opts || {}),
      $forms = $(form);
    setupForms($forms, options);
    loadValidationModules(options);
  };

  function setupForms($forms, options) {
    $forms.each((i, formElement) => {
      formElement.validationConfig = config;
      $forms.trigger(FormValidatorEvents.formValidationSetup, [$forms, options]);
    });
  }

  function loadValidationModules($forms, options) {
    const modules = config.modules || config.module;
    if (modules) {
      moduleLoader.loadModules(modules, () => {
        $window.trigger(FormValidatorEvents.validatorsLoaded, [$forms, options]);
      });
    }
  }

})(jQuery);
