(function($) {

  $.formUtils = {};

  const moduleLoader = new ModuleLoader($),
    formValidatorGui = new FormValidatorGui(),
    defaultConfig = new FormValidatorOptions();

  /**
   * @param callback
   * @param {Object} options {config:FormValidatorOptions, displayErrors:Boolean}
   */
  $.fn.validate = function(callback, options) {
    if (moduleLoader.isLoading()) {
      moduleLoader.on(ModuleLoader.EVENT_MODULES_LOADED, () => {
        this.validate(callback, options);
      });
    } else {
      switch (this.get(0).nodeName) {
        case 'input':
          // validateInput
          break;
        case 'select':
          // validateInput
          break;
        default:
          runFormValidation(this, callback, options);
          break;
      }
    }
    return this;
  };

  /**
   * @param {jQuery} $form
   * @param {Function} callback
   * @param {Object} options
   */
  function runFormValidation($form, callback, options) {
    const config = defaultConfig.override(options.config || {});
    new FormValidator($form).validate(results => {
      if (config.addValidClassOnAll) {
        results.ignored.every(result => {
          results.input.display('valid');
        });
      }
      results.valid.every(result => {
        results.input.display('valid');
      });
      results.invalid.every(result => {
        results.input.display('invalid', result.errorMessage);
      });
    });
  }

  // $.fn.isValid

})(jQuery);
