window = {};
window.jQuery = {};

var pron = require('../src/jquery.korean-pron.js')
var assert = require('assert');

var testCase = [
    ["뜥", "ttyut"], ["뜠", "ttyuss"], ["뜟", "ttyus"], ["뜦", "ttyup"], ["뜡", "ttyung"], ["뜐", "ttyun"], ["뜜", "ttyum"], ["뜔", "ttyuL"],
    ["뜎", "ttyukk"], ["뜤", "ttyuk"], ["뜢", "ttyuj"], ["뜧", "ttyuh"], ["뜍", "ttyuG"], ["뜓", "ttyuD"], ["뜝", "ttyuB"], ["뜌", "ttyu"],
    ["뚙", "ttyot"], ["뚔", "ttyoss"], ["뚓", "ttyos"], ["뚚", "ttyop"], ["뚕", "ttyong"], ["뚄", "ttyon"], ["뚐", "ttyom"], ["뚈", "ttyoL"],
    ["뚂", "ttyokk"], ["뚘", "ttyok"], ["뚖", "ttyoj"], ["뚛", "ttyoh"], ["뚁", "ttyoG"], ["뚇", "ttyoD"], ["뚑", "ttyoB"], ["뚀", "ttyo"],
    ["띝", "ttuit"], ["띘", "ttuiss"], ["띗", "ttuis"], ["띞", "ttuip"], ["띙", "ttuing"], ["띈", "ttuin"], ["띔", "ttuim"], ["띌", "ttuiL"],
    ["띆", "ttuikk"], ["띜", "ttuik"], ["띚", "ttuij"], ["띟", "ttuih"], ["띅", "ttuiG"], ["띋", "ttuiD"], ["띕", "ttuiB"], ["띄", "ttui"],
    ["똍", "ttyet"], ["똈", "ttyess"], ["똇", "ttyes"], ["똎", "ttyep"], ["뗱", "ttyeot"], ["뗬", "ttyeoss"], ["뗫", "ttyeos"], ["뗲", "ttyeop"],
    ["뗭", "ttyeong"], ["뗜", "ttyeon"], ["뗨", "ttyeom"], ["뗠", "ttyeoL"], ["뗚", "ttyeokk"], ["뗰", "ttyeok"], ["뗮", "ttyeoj"], ["뗳", "ttyeoh"],
    ["뗙", "ttyeoG"], ["뗟", "ttyeoD"], ["뗩", "ttyeoB"], ["뗘", "ttyeo"], ["똉", "ttyeng"], ["뗸", "ttyen"], ["똄", "ttyem"], ["뗼", "ttyeL"],
    ["뗶", "ttyekk"], ["똌", "ttyek"], ["똊", "ttyej"], ["똏", "ttyeh"], ["뗵", "ttyeG"], ["뗻", "ttyeD"], ["똅", "ttyeB"], ["뗴", "ttye"],
    ["떁", "ttyat"], ["땼", "ttyass"], ["땻", "ttyas"], ["떂", "ttyap"], ["땽", "ttyang"], ["땬", "ttyan"], ["땸", "ttyam"], ["땰", "ttyaL"],
    ["땪", "ttyakk"], ["떀", "ttyak"], ["땾", "ttyaj"], ["떃", "ttyah"], ["땩", "ttyaG"], ["떝", "ttyaet"], ["떘", "ttyaess"], ["떗", "ttyaes"],
    ["떞", "ttyaep"], ["떙", "ttyaeng"], ["떈", "ttyaen"], ["떔", "ttyaem"], ["떌", "ttyaeL"], ["떆", "ttyaekk"], ["떜", "ttyaek"], ["떚", "ttyaej"],
    ["떟", "ttyaeh"], ["떅", "ttyaeG"], ["떋", "ttyaeD"], ["떕", "ttyaeB"], ["떄", "ttyae"], ["땯", "ttyaD"], ["땹", "ttyaB"], ["땨", "ttya"],
    ["뜉", "ttwit"], ["뜄", "ttwiss"], ["뜃", "ttwis"], ["뜊", "ttwip"], ["뜅", "ttwing"], ["뛴", "ttwin"], ["뜀", "ttwim"], ["뛸", "ttwiL"],
    ["뛲", "ttwikk"], ["뜈", "ttwik"], ["뜆", "ttwij"], ["뜋", "ttwih"], ["뛱", "ttwiG"], ["뛷", "ttwiD"], ["뜁", "ttwiB"], ["뛰", "ttwi"],
    ["뛭", "ttwet"], ["뛨", "ttwess"], ["뛧", "ttwes"], ["뛮", "ttwep"], ["뛑", "ttwot"], ["뛌", "ttwoss"], ["뛋", "ttwos"], ["뛒", "ttwop"],
    ["뛍", "ttwong"], ["뚼", "ttwon"], ["뛈", "ttwom"], ["뛀", "ttwoL"], ["뚺", "ttwokk"], ["뛐", "ttwok"], ["뛎", "ttwoj"], ["뛓", "ttwoh"],
    ["뚹", "ttwoG"], ["뚿", "ttwoD"], ["뛉", "ttwoB"], ["뚸", "ttwo"], ["뛩", "ttweng"], ["뛘", "ttwen"], ["뛤", "ttwem"], ["뛜", "ttweL"],
    ["뛖", "ttwekk"], ["뛬", "ttwek"], ["뛪", "ttwej"], ["뛯", "ttweh"], ["뛕", "ttweG"], ["뛛", "ttweD"], ["뛥", "ttweB"], ["뛔", "ttwe"],
    ["뙅", "ttwat"], ["뙀", "ttwass"], ["똿", "ttwas"], ["뙆", "ttwap"], ["뙁", "ttwang"], ["똰", "ttwan"], ["똼", "ttwam"], ["똴", "ttwaL"],
    ["똮", "ttwakk"], ["뙄", "ttwak"], ["뙂", "ttwaj"], ["뙇", "ttwah"], ["똭", "ttwaG"], ["뙡", "ttwaet"], ["뙜", "ttwaess"], ["뙛", "ttwaes"],
    ["뙢", "ttwaep"], ["뙝", "ttwaeng"], ["뙌", "ttwaen"], ["뙘", "ttwaem"], ["뙐", "ttwaeL"], ["뙊", "ttwaekk"], ["뙠", "ttwaek"], ["뙞", "ttwaej"],
    ["뙣", "ttwaeh"], ["뙉", "ttwaeG"], ["뙏", "ttwaeD"], ["뙙", "ttwaeB"], ["뙈", "ttwae"], ["똳", "ttwaD"], ["똽", "ttwaB"], ["똬", "ttwa"],
    ["뚵", "ttut"], ["뚰", "ttuss"], ["뚯", "ttus"], ["뚶", "ttup"], ["뚱", "ttung"], ["뚠", "ttun"], ["뚬", "ttum"], ["뚤", "ttuL"],
    ["뚞", "ttukk"], ["뚴", "ttuk"], ["뚲", "ttuj"], ["뚷", "ttuh"], ["뚝", "ttuG"], ["뚣", "ttuD"], ["뚭", "ttuB"], ["뚜", "ttu"],
    ["똩", "ttot"], ["똤", "ttoss"], ["똣", "ttos"], ["똪", "ttop"], ["똥", "ttong"], ["똔", "tton"], ["똠", "ttom"], ["똘", "ttoL"],
    ["똒", "ttokk"], ["똨", "ttok"], ["똦", "ttoj"], ["똫", "ttoh"], ["똑", "ttoG"], ["뙽", "ttoet"], ["뙸", "ttoess"], ["뙷", "ttoes"],
    ["뙾", "ttoep"], ["뙹", "ttoeng"], ["뙨", "ttoen"], ["뙴", "ttoem"], ["뙬", "ttoeL"], ["뙦", "ttoekk"], ["뙼", "ttoek"], ["뙺", "ttoej"],
    ["뙿", "ttoeh"], ["뙥", "ttoeG"], ["뙫", "ttoeD"], ["뙵", "ttoeB"], ["뙤", "ttoe"], ["똗", "ttoD"], ["똡", "ttoB"], ["또", "tto"],
    ["띹", "ttit"], ["띴", "ttiss"], ["띳", "ttis"], ["띺", "ttip"], ["띵", "tting"], ["띤", "ttin"], ["띰", "ttim"], ["띨", "ttiL"],
    ["띢", "ttikk"], ["띸", "ttik"], ["띶", "ttij"], ["띻", "ttih"], ["띡", "ttiG"], ["띧", "ttiD"], ["띱", "ttiB"], ["띠", "tti"],
    ["띁", "tteut"], ["뜼", "tteuss"], ["뜻", "tteus"], ["띂", "tteup"], ["뜽", "tteung"], ["뜬", "tteun"], ["뜸", "tteum"], ["뜰", "tteuL"],
    ["뜪", "tteukk"], ["띀", "tteuk"], ["뜾", "tteuj"], ["띃", "tteuh"], ["뜩", "tteuG"], ["뜯", "tteuD"], ["뜹", "tteuB"], ["뜨", "tteu"],
    ["뗕", "ttet"], ["뗐", "ttess"], ["뗏", "ttes"], ["뗖", "ttep"], ["떹", "tteot"], ["떴", "tteoss"], ["떳", "tteos"], ["떺", "tteop"],
    ["떵", "tteong"], ["떤", "tteon"], ["떰", "tteom"], ["떨", "tteoL"], ["떢", "tteokk"], ["떸", "tteok"], ["떶", "tteoj"], ["떻", "tteoh"],
    ["떡", "tteoG"], ["떧", "tteoD"], ["떱", "tteoB"], ["떠", "tteo"], ["뗑", "tteng"], ["뗀", "tten"], ["뗌", "ttem"], ["뗄", "tteL"],
    ["떾", "ttekk"], ["뗔", "ttek"], ["뗒", "ttej"], ["뗗", "tteh"], ["떽", "tteG"], ["뗃", "tteD"], ["뗍", "tteB"], ["떼", "tte"],
    ["땉", "ttat"], ["땄", "ttass"], ["땃", "ttas"], ["땊", "ttap"], ["땅", "ttang"], ["딴", "ttan"], ["땀", "ttam"], ["딸", "ttaL"],
    ["딲", "ttakk"], ["땈", "ttak"], ["땆", "ttaj"], ["땋", "ttah"], ["딱", "ttaG"], ["땥", "ttaet"], ["땠", "ttaess"], ["땟", "ttaes"],
    ["땦", "ttaep"], ["땡", "ttaeng"], ["땐", "ttaen"], ["땜", "ttaem"], ["땔", "ttaeL"], ["땎", "ttaekk"], ["땤", "ttaek"], ["땢", "ttaej"],
    ["땧", "ttaeh"], ["땍", "ttaeG"], ["땓", "ttaeD"], ["땝", "ttaeB"], ["때", "ttae"], ["딷", "ttaD"], ["땁", "ttaB"], ["따", "tta"],
    ["늍", "nyut"], ["늈", "nyuss"], ["늇", "nyus"], ["늎", "nyup"], ["늉", "nyung"], ["뉸", "nyun"], ["늄", "nyum"], ["뉼", "nyuL"],
    ["뉶", "nyukk"], ["늌", "nyuk"], ["늊", "nyuj"], ["늏", "nyuh"], ["뉵", "nyuG"], ["뉻", "nyuD"], ["늅", "nyuB"], ["뉴", "nyu"],
    ["눁", "nyot"], ["뇼", "nyoss"], ["뇻", "nyos"], ["눂", "nyop"], ["뇽", "nyong"], ["뇬", "nyon"], ["뇸", "nyom"], ["뇰", "nyoL"],
    ["뇪", "nyokk"], ["눀", "nyok"], ["뇾", "nyoj"], ["눃", "nyoh"], ["뇩", "nyoG"], ["뇯", "nyoD"], ["뇹", "nyoB"], ["뇨", "nyo"],
    ["닅", "nuit"], ["닀", "nuiss"], ["늿", "nuis"], ["닆", "nuip"], ["닁", "nuing"], ["늰", "nuin"], ["늼", "nuim"], ["늴", "nuiL"],
    ["늮", "nuikk"], ["닄", "nuik"], ["닂", "nuij"], ["닇", "nuih"], ["늭", "nuiG"], ["늳", "nuiD"], ["늽", "nuiB"], ["늬", "nui"],
    ["녵", "nyet"], ["녰", "nyess"], ["녯", "nyes"], ["녶", "nyep"], ["녙", "nyeot"], ["녔", "nyeoss"], ["녓", "nyeos"], ["녚", "nyeop"],
    ["녕", "nyeong"], ["년", "nyeon"], ["념", "nyeom"], ["녈", "nyeoL"], ["녂", "nyeokk"], ["녘", "nyeok"], ["녖", "nyeoj"], ["녛", "nyeoh"],
    ["녁", "nyeoG"], ["녇", "nyeoD"], ["녑", "nyeoB"], ["녀", "nyeo"], ["녱", "nyeng"], ["녠", "nyen"], ["녬", "nyem"], ["녤", "nyeL"],
    ["녞", "nyekk"], ["녴", "nyek"], ["녲", "nyej"], ["녷", "nyeh"], ["녝", "nyeG"], ["녣", "nyeD"], ["녭", "nyeB"], ["녜", "nye"],
    ["냩", "nyat"], ["냤", "nyass"], ["냣", "nyas"], ["냪", "nyap"], ["냥", "nyang"], ["냔", "nyan"], ["냠", "nyam"], ["냘", "nyaL"],
    ["냒", "nyakk"], ["냨", "nyak"], ["냦", "nyaj"], ["냫", "nyah"], ["냑", "nyaG"], ["넅", "nyaet"], ["넀", "nyaess"], ["냿", "nyaes"],
    ["넆", "nyaep"], ["넁", "nyaeng"], ["냰", "nyaen"], ["냼", "nyaem"], ["냴", "nyaeL"], ["냮", "nyaekk"], ["넄", "nyaek"], ["넂", "nyaej"],
    ["넇", "nyaeh"], ["냭", "nyaeG"], ["냳", "nyaeD"], ["냽", "nyaeB"], ["냬", "nyae"], ["냗", "nyaD"], ["냡", "nyaB"], ["냐", "nya"],
    ["뉱", "nwit"], ["뉬", "nwiss"], ["뉫", "nwis"], ["뉲", "nwip"], ["뉭", "nwing"], ["뉜", "nwin"], ["뉨", "nwim"], ["뉠", "nwiL"],
    ["뉚", "nwikk"], ["뉰", "nwik"], ["뉮", "nwij"], ["뉳", "nwih"], ["뉙", "nwiG"], ["뉟", "nwiD"], ["뉩", "nwiB"], ["뉘", "nwi"],
    ["뉕", "nwet"], ["뉐", "nwess"], ["뉏", "nwes"], ["뉖", "nwep"], ["눹", "nwot"], ["눴", "nwoss"], ["눳", "nwos"], ["눺", "nwop"],
    ["눵", "nwong"], ["눤", "nwon"], ["눰", "nwom"], ["눨", "nwoL"], ["눢", "nwokk"], ["눸", "nwok"], ["눶", "nwoj"], ["눻", "nwoh"],
    ["눡", "nwoG"], ["눧", "nwoD"], ["눱", "nwoB"], ["눠", "nwo"], ["뉑", "nweng"], ["뉀", "nwen"], ["뉌", "nwem"], ["뉄", "nweL"],
    ["눾", "nwekk"], ["뉔", "nwek"], ["뉒", "nwej"], ["뉗", "nweh"], ["눽", "nweG"], ["뉃", "nweD"], ["뉍", "nweB"], ["눼", "nwe"],
    ["놭", "nwat"], ["놨", "nwass"], ["놧", "nwas"], ["놮", "nwap"], ["놩", "nwang"], ["놘", "nwan"], ["놤", "nwam"], ["놜", "nwaL"],
    ["놖", "nwakk"], ["놬", "nwak"], ["놪", "nwaj"], ["놯", "nwah"], ["놕", "nwaG"], ["뇉", "nwaet"], ["뇄", "nwaess"], ["뇃", "nwaes"],
    ["뇊", "nwaep"], ["뇅", "nwaeng"], ["놴", "nwaen"], ["뇀", "nwaem"], ["놸", "nwaeL"], ["놲", "nwaekk"], ["뇈", "nwaek"], ["뇆", "nwaej"],
    ["뇋", "nwaeh"], ["놱", "nwaeG"], ["놷", "nwaeD"], ["뇁", "nwaeB"], ["놰", "nwae"], ["놛", "nwaD"], ["놥", "nwaB"], ["놔", "nwa"],
    ["눝", "nut"], ["눘", "nuss"], ["눗", "nus"], ["눞", "nup"], ["눙", "nung"], ["눈", "nun"], ["눔", "num"], ["눌", "nuL"],
    ["눆", "nukk"], ["눜", "nuk"], ["눚", "nuj"], ["눟", "nuh"], ["눅", "nuG"], ["눋", "nuD"], ["눕", "nuB"], ["누", "nu"],
    ["놑", "not"], ["놌", "noss"], ["놋", "nos"], ["높", "nop"], ["농", "nong"], ["논", "non"], ["놈", "nom"], ["놀", "noL"],
    ["녺", "nokk"], ["놐", "nok"], ["놎", "noj"], ["놓", "noh"], ["녹", "noG"], ["뇥", "noet"], ["뇠", "noess"], ["뇟", "noes"],
    ["뇦", "noep"], ["뇡", "noeng"], ["뇐", "noen"], ["뇜", "noem"], ["뇔", "noeL"], ["뇎", "noekk"], ["뇤", "noek"], ["뇢", "noej"],
    ["뇧", "noeh"], ["뇍", "noeG"], ["뇓", "noeD"], ["뇝", "noeB"], ["뇌", "noe"], ["녿", "noD"], ["놉", "noB"], ["노", "no"],
    ["닡", "nit"], ["닜", "niss"], ["닛", "nis"], ["닢", "nip"], ["닝", "ning"], ["닌", "nin"], ["님", "nim"], ["닐", "niL"],
    ["닊", "nikk"], ["닠", "nik"], ["닞", "nij"], ["닣", "nih"], ["닉", "niG"], ["닏", "niD"], ["닙", "niB"], ["니", "ni"],
    ["늩", "neut"], ["늤", "neuss"], ["늣", "neus"], ["늪", "neup"], ["능", "neung"], ["는", "neun"], ["늠", "neum"], ["늘", "neuL"],
    ["늒", "neukk"], ["늨", "neuk"], ["늦", "neuj"], ["늫", "neuh"], ["늑", "neuG"], ["늗", "neuD"], ["늡", "neuB"], ["느", "neu"],
    ["넽", "net"], ["넸", "ness"], ["넷", "nes"], ["넾", "nep"], ["넡", "neot"], ["넜", "neoss"], ["넛", "neos"], ["넢", "neop"],
    ["넝", "neong"], ["넌", "neon"], ["넘", "neom"], ["널", "neoL"], ["넊", "neokk"], ["넠", "neok"], ["넞", "neoj"], ["넣", "neoh"],
    ["넉", "neoG"], ["넏", "neoD"], ["넙", "neoB"], ["너", "neo"], ["넹", "neng"], ["넨", "nen"], ["넴", "nem"], ["넬", "neL"],
    ["넦", "nekk"], ["넼", "nek"], ["넺", "nej"], ["넿", "neh"], ["넥", "neG"], ["넫", "neD"], ["넵", "neB"], ["네", "ne"],
    ["낱", "nat"], ["났", "nass"], ["낫", "nas"], ["낲", "nap"], ["낭", "nang"], ["난", "nan"], ["남", "nam"], ["날", "naL"],
    ["낚", "nakk"], ["낰", "nak"], ["낮", "naj"], ["낳", "nah"], ["낙", "naG"], ["냍", "naet"], ["냈", "naess"], ["냇", "naes"],
    ["냎", "naep"], ["냉", "naeng"], ["낸", "naen"], ["냄", "naem"], ["낼", "naeL"], ["낶", "naekk"], ["냌", "naek"], ["냊", "naej"],
    ["냏", "naeh"], ["낵", "naeG"], ["낻", "naeD"], ["냅", "naeB"], ["내", "nae"], ["낟", "naD"], ["납", "naB"], ["나", "na"],
    ["끁", "kkyut"], ["뀼", "kkyuss"], ["뀻", "kkyus"], ["끂", "kkyup"], ["뀽", "kkyung"], ["뀬", "kkyun"], ["뀸", "kkyum"], ["뀰", "kkyuL"],
    ["뀪", "kkyukk"], ["끀", "kkyuk"], ["뀾", "kkyuj"], ["끃", "kkyuh"], ["뀩", "kkyuG"], ["뀯", "kkyuD"], ["뀹", "kkyuB"], ["뀨", "kkyu"],
    ["꾵", "kkyot"], ["꾰", "kkyoss"], ["꾯", "kkyos"], ["꾶", "kkyop"], ["꾱", "kkyong"], ["꾠", "kkyon"], ["꾬", "kkyom"], ["꾤", "kkyoL"],
    ["꾞", "kkyokk"], ["꾴", "kkyok"], ["꾲", "kkyoj"], ["꾷", "kkyoh"], ["꾝", "kkyoG"], ["꾣", "kkyoD"], ["꾭", "kkyoB"], ["꾜", "kkyo"],
    ["끹", "kkuit"], ["끴", "kkuiss"], ["끳", "kkuis"], ["끺", "kkuip"], ["끵", "kkuing"], ["끤", "kkuin"], ["끰", "kkuim"], ["끨", "kkuiL"],
    ["끢", "kkuikk"], ["끸", "kkuik"], ["끶", "kkuij"], ["끻", "kkuih"], ["끡", "kkuiG"], ["끧", "kkuiD"], ["끱", "kkuiB"], ["끠", "kkui"],
    ["꼩", "kkyet"], ["꼤", "kkyess"], ["꼣", "kkyes"], ["꼪", "kkyep"], ["꼍", "kkyeot"], ["꼈", "kkyeoss"], ["꼇", "kkyeos"], ["꼎", "kkyeop"],
    ["꼉", "kkyeong"], ["껸", "kkyeon"], ["꼄", "kkyeom"], ["껼", "kkyeoL"], ["껶", "kkyeokk"], ["꼌", "kkyeok"], ["꼊", "kkyeoj"], ["꼏", "kkyeoh"],
    ["껵", "kkyeoG"], ["껻", "kkyeoD"], ["꼅", "kkyeoB"], ["껴", "kkyeo"], ["꼥", "kkyeng"], ["꼔", "kkyen"], ["꼠", "kkyem"], ["꼘", "kkyeL"],
    ["꼒", "kkyekk"], ["꼨", "kkyek"], ["꼦", "kkyej"], ["꼫", "kkyeh"], ["꼑", "kkyeG"], ["꼗", "kkyeD"], ["꼡", "kkyeB"], ["꼐", "kkye"],
    ["꺝", "kkyat"], ["꺘", "kkyass"], ["꺗", "kkyas"], ["꺞", "kkyap"], ["꺙", "kkyang"], ["꺈", "kkyan"], ["꺔", "kkyam"], ["꺌", "kkyaL"],
    ["꺆", "kkyakk"], ["꺜", "kkyak"], ["꺚", "kkyaj"], ["꺟", "kkyah"], ["꺅", "kkyaG"], ["꺹", "kkyaet"], ["꺴", "kkyaess"], ["꺳", "kkyaes"],
    ["꺺", "kkyaep"], ["꺵", "kkyaeng"], ["꺤", "kkyaen"], ["꺰", "kkyaem"], ["꺨", "kkyaeL"], ["꺢", "kkyaekk"], ["꺸", "kkyaek"], ["꺶", "kkyaej"],
    ["꺻", "kkyaeh"], ["꺡", "kkyaeG"], ["꺧", "kkyaeD"], ["꺱", "kkyaeB"], ["꺠", "kkyae"], ["꺋", "kkyaD"], ["꺕", "kkyaB"], ["꺄", "kkya"],
    ["뀥", "kkwit"], ["뀠", "kkwiss"], ["뀟", "kkwis"], ["뀦", "kkwip"], ["뀡", "kkwing"], ["뀐", "kkwin"], ["뀜", "kkwim"], ["뀔", "kkwiL"],
    ["뀎", "kkwikk"], ["뀤", "kkwik"], ["뀢", "kkwij"], ["뀧", "kkwih"], ["뀍", "kkwiG"], ["뀓", "kkwiD"], ["뀝", "kkwiB"], ["뀌", "kkwi"],
    ["뀉", "kkwet"], ["뀄", "kkwess"], ["뀃", "kkwes"], ["뀊", "kkwep"], ["꿭", "kkwot"], ["꿨", "kkwoss"], ["꿧", "kkwos"], ["꿮", "kkwop"],
    ["꿩", "kkwong"], ["꿘", "kkwon"], ["꿤", "kkwom"], ["꿜", "kkwoL"], ["꿖", "kkwokk"], ["꿬", "kkwok"], ["꿪", "kkwoj"], ["꿯", "kkwoh"],
    ["꿕", "kkwoG"], ["꿛", "kkwoD"], ["꿥", "kkwoB"], ["꿔", "kkwo"], ["뀅", "kkweng"], ["꿴", "kkwen"], ["뀀", "kkwem"], ["꿸", "kkweL"],
    ["꿲", "kkwekk"], ["뀈", "kkwek"], ["뀆", "kkwej"], ["뀋", "kkweh"], ["꿱", "kkweG"], ["꿷", "kkweD"], ["뀁", "kkweB"], ["꿰", "kkwe"],
    ["꽡", "kkwat"], ["꽜", "kkwass"], ["꽛", "kkwas"], ["꽢", "kkwap"], ["꽝", "kkwang"], ["꽌", "kkwan"], ["꽘", "kkwam"], ["꽐", "kkwaL"],
    ["꽊", "kkwakk"], ["꽠", "kkwak"], ["꽞", "kkwaj"], ["꽣", "kkwah"], ["꽉", "kkwaG"], ["꽽", "kkwaet"], ["꽸", "kkwaess"], ["꽷", "kkwaes"],
    ["꽾", "kkwaep"], ["꽹", "kkwaeng"], ["꽨", "kkwaen"], ["꽴", "kkwaem"], ["꽬", "kkwaeL"], ["꽦", "kkwaekk"], ["꽼", "kkwaek"], ["꽺", "kkwaej"],
    ["꽿", "kkwaeh"], ["꽥", "kkwaeG"], ["꽫", "kkwaeD"], ["꽵", "kkwaeB"], ["꽤", "kkwae"], ["꽏", "kkwaD"], ["꽙", "kkwaB"], ["꽈", "kkwa"],
    ["꿑", "kkut"], ["꿌", "kkuss"], ["꿋", "kkus"], ["꿒", "kkup"], ["꿍", "kkung"], ["꾼", "kkun"], ["꿈", "kkum"], ["꿀", "kkuL"],
    ["꾺", "kkukk"], ["꿐", "kkuk"], ["꿎", "kkuj"], ["꿓", "kkuh"], ["꾹", "kkuG"], ["꾿", "kkuD"], ["꿉", "kkuB"], ["꾸", "kku"],
    ["꽅", "kkot"], ["꽀", "kkoss"], ["꼿", "kkos"], ["꽆", "kkop"], ["꽁", "kkong"], ["꼰", "kkon"], ["꼼", "kkom"], ["꼴", "kkoL"],
    ["꼮", "kkokk"], ["꽄", "kkok"], ["꽂", "kkoj"], ["꽇", "kkoh"], ["꼭", "kkoG"], ["꾙", "kkoet"], ["꾔", "kkoess"], ["꾓", "kkoes"],
    ["꾚", "kkoep"], ["꾕", "kkoeng"], ["꾄", "kkoen"], ["꾐", "kkoem"], ["꾈", "kkoeL"], ["꾂", "kkoekk"], ["꾘", "kkoek"], ["꾖", "kkoej"],
    ["꾛", "kkoeh"], ["꾁", "kkoeG"], ["꾇", "kkoeD"], ["꾑", "kkoeB"], ["꾀", "kkoe"], ["꼳", "kkoD"], ["꼽", "kkoB"], ["꼬", "kko"],
    ["낕", "kkit"], ["낐", "kkiss"], ["낏", "kkis"], ["낖", "kkip"], ["낑", "kking"], ["낀", "kkin"], ["낌", "kkim"], ["낄", "kkiL"],
    ["끾", "kkikk"], ["낔", "kkik"], ["낒", "kkij"], ["낗", "kkih"], ["끽", "kkiG"], ["낃", "kkiD"], ["낍", "kkiB"], ["끼", "kki"],
    ["끝", "kkeut"], ["끘", "kkeuss"], ["끗", "kkeus"], ["끞", "kkeup"], ["끙", "kkeung"], ["끈", "kkeun"], ["끔", "kkeum"], ["끌", "kkeuL"],
    ["끆", "kkeukk"], ["끜", "kkeuk"], ["끚", "kkeuj"], ["끟", "kkeuh"], ["끅", "kkeuG"], ["끋", "kkeuD"], ["끕", "kkeuB"], ["끄", "kkeu"],
    ["껱", "kket"], ["껬", "kkess"], ["껫", "kkes"], ["껲", "kkep"], ["껕", "kkeot"], ["껐", "kkeoss"], ["껏", "kkeos"], ["껖", "kkeop"],
    ["껑", "kkeong"], ["껀", "kkeon"], ["껌", "kkeom"], ["껄", "kkeoL"], ["꺾", "kkeokk"], ["껔", "kkeok"], ["껒", "kkeoj"], ["껗", "kkeoh"],
    ["꺽", "kkeoG"], ["껃", "kkeoD"], ["껍", "kkeoB"], ["꺼", "kkeo"], ["껭", "kkeng"], ["껜", "kken"], ["껨", "kkem"], ["껠", "kkeL"],
    ["껚", "kkekk"], ["껰", "kkek"], ["껮", "kkej"], ["껳", "kkeh"], ["껙", "kkeG"], ["껟", "kkeD"], ["껩", "kkeB"], ["께", "kke"],
    ["깥", "kkat"], ["깠", "kkass"], ["깟", "kkas"], ["깦", "kkap"], ["깡", "kkang"], ["깐", "kkan"], ["깜", "kkam"], ["깔", "kkaL"],
    ["깎", "kkakk"], ["깤", "kkak"], ["깢", "kkaj"], ["깧", "kkah"], ["깍", "kkaG"], ["꺁", "kkaet"], ["깼", "kkaess"], ["깻", "kkaes"],
    ["꺂", "kkaep"], ["깽", "kkaeng"], ["깬", "kkaen"], ["깸", "kkaem"], ["깰", "kkaeL"], ["깪", "kkaekk"], ["꺀", "kkaek"], ["깾", "kkaej"],
    ["꺃", "kkaeh"], ["깩", "kkaeG"], ["깯", "kkaeD"], ["깹", "kkaeB"], ["깨", "kkae"], ["깓", "kkaD"], ["깝", "kkaB"], ["까", "kka"],
    ["귵", "gyut"], ["귰", "gyuss"], ["귯", "gyus"], ["귶", "gyup"], ["귱", "gyung"], ["균", "gyun"], ["귬", "gyum"], ["귤", "gyuL"],
    ["귞", "gyukk"], ["귴", "gyuk"], ["귲", "gyuj"], ["귷", "gyuh"], ["귝", "gyuG"], ["귣", "gyuD"], ["귭", "gyuB"], ["규", "gyu"],
    ["굩", "gyot"], ["굤", "gyoss"], ["굣", "gyos"], ["굪", "gyop"], ["굥", "gyong"], ["굔", "gyon"], ["굠", "gyom"], ["굘", "gyoL"],
    ["굒", "gyokk"], ["굨", "gyok"], ["굦", "gyoj"], ["굫", "gyoh"], ["굑", "gyoG"], ["굗", "gyoD"], ["굡", "gyoB"], ["교", "gyo"],
    ["긭", "guit"], ["긨", "guiss"], ["긧", "guis"], ["긮", "guip"], ["긩", "guing"], ["긘", "guin"], ["긤", "guim"], ["긜", "guiL"],
    ["긖", "guikk"], ["긬", "guik"], ["긪", "guij"], ["긯", "guih"], ["긕", "guiG"], ["긛", "guiD"], ["긥", "guiB"], ["긔", "gui"],
    ["곝", "gyet"], ["곘", "gyess"], ["곗", "gyes"], ["곞", "gyep"], ["곁", "gyeot"], ["겼", "gyeoss"], ["겻", "gyeos"], ["곂", "gyeop"],
    ["경", "gyeong"], ["견", "gyeon"], ["겸", "gyeom"], ["결", "gyeoL"], ["겪", "gyeokk"], ["곀", "gyeok"], ["겾", "gyeoj"], ["곃", "gyeoh"],
    ["격", "gyeoG"], ["겯", "gyeoD"], ["겹", "gyeoB"], ["겨", "gyeo"], ["곙", "gyeng"], ["곈", "gyen"], ["곔", "gyem"], ["곌", "gyeL"],
    ["곆", "gyekk"], ["곜", "gyek"], ["곚", "gyej"], ["곟", "gyeh"], ["곅", "gyeG"], ["곋", "gyeD"], ["곕", "gyeB"], ["계", "gye"],
    ["걑", "gyat"], ["걌", "gyass"], ["걋", "gyas"], ["걒", "gyap"], ["걍", "gyang"], ["갼", "gyan"], ["걈", "gyam"], ["걀", "gyaL"],
    ["갺", "gyakk"], ["걐", "gyak"], ["걎", "gyaj"], ["걓", "gyah"], ["갹", "gyaG"], ["걭", "gyaet"], ["걨", "gyaess"], ["걧", "gyaes"],
    ["걮", "gyaep"], ["걩", "gyaeng"], ["걘", "gyaen"], ["걤", "gyaem"], ["걜", "gyaeL"], ["걖", "gyaekk"], ["걬", "gyaek"], ["걪", "gyaej"],
    ["걯", "gyaeh"], ["걕", "gyaeG"], ["걛", "gyaeD"], ["걥", "gyaeB"], ["걔", "gyae"], ["갿", "gyaD"], ["걉", "gyaB"], ["갸", "gya"],
    ["귙", "gwit"], ["귔", "gwiss"], ["귓", "gwis"], ["귚", "gwip"], ["귕", "gwing"], ["귄", "gwin"], ["귐", "gwim"], ["귈", "gwiL"],
    ["귂", "gwikk"], ["귘", "gwik"], ["귖", "gwij"], ["귛", "gwih"], ["귁", "gwiG"], ["귇", "gwiD"], ["귑", "gwiB"], ["귀", "gwi"],
    ["궽", "gwet"], ["궸", "gwess"], ["궷", "gwes"], ["궾", "gwep"], ["궡", "gwot"], ["궜", "gwoss"], ["궛", "gwos"], ["궢", "gwop"],
    ["궝", "gwong"], ["권", "gwon"], ["궘", "gwom"], ["궐", "gwoL"], ["궊", "gwokk"], ["궠", "gwok"], ["궞", "gwoj"], ["궣", "gwoh"],
    ["궉", "gwoG"], ["궏", "gwoD"], ["궙", "gwoB"], ["궈", "gwo"], ["궹", "gweng"], ["궨", "gwen"], ["궴", "gwem"], ["궬", "gweL"],
    ["궦", "gwekk"], ["궼", "gwek"], ["궺", "gwej"], ["궿", "gweh"], ["궥", "gweG"], ["궫", "gweD"], ["궵", "gweB"], ["궤", "gwe"],
    ["괕", "gwat"], ["괐", "gwass"], ["괏", "gwas"], ["괖", "gwap"], ["광", "gwang"], ["관", "gwan"], ["괌", "gwam"], ["괄", "gwaL"],
    ["곾", "gwakk"], ["괔", "gwak"], ["괒", "gwaj"], ["괗", "gwah"], ["곽", "gwaG"], ["괱", "gwaet"], ["괬", "gwaess"], ["괫", "gwaes"],
    ["괲", "gwaep"], ["괭", "gwaeng"], ["괜", "gwaen"], ["괨", "gwaem"], ["괠", "gwaeL"], ["괚", "gwaekk"], ["괰", "gwaek"], ["괮", "gwaej"],
    ["괳", "gwaeh"], ["괙", "gwaeG"], ["괟", "gwaeD"], ["괩", "gwaeB"], ["괘", "gwae"], ["괃", "gwaD"], ["괍", "gwaB"], ["과", "gwa"],
    ["궅", "gut"], ["궀", "guss"], ["굿", "gus"], ["궆", "gup"], ["궁", "gung"], ["군", "gun"], ["굼", "gum"], ["굴", "guL"],
    ["굮", "gukk"], ["궄", "guk"], ["궂", "guj"], ["궇", "guh"], ["국", "guG"], ["굳", "guD"], ["굽", "guB"], ["구", "gu"],
    ["곹", "got"], ["곴", "goss"], ["곳", "gos"], ["곺", "gop"], ["공", "gong"], ["곤", "gon"], ["곰", "gom"], ["골", "goL"],
    ["곢", "gokk"], ["곸", "gok"], ["곶", "goj"], ["곻", "goh"], ["곡", "goG"], ["굍", "goet"], ["굈", "goess"], ["굇", "goes"],
    ["굎", "goep"], ["굉", "goeng"], ["괸", "goen"], ["굄", "goem"], ["괼", "goeL"], ["괶", "goekk"], ["굌", "goek"], ["굊", "goej"],
    ["굏", "goeh"], ["괵", "goeG"], ["괻", "goeD"], ["굅", "goeB"], ["괴", "goe"], ["곧", "goD"], ["곱", "goB"], ["고", "go"],
    ["깉", "git"], ["깄", "giss"], ["깃", "gis"], ["깊", "gip"], ["깅", "ging"], ["긴", "gin"], ["김", "gim"], ["길", "giL"],
    ["긲", "gikk"], ["깈", "gik"], ["깆", "gij"], ["깋", "gih"], ["긱", "giG"], ["긷", "giD"], ["깁", "giB"], ["기", "gi"],
    ["긑", "geut"], ["긌", "geuss"], ["긋", "geus"], ["긒", "geup"], ["긍", "geung"], ["근", "geun"], ["금", "geum"], ["글", "geuL"],
    ["귺", "geukk"], ["긐", "geuk"], ["긎", "geuj"], ["긓", "geuh"], ["극", "geuG"], ["귿", "geuD"], ["급", "geuB"], ["그", "geu"],
    ["겥", "get"], ["겠", "gess"], ["겟", "ges"], ["겦", "gep"], ["겉", "geot"], ["겄", "geoss"], ["것", "geos"], ["겊", "geop"],
    ["겅", "geong"], ["건", "geon"], ["검", "geom"], ["걸", "geoL"], ["걲", "geokk"], ["겈", "geok"], ["겆", "geoj"], ["겋", "geoh"],
    ["걱", "geoG"], ["걷", "geoD"], ["겁", "geoB"], ["거", "geo"], ["겡", "geng"], ["겐", "gen"], ["겜", "gem"], ["겔", "geL"],
    ["겎", "gekk"], ["겤", "gek"], ["겢", "gej"], ["겧", "geh"], ["겍", "geG"], ["겓", "geD"], ["겝", "geB"], ["게", "ge"],
    ["같", "gat"], ["갔", "gass"], ["갓", "gas"], ["갚", "gap"], ["강", "gang"], ["간", "gan"], ["감", "gam"], ["갈", "gaL"],
    ["갂", "gakk"], ["갘", "gak"], ["갖", "gaj"], ["갛", "gah"], ["각", "gaG"], ["갵", "gaet"], ["갰", "gaess"], ["갯", "gaes"],
    ["갶", "gaep"], ["갱", "gaeng"], ["갠", "gaen"], ["갬", "gaem"], ["갤", "gaeL"], ["갞", "gaekk"], ["갴", "gaek"], ["갲", "gaej"],
    ["갷", "gaeh"], ["객", "gaeG"], ["갣", "gaeD"], ["갭", "gaeB"], ["개", "gae"], ["갇", "gaD"], ["갑", "gaB"], ["가", "ga"],
    ["듙", "dyut"], ["듔", "dyuss"], ["듓", "dyus"], ["듚", "dyup"], ["듕", "dyung"], ["듄", "dyun"], ["듐", "dyum"], ["듈", "dyuL"],
    ["듂", "dyukk"], ["듘", "dyuk"], ["듖", "dyuj"], ["듛", "dyuh"], ["듁", "dyuG"], ["듇", "dyuD"], ["듑", "dyuB"], ["듀", "dyu"],
    ["둍", "dyot"], ["둈", "dyoss"], ["둇", "dyos"], ["둎", "dyop"], ["둉", "dyong"], ["됸", "dyon"], ["둄", "dyom"], ["됼", "dyoL"],
    ["됶", "dyokk"], ["둌", "dyok"], ["둊", "dyoj"], ["둏", "dyoh"], ["됵", "dyoG"], ["됻", "dyoD"], ["둅", "dyoB"], ["됴", "dyo"],
    ["딑", "duit"], ["딌", "duiss"], ["딋", "duis"], ["딒", "duip"], ["딍", "duing"], ["듼", "duin"], ["딈", "duim"], ["딀", "duiL"],
    ["듺", "duikk"], ["딐", "duik"], ["딎", "duij"], ["딓", "duih"], ["듹", "duiG"], ["듿", "duiD"], ["딉", "duiB"], ["듸", "dui"],
    ["돁", "dyet"], ["뎼", "dyess"], ["뎻", "dyes"], ["돂", "dyep"], ["뎥", "dyeot"], ["뎠", "dyeoss"], ["뎟", "dyeos"], ["뎦", "dyeop"],
    ["뎡", "dyeong"], ["뎐", "dyeon"], ["뎜", "dyeom"], ["뎔", "dyeoL"], ["뎎", "dyeokk"], ["뎤", "dyeok"], ["뎢", "dyeoj"], ["뎧", "dyeoh"],
    ["뎍", "dyeoG"], ["뎓", "dyeoD"], ["뎝", "dyeoB"], ["뎌", "dyeo"], ["뎽", "dyeng"], ["뎬", "dyen"], ["뎸", "dyem"], ["뎰", "dyeL"],
    ["뎪", "dyekk"], ["돀", "dyek"], ["뎾", "dyej"], ["돃", "dyeh"], ["뎩", "dyeG"], ["뎯", "dyeD"], ["뎹", "dyeB"], ["뎨", "dye"],
    ["댵", "dyat"], ["댰", "dyass"], ["댯", "dyas"], ["댶", "dyap"], ["댱", "dyang"], ["댠", "dyan"], ["댬", "dyam"], ["댤", "dyaL"],
    ["댞", "dyakk"], ["댴", "dyak"], ["댲", "dyaj"], ["댷", "dyah"], ["댝", "dyaG"], ["덑", "dyaet"], ["덌", "dyaess"], ["덋", "dyaes"],
    ["덒", "dyaep"], ["덍", "dyaeng"], ["댼", "dyaen"], ["덈", "dyaem"], ["덀", "dyaeL"], ["댺", "dyaekk"], ["덐", "dyaek"], ["덎", "dyaej"],
    ["덓", "dyaeh"], ["댹", "dyaeG"], ["댿", "dyaeD"], ["덉", "dyaeB"], ["댸", "dyae"], ["댣", "dyaD"], ["댭", "dyaB"], ["댜", "dya"],
    ["뒽", "dwit"], ["뒸", "dwiss"], ["뒷", "dwis"], ["뒾", "dwip"], ["뒹", "dwing"], ["뒨", "dwin"], ["뒴", "dwim"], ["뒬", "dwiL"],
    ["뒦", "dwikk"], ["뒼", "dwik"], ["뒺", "dwij"], ["뒿", "dwih"], ["뒥", "dwiG"], ["뒫", "dwiD"], ["뒵", "dwiB"], ["뒤", "dwi"],
    ["뒡", "dwet"], ["뒜", "dwess"], ["뒛", "dwes"], ["뒢", "dwep"], ["뒅", "dwot"], ["뒀", "dwoss"], ["둿", "dwos"], ["뒆", "dwop"],
    ["뒁", "dwong"], ["둰", "dwon"], ["둼", "dwom"], ["둴", "dwoL"], ["둮", "dwokk"], ["뒄", "dwok"], ["뒂", "dwoj"], ["뒇", "dwoh"],
    ["둭", "dwoG"], ["둳", "dwoD"], ["둽", "dwoB"], ["둬", "dwo"], ["뒝", "dweng"], ["뒌", "dwen"], ["뒘", "dwem"], ["뒐", "dweL"],
    ["뒊", "dwekk"], ["뒠", "dwek"], ["뒞", "dwej"], ["뒣", "dweh"], ["뒉", "dweG"], ["뒏", "dweD"], ["뒙", "dweB"], ["뒈", "dwe"],
    ["돹", "dwat"], ["돴", "dwass"], ["돳", "dwas"], ["돺", "dwap"], ["돵", "dwang"], ["돤", "dwan"], ["돰", "dwam"], ["돨", "dwaL"],
    ["돢", "dwakk"], ["돸", "dwak"], ["돶", "dwaj"], ["돻", "dwah"], ["돡", "dwaG"], ["됕", "dwaet"], ["됐", "dwaess"], ["됏", "dwaes"],
    ["됖", "dwaep"], ["됑", "dwaeng"], ["됀", "dwaen"], ["됌", "dwaem"], ["됄", "dwaeL"], ["돾", "dwaekk"], ["됔", "dwaek"], ["됒", "dwaej"],
    ["됗", "dwaeh"], ["돽", "dwaeG"], ["됃", "dwaeD"], ["됍", "dwaeB"], ["돼", "dwae"], ["돧", "dwaD"], ["돱", "dwaB"], ["돠", "dwa"],
    ["둩", "dut"], ["둤", "duss"], ["둣", "dus"], ["둪", "dup"], ["둥", "dung"], ["둔", "dun"], ["둠", "dum"], ["둘", "duL"],
    ["둒", "dukk"], ["둨", "duk"], ["둦", "duj"], ["둫", "duh"], ["둑", "duG"], ["둗", "duD"], ["둡", "duB"], ["두", "du"],
    ["돝", "dot"], ["돘", "doss"], ["돗", "dos"], ["돞", "dop"], ["동", "dong"], ["돈", "don"], ["돔", "dom"], ["돌", "doL"],
    ["돆", "dokk"], ["돜", "dok"], ["돚", "doj"], ["돟", "doh"], ["독", "doG"], ["됱", "doet"], ["됬", "doess"], ["됫", "does"],
    ["됲", "doep"], ["됭", "doeng"], ["된", "doen"], ["됨", "doem"], ["될", "doeL"], ["됚", "doekk"], ["됰", "doek"], ["됮", "doej"],
    ["됳", "doeh"], ["됙", "doeG"], ["됟", "doeD"], ["됩", "doeB"], ["되", "doe"], ["돋", "doD"], ["돕", "doB"], ["도", "do"],
    ["딭", "dit"], ["딨", "diss"], ["딧", "dis"], ["딮", "dip"], ["딩", "ding"], ["딘", "din"], ["딤", "dim"], ["딜", "diL"],
    ["딖", "dikk"], ["딬", "dik"], ["딪", "dij"], ["딯", "dih"], ["딕", "diG"], ["딛", "diD"], ["딥", "diB"], ["디", "di"],
    ["듵", "deut"], ["듰", "deuss"], ["듯", "deus"], ["듶", "deup"], ["등", "deung"], ["든", "deun"], ["듬", "deum"], ["들", "deuL"],
    ["듞", "deukk"], ["듴", "deuk"], ["듲", "deuj"], ["듷", "deuh"], ["득", "deuG"], ["듣", "deuD"], ["듭", "deuB"], ["드", "deu"],
    ["뎉", "det"], ["뎄", "dess"], ["뎃", "des"], ["뎊", "dep"], ["덭", "deot"], ["덨", "deoss"], ["덧", "deos"], ["덮", "deop"],
    ["덩", "deong"], ["던", "deon"], ["덤", "deom"], ["덜", "deoL"], ["덖", "deokk"], ["덬", "deok"], ["덪", "deoj"], ["덯", "deoh"],
    ["덕", "deoG"], ["덛", "deoD"], ["덥", "deoB"], ["더", "deo"], ["뎅", "deng"], ["덴", "den"], ["뎀", "dem"], ["델", "deL"],
    ["덲", "dekk"], ["뎈", "dek"], ["뎆", "dej"], ["뎋", "deh"], ["덱", "deG"], ["덷", "deD"], ["뎁", "deB"], ["데", "de"],
    ["닽", "dat"], ["닸", "dass"], ["닷", "das"], ["닾", "dap"], ["당", "dang"], ["단", "dan"], ["담", "dam"], ["달", "daL"],
    ["닦", "dakk"], ["닼", "dak"], ["닺", "daj"], ["닿", "dah"], ["닥", "daG"], ["댙", "daet"], ["댔", "daess"], ["댓", "daes"],
    ["댚", "daep"], ["댕", "daeng"], ["댄", "daen"], ["댐", "daem"], ["댈", "daeL"], ["댂", "daekk"], ["댘", "daek"], ["댖", "daej"],
    ["댛", "daeh"], ["댁", "daeG"], ["댇", "daeD"], ["댑", "daeB"], ["대", "dae"], ["닫", "daD"], ["답", "daB"], ["다", "da"],
    ["륱", "ryut"], ["륬", "ryuss"], ["륫", "ryus"], ["륲", "ryup"], ["륭", "ryung"], ["륜", "ryun"], ["륨", "ryum"], ["률", "ryuL"],
    ["륚", "ryukk"], ["륰", "ryuk"], ["륮", "ryuj"], ["륳", "ryuh"], ["륙", "ryuG"], ["륟", "ryuD"], ["륩", "ryuB"], ["류", "ryu"],
    ["룥", "ryot"], ["룠", "ryoss"], ["룟", "ryos"], ["룦", "ryop"], ["룡", "ryong"], ["룐", "ryon"], ["룜", "ryom"], ["룔", "ryoL"],
    ["룎", "ryokk"], ["룤", "ryok"], ["룢", "ryoj"], ["룧", "ryoh"], ["룍", "ryoG"], ["룓", "ryoD"], ["룝", "ryoB"], ["료", "ryo"],
    ["릩", "ruit"], ["릤", "ruiss"], ["릣", "ruis"], ["릪", "ruip"], ["릥", "ruing"], ["릔", "ruin"], ["릠", "ruim"], ["릘", "ruiL"],
    ["릒", "ruikk"], ["릨", "ruik"], ["릦", "ruij"], ["릫", "ruih"], ["릑", "ruiG"], ["릗", "ruiD"], ["릡", "ruiB"], ["릐", "rui"],
    ["롙", "ryet"], ["롔", "ryess"], ["롓", "ryes"], ["롚", "ryep"], ["렽", "ryeot"], ["렸", "ryeoss"], ["렷", "ryeos"], ["렾", "ryeop"],
    ["령", "ryeong"], ["련", "ryeon"], ["렴", "ryeom"], ["렬", "ryeoL"], ["렦", "ryeokk"], ["렼", "ryeok"], ["렺", "ryeoj"], ["렿", "ryeoh"],
    ["력", "ryeoG"], ["렫", "ryeoD"], ["렵", "ryeoB"], ["려", "ryeo"], ["롕", "ryeng"], ["롄", "ryen"], ["롐", "ryem"], ["롈", "ryeL"],
    ["롂", "ryekk"], ["롘", "ryek"], ["롖", "ryej"], ["롛", "ryeh"], ["롁", "ryeG"], ["롇", "ryeD"], ["롑", "ryeB"], ["례", "rye"],
    ["럍", "ryat"], ["럈", "ryass"], ["럇", "ryas"], ["럎", "ryap"], ["량", "ryang"], ["랸", "ryan"], ["럄", "ryam"], ["랼", "ryaL"],
    ["랶", "ryakk"], ["럌", "ryak"], ["럊", "ryaj"], ["럏", "ryah"], ["략", "ryaG"], ["럩", "ryaet"], ["럤", "ryaess"], ["럣", "ryaes"],
    ["럪", "ryaep"], ["럥", "ryaeng"], ["럔", "ryaen"], ["럠", "ryaem"], ["럘", "ryaeL"], ["럒", "ryaekk"], ["럨", "ryaek"], ["럦", "ryaej"],
    ["럫", "ryaeh"], ["럑", "ryaeG"], ["럗", "ryaeD"], ["럡", "ryaeB"], ["럐", "ryae"], ["랻", "ryaD"], ["럅", "ryaB"], ["랴", "rya"],
    ["륕", "rwit"], ["륐", "rwiss"], ["륏", "rwis"], ["륖", "rwip"], ["륑", "rwing"], ["륀", "rwin"], ["륌", "rwim"], ["륄", "rwiL"],
    ["뤾", "rwikk"], ["륔", "rwik"], ["륒", "rwij"], ["륗", "rwih"], ["뤽", "rwiG"], ["륃", "rwiD"], ["륍", "rwiB"], ["뤼", "rwi"],
    ["뤹", "rwet"], ["뤴", "rwess"], ["뤳", "rwes"], ["뤺", "rwep"], ["뤝", "rwot"], ["뤘", "rwoss"], ["뤗", "rwos"], ["뤞", "rwop"],
    ["뤙", "rwong"], ["뤈", "rwon"], ["뤔", "rwom"], ["뤌", "rwoL"], ["뤆", "rwokk"], ["뤜", "rwok"], ["뤚", "rwoj"], ["뤟", "rwoh"],
    ["뤅", "rwoG"], ["뤋", "rwoD"], ["뤕", "rwoB"], ["뤄", "rwo"], ["뤵", "rweng"], ["뤤", "rwen"], ["뤰", "rwem"], ["뤨", "rweL"],
    ["뤢", "rwekk"], ["뤸", "rwek"], ["뤶", "rwej"], ["뤻", "rweh"], ["뤡", "rweG"], ["뤧", "rweD"], ["뤱", "rweB"], ["뤠", "rwe"],
    ["뢑", "rwat"], ["뢌", "rwass"], ["뢋", "rwas"], ["뢒", "rwap"], ["뢍", "rwang"], ["롼", "rwan"], ["뢈", "rwam"], ["뢀", "rwaL"],
    ["롺", "rwakk"], ["뢐", "rwak"], ["뢎", "rwaj"], ["뢓", "rwah"], ["롹", "rwaG"], ["뢭", "rwaet"], ["뢨", "rwaess"], ["뢧", "rwaes"],
    ["뢮", "rwaep"], ["뢩", "rwaeng"], ["뢘", "rwaen"], ["뢤", "rwaem"], ["뢜", "rwaeL"], ["뢖", "rwaekk"], ["뢬", "rwaek"], ["뢪", "rwaej"],
    ["뢯", "rwaeh"], ["뢕", "rwaeG"], ["뢛", "rwaeD"], ["뢥", "rwaeB"], ["뢔", "rwae"], ["롿", "rwaD"], ["뢉", "rwaB"], ["롸", "rwa"],
    ["뤁", "rut"], ["룼", "russ"], ["룻", "rus"], ["뤂", "rup"], ["룽", "rung"], ["룬", "run"], ["룸", "rum"], ["룰", "ruL"],
    ["룪", "rukk"], ["뤀", "ruk"], ["룾", "ruj"], ["뤃", "ruh"], ["룩", "ruG"], ["룯", "ruD"], ["룹", "ruB"], ["루", "ru"],
    ["롵", "rot"], ["롰", "ross"], ["롯", "ros"], ["롶", "rop"], ["롱", "rong"], ["론", "ron"], ["롬", "rom"], ["롤", "roL"],
    ["롞", "rokk"], ["롴", "rok"], ["롲", "roj"], ["롷", "roh"], ["록", "roG"], ["룉", "roet"], ["룄", "roess"], ["룃", "roes"],
    ["룊", "roep"], ["룅", "roeng"], ["뢴", "roen"], ["룀", "roem"], ["뢸", "roeL"], ["뢲", "roekk"], ["룈", "roek"], ["룆", "roej"],
    ["룋", "roeh"], ["뢱", "roeG"], ["뢷", "roeD"], ["룁", "roeB"], ["뢰", "roe"], ["롣", "roD"], ["롭", "roB"], ["로", "ro"],
    ["맅", "rit"], ["맀", "riss"], ["릿", "ris"], ["맆", "rip"], ["링", "ring"], ["린", "rin"], ["림", "rim"], ["릴", "riL"],
    ["릮", "rikk"], ["맄", "rik"], ["맂", "rij"], ["맇", "rih"], ["릭", "riG"], ["릳", "riD"], ["립", "riB"], ["리", "ri"],
    ["릍", "reut"], ["릈", "reuss"], ["릇", "reus"], ["릎", "reup"], ["릉", "reung"], ["른", "reun"], ["름", "reum"], ["를", "reuL"],
    ["륶", "reukk"], ["릌", "reuk"], ["릊", "reuj"], ["릏", "reuh"], ["륵", "reuG"], ["륻", "reuD"], ["릅", "reuB"], ["르", "reu"],
    ["렡", "ret"], ["렜", "ress"], ["렛", "res"], ["렢", "rep"], ["렅", "reot"], ["렀", "reoss"], ["럿", "reos"], ["렆", "reop"],
    ["렁", "reong"], ["런", "reon"], ["럼", "reom"], ["럴", "reoL"], ["럮", "reokk"], ["렄", "reok"], ["렂", "reoj"], ["렇", "reoh"],
    ["럭", "reoG"], ["럳", "reoD"], ["럽", "reoB"], ["러", "reo"], ["렝", "reng"], ["렌", "ren"], ["렘", "rem"], ["렐", "reL"],
    ["렊", "rekk"], ["렠", "rek"], ["렞", "rej"], ["렣", "reh"], ["렉", "reG"], ["렏", "reD"], ["렙", "reB"], ["레", "re"],
    ["랕", "rat"], ["랐", "rass"], ["랏", "ras"], ["랖", "rap"], ["랑", "rang"], ["란", "ran"], ["람", "ram"], ["랄", "raL"],
    ["띾", "rakk"], ["랔", "rak"], ["랒", "raj"], ["랗", "rah"], ["락", "raG"], ["랱", "raet"], ["랬", "raess"], ["랫", "raes"],
    ["랲", "raep"], ["랭", "raeng"], ["랜", "raen"], ["램", "raem"], ["랠", "raeL"], ["랚", "raekk"], ["랰", "raek"], ["랮", "raej"],
    ["랳", "raeh"], ["랙", "raeG"], ["랟", "raeD"], ["랩", "raeB"], ["래", "rae"], ["랃", "raD"], ["랍", "raB"], ["라", "ra"],
    ["쁕", "ppyut"], ["쁐", "ppyuss"], ["쁏", "ppyus"], ["쁖", "ppyup"], ["쁑", "ppyung"], ["쁀", "ppyun"], ["쁌", "ppyum"], ["쁄", "ppyuL"],
    ["쀾", "ppyukk"], ["쁔", "ppyuk"], ["쁒", "ppyuj"], ["쁗", "ppyuh"], ["쀽", "ppyuG"], ["쁃", "ppyuD"], ["쁍", "ppyuB"], ["쀼", "ppyu"],
    ["뿉", "ppyot"], ["뿄", "ppyoss"], ["뿃", "ppyos"], ["뿊", "ppyop"], ["뿅", "ppyong"], ["뾴", "ppyon"], ["뿀", "ppyom"], ["뾸", "ppyoL"],
    ["뾲", "ppyokk"], ["뿈", "ppyok"], ["뿆", "ppyoj"], ["뿋", "ppyoh"], ["뾱", "ppyoG"], ["뾷", "ppyoD"], ["뿁", "ppyoB"], ["뾰", "ppyo"],
    ["삍", "ppuit"], ["삈", "ppuiss"], ["삇", "ppuis"], ["삎", "ppuip"], ["삉", "ppuing"], ["쁸", "ppuin"], ["삄", "ppuim"], ["쁼", "ppuiL"],
    ["쁶", "ppuikk"], ["삌", "ppuik"], ["삊", "ppuij"], ["삏", "ppuih"], ["쁵", "ppuiG"], ["쁻", "ppuiD"], ["삅", "ppuiB"], ["쁴", "ppui"],
    ["뼽", "ppyet"], ["뼸", "ppyess"], ["뼷", "ppyes"], ["뼾", "ppyep"], ["뼡", "ppyeot"], ["뼜", "ppyeoss"], ["뼛", "ppyeos"], ["뼢", "ppyeop"],
    ["뼝", "ppyeong"], ["뼌", "ppyeon"], ["뼘", "ppyeom"], ["뼐", "ppyeoL"], ["뼊", "ppyeokk"], ["뼠", "ppyeok"], ["뼞", "ppyeoj"], ["뼣", "ppyeoh"],
    ["뼉", "ppyeoG"], ["뼏", "ppyeoD"], ["뼙", "ppyeoB"], ["뼈", "ppyeo"], ["뼹", "ppyeng"], ["뼨", "ppyen"], ["뼴", "ppyem"], ["뼬", "ppyeL"],
    ["뼦", "ppyekk"], ["뼼", "ppyek"], ["뼺", "ppyej"], ["뼿", "ppyeh"], ["뼥", "ppyeG"], ["뼫", "ppyeD"], ["뼵", "ppyeB"], ["뼤", "ppye"],
    ["뺱", "ppyat"], ["뺬", "ppyass"], ["뺫", "ppyas"], ["뺲", "ppyap"], ["뺭", "ppyang"], ["뺜", "ppyan"], ["뺨", "ppyam"], ["뺠", "ppyaL"],
    ["뺚", "ppyakk"], ["뺰", "ppyak"], ["뺮", "ppyaj"], ["뺳", "ppyah"], ["뺙", "ppyaG"], ["뻍", "ppyaet"], ["뻈", "ppyaess"], ["뻇", "ppyaes"],
    ["뻎", "ppyaep"], ["뻉", "ppyaeng"], ["뺸", "ppyaen"], ["뻄", "ppyaem"], ["뺼", "ppyaeL"], ["뺶", "ppyaekk"], ["뻌", "ppyaek"], ["뻊", "ppyaej"],
    ["뻏", "ppyaeh"], ["뺵", "ppyaeG"], ["뺻", "ppyaeD"], ["뻅", "ppyaeB"], ["뺴", "ppyae"], ["뺟", "ppyaD"], ["뺩", "ppyaB"], ["뺘", "ppya"],
    ["쀹", "ppwit"], ["쀴", "ppwiss"], ["쀳", "ppwis"], ["쀺", "ppwip"], ["쀵", "ppwing"], ["쀤", "ppwin"], ["쀰", "ppwim"], ["쀨", "ppwiL"],
    ["쀢", "ppwikk"], ["쀸", "ppwik"], ["쀶", "ppwij"], ["쀻", "ppwih"], ["쀡", "ppwiG"], ["쀧", "ppwiD"], ["쀱", "ppwiB"], ["쀠", "ppwi"],
    ["쀝", "ppwet"], ["쀘", "ppwess"], ["쀗", "ppwes"], ["쀞", "ppwep"], ["쀁", "ppwot"], ["뿼", "ppwoss"], ["뿻", "ppwos"], ["쀂", "ppwop"],
    ["뿽", "ppwong"], ["뿬", "ppwon"], ["뿸", "ppwom"], ["뿰", "ppwoL"], ["뿪", "ppwokk"], ["쀀", "ppwok"], ["뿾", "ppwoj"], ["쀃", "ppwoh"],
    ["뿩", "ppwoG"], ["뿯", "ppwoD"], ["뿹", "ppwoB"], ["뿨", "ppwo"], ["쀙", "ppweng"], ["쀈", "ppwen"], ["쀔", "ppwem"], ["쀌", "ppweL"],
    ["쀆", "ppwekk"], ["쀜", "ppwek"], ["쀚", "ppwej"], ["쀟", "ppweh"], ["쀅", "ppweG"], ["쀋", "ppweD"], ["쀕", "ppweB"], ["쀄", "ppwe"],
    ["뽵", "ppwat"], ["뽰", "ppwass"], ["뽯", "ppwas"], ["뽶", "ppwap"], ["뽱", "ppwang"], ["뽠", "ppwan"], ["뽬", "ppwam"], ["뽤", "ppwaL"],
    ["뽞", "ppwakk"], ["뽴", "ppwak"], ["뽲", "ppwaj"], ["뽷", "ppwah"], ["뽝", "ppwaG"], ["뾑", "ppwaet"], ["뾌", "ppwaess"], ["뾋", "ppwaes"],
    ["뾒", "ppwaep"], ["뾍", "ppwaeng"], ["뽼", "ppwaen"], ["뾈", "ppwaem"], ["뾀", "ppwaeL"], ["뽺", "ppwaekk"], ["뾐", "ppwaek"], ["뾎", "ppwaej"],
    ["뾓", "ppwaeh"], ["뽹", "ppwaeG"], ["뽿", "ppwaeD"], ["뾉", "ppwaeB"], ["뽸", "ppwae"], ["뽣", "ppwaD"], ["뽭", "ppwaB"], ["뽜", "ppwa"],
    ["뿥", "pput"], ["뿠", "ppuss"], ["뿟", "ppus"], ["뿦", "ppup"], ["뿡", "ppung"], ["뿐", "ppun"], ["뿜", "ppum"], ["뿔", "ppuL"],
    ["뿎", "ppukk"], ["뿤", "ppuk"], ["뿢", "ppuj"], ["뿧", "ppuh"], ["뿍", "ppuG"], ["뿓", "ppuD"], ["뿝", "ppuB"], ["뿌", "ppu"],
    ["뽙", "ppot"], ["뽔", "pposs"], ["뽓", "ppos"], ["뽚", "ppop"], ["뽕", "ppong"], ["뽄", "ppon"], ["뽐", "ppom"], ["뽈", "ppoL"],
    ["뽂", "ppokk"], ["뽘", "ppok"], ["뽖", "ppoj"], ["뽛", "ppoh"], ["뽁", "ppoG"], ["뾭", "ppoet"], ["뾨", "ppoess"], ["뾧", "ppoes"],
    ["뾮", "ppoep"], ["뾩", "ppoeng"], ["뾘", "ppoen"], ["뾤", "ppoem"], ["뾜", "ppoeL"], ["뾖", "ppoekk"], ["뾬", "ppoek"], ["뾪", "ppoej"],
    ["뾯", "ppoeh"], ["뾕", "ppoeG"], ["뾛", "ppoeD"], ["뾥", "ppoeB"], ["뾔", "ppoe"], ["뽇", "ppoD"], ["뽑", "ppoB"], ["뽀", "ppo"],
    ["삩", "ppit"], ["삤", "ppiss"], ["삣", "ppis"], ["삪", "ppip"], ["삥", "pping"], ["삔", "ppin"], ["삠", "ppim"], ["삘", "ppiL"],
    ["삒", "ppikk"], ["삨", "ppik"], ["삦", "ppij"], ["삫", "ppih"], ["삑", "ppiG"], ["삗", "ppiD"], ["삡", "ppiB"], ["삐", "ppi"],
    ["쁱", "ppeut"], ["쁬", "ppeuss"], ["쁫", "ppeus"], ["쁲", "ppeup"], ["쁭", "ppeung"], ["쁜", "ppeun"], ["쁨", "ppeum"], ["쁠", "ppeuL"],
    ["쁚", "ppeukk"], ["쁰", "ppeuk"], ["쁮", "ppeuj"], ["쁳", "ppeuh"], ["쁙", "ppeuG"], ["쁟", "ppeuD"], ["쁩", "ppeuB"], ["쁘", "ppeu"],
    ["뼅", "ppet"], ["뼀", "ppess"], ["뻿", "ppes"], ["뼆", "ppep"], ["뻩", "ppeot"], ["뻤", "ppeoss"], ["뻣", "ppeos"], ["뻪", "ppeop"],
    ["뻥", "ppeong"], ["뻔", "ppeon"], ["뻠", "ppeom"], ["뻘", "ppeoL"], ["뻒", "ppeokk"], ["뻨", "ppeok"], ["뻦", "ppeoj"], ["뻫", "ppeoh"],
    ["뻑", "ppeoG"], ["뻗", "ppeoD"], ["뻡", "ppeoB"], ["뻐", "ppeo"], ["뼁", "ppeng"], ["뻰", "ppen"], ["뻼", "ppem"], ["뻴", "ppeL"],
    ["뻮", "ppekk"], ["뼄", "ppek"], ["뼂", "ppej"], ["뼇", "ppeh"], ["뻭", "ppeG"], ["뻳", "ppeD"], ["뻽", "ppeB"], ["뻬", "ppe"],
    ["빹", "ppat"], ["빴", "ppass"], ["빳", "ppas"], ["빺", "ppap"], ["빵", "ppang"], ["빤", "ppan"], ["빰", "ppam"], ["빨", "ppaL"],
    ["빢", "ppakk"], ["빸", "ppak"], ["빶", "ppaj"], ["빻", "ppah"], ["빡", "ppaG"], ["뺕", "ppaet"], ["뺐", "ppaess"], ["뺏", "ppaes"],
    ["뺖", "ppaep"], ["뺑", "ppaeng"], ["뺀", "ppaen"], ["뺌", "ppaem"], ["뺄", "ppaeL"], ["빾", "ppaekk"], ["뺔", "ppaek"], ["뺒", "ppaej"],
    ["뺗", "ppaeh"], ["빽", "ppaeG"], ["뺃", "ppaeD"], ["뺍", "ppaeB"], ["빼", "ppae"], ["빧", "ppaD"], ["빱", "ppaB"], ["빠", "ppa"],
    ["뮽", "myut"], ["뮸", "myuss"], ["뮷", "myus"], ["뮾", "myup"], ["뮹", "myung"], ["뮨", "myun"], ["뮴", "myum"], ["뮬", "myuL"],
    ["뮦", "myukk"], ["뮼", "myuk"], ["뮺", "myuj"], ["뮿", "myuh"], ["뮥", "myuG"], ["뮫", "myuD"], ["뮵", "myuB"], ["뮤", "myu"],
    ["묱", "myot"], ["묬", "myoss"], ["묫", "myos"], ["묲", "myop"], ["묭", "myong"], ["묜", "myon"], ["묨", "myom"], ["묠", "myoL"],
    ["묚", "myokk"], ["묰", "myok"], ["묮", "myoj"], ["묳", "myoh"], ["묙", "myoG"], ["묟", "myoD"], ["묩", "myoB"], ["묘", "myo"],
    ["믵", "muit"], ["믰", "muiss"], ["믯", "muis"], ["믶", "muip"], ["믱", "muing"], ["믠", "muin"], ["믬", "muim"], ["믤", "muiL"],
    ["믞", "muikk"], ["믴", "muik"], ["믲", "muij"], ["믷", "muih"], ["믝", "muiG"], ["믣", "muiD"], ["믭", "muiB"], ["믜", "mui"],
    ["몥", "myet"], ["몠", "myess"], ["몟", "myes"], ["몦", "myep"], ["몉", "myeot"], ["몄", "myeoss"], ["몃", "myeos"], ["몊", "myeop"],
    ["명", "myeong"], ["면", "myeon"], ["몀", "myeom"], ["멸", "myeoL"], ["멲", "myeokk"], ["몈", "myeok"], ["몆", "myeoj"], ["몋", "myeoh"],
    ["멱", "myeoG"], ["멷", "myeoD"], ["몁", "myeoB"], ["며", "myeo"], ["몡", "myeng"], ["몐", "myen"], ["몜", "myem"], ["몔", "myeL"],
    ["몎", "myekk"], ["몤", "myek"], ["몢", "myej"], ["몧", "myeh"], ["몍", "myeG"], ["몓", "myeD"], ["몝", "myeB"], ["몌", "mye"],
    ["먙", "myat"], ["먔", "myass"], ["먓", "myas"], ["먚", "myap"], ["먕", "myang"], ["먄", "myan"], ["먐", "myam"], ["먈", "myaL"],
    ["먂", "myakk"], ["먘", "myak"], ["먖", "myaj"], ["먛", "myah"], ["먁", "myaG"], ["먵", "myaet"], ["먰", "myaess"], ["먯", "myaes"],
    ["먶", "myaep"], ["먱", "myaeng"], ["먠", "myaen"], ["먬", "myaem"], ["먤", "myaeL"], ["먞", "myaekk"], ["먴", "myaek"], ["먲", "myaej"],
    ["먷", "myaeh"], ["먝", "myaeG"], ["먣", "myaeD"], ["먭", "myaeB"], ["먜", "myae"], ["먇", "myaD"], ["먑", "myaB"], ["먀", "mya"],
    ["뮡", "mwit"], ["뮜", "mwiss"], ["뮛", "mwis"], ["뮢", "mwip"], ["뮝", "mwing"], ["뮌", "mwin"], ["뮘", "mwim"], ["뮐", "mwiL"],
    ["뮊", "mwikk"], ["뮠", "mwik"], ["뮞", "mwij"], ["뮣", "mwih"], ["뮉", "mwiG"], ["뮏", "mwiD"], ["뮙", "mwiB"], ["뮈", "mwi"],
    ["뮅", "mwet"], ["뮀", "mwess"], ["뭿", "mwes"], ["뮆", "mwep"], ["뭩", "mwot"], ["뭤", "mwoss"], ["뭣", "mwos"], ["뭪", "mwop"],
    ["뭥", "mwong"], ["뭔", "mwon"], ["뭠", "mwom"], ["뭘", "mwoL"], ["뭒", "mwokk"], ["뭨", "mwok"], ["뭦", "mwoj"], ["뭫", "mwoh"],
    ["뭑", "mwoG"], ["뭗", "mwoD"], ["뭡", "mwoB"], ["뭐", "mwo"], ["뮁", "mweng"], ["뭰", "mwen"], ["뭼", "mwem"], ["뭴", "mweL"],
    ["뭮", "mwekk"], ["뮄", "mwek"], ["뮂", "mwej"], ["뮇", "mweh"], ["뭭", "mweG"], ["뭳", "mweD"], ["뭽", "mweB"], ["뭬", "mwe"],
    ["뫝", "mwat"], ["뫘", "mwass"], ["뫗", "mwas"], ["뫞", "mwap"], ["뫙", "mwang"], ["뫈", "mwan"], ["뫔", "mwam"], ["뫌", "mwaL"],
    ["뫆", "mwakk"], ["뫜", "mwak"], ["뫚", "mwaj"], ["뫟", "mwah"], ["뫅", "mwaG"], ["뫹", "mwaet"], ["뫴", "mwaess"], ["뫳", "mwaes"],
    ["뫺", "mwaep"], ["뫵", "mwaeng"], ["뫤", "mwaen"], ["뫰", "mwaem"], ["뫨", "mwaeL"], ["뫢", "mwaekk"], ["뫸", "mwaek"], ["뫶", "mwaej"],
    ["뫻", "mwaeh"], ["뫡", "mwaeG"], ["뫧", "mwaeD"], ["뫱", "mwaeB"], ["뫠", "mwae"], ["뫋", "mwaD"], ["뫕", "mwaB"], ["뫄", "mwa"],
    ["뭍", "mut"], ["뭈", "muss"], ["뭇", "mus"], ["뭎", "mup"], ["뭉", "mung"], ["문", "mun"], ["뭄", "mum"], ["물", "muL"],
    ["묶", "mukk"], ["뭌", "muk"], ["뭊", "muj"], ["뭏", "muh"], ["묵", "muG"], ["묻", "muD"], ["뭅", "muB"], ["무", "mu"],
    ["뫁", "mot"], ["몼", "moss"], ["못", "mos"], ["뫂", "mop"], ["몽", "mong"], ["몬", "mon"], ["몸", "mom"], ["몰", "moL"],
    ["몪", "mokk"], ["뫀", "mok"], ["몾", "moj"], ["뫃", "moh"], ["목", "moG"], ["묕", "moet"], ["묐", "moess"], ["묏", "moes"],
    ["묖", "moep"], ["묑", "moeng"], ["묀", "moen"], ["묌", "moem"], ["묄", "moeL"], ["뫾", "moekk"], ["묔", "moek"], ["묒", "moej"],
    ["묗", "moeh"], ["뫽", "moeG"], ["묃", "moeD"], ["묍", "moeB"], ["뫼", "moe"], ["몯", "moD"], ["몹", "moB"], ["모", "mo"],
    ["밑", "mit"], ["밌", "miss"], ["밋", "mis"], ["밒", "mip"], ["밍", "ming"], ["민", "min"], ["밈", "mim"], ["밀", "miL"],
    ["믺", "mikk"], ["밐", "mik"], ["밎", "mij"], ["밓", "mih"], ["믹", "miG"], ["믿", "miD"], ["밉", "miB"], ["미", "mi"],
    ["믙", "meut"], ["믔", "meuss"], ["믓", "meus"], ["믚", "meup"], ["믕", "meung"], ["믄", "meun"], ["믐", "meum"], ["믈", "meuL"],
    ["믂", "meukk"], ["믘", "meuk"], ["믖", "meuj"], ["믛", "meuh"], ["믁", "meuG"], ["믇", "meuD"], ["믑", "meuB"], ["므", "meu"],
    ["멭", "met"], ["멨", "mess"], ["멧", "mes"], ["멮", "mep"], ["멑", "meot"], ["멌", "meoss"], ["멋", "meos"], ["멒", "meop"],
    ["멍", "meong"], ["먼", "meon"], ["멈", "meom"], ["멀", "meoL"], ["먺", "meokk"], ["멐", "meok"], ["멎", "meoj"], ["멓", "meoh"],
    ["먹", "meoG"], ["먿", "meoD"], ["멉", "meoB"], ["머", "meo"], ["멩", "meng"], ["멘", "men"], ["멤", "mem"], ["멜", "meL"],
    ["멖", "mekk"], ["멬", "mek"], ["멪", "mej"], ["멯", "meh"], ["멕", "meG"], ["멛", "meD"], ["멥", "meB"], ["메", "me"],
    ["맡", "mat"], ["맜", "mass"], ["맛", "mas"], ["맢", "map"], ["망", "mang"], ["만", "man"], ["맘", "mam"], ["말", "maL"],
    ["맊", "makk"], ["맠", "mak"], ["맞", "maj"], ["맣", "mah"], ["막", "maG"], ["맽", "maet"], ["맸", "maess"], ["맷", "maes"],
    ["맾", "maep"], ["맹", "maeng"], ["맨", "maen"], ["맴", "maem"], ["맬", "maeL"], ["맦", "maekk"], ["맼", "maek"], ["맺", "maej"],
    ["맿", "maeh"], ["맥", "maeG"], ["맫", "maeD"], ["맵", "maeB"], ["매", "mae"], ["맏", "maD"], ["맙", "maB"], ["마", "ma"],
    ["븉", "byut"], ["븄", "byuss"], ["븃", "byus"], ["븊", "byup"], ["븅", "byung"], ["뷴", "byun"], ["븀", "byum"], ["뷸", "byuL"],
    ["뷲", "byukk"], ["븈", "byuk"], ["븆", "byuj"], ["븋", "byuh"], ["뷱", "byuG"], ["뷷", "byuD"], ["븁", "byuB"], ["뷰", "byu"],
    ["뵽", "byot"], ["뵸", "byoss"], ["뵷", "byos"], ["뵾", "byop"], ["뵹", "byong"], ["뵨", "byon"], ["뵴", "byom"], ["뵬", "byoL"],
    ["뵦", "byokk"], ["뵼", "byok"], ["뵺", "byoj"], ["뵿", "byoh"], ["뵥", "byoG"], ["뵫", "byoD"], ["뵵", "byoB"], ["뵤", "byo"],
    ["빁", "buit"], ["븼", "buiss"], ["븻", "buis"], ["빂", "buip"], ["븽", "buing"], ["븬", "buin"], ["븸", "buim"], ["븰", "buiL"],
    ["븪", "buikk"], ["빀", "buik"], ["븾", "buij"], ["빃", "buih"], ["븩", "buiG"], ["븯", "buiD"], ["븹", "buiB"], ["븨", "bui"],
    ["볱", "byet"], ["볬", "byess"], ["볫", "byes"], ["볲", "byep"], ["볕", "byeot"], ["볐", "byeoss"], ["볏", "byeos"], ["볖", "byeop"],
    ["병", "byeong"], ["변", "byeon"], ["볌", "byeom"], ["별", "byeoL"], ["벾", "byeokk"], ["볔", "byeok"], ["볒", "byeoj"], ["볗", "byeoh"],
    ["벽", "byeoG"], ["볃", "byeoD"], ["볍", "byeoB"], ["벼", "byeo"], ["볭", "byeng"], ["볜", "byen"], ["볨", "byem"], ["볠", "byeL"],
    ["볚", "byekk"], ["볰", "byek"], ["볮", "byej"], ["볳", "byeh"], ["볙", "byeG"], ["볟", "byeD"], ["볩", "byeB"], ["볘", "bye"],
    ["뱥", "byat"], ["뱠", "byass"], ["뱟", "byas"], ["뱦", "byap"], ["뱡", "byang"], ["뱐", "byan"], ["뱜", "byam"], ["뱔", "byaL"],
    ["뱎", "byakk"], ["뱤", "byak"], ["뱢", "byaj"], ["뱧", "byah"], ["뱍", "byaG"], ["벁", "byaet"], ["뱼", "byaess"], ["뱻", "byaes"],
    ["벂", "byaep"], ["뱽", "byaeng"], ["뱬", "byaen"], ["뱸", "byaem"], ["뱰", "byaeL"], ["뱪", "byaekk"], ["벀", "byaek"], ["뱾", "byaej"],
    ["벃", "byaeh"], ["뱩", "byaeG"], ["뱯", "byaeD"], ["뱹", "byaeB"], ["뱨", "byae"], ["뱓", "byaD"], ["뱝", "byaB"], ["뱌", "bya"],
    ["뷭", "bwit"], ["뷨", "bwiss"], ["뷧", "bwis"], ["뷮", "bwip"], ["뷩", "bwing"], ["뷘", "bwin"], ["뷤", "bwim"], ["뷜", "bwiL"],
    ["뷖", "bwikk"], ["뷬", "bwik"], ["뷪", "bwij"], ["뷯", "bwih"], ["뷕", "bwiG"], ["뷛", "bwiD"], ["뷥", "bwiB"], ["뷔", "bwi"],
    ["뷑", "bwet"], ["뷌", "bwess"], ["뷋", "bwes"], ["뷒", "bwep"], ["붵", "bwot"], ["붰", "bwoss"], ["붯", "bwos"], ["붶", "bwop"],
    ["붱", "bwong"], ["붠", "bwon"], ["붬", "bwom"], ["붤", "bwoL"], ["붞", "bwokk"], ["붴", "bwok"], ["붲", "bwoj"], ["붷", "bwoh"],
    ["붝", "bwoG"], ["붣", "bwoD"], ["붭", "bwoB"], ["붜", "bwo"], ["뷍", "bweng"], ["붼", "bwen"], ["뷈", "bwem"], ["뷀", "bweL"],
    ["붺", "bwekk"], ["뷐", "bwek"], ["뷎", "bwej"], ["뷓", "bweh"], ["붹", "bweG"], ["붿", "bweD"], ["뷉", "bweB"], ["붸", "bwe"],
    ["봩", "bwat"], ["봤", "bwass"], ["봣", "bwas"], ["봪", "bwap"], ["봥", "bwang"], ["봔", "bwan"], ["봠", "bwam"], ["봘", "bwaL"],
    ["봒", "bwakk"], ["봨", "bwak"], ["봦", "bwaj"], ["봫", "bwah"], ["봑", "bwaG"], ["뵅", "bwaet"], ["뵀", "bwaess"], ["봿", "bwaes"],
    ["뵆", "bwaep"], ["뵁", "bwaeng"], ["봰", "bwaen"], ["봼", "bwaem"], ["봴", "bwaeL"], ["봮", "bwaekk"], ["뵄", "bwaek"], ["뵂", "bwaej"],
    ["뵇", "bwaeh"], ["봭", "bwaeG"], ["봳", "bwaeD"], ["봽", "bwaeB"], ["봬", "bwae"], ["봗", "bwaD"], ["봡", "bwaB"], ["봐", "bwa"],
    ["붙", "but"], ["붔", "buss"], ["붓", "bus"], ["붚", "bup"], ["붕", "bung"], ["분", "bun"], ["붐", "bum"], ["불", "buL"],
    ["붂", "bukk"], ["붘", "buk"], ["붖", "buj"], ["붛", "buh"], ["북", "buG"], ["붇", "buD"], ["붑", "buB"], ["부", "bu"],
    ["봍", "bot"], ["봈", "boss"], ["봇", "bos"], ["봎", "bop"], ["봉", "bong"], ["본", "bon"], ["봄", "bom"], ["볼", "boL"],
    ["볶", "bokk"], ["봌", "bok"], ["봊", "boj"], ["봏", "boh"], ["복", "boG"], ["뵡", "boet"], ["뵜", "boess"], ["뵛", "boes"],
    ["뵢", "boep"], ["뵝", "boeng"], ["뵌", "boen"], ["뵘", "boem"], ["뵐", "boeL"], ["뵊", "boekk"], ["뵠", "boek"], ["뵞", "boej"],
    ["뵣", "boeh"], ["뵉", "boeG"], ["뵏", "boeD"], ["뵙", "boeB"], ["뵈", "boe"], ["볻", "boD"], ["봅", "boB"], ["보", "bo"],
    ["빝", "bit"], ["빘", "biss"], ["빗", "bis"], ["빞", "bip"], ["빙", "bing"], ["빈", "bin"], ["빔", "bim"], ["빌", "biL"],
    ["빆", "bikk"], ["빜", "bik"], ["빚", "bij"], ["빟", "bih"], ["빅", "biG"], ["빋", "biD"], ["빕", "biB"], ["비", "bi"],
    ["븥", "beut"], ["븠", "beuss"], ["븟", "beus"], ["븦", "beup"], ["븡", "beung"], ["븐", "beun"], ["븜", "beum"], ["블", "beuL"],
    ["븎", "beukk"], ["븤", "beuk"], ["븢", "beuj"], ["븧", "beuh"], ["븍", "beuG"], ["븓", "beuD"], ["븝", "beuB"], ["브", "beu"],
    ["벹", "bet"], ["벴", "bess"], ["벳", "bes"], ["벺", "bep"], ["벝", "beot"], ["벘", "beoss"], ["벗", "beos"], ["벞", "beop"],
    ["벙", "beong"], ["번", "beon"], ["범", "beom"], ["벌", "beoL"], ["벆", "beokk"], ["벜", "beok"], ["벚", "beoj"], ["벟", "beoh"],
    ["벅", "beoG"], ["벋", "beoD"], ["법", "beoB"], ["버", "beo"], ["벵", "beng"], ["벤", "ben"], ["벰", "bem"], ["벨", "beL"],
    ["벢", "bekk"], ["벸", "bek"], ["벶", "bej"], ["벻", "beh"], ["벡", "beG"], ["벧", "beD"], ["벱", "beB"], ["베", "be"],
    ["밭", "bat"], ["밨", "bass"], ["밧", "bas"], ["밮", "bap"], ["방", "bang"], ["반", "ban"], ["밤", "bam"], ["발", "baL"],
    ["밖", "bakk"], ["밬", "bak"], ["밪", "baj"], ["밯", "bah"], ["박", "baG"], ["뱉", "baet"], ["뱄", "baess"], ["뱃", "baes"],
    ["뱊", "baep"], ["뱅", "baeng"], ["밴", "baen"], ["뱀", "baem"], ["밸", "baeL"], ["밲", "baekk"], ["뱈", "baek"], ["뱆", "baej"],
    ["뱋", "baeh"], ["백", "baeG"], ["밷", "baeD"], ["뱁", "baeB"], ["배", "bae"], ["받", "baD"], ["밥", "baB"], ["바", "ba"],
    ["윹", "yut"], ["윴", "yuss"], ["윳", "yus"], ["윺", "yup"], ["융", "yung"], ["윤", "yun"], ["윰", "yum"], ["율", "yuL"],
    ["윢", "yukk"], ["윸", "yuk"], ["윶", "yuj"], ["윻", "yuh"], ["육", "yuG"], ["윧", "yuD"], ["윱", "yuB"], ["유", "yu"],
    ["욭", "yot"], ["욨", "yoss"], ["욧", "yos"], ["욮", "yop"], ["용", "yong"], ["욘", "yon"], ["욤", "yom"], ["욜", "yoL"],
    ["욖", "yokk"], ["욬", "yok"], ["욪", "yoj"], ["욯", "yoh"], ["욕", "yoG"], ["욛", "yoD"], ["욥", "yoB"], ["요", "yo"],
    ["읱", "uit"], ["읬", "uiss"], ["읫", "uis"], ["읲", "uip"], ["읭", "uing"], ["읜", "uin"], ["읨", "uim"], ["읠", "uiL"],
    ["읚", "uikk"], ["읰", "uik"], ["읮", "uij"], ["읳", "uih"], ["읙", "uiG"], ["읟", "uiD"], ["읩", "uiB"], ["의", "ui"],
    ["옡", "yet"], ["옜", "yess"], ["옛", "yes"], ["옢", "yep"], ["옅", "yeot"], ["였", "yeoss"], ["엿", "yeos"], ["옆", "yeop"],
    ["영", "yeong"], ["연", "yeon"], ["염", "yeom"], ["열", "yeoL"], ["엮", "yeokk"], ["옄", "yeok"], ["옂", "yeoj"], ["옇", "yeoh"],
    ["역", "yeoG"], ["엳", "yeoD"], ["엽", "yeoB"], ["여", "yeo"], ["옝", "yeng"], ["옌", "yen"], ["옘", "yem"], ["옐", "yeL"],
    ["옊", "yekk"], ["옠", "yek"], ["옞", "yej"], ["옣", "yeh"], ["옉", "yeG"], ["옏", "yeD"], ["옙", "yeB"], ["예", "ye"],
    ["얕", "yat"], ["얐", "yass"], ["얏", "yas"], ["얖", "yap"], ["양", "yang"], ["얀", "yan"], ["얌", "yam"], ["얄", "yaL"],
    ["앾", "yakk"], ["얔", "yak"], ["얒", "yaj"], ["얗", "yah"], ["약", "yaG"], ["얱", "yaet"], ["얬", "yaess"], ["얫", "yaes"],
    ["얲", "yaep"], ["얭", "yaeng"], ["얜", "yaen"], ["얨", "yaem"], ["얠", "yaeL"], ["얚", "yaekk"], ["얰", "yaek"], ["얮", "yaej"],
    ["얳", "yaeh"], ["얙", "yaeG"], ["얟", "yaeD"], ["얩", "yaeB"], ["얘", "yae"], ["얃", "yaD"], ["얍", "yaB"], ["야", "ya"],
    ["윝", "wit"], ["윘", "wiss"], ["윗", "wis"], ["윞", "wip"], ["윙", "wing"], ["윈", "win"], ["윔", "wim"], ["윌", "wiL"],
    ["윆", "wikk"], ["윜", "wik"], ["윚", "wij"], ["윟", "wih"], ["윅", "wiG"], ["윋", "wiD"], ["윕", "wiB"], ["위", "wi"],
    ["윁", "wet"], ["웼", "wess"], ["웻", "wes"], ["윂", "wep"], ["웥", "wot"], ["웠", "woss"], ["웟", "wos"], ["웦", "wop"],
    ["웡", "wong"], ["원", "won"], ["웜", "wom"], ["월", "woL"], ["웎", "wokk"], ["웤", "wok"], ["웢", "woj"], ["웧", "woh"],
    ["웍", "woG"], ["웓", "woD"], ["웝", "woB"], ["워", "wo"], ["웽", "weng"], ["웬", "wen"], ["웸", "wem"], ["웰", "weL"],
    ["웪", "wekk"], ["윀", "wek"], ["웾", "wej"], ["윃", "weh"], ["웩", "weG"], ["웯", "weD"], ["웹", "weB"], ["웨", "we"],
    ["왙", "wat"], ["왔", "wass"], ["왓", "was"], ["왚", "wap"], ["왕", "wang"], ["완", "wan"], ["왐", "wam"], ["왈", "waL"],
    ["왂", "wakk"], ["왘", "wak"], ["왖", "waj"], ["왛", "wah"], ["왁", "waG"], ["왵", "waet"], ["왰", "waess"], ["왯", "waes"],
    ["왶", "waep"], ["왱", "waeng"], ["왠", "waen"], ["왬", "waem"], ["왤", "waeL"], ["왞", "waekk"], ["왴", "waek"], ["왲", "waej"],
    ["왷", "waeh"], ["왝", "waeG"], ["왣", "waeD"], ["왭", "waeB"], ["왜", "wae"], ["왇", "waD"], ["왑", "waB"], ["와", "wa"],
    ["웉", "ut"], ["웄", "uss"], ["웃", "us"], ["웊", "up"], ["웅", "ung"], ["운", "un"], ["움", "um"], ["울", "uL"],
    ["욲", "ukk"], ["웈", "uk"], ["웆", "uj"], ["웋", "uh"], ["욱", "uG"], ["욷", "uD"], ["웁", "uB"], ["우", "u"],
    ["슡", "syut"], ["슜", "syuss"], ["슛", "syus"], ["슢", "syup"], ["슝", "syung"], ["슌", "syun"], ["슘", "syum"], ["슐", "syuL"],
    ["슊", "syukk"], ["슠", "syuk"], ["슞", "syuj"], ["슣", "syuh"], ["슉", "syuG"], ["슏", "syuD"], ["슙", "syuB"], ["슈", "syu"],
    ["숕", "syot"], ["숐", "syoss"], ["숏", "syos"], ["숖", "syop"], ["숑", "syong"], ["숀", "syon"], ["숌", "syom"], ["숄", "syoL"],
    ["쇾", "syokk"], ["숔", "syok"], ["숒", "syoj"], ["숗", "syoh"], ["쇽", "syoG"], ["숃", "syoD"], ["숍", "syoB"], ["쇼", "syo"],
    ["싙", "suit"], ["싔", "suiss"], ["싓", "suis"], ["싚", "suip"], ["싕", "suing"], ["싄", "suin"], ["싐", "suim"], ["싈", "suiL"],
    ["싂", "suikk"], ["싘", "suik"], ["싖", "suij"], ["싛", "suih"], ["싁", "suiG"], ["싇", "suiD"], ["싑", "suiB"], ["싀", "sui"],
    ["솉", "syet"], ["솄", "syess"], ["솃", "syes"], ["솊", "syep"], ["셭", "syeot"], ["셨", "syeoss"], ["셧", "syeos"], ["셮", "syeop"],
    ["셩", "syeong"], ["션", "syeon"], ["셤", "syeom"], ["셜", "syeoL"], ["셖", "syeokk"], ["셬", "syeok"], ["셪", "syeoj"], ["셯", "syeoh"],
    ["셕", "syeoG"], ["셛", "syeoD"], ["셥", "syeoB"], ["셔", "syeo"], ["솅", "syeng"], ["셴", "syen"], ["솀", "syem"], ["셸", "syeL"],
    ["셲", "syekk"], ["솈", "syek"], ["솆", "syej"], ["솋", "syeh"], ["셱", "syeG"], ["셷", "syeD"], ["솁", "syeB"], ["셰", "sye"],
    ["샽", "syat"], ["샸", "syass"], ["샷", "syas"], ["샾", "syap"], ["샹", "syang"], ["샨", "syan"], ["샴", "syam"], ["샬", "syaL"],
    ["샦", "syakk"], ["샼", "syak"], ["샺", "syaj"], ["샿", "syah"], ["샥", "syaG"], ["섙", "syaet"], ["섔", "syaess"], ["섓", "syaes"],
    ["섚", "syaep"], ["섕", "syaeng"], ["섄", "syaen"], ["섐", "syaem"], ["섈", "syaeL"], ["섂", "syaekk"], ["섘", "syaek"], ["섖", "syaej"],
    ["섛", "syaeh"], ["섁", "syaeG"], ["섇", "syaeD"], ["섑", "syaeB"], ["섀", "syae"], ["샫", "syaD"], ["샵", "syaB"], ["샤", "sya"],
    ["슅", "swit"], ["슀", "swiss"], ["쉿", "swis"], ["슆", "swip"], ["슁", "swing"], ["쉰", "swin"], ["쉼", "swim"], ["쉴", "swiL"],
    ["쉮", "swikk"], ["슄", "swik"], ["슂", "swij"], ["슇", "swih"], ["쉭", "swiG"], ["쉳", "swiD"], ["쉽", "swiB"], ["쉬", "swi"],
    ["쉩", "swet"], ["쉤", "swess"], ["쉣", "swes"], ["쉪", "swep"], ["쉍", "swot"], ["쉈", "swoss"], ["쉇", "swos"], ["쉎", "swop"],
    ["쉉", "swong"], ["숸", "swon"], ["쉄", "swom"], ["숼", "swoL"], ["숶", "swokk"], ["쉌", "swok"], ["쉊", "swoj"], ["쉏", "swoh"],
    ["숵", "swoG"], ["숻", "swoD"], ["쉅", "swoB"], ["숴", "swo"], ["쉥", "sweng"], ["쉔", "swen"], ["쉠", "swem"], ["쉘", "sweL"],
    ["쉒", "swekk"], ["쉨", "swek"], ["쉦", "swej"], ["쉫", "sweh"], ["쉑", "sweG"], ["쉗", "sweD"], ["쉡", "sweB"], ["쉐", "swe"],
    ["쇁", "swat"], ["솼", "swass"], ["솻", "swas"], ["쇂", "swap"], ["솽", "swang"], ["솬", "swan"], ["솸", "swam"], ["솰", "swaL"],
    ["솪", "swakk"], ["쇀", "swak"], ["솾", "swaj"], ["쇃", "swah"], ["솩", "swaG"], ["쇝", "swaet"], ["쇘", "swaess"], ["쇗", "swaes"],
    ["쇞", "swaep"], ["쇙", "swaeng"], ["쇈", "swaen"], ["쇔", "swaem"], ["쇌", "swaeL"], ["쇆", "swaekk"], ["쇜", "swaek"], ["쇚", "swaej"],
    ["쇟", "swaeh"], ["쇅", "swaeG"], ["쇋", "swaeD"], ["쇕", "swaeB"], ["쇄", "swae"], ["솯", "swaD"], ["솹", "swaB"], ["솨", "swa"],
    ["숱", "sut"], ["숬", "suss"], ["숫", "sus"], ["숲", "sup"], ["숭", "sung"], ["순", "sun"], ["숨", "sum"], ["술", "suL"],
    ["숚", "sukk"], ["숰", "suk"], ["숮", "suj"], ["숳", "suh"], ["숙", "suG"], ["숟", "suD"], ["숩", "suB"], ["수", "su"],
    ["쓭", "ssyut"], ["쓨", "ssyuss"], ["쓧", "ssyus"], ["쓮", "ssyup"], ["쓩", "ssyung"], ["쓘", "ssyun"], ["쓤", "ssyum"], ["쓜", "ssyuL"],
    ["쓖", "ssyukk"], ["쓬", "ssyuk"], ["쓪", "ssyuj"], ["쓯", "ssyuh"], ["쓕", "ssyuG"], ["쓛", "ssyuD"], ["쓥", "ssyuB"], ["쓔", "ssyu"],
    ["쑡", "ssyot"], ["쑜", "ssyoss"], ["쑛", "ssyos"], ["쑢", "ssyop"], ["쑝", "ssyong"], ["쑌", "ssyon"], ["쑘", "ssyom"], ["쑐", "ssyoL"],
    ["쑊", "ssyokk"], ["쑠", "ssyok"], ["쑞", "ssyoj"], ["쑣", "ssyoh"], ["쑉", "ssyoG"], ["쑏", "ssyoD"], ["쑙", "ssyoB"], ["쑈", "ssyo"],
    ["씥", "ssuit"], ["씠", "ssuiss"], ["씟", "ssuis"], ["씦", "ssuip"], ["씡", "ssuing"], ["씐", "ssuin"], ["씜", "ssuim"], ["씔", "ssuiL"],
    ["씎", "ssuikk"], ["씤", "ssuik"], ["씢", "ssuij"], ["씧", "ssuih"], ["씍", "ssuiG"], ["씓", "ssuiD"], ["씝", "ssuiB"], ["씌", "ssui"],
    ["쏕", "ssyet"], ["쏐", "ssyess"], ["쏏", "ssyes"], ["쏖", "ssyep"], ["쎹", "ssyeot"], ["쎴", "ssyeoss"], ["쎳", "ssyeos"], ["쎺", "ssyeop"],
    ["쎵", "ssyeong"], ["쎤", "ssyeon"], ["쎰", "ssyeom"], ["쎨", "ssyeoL"], ["쎢", "ssyeokk"], ["쎸", "ssyeok"], ["쎶", "ssyeoj"], ["쎻", "ssyeoh"],
    ["쎡", "ssyeoG"], ["쎧", "ssyeoD"], ["쎱", "ssyeoB"], ["쎠", "ssyeo"], ["쏑", "ssyeng"], ["쏀", "ssyen"], ["쏌", "ssyem"], ["쏄", "ssyeL"],
    ["쎾", "ssyekk"], ["쏔", "ssyek"], ["쏒", "ssyej"], ["쏗", "ssyeh"], ["쎽", "ssyeG"], ["쏃", "ssyeD"], ["쏍", "ssyeB"], ["쎼", "ssye"],
    ["썉", "ssyat"], ["썄", "ssyass"], ["썃", "ssyas"], ["썊", "ssyap"], ["썅", "ssyang"], ["쌴", "ssyan"], ["썀", "ssyam"], ["쌸", "ssyaL"],
    ["쌲", "ssyakk"], ["썈", "ssyak"], ["썆", "ssyaj"], ["썋", "ssyah"], ["쌱", "ssyaG"], ["썥", "ssyaet"], ["썠", "ssyaess"], ["썟", "ssyaes"],
    ["썦", "ssyaep"], ["썡", "ssyaeng"], ["썐", "ssyaen"], ["썜", "ssyaem"], ["썔", "ssyaeL"], ["썎", "ssyaekk"], ["썤", "ssyaek"], ["썢", "ssyaej"],
    ["썧", "ssyaeh"], ["썍", "ssyaeG"], ["썓", "ssyaeD"], ["썝", "ssyaeB"], ["썌", "ssyae"], ["쌷", "ssyaD"], ["썁", "ssyaB"], ["쌰", "ssya"],
    ["쓑", "sswit"], ["쓌", "sswiss"], ["쓋", "sswis"], ["쓒", "sswip"], ["쓍", "sswing"], ["쒼", "sswin"], ["쓈", "sswim"], ["쓀", "sswiL"],
    ["쒺", "sswikk"], ["쓐", "sswik"], ["쓎", "sswij"], ["쓓", "sswih"], ["쒹", "sswiG"], ["쒿", "sswiD"], ["쓉", "sswiB"], ["쒸", "sswi"],
    ["쒵", "sswet"], ["쒰", "sswess"], ["쒯", "sswes"], ["쒶", "sswep"], ["쒙", "sswot"], ["쒔", "sswoss"], ["쒓", "sswos"], ["쒚", "sswop"],
    ["쒕", "sswong"], ["쒄", "sswon"], ["쒐", "sswom"], ["쒈", "sswoL"], ["쒂", "sswokk"], ["쒘", "sswok"], ["쒖", "sswoj"], ["쒛", "sswoh"],
    ["쒁", "sswoG"], ["쒇", "sswoD"], ["쒑", "sswoB"], ["쒀", "sswo"], ["쒱", "ssweng"], ["쒠", "sswen"], ["쒬", "sswem"], ["쒤", "ssweL"],
    ["쒞", "sswekk"], ["쒴", "sswek"], ["쒲", "sswej"], ["쒷", "ssweh"], ["쒝", "ssweG"], ["쒣", "ssweD"], ["쒭", "ssweB"], ["쒜", "sswe"],
    ["쐍", "sswat"], ["쐈", "sswass"], ["쐇", "sswas"], ["쐎", "sswap"], ["쐉", "sswang"], ["쏸", "sswan"], ["쐄", "sswam"], ["쏼", "sswaL"],
    ["쏶", "sswakk"], ["쐌", "sswak"], ["쐊", "sswaj"], ["쐏", "sswah"], ["쏵", "sswaG"], ["쐩", "sswaet"], ["쐤", "sswaess"], ["쐣", "sswaes"],
    ["쐪", "sswaep"], ["쐥", "sswaeng"], ["쐔", "sswaen"], ["쐠", "sswaem"], ["쐘", "sswaeL"], ["쐒", "sswaekk"], ["쐨", "sswaek"], ["쐦", "sswaej"],
    ["쐫", "sswaeh"], ["쐑", "sswaeG"], ["쐗", "sswaeD"], ["쐡", "sswaeB"], ["쐐", "sswae"], ["쏻", "sswaD"], ["쐅", "sswaB"], ["쏴", "sswa"],
    ["쑽", "ssut"], ["쑸", "ssuss"], ["쑷", "ssus"], ["쑾", "ssup"], ["쑹", "ssung"], ["쑨", "ssun"], ["쑴", "ssum"], ["쑬", "ssuL"],
    ["쑦", "ssukk"], ["쑼", "ssuk"], ["쑺", "ssuj"], ["쑿", "ssuh"], ["쑥", "ssuG"], ["쑫", "ssuD"], ["쑵", "ssuB"], ["쑤", "ssu"],
    ["쏱", "ssot"], ["쏬", "ssoss"], ["쏫", "ssos"], ["쏲", "ssop"], ["쏭", "ssong"], ["쏜", "sson"], ["쏨", "ssom"], ["쏠", "ssoL"],
    ["쏚", "ssokk"], ["쏰", "ssok"], ["쏮", "ssoj"], ["쏳", "ssoh"], ["쏙", "ssoG"], ["쑅", "ssoet"], ["쑀", "ssoess"], ["쐿", "ssoes"],
    ["쑆", "ssoep"], ["쑁", "ssoeng"], ["쐰", "ssoen"], ["쐼", "ssoem"], ["쐴", "ssoeL"], ["쐮", "ssoekk"], ["쑄", "ssoek"], ["쑂", "ssoej"],
    ["쑇", "ssoeh"], ["쐭", "ssoeG"], ["쐳", "ssoeD"], ["쐽", "ssoeB"], ["쐬", "ssoe"], ["쏟", "ssoD"], ["쏩", "ssoB"], ["쏘", "sso"],
    ["앁", "ssit"], ["씼", "ssiss"], ["씻", "ssis"], ["앂", "ssip"], ["씽", "ssing"], ["씬", "ssin"], ["씸", "ssim"], ["씰", "ssiL"],
    ["씪", "ssikk"], ["앀", "ssik"], ["씾", "ssij"], ["앃", "ssih"], ["씩", "ssiG"], ["씯", "ssiD"], ["씹", "ssiB"], ["씨", "ssi"],
    ["씉", "sseut"], ["씄", "sseuss"], ["씃", "sseus"], ["씊", "sseup"], ["씅", "sseung"], ["쓴", "sseun"], ["씀", "sseum"], ["쓸", "sseuL"],
    ["쓲", "sseukk"], ["씈", "sseuk"], ["씆", "sseuj"], ["씋", "sseuh"], ["쓱", "sseuG"], ["쓷", "sseuD"], ["씁", "sseuB"], ["쓰", "sseu"],
    ["쎝", "sset"], ["쎘", "ssess"], ["쎗", "sses"], ["쎞", "ssep"], ["쎁", "sseot"], ["썼", "sseoss"], ["썻", "sseos"], ["쎂", "sseop"],
    ["썽", "sseong"], ["썬", "sseon"], ["썸", "sseom"], ["썰", "sseoL"], ["썪", "sseokk"], ["쎀", "sseok"], ["썾", "sseoj"], ["쎃", "sseoh"],
    ["썩", "sseoG"], ["썯", "sseoD"], ["썹", "sseoB"], ["써", "sseo"], ["쎙", "sseng"], ["쎈", "ssen"], ["쎔", "ssem"], ["쎌", "sseL"],
    ["쎆", "ssekk"], ["쎜", "ssek"], ["쎚", "ssej"], ["쎟", "sseh"], ["쎅", "sseG"], ["쎋", "sseD"], ["쎕", "sseB"], ["쎄", "sse"],
    ["쌑", "ssat"], ["쌌", "ssass"], ["쌋", "ssas"], ["쌒", "ssap"], ["쌍", "ssang"], ["싼", "ssan"], ["쌈", "ssam"], ["쌀", "ssaL"],
    ["싺", "ssakk"], ["쌐", "ssak"], ["쌎", "ssaj"], ["쌓", "ssah"], ["싹", "ssaG"], ["쌭", "ssaet"], ["쌨", "ssaess"], ["쌧", "ssaes"],
    ["쌮", "ssaep"], ["쌩", "ssaeng"], ["쌘", "ssaen"], ["쌤", "ssaem"], ["쌜", "ssaeL"], ["쌖", "ssaekk"], ["쌬", "ssaek"], ["쌪", "ssaej"],
    ["쌯", "ssaeh"], ["쌕", "ssaeG"], ["쌛", "ssaeD"], ["쌥", "ssaeB"], ["쌔", "ssae"], ["싿", "ssaD"], ["쌉", "ssaB"], ["싸", "ssa"],
    ["솥", "sot"], ["솠", "soss"], ["솟", "sos"], ["솦", "sop"], ["송", "song"], ["손", "son"], ["솜", "som"], ["솔", "soL"],
    ["솎", "sokk"], ["솤", "sok"], ["솢", "soj"], ["솧", "soh"], ["속", "soG"], ["쇹", "soet"], ["쇴", "soess"], ["쇳", "soes"],
    ["쇺", "soep"], ["쇵", "soeng"], ["쇤", "soen"], ["쇰", "soem"], ["쇨", "soeL"], ["쇢", "soekk"], ["쇸", "soek"], ["쇶", "soej"],
    ["쇻", "soeh"], ["쇡", "soeG"], ["쇧", "soeD"], ["쇱", "soeB"], ["쇠", "soe"], ["솓", "soD"], ["솝", "soB"], ["소", "so"],
    ["싵", "sit"], ["싰", "siss"], ["싯", "sis"], ["싶", "sip"], ["싱", "sing"], ["신", "sin"], ["심", "sim"], ["실", "siL"],
    ["싞", "sikk"], ["싴", "sik"], ["싲", "sij"], ["싷", "sih"], ["식", "siG"], ["싣", "siD"], ["십", "siB"], ["시", "si"],
    ["슽", "seut"], ["슸", "seuss"], ["슷", "seus"], ["슾", "seup"], ["승", "seung"], ["슨", "seun"], ["슴", "seum"], ["슬", "seuL"],
    ["슦", "seukk"], ["슼", "seuk"], ["슺", "seuj"], ["슿", "seuh"], ["슥", "seuG"], ["슫", "seuD"], ["습", "seuB"], ["스", "seu"],
    ["셑", "set"], ["셌", "sess"], ["셋", "ses"], ["셒", "sep"], ["섵", "seot"], ["섰", "seoss"], ["섯", "seos"], ["섶", "seop"],
    ["성", "seong"], ["선", "seon"], ["섬", "seom"], ["설", "seoL"], ["섞", "seokk"], ["섴", "seok"], ["섲", "seoj"], ["섷", "seoh"],
    ["석", "seoG"], ["섣", "seoD"], ["섭", "seoB"], ["서", "seo"], ["셍", "seng"], ["센", "sen"], ["셈", "sem"], ["셀", "seL"],
    ["섺", "sekk"], ["셐", "sek"], ["셎", "sej"], ["셓", "seh"], ["섹", "seG"], ["섿", "seD"], ["셉", "seB"], ["세", "se"],
    ["샅", "sat"], ["샀", "sass"], ["삿", "sas"], ["샆", "sap"], ["상", "sang"], ["산", "san"], ["삼", "sam"], ["살", "saL"],
    ["삮", "sakk"], ["샄", "sak"], ["샂", "saj"], ["샇", "sah"], ["삭", "saG"], ["샡", "saet"], ["샜", "saess"], ["샛", "saes"],
    ["샢", "saep"], ["생", "saeng"], ["샌", "saen"], ["샘", "saem"], ["샐", "saeL"], ["샊", "saekk"], ["샠", "saek"], ["샞", "saej"],
    ["샣", "saeh"], ["색", "saeG"], ["샏", "saeD"], ["샙", "saeB"], ["새", "sae"], ["삳", "saD"], ["삽", "saB"], ["사", "sa"],
    ["옽", "ot"], ["옸", "oss"], ["옷", "os"], ["옾", "op"], ["옹", "ong"], ["온", "on"], ["옴", "om"], ["올", "oL"],
    ["옦", "okk"], ["옼", "ok"], ["옺", "oj"], ["옿", "oh"], ["옥", "oG"], ["욑", "oet"], ["욌", "oess"], ["욋", "oes"],
    ["욒", "oep"], ["욍", "oeng"], ["왼", "oen"], ["욈", "oem"], ["욀", "oeL"], ["왺", "oekk"], ["욐", "oek"], ["욎", "oej"],
    ["욓", "oeh"], ["왹", "oeG"], ["왿", "oeD"], ["욉", "oeB"], ["외", "oe"], ["옫", "oD"], ["옵", "oB"], ["오", "o"],
    ["즅", "jyut"], ["즀", "jyuss"], ["쥿", "jyus"], ["즆", "jyup"], ["즁", "jyung"], ["쥰", "jyun"], ["쥼", "jyum"], ["쥴", "jyuL"],
    ["쥮", "jyukk"], ["즄", "jyuk"], ["즂", "jyuj"], ["즇", "jyuh"], ["쥭", "jyuG"], ["쥳", "jyuD"], ["쥽", "jyuB"], ["쥬", "jyu"],
    ["죹", "jyot"], ["죴", "jyoss"], ["죳", "jyos"], ["죺", "jyop"], ["죵", "jyong"], ["죤", "jyon"], ["죰", "jyom"], ["죨", "jyoL"],
    ["죢", "jyokk"], ["죸", "jyok"], ["죶", "jyoj"], ["죻", "jyoh"], ["죡", "jyoG"], ["죧", "jyoD"], ["죱", "jyoB"], ["죠", "jyo"],
    ["즽", "juit"], ["즸", "juiss"], ["즷", "juis"], ["즾", "juip"], ["즹", "juing"], ["즨", "juin"], ["즴", "juim"], ["즬", "juiL"],
    ["즦", "juikk"], ["즼", "juik"], ["즺", "juij"], ["즿", "juih"], ["즥", "juiG"], ["즫", "juiD"], ["즵", "juiB"], ["즤", "jui"],
    ["졭", "jyet"], ["졨", "jyess"], ["졧", "jyes"], ["졮", "jyep"], ["졑", "jyeot"], ["졌", "jyeoss"], ["졋", "jyeos"], ["졒", "jyeop"],
    ["졍", "jyeong"], ["젼", "jyeon"], ["졈", "jyeom"], ["졀", "jyeoL"], ["젺", "jyeokk"], ["졐", "jyeok"], ["졎", "jyeoj"], ["졓", "jyeoh"],
    ["젹", "jyeoG"], ["젿", "jyeoD"], ["졉", "jyeoB"], ["져", "jyeo"], ["졩", "jyeng"], ["졘", "jyen"], ["졤", "jyem"], ["졜", "jyeL"],
    ["졖", "jyekk"], ["졬", "jyek"], ["졪", "jyej"], ["졯", "jyeh"], ["졕", "jyeG"], ["졛", "jyeD"], ["졥", "jyeB"], ["졔", "jye"],
    ["쟡", "jyat"], ["쟜", "jyass"], ["쟛", "jyas"], ["쟢", "jyap"], ["쟝", "jyang"], ["쟌", "jyan"], ["쟘", "jyam"], ["쟐", "jyaL"],
    ["쟊", "jyakk"], ["쟠", "jyak"], ["쟞", "jyaj"], ["쟣", "jyah"], ["쟉", "jyaG"], ["쟽", "jyaet"], ["쟸", "jyaess"], ["쟷", "jyaes"],
    ["쟾", "jyaep"], ["쟹", "jyaeng"], ["쟨", "jyaen"], ["쟴", "jyaem"], ["쟬", "jyaeL"], ["쟦", "jyaekk"], ["쟼", "jyaek"], ["쟺", "jyaej"],
    ["쟿", "jyaeh"], ["쟥", "jyaeG"], ["쟫", "jyaeD"], ["쟵", "jyaeB"], ["쟤", "jyae"], ["쟏", "jyaD"], ["쟙", "jyaB"], ["쟈", "jya"],
    ["쥩", "jwit"], ["쥤", "jwiss"], ["쥣", "jwis"], ["쥪", "jwip"], ["쥥", "jwing"], ["쥔", "jwin"], ["쥠", "jwim"], ["쥘", "jwiL"],
    ["쥒", "jwikk"], ["쥨", "jwik"], ["쥦", "jwij"], ["쥫", "jwih"], ["쥑", "jwiG"], ["쥗", "jwiD"], ["쥡", "jwiB"], ["쥐", "jwi"],
    ["쥍", "jwet"], ["쥈", "jwess"], ["쥇", "jwes"], ["쥎", "jwep"], ["줱", "jwot"], ["줬", "jwoss"], ["줫", "jwos"], ["줲", "jwop"],
    ["줭", "jwong"], ["줜", "jwon"], ["줨", "jwom"], ["줠", "jwoL"], ["줚", "jwokk"], ["줰", "jwok"], ["줮", "jwoj"], ["줳", "jwoh"],
    ["줙", "jwoG"], ["줟", "jwoD"], ["줩", "jwoB"], ["줘", "jwo"], ["쥉", "jweng"], ["줸", "jwen"], ["쥄", "jwem"], ["줼", "jweL"],
    ["줶", "jwekk"], ["쥌", "jwek"], ["쥊", "jwej"], ["쥏", "jweh"], ["줵", "jweG"], ["줻", "jweD"], ["쥅", "jweB"], ["줴", "jwe"],
    ["좥", "jwat"], ["좠", "jwass"], ["좟", "jwas"], ["좦", "jwap"], ["좡", "jwang"], ["좐", "jwan"], ["좜", "jwam"], ["좔", "jwaL"],
    ["좎", "jwakk"], ["좤", "jwak"], ["좢", "jwaj"], ["좧", "jwah"], ["좍", "jwaG"], ["죁", "jwaet"], ["좼", "jwaess"], ["좻", "jwaes"],
    ["죂", "jwaep"], ["좽", "jwaeng"], ["좬", "jwaen"], ["좸", "jwaem"], ["좰", "jwaeL"], ["좪", "jwaekk"], ["죀", "jwaek"], ["좾", "jwaej"],
    ["죃", "jwaeh"], ["좩", "jwaeG"], ["좯", "jwaeD"], ["좹", "jwaeB"], ["좨", "jwae"], ["좓", "jwaD"], ["좝", "jwaB"], ["좌", "jwa"],
    ["줕", "jut"], ["줐", "juss"], ["줏", "jus"], ["줖", "jup"], ["중", "jung"], ["준", "jun"], ["줌", "jum"], ["줄", "juL"],
    ["죾", "jukk"], ["줔", "juk"], ["줒", "juj"], ["줗", "juh"], ["죽", "juG"], ["줃", "juD"], ["줍", "juB"], ["주", "ju"],
    ["좉", "jot"], ["좄", "joss"], ["좃", "jos"], ["좊", "jop"], ["종", "jong"], ["존", "jon"], ["좀", "jom"], ["졸", "joL"],
    ["졲", "jokk"], ["좈", "jok"], ["좆", "joj"], ["좋", "joh"], ["족", "joG"], ["죝", "joet"], ["죘", "joess"], ["죗", "joes"],
    ["죞", "joep"], ["죙", "joeng"], ["죈", "joen"], ["죔", "joem"], ["죌", "joeL"], ["죆", "joekk"], ["죜", "joek"], ["죚", "joej"],
    ["죟", "joeh"], ["죅", "joeG"], ["죋", "joeD"], ["죕", "joeB"], ["죄", "joe"], ["졷", "joD"], ["좁", "joB"], ["조", "jo"],
    ["쯑", "jjyut"], ["쯌", "jjyuss"], ["쯋", "jjyus"], ["쯒", "jjyup"], ["쯍", "jjyung"], ["쮼", "jjyun"], ["쯈", "jjyum"], ["쯀", "jjyuL"],
    ["쮺", "jjyukk"], ["쯐", "jjyuk"], ["쯎", "jjyuj"], ["쯓", "jjyuh"], ["쮹", "jjyuG"], ["쮿", "jjyuD"], ["쯉", "jjyuB"], ["쮸", "jjyu"],
    ["쭅", "jjyot"], ["쭀", "jjyoss"], ["쬿", "jjyos"], ["쭆", "jjyop"], ["쭁", "jjyong"], ["쬰", "jjyon"], ["쬼", "jjyom"], ["쬴", "jjyoL"],
    ["쬮", "jjyokk"], ["쭄", "jjyok"], ["쭂", "jjyoj"], ["쭇", "jjyoh"], ["쬭", "jjyoG"], ["쬳", "jjyoD"], ["쬽", "jjyoB"], ["쬬", "jjyo"],
    ["찉", "jjuit"], ["찄", "jjuiss"], ["찃", "jjuis"], ["찊", "jjuip"], ["찅", "jjuing"], ["쯴", "jjuin"], ["찀", "jjuim"], ["쯸", "jjuiL"],
    ["쯲", "jjuikk"], ["찈", "jjuik"], ["찆", "jjuij"], ["찋", "jjuih"], ["쯱", "jjuiG"], ["쯷", "jjuiD"], ["찁", "jjuiB"], ["쯰", "jjui"],
    ["쪹", "jjyet"], ["쪴", "jjyess"], ["쪳", "jjyes"], ["쪺", "jjyep"], ["쪝", "jjyeot"], ["쪘", "jjyeoss"], ["쪗", "jjyeos"], ["쪞", "jjyeop"],
    ["쪙", "jjyeong"], ["쪈", "jjyeon"], ["쪔", "jjyeom"], ["쪌", "jjyeoL"], ["쪆", "jjyeokk"], ["쪜", "jjyeok"], ["쪚", "jjyeoj"], ["쪟", "jjyeoh"],
    ["쪅", "jjyeoG"], ["쪋", "jjyeoD"], ["쪕", "jjyeoB"], ["쪄", "jjyeo"], ["쪵", "jjyeng"], ["쪤", "jjyen"], ["쪰", "jjyem"], ["쪨", "jjyeL"],
    ["쪢", "jjyekk"], ["쪸", "jjyek"], ["쪶", "jjyej"], ["쪻", "jjyeh"], ["쪡", "jjyeG"], ["쪧", "jjyeD"], ["쪱", "jjyeB"], ["쪠", "jjye"],
    ["쨭", "jjyat"], ["쨨", "jjyass"], ["쨧", "jjyas"], ["쨮", "jjyap"], ["쨩", "jjyang"], ["쨘", "jjyan"], ["쨤", "jjyam"], ["쨜", "jjyaL"],
    ["쨖", "jjyakk"], ["쨬", "jjyak"], ["쨪", "jjyaj"], ["쨯", "jjyah"], ["쨕", "jjyaG"], ["쩉", "jjyaet"], ["쩄", "jjyaess"], ["쩃", "jjyaes"],
    ["쩊", "jjyaep"], ["쩅", "jjyaeng"], ["쨴", "jjyaen"], ["쩀", "jjyaem"], ["쨸", "jjyaeL"], ["쨲", "jjyaekk"], ["쩈", "jjyaek"], ["쩆", "jjyaej"],
    ["쩋", "jjyaeh"], ["쨱", "jjyaeG"], ["쨷", "jjyaeD"], ["쩁", "jjyaeB"], ["쨰", "jjyae"], ["쨛", "jjyaD"], ["쨥", "jjyaB"], ["쨔", "jjya"],
    ["쮵", "jjwit"], ["쮰", "jjwiss"], ["쮯", "jjwis"], ["쮶", "jjwip"], ["쮱", "jjwing"], ["쮠", "jjwin"], ["쮬", "jjwim"], ["쮤", "jjwiL"],
    ["쮞", "jjwikk"], ["쮴", "jjwik"], ["쮲", "jjwij"], ["쮷", "jjwih"], ["쮝", "jjwiG"], ["쮣", "jjwiD"], ["쮭", "jjwiB"], ["쮜", "jjwi"],
    ["쮙", "jjwet"], ["쮔", "jjwess"], ["쮓", "jjwes"], ["쮚", "jjwep"], ["쭽", "jjwot"], ["쭸", "jjwoss"], ["쭷", "jjwos"], ["쭾", "jjwop"],
    ["쭹", "jjwong"], ["쭨", "jjwon"], ["쭴", "jjwom"], ["쭬", "jjwoL"], ["쭦", "jjwokk"], ["쭼", "jjwok"], ["쭺", "jjwoj"], ["쭿", "jjwoh"],
    ["쭥", "jjwoG"], ["쭫", "jjwoD"], ["쭵", "jjwoB"], ["쭤", "jjwo"], ["쮕", "jjweng"], ["쮄", "jjwen"], ["쮐", "jjwem"], ["쮈", "jjweL"],
    ["쮂", "jjwekk"], ["쮘", "jjwek"], ["쮖", "jjwej"], ["쮛", "jjweh"], ["쮁", "jjweG"], ["쮇", "jjweD"], ["쮑", "jjweB"], ["쮀", "jjwe"],
    ["쫱", "jjwat"], ["쫬", "jjwass"], ["쫫", "jjwas"], ["쫲", "jjwap"], ["쫭", "jjwang"], ["쫜", "jjwan"], ["쫨", "jjwam"], ["쫠", "jjwaL"],
    ["쫚", "jjwakk"], ["쫰", "jjwak"], ["쫮", "jjwaj"], ["쫳", "jjwah"], ["쫙", "jjwaG"], ["쬍", "jjwaet"], ["쬈", "jjwaess"], ["쬇", "jjwaes"],
    ["쬎", "jjwaep"], ["쬉", "jjwaeng"], ["쫸", "jjwaen"], ["쬄", "jjwaem"], ["쫼", "jjwaeL"], ["쫶", "jjwaekk"], ["쬌", "jjwaek"], ["쬊", "jjwaej"],
    ["쬏", "jjwaeh"], ["쫵", "jjwaeG"], ["쫻", "jjwaeD"], ["쬅", "jjwaeB"], ["쫴", "jjwae"], ["쫟", "jjwaD"], ["쫩", "jjwaB"], ["쫘", "jjwa"],
    ["쭡", "jjut"], ["쭜", "jjuss"], ["쭛", "jjus"], ["쭢", "jjup"], ["쭝", "jjung"], ["쭌", "jjun"], ["쭘", "jjum"], ["쭐", "jjuL"],
    ["쭊", "jjukk"], ["쭠", "jjuk"], ["쭞", "jjuj"], ["쭣", "jjuh"], ["쭉", "jjuG"], ["쭏", "jjuD"], ["쭙", "jjuB"], ["쭈", "jju"],
    ["쫕", "jjot"], ["쫐", "jjoss"], ["쫏", "jjos"], ["쫖", "jjop"], ["쫑", "jjong"], ["쫀", "jjon"], ["쫌", "jjom"], ["쫄", "jjoL"],
    ["쪾", "jjokk"], ["쫔", "jjok"], ["쫒", "jjoj"], ["쫗", "jjoh"], ["쪽", "jjoG"], ["쬩", "jjoet"], ["쬤", "jjoess"], ["쬣", "jjoes"],
    ["쬪", "jjoep"], ["쬥", "jjoeng"], ["쬔", "jjoen"], ["쬠", "jjoem"], ["쬘", "jjoeL"], ["쬒", "jjoekk"], ["쬨", "jjoek"], ["쬦", "jjoej"],
    ["쬫", "jjoeh"], ["쬑", "jjoeG"], ["쬗", "jjoeD"], ["쬡", "jjoeB"], ["쬐", "jjoe"], ["쫃", "jjoD"], ["쫍", "jjoB"], ["쪼", "jjo"],
    ["찥", "jjit"], ["찠", "jjiss"], ["찟", "jjis"], ["찦", "jjip"], ["찡", "jjing"], ["찐", "jjin"], ["찜", "jjim"], ["찔", "jjiL"],
    ["찎", "jjikk"], ["찤", "jjik"], ["찢", "jjij"], ["찧", "jjih"], ["찍", "jjiG"], ["찓", "jjiD"], ["찝", "jjiB"], ["찌", "jji"],
    ["쯭", "jjeut"], ["쯨", "jjeuss"], ["쯧", "jjeus"], ["쯮", "jjeup"], ["쯩", "jjeung"], ["쯘", "jjeun"], ["쯤", "jjeum"], ["쯜", "jjeuL"],
    ["쯖", "jjeukk"], ["쯬", "jjeuk"], ["쯪", "jjeuj"], ["쯯", "jjeuh"], ["쯕", "jjeuG"], ["쯛", "jjeuD"], ["쯥", "jjeuB"], ["쯔", "jjeu"],
    ["쪁", "jjet"], ["쩼", "jjess"], ["쩻", "jjes"], ["쪂", "jjep"], ["쩥", "jjeot"], ["쩠", "jjeoss"], ["쩟", "jjeos"], ["쩦", "jjeop"],
    ["쩡", "jjeong"], ["쩐", "jjeon"], ["쩜", "jjeom"], ["쩔", "jjeoL"], ["쩎", "jjeokk"], ["쩤", "jjeok"], ["쩢", "jjeoj"], ["쩧", "jjeoh"],
    ["쩍", "jjeoG"], ["쩓", "jjeoD"], ["쩝", "jjeoB"], ["쩌", "jjeo"], ["쩽", "jjeng"], ["쩬", "jjen"], ["쩸", "jjem"], ["쩰", "jjeL"],
    ["쩪", "jjekk"], ["쪀", "jjek"], ["쩾", "jjej"], ["쪃", "jjeh"], ["쩩", "jjeG"], ["쩯", "jjeD"], ["쩹", "jjeB"], ["쩨", "jje"],
    ["짵", "jjat"], ["짰", "jjass"], ["짯", "jjas"], ["짶", "jjap"], ["짱", "jjang"], ["짠", "jjan"], ["짬", "jjam"], ["짤", "jjaL"],
    ["짞", "jjakk"], ["짴", "jjak"], ["짲", "jjaj"], ["짷", "jjah"], ["짝", "jjaG"], ["쨑", "jjaet"], ["쨌", "jjaess"], ["쨋", "jjaes"],
    ["쨒", "jjaep"], ["쨍", "jjaeng"], ["짼", "jjaen"], ["쨈", "jjaem"], ["쨀", "jjaeL"], ["짺", "jjaekk"], ["쨐", "jjaek"], ["쨎", "jjaej"],
    ["쨓", "jjaeh"], ["짹", "jjaeG"], ["짿", "jjaeD"], ["쨉", "jjaeB"], ["째", "jjae"], ["짣", "jjaD"], ["짭", "jjaB"], ["짜", "jja"],
    ["짙", "jit"], ["짔", "jiss"], ["짓", "jis"], ["짚", "jip"], ["징", "jing"], ["진", "jin"], ["짐", "jim"], ["질", "jiL"],
    ["짂", "jikk"], ["짘", "jik"], ["짖", "jij"], ["짛", "jih"], ["직", "jiG"], ["짇", "jiD"], ["집", "jiB"], ["지", "ji"],
    ["즡", "jeut"], ["즜", "jeuss"], ["즛", "jeus"], ["즢", "jeup"], ["증", "jeung"], ["즌", "jeun"], ["즘", "jeum"], ["즐", "jeuL"],
    ["즊", "jeukk"], ["즠", "jeuk"], ["즞", "jeuj"], ["즣", "jeuh"], ["즉", "jeuG"], ["즏", "jeuD"], ["즙", "jeuB"], ["즈", "jeu"],
    ["젵", "jet"], ["젰", "jess"], ["젯", "jes"], ["젶", "jep"], ["젙", "jeot"], ["젔", "jeoss"], ["젓", "jeos"], ["젚", "jeop"],
    ["정", "jeong"], ["전", "jeon"], ["점", "jeom"], ["절", "jeoL"], ["젂", "jeokk"], ["젘", "jeok"], ["젖", "jeoj"], ["젛", "jeoh"],
    ["적", "jeoG"], ["젇", "jeoD"], ["접", "jeoB"], ["저", "jeo"], ["젱", "jeng"], ["젠", "jen"], ["젬", "jem"], ["젤", "jeL"],
    ["젞", "jekk"], ["젴", "jek"], ["젲", "jej"], ["젷", "jeh"], ["젝", "jeG"], ["젣", "jeD"], ["젭", "jeB"], ["제", "je"],
    ["잩", "jat"], ["잤", "jass"], ["잣", "jas"], ["잪", "jap"], ["장", "jang"], ["잔", "jan"], ["잠", "jam"], ["잘", "jaL"],
    ["잒", "jakk"], ["잨", "jak"], ["잦", "jaj"], ["잫", "jah"], ["작", "jaG"], ["쟅", "jaet"], ["쟀", "jaess"], ["잿", "jaes"],
    ["쟆", "jaep"], ["쟁", "jaeng"], ["잰", "jaen"], ["잼", "jaem"], ["잴", "jaeL"], ["잮", "jaekk"], ["쟄", "jaek"], ["쟂", "jaej"],
    ["쟇", "jaeh"], ["잭", "jaeG"], ["잳", "jaeD"], ["잽", "jaeB"], ["재", "jae"], ["잗", "jaD"], ["잡", "jaB"], ["자", "ja"],
    ["잍", "it"], ["있", "iss"], ["잇", "is"], ["잎", "ip"], ["잉", "ing"], ["인", "in"], ["임", "im"], ["일", "iL"],
    ["읶", "ikk"], ["잌", "ik"], ["잊", "ij"], ["잏", "ih"], ["익", "iG"], ["읻", "iD"], ["입", "iB"], ["이", "i"],
    ["읕", "eut"], ["읐", "euss"], ["읏", "eus"], ["읖", "eup"], ["응", "eung"], ["은", "eun"], ["음", "eum"], ["을", "euL"],
    ["윾", "eukk"], ["읔", "euk"], ["읒", "euj"], ["읗", "euh"], ["윽", "euG"], ["읃", "euD"], ["읍", "euB"], ["으", "eu"],
    ["엩", "et"], ["엤", "ess"], ["엣", "es"], ["엪", "ep"], ["엍", "eot"], ["었", "eoss"], ["엇", "eos"], ["엎", "eop"],
    ["엉", "eong"], ["언", "eon"], ["엄", "eom"], ["얼", "eoL"], ["얶", "eokk"], ["엌", "eok"], ["엊", "eoj"], ["엏", "eoh"],
    ["억", "eoG"], ["얻", "eoD"], ["업", "eoB"], ["어", "eo"], ["엥", "eng"], ["엔", "en"], ["엠", "em"], ["엘", "eL"],
    ["엒", "ekk"], ["엨", "ek"], ["엦", "ej"], ["엫", "eh"], ["엑", "eG"], ["엗", "eD"], ["엡", "eB"], ["에", "e"],
    ["츝", "chyut"], ["츘", "chyuss"], ["츗", "chyus"], ["츞", "chyup"], ["츙", "chyung"], ["츈", "chyun"], ["츔", "chyum"], ["츌", "chyuL"],
    ["츆", "chyukk"], ["츜", "chyuk"], ["츚", "chyuj"], ["츟", "chyuh"], ["츅", "chyuG"], ["츋", "chyuD"], ["츕", "chyuB"], ["츄", "chyu"],
    ["춑", "chyot"], ["춌", "chyoss"], ["춋", "chyos"], ["춒", "chyop"], ["춍", "chyong"], ["쵼", "chyon"], ["춈", "chyom"], ["춀", "chyoL"],
    ["쵺", "chyokk"], ["춐", "chyok"], ["춎", "chyoj"], ["춓", "chyoh"], ["쵹", "chyoG"], ["쵿", "chyoD"], ["춉", "chyoB"], ["쵸", "chyo"],
    ["칕", "chuit"], ["칐", "chuiss"], ["칏", "chuis"], ["칖", "chuip"], ["칑", "chuing"], ["칀", "chuin"], ["칌", "chuim"], ["칄", "chuiL"],
    ["츾", "chuikk"], ["칔", "chuik"], ["칒", "chuij"], ["칗", "chuih"], ["츽", "chuiG"], ["칃", "chuiD"], ["칍", "chuiB"], ["츼", "chui"],
    ["촅", "chyet"], ["촀", "chyess"], ["쳿", "chyes"], ["촆", "chyep"], ["쳩", "chyeot"], ["쳤", "chyeoss"], ["쳣", "chyeos"], ["쳪", "chyeop"],
    ["쳥", "chyeong"], ["쳔", "chyeon"], ["쳠", "chyeom"], ["쳘", "chyeoL"], ["쳒", "chyeokk"], ["쳨", "chyeok"], ["쳦", "chyeoj"], ["쳫", "chyeoh"],
    ["쳑", "chyeoG"], ["쳗", "chyeoD"], ["쳡", "chyeoB"], ["쳐", "chyeo"], ["촁", "chyeng"], ["쳰", "chyen"], ["쳼", "chyem"], ["쳴", "chyeL"],
    ["쳮", "chyekk"], ["촄", "chyek"], ["촂", "chyej"], ["촇", "chyeh"], ["쳭", "chyeG"], ["쳳", "chyeD"], ["쳽", "chyeB"], ["쳬", "chye"],
    ["챹", "chyat"], ["챴", "chyass"], ["챳", "chyas"], ["챺", "chyap"], ["챵", "chyang"], ["챤", "chyan"], ["챰", "chyam"], ["챨", "chyaL"],
    ["챢", "chyakk"], ["챸", "chyak"], ["챶", "chyaj"], ["챻", "chyah"], ["챡", "chyaG"], ["첕", "chyaet"], ["첐", "chyaess"], ["첏", "chyaes"],
    ["첖", "chyaep"], ["첑", "chyaeng"], ["첀", "chyaen"], ["첌", "chyaem"], ["첄", "chyaeL"], ["챾", "chyaekk"], ["첔", "chyaek"], ["첒", "chyaej"],
    ["첗", "chyaeh"], ["챽", "chyaeG"], ["첃", "chyaeD"], ["첍", "chyaeB"], ["챼", "chyae"], ["챧", "chyaD"], ["챱", "chyaB"], ["챠", "chya"],
    ["츁", "chwit"], ["췼", "chwiss"], ["췻", "chwis"], ["츂", "chwip"], ["췽", "chwing"], ["췬", "chwin"], ["췸", "chwim"], ["췰", "chwiL"],
    ["췪", "chwikk"], ["츀", "chwik"], ["췾", "chwij"], ["츃", "chwih"], ["췩", "chwiG"], ["췯", "chwiD"], ["췹", "chwiB"], ["취", "chwi"],
    ["췥", "chwet"], ["췠", "chwess"], ["췟", "chwes"], ["췦", "chwep"], ["췉", "chwot"], ["췄", "chwoss"], ["췃", "chwos"], ["췊", "chwop"],
    ["췅", "chwong"], ["춴", "chwon"], ["췀", "chwom"], ["춸", "chwoL"], ["춲", "chwokk"], ["췈", "chwok"], ["췆", "chwoj"], ["췋", "chwoh"],
    ["춱", "chwoG"], ["춷", "chwoD"], ["췁", "chwoB"], ["춰", "chwo"], ["췡", "chweng"], ["췐", "chwen"], ["췜", "chwem"], ["췔", "chweL"],
    ["췎", "chwekk"], ["췤", "chwek"], ["췢", "chwej"], ["췧", "chweh"], ["췍", "chweG"], ["췓", "chweD"], ["췝", "chweB"], ["췌", "chwe"],
    ["촽", "chwat"], ["촸", "chwass"], ["촷", "chwas"], ["촾", "chwap"], ["촹", "chwang"], ["촨", "chwan"], ["촴", "chwam"], ["촬", "chwaL"],
    ["촦", "chwakk"], ["촼", "chwak"], ["촺", "chwaj"], ["촿", "chwah"], ["촥", "chwaG"], ["쵙", "chwaet"], ["쵔", "chwaess"], ["쵓", "chwaes"],
    ["쵚", "chwaep"], ["쵕", "chwaeng"], ["쵄", "chwaen"], ["쵐", "chwaem"], ["쵈", "chwaeL"], ["쵂", "chwaekk"], ["쵘", "chwaek"], ["쵖", "chwaej"],
    ["쵛", "chwaeh"], ["쵁", "chwaeG"], ["쵇", "chwaeD"], ["쵑", "chwaeB"], ["쵀", "chwae"], ["촫", "chwaD"], ["촵", "chwaB"], ["촤", "chwa"],
    ["춭", "chut"], ["춨", "chuss"], ["춧", "chus"], ["춮", "chup"], ["충", "chung"], ["춘", "chun"], ["춤", "chum"], ["출", "chuL"],
    ["춖", "chukk"], ["춬", "chuk"], ["춪", "chuj"], ["춯", "chuh"], ["축", "chuG"], ["춛", "chuD"], ["춥", "chuB"], ["추", "chu"],
    ["촡", "chot"], ["촜", "choss"], ["촛", "chos"], ["촢", "chop"], ["총", "chong"], ["촌", "chon"], ["촘", "chom"], ["촐", "choL"],
    ["촊", "chokk"], ["촠", "chok"], ["촞", "choj"], ["촣", "choh"], ["촉", "choG"], ["쵵", "choet"], ["쵰", "choess"], ["쵯", "choes"],
    ["쵶", "choep"], ["쵱", "choeng"], ["쵠", "choen"], ["쵬", "choem"], ["쵤", "choeL"], ["쵞", "choekk"], ["쵴", "choek"], ["쵲", "choej"],
    ["쵷", "choeh"], ["쵝", "choeG"], ["쵣", "choeD"], ["쵭", "choeB"], ["최", "choe"], ["촏", "choD"], ["촙", "choB"], ["초", "cho"],
    ["칱", "chit"], ["칬", "chiss"], ["칫", "chis"], ["칲", "chip"], ["칭", "ching"], ["친", "chin"], ["침", "chim"], ["칠", "chiL"],
    ["칚", "chikk"], ["칰", "chik"], ["칮", "chij"], ["칳", "chih"], ["칙", "chiG"], ["칟", "chiD"], ["칩", "chiB"], ["치", "chi"],
    ["츹", "cheut"], ["츴", "cheuss"], ["츳", "cheus"], ["츺", "cheup"], ["층", "cheung"], ["츤", "cheun"], ["츰", "cheum"], ["츨", "cheuL"],
    ["츢", "cheukk"], ["츸", "cheuk"], ["츶", "cheuj"], ["츻", "cheuh"], ["측", "cheuG"], ["츧", "cheuD"], ["츱", "cheuB"], ["츠", "cheu"],
    ["쳍", "chet"], ["쳈", "chess"], ["쳇", "ches"], ["쳎", "chep"], ["첱", "cheot"], ["첬", "cheoss"], ["첫", "cheos"], ["첲", "cheop"],
    ["청", "cheong"], ["천", "cheon"], ["첨", "cheom"], ["철", "cheoL"], ["첚", "cheokk"], ["첰", "cheok"], ["첮", "cheoj"], ["첳", "cheoh"],
    ["척", "cheoG"], ["첟", "cheoD"], ["첩", "cheoB"], ["처", "cheo"], ["쳉", "cheng"], ["첸", "chen"], ["쳄", "chem"], ["첼", "cheL"],
    ["첶", "chekk"], ["쳌", "chek"], ["쳊", "chej"], ["쳏", "cheh"], ["첵", "cheG"], ["첻", "cheD"], ["쳅", "cheB"], ["체", "che"],
    ["챁", "chat"], ["찼", "chass"], ["찻", "chas"], ["챂", "chap"], ["창", "chang"], ["찬", "chan"], ["참", "cham"], ["찰", "chaL"],
    ["찪", "chakk"], ["챀", "chak"], ["찾", "chaj"], ["챃", "chah"], ["착", "chaG"], ["챝", "chaet"], ["챘", "chaess"], ["챗", "chaes"],
    ["챞", "chaep"], ["챙", "chaeng"], ["챈", "chaen"], ["챔", "chaem"], ["챌", "chaeL"], ["챆", "chaekk"], ["챜", "chaek"], ["챚", "chaej"],
    ["챟", "chaeh"], ["책", "chaeG"], ["챋", "chaeD"], ["챕", "chaeB"], ["채", "chae"], ["찯", "chaD"], ["찹", "chaB"], ["차", "cha"],
    ["앝", "at"], ["았", "ass"], ["앗", "as"], ["앞", "ap"], ["앙", "ang"], ["안", "an"], ["암", "am"], ["알", "aL"],
    ["앆", "akk"], ["앜", "ak"], ["앚", "aj"], ["앟", "ah"], ["악", "aG"], ["앹", "aet"], ["앴", "aess"], ["앳", "aes"],
    ["앺", "aep"], ["앵", "aeng"], ["앤", "aen"], ["앰", "aem"], ["앨", "aeL"], ["앢", "aekk"], ["앸", "aek"], ["앶", "aej"],
    ["앻", "aeh"], ["액", "aeG"], ["앧", "aeD"], ["앱", "aeB"], ["애", "ae"], ["앋", "aD"], ["압", "aB"], ["아", "a"],
    ["튵", "tyut"], ["튰", "tyuss"], ["튯", "tyus"], ["튶", "tyup"], ["튱", "tyung"], ["튠", "tyun"], ["튬", "tyum"], ["튤", "tyuL"],
    ["튞", "tyukk"], ["튴", "tyuk"], ["튲", "tyuj"], ["튷", "tyuh"], ["튝", "tyuG"], ["튣", "tyuD"], ["튭", "tyuB"], ["튜", "tyu"],
    ["툩", "tyot"], ["툤", "tyoss"], ["툣", "tyos"], ["툪", "tyop"], ["툥", "tyong"], ["툔", "tyon"], ["툠", "tyom"], ["툘", "tyoL"],
    ["툒", "tyokk"], ["툨", "tyok"], ["툦", "tyoj"], ["툫", "tyoh"], ["툑", "tyoG"], ["툗", "tyoD"], ["툡", "tyoB"], ["툐", "tyo"],
    ["틭", "tuit"], ["틨", "tuiss"], ["틧", "tuis"], ["틮", "tuip"], ["틩", "tuing"], ["틘", "tuin"], ["틤", "tuim"], ["틜", "tuiL"],
    ["틖", "tuikk"], ["틬", "tuik"], ["틪", "tuij"], ["틯", "tuih"], ["틕", "tuiG"], ["틛", "tuiD"], ["틥", "tuiB"], ["틔", "tui"],
    ["톝", "tyet"], ["톘", "tyess"], ["톗", "tyes"], ["톞", "tyep"], ["톁", "tyeot"], ["텼", "tyeoss"], ["텻", "tyeos"], ["톂", "tyeop"],
    ["텽", "tyeong"], ["텬", "tyeon"], ["텸", "tyeom"], ["텰", "tyeoL"], ["텪", "tyeokk"], ["톀", "tyeok"], ["텾", "tyeoj"], ["톃", "tyeoh"],
    ["텩", "tyeoG"], ["텯", "tyeoD"], ["텹", "tyeoB"], ["텨", "tyeo"], ["톙", "tyeng"], ["톈", "tyen"], ["톔", "tyem"], ["톌", "tyeL"],
    ["톆", "tyekk"], ["톜", "tyek"], ["톚", "tyej"], ["톟", "tyeh"], ["톅", "tyeG"], ["톋", "tyeD"], ["톕", "tyeB"], ["톄", "tye"],
    ["턑", "tyat"], ["턌", "tyass"], ["턋", "tyas"], ["턒", "tyap"], ["턍", "tyang"], ["탼", "tyan"], ["턈", "tyam"], ["턀", "tyaL"],
    ["탺", "tyakk"], ["턐", "tyak"], ["턎", "tyaj"], ["턓", "tyah"], ["탹", "tyaG"], ["턭", "tyaet"], ["턨", "tyaess"], ["턧", "tyaes"],
    ["턮", "tyaep"], ["턩", "tyaeng"], ["턘", "tyaen"], ["턤", "tyaem"], ["턜", "tyaeL"], ["턖", "tyaekk"], ["턬", "tyaek"], ["턪", "tyaej"],
    ["턯", "tyaeh"], ["턕", "tyaeG"], ["턛", "tyaeD"], ["턥", "tyaeB"], ["턔", "tyae"], ["탿", "tyaD"], ["턉", "tyaB"], ["탸", "tya"],
    ["튙", "twit"], ["튔", "twiss"], ["튓", "twis"], ["튚", "twip"], ["튕", "twing"], ["튄", "twin"], ["튐", "twim"], ["튈", "twiL"],
    ["튂", "twikk"], ["튘", "twik"], ["튖", "twij"], ["튛", "twih"], ["튁", "twiG"], ["튇", "twiD"], ["튑", "twiB"], ["튀", "twi"],
    ["퉽", "twet"], ["퉸", "twess"], ["퉷", "twes"], ["퉾", "twep"], ["퉡", "twot"], ["퉜", "twoss"], ["퉛", "twos"], ["퉢", "twop"],
    ["퉝", "twong"], ["퉌", "twon"], ["퉘", "twom"], ["퉐", "twoL"], ["퉊", "twokk"], ["퉠", "twok"], ["퉞", "twoj"], ["퉣", "twoh"],
    ["퉉", "twoG"], ["퉏", "twoD"], ["퉙", "twoB"], ["퉈", "two"], ["퉹", "tweng"], ["퉨", "twen"], ["퉴", "twem"], ["퉬", "tweL"],
    ["퉦", "twekk"], ["퉼", "twek"], ["퉺", "twej"], ["퉿", "tweh"], ["퉥", "tweG"], ["퉫", "tweD"], ["퉵", "tweB"], ["퉤", "twe"],
    ["퇕", "twat"], ["퇐", "twass"], ["퇏", "twas"], ["퇖", "twap"], ["퇑", "twang"], ["퇀", "twan"], ["퇌", "twam"], ["퇄", "twaL"],
    ["톾", "twakk"], ["퇔", "twak"], ["퇒", "twaj"], ["퇗", "twah"], ["톽", "twaG"], ["퇱", "twaet"], ["퇬", "twaess"], ["퇫", "twaes"],
    ["퇲", "twaep"], ["퇭", "twaeng"], ["퇜", "twaen"], ["퇨", "twaem"], ["퇠", "twaeL"], ["퇚", "twaekk"], ["퇰", "twaek"], ["퇮", "twaej"],
    ["퇳", "twaeh"], ["퇙", "twaeG"], ["퇟", "twaeD"], ["퇩", "twaeB"], ["퇘", "twae"], ["퇃", "twaD"], ["퇍", "twaB"], ["톼", "twa"],
    ["퉅", "tut"], ["퉀", "tuss"], ["툿", "tus"], ["퉆", "tup"], ["퉁", "tung"], ["툰", "tun"], ["툼", "tum"], ["툴", "tuL"],
    ["툮", "tukk"], ["퉄", "tuk"], ["퉂", "tuj"], ["퉇", "tuh"], ["툭", "tuG"], ["툳", "tuD"], ["툽", "tuB"], ["투", "tu"],
    ["톹", "tot"], ["톴", "toss"], ["톳", "tos"], ["톺", "top"], ["통", "tong"], ["톤", "ton"], ["톰", "tom"], ["톨", "toL"],
    ["톢", "tokk"], ["톸", "tok"], ["톶", "toj"], ["톻", "toh"], ["톡", "toG"], ["툍", "toet"], ["툈", "toess"], ["툇", "toes"],
    ["툎", "toep"], ["툉", "toeng"], ["퇸", "toen"], ["툄", "toem"], ["퇼", "toeL"], ["퇶", "toekk"], ["툌", "toek"], ["툊", "toej"],
    ["툏", "toeh"], ["퇵", "toeG"], ["퇻", "toeD"], ["툅", "toeB"], ["퇴", "toe"], ["톧", "toD"], ["톱", "toB"], ["토", "to"],
    ["팉", "tit"], ["팄", "tiss"], ["팃", "tis"], ["팊", "tip"], ["팅", "ting"], ["틴", "tin"], ["팀", "tim"], ["틸", "tiL"],
    ["틲", "tikk"], ["팈", "tik"], ["팆", "tij"], ["팋", "tih"], ["틱", "tiG"], ["틷", "tiD"], ["팁", "tiB"], ["티", "ti"],
    ["틑", "teut"], ["틌", "teuss"], ["틋", "teus"], ["틒", "teup"], ["틍", "teung"], ["튼", "teun"], ["틈", "teum"], ["틀", "teuL"],
    ["튺", "teukk"], ["틐", "teuk"], ["틎", "teuj"], ["틓", "teuh"], ["특", "teuG"], ["튿", "teuD"], ["틉", "teuB"], ["트", "teu"],
    ["텥", "tet"], ["텠", "tess"], ["텟", "tes"], ["텦", "tep"], ["텉", "teot"], ["텄", "teoss"], ["텃", "teos"], ["텊", "teop"],
    ["텅", "teong"], ["턴", "teon"], ["텀", "teom"], ["털", "teoL"], ["턲", "teokk"], ["텈", "teok"], ["텆", "teoj"], ["텋", "teoh"],
    ["턱", "teoG"], ["턷", "teoD"], ["텁", "teoB"], ["터", "teo"], ["텡", "teng"], ["텐", "ten"], ["템", "tem"], ["텔", "teL"],
    ["텎", "tekk"], ["텤", "tek"], ["텢", "tej"], ["텧", "teh"], ["텍", "teG"], ["텓", "teD"], ["텝", "teB"], ["테", "te"],
    ["탙", "tat"], ["탔", "tass"], ["탓", "tas"], ["탚", "tap"], ["탕", "tang"], ["탄", "tan"], ["탐", "tam"], ["탈", "taL"],
    ["탂", "takk"], ["탘", "tak"], ["탖", "taj"], ["탛", "tah"], ["탁", "taG"], ["탵", "taet"], ["탰", "taess"], ["탯", "taes"],
    ["탶", "taep"], ["탱", "taeng"], ["탠", "taen"], ["탬", "taem"], ["탤", "taeL"], ["탞", "taekk"], ["탴", "taek"], ["탲", "taej"],
    ["탷", "taeh"], ["택", "taeG"], ["탣", "taeD"], ["탭", "taeB"], ["태", "tae"], ["탇", "taD"], ["탑", "taB"], ["타", "ta"],
    ["픁", "pyut"], ["퓼", "pyuss"], ["퓻", "pyus"], ["픂", "pyup"], ["퓽", "pyung"], ["퓬", "pyun"], ["퓸", "pyum"], ["퓰", "pyuL"],
    ["퓪", "pyukk"], ["픀", "pyuk"], ["퓾", "pyuj"], ["픃", "pyuh"], ["퓩", "pyuG"], ["퓯", "pyuD"], ["퓹", "pyuB"], ["퓨", "pyu"],
    ["푵", "pyot"], ["푰", "pyoss"], ["푯", "pyos"], ["푶", "pyop"], ["푱", "pyong"], ["푠", "pyon"], ["푬", "pyom"], ["푤", "pyoL"],
    ["푞", "pyokk"], ["푴", "pyok"], ["푲", "pyoj"], ["푷", "pyoh"], ["푝", "pyoG"], ["푣", "pyoD"], ["푭", "pyoB"], ["표", "pyo"],
    ["픹", "puit"], ["픴", "puiss"], ["픳", "puis"], ["픺", "puip"], ["픵", "puing"], ["픤", "puin"], ["픰", "puim"], ["픨", "puiL"],
    ["픢", "puikk"], ["픸", "puik"], ["픶", "puij"], ["픻", "puih"], ["픡", "puiG"], ["픧", "puiD"], ["픱", "puiB"], ["픠", "pui"],
    ["폩", "pyet"], ["폤", "pyess"], ["폣", "pyes"], ["폪", "pyep"], ["폍", "pyeot"], ["폈", "pyeoss"], ["폇", "pyeos"], ["폎", "pyeop"],
    ["평", "pyeong"], ["편", "pyeon"], ["폄", "pyeom"], ["펼", "pyeoL"], ["펶", "pyeokk"], ["폌", "pyeok"], ["폊", "pyeoj"], ["폏", "pyeoh"],
    ["펵", "pyeoG"], ["펻", "pyeoD"], ["폅", "pyeoB"], ["펴", "pyeo"], ["폥", "pyeng"], ["폔", "pyen"], ["폠", "pyem"], ["폘", "pyeL"],
    ["폒", "pyekk"], ["폨", "pyek"], ["폦", "pyej"], ["폫", "pyeh"], ["폑", "pyeG"], ["폗", "pyeD"], ["폡", "pyeB"], ["폐", "pye"],
    ["퍝", "pyat"], ["퍘", "pyass"], ["퍗", "pyas"], ["퍞", "pyap"], ["퍙", "pyang"], ["퍈", "pyan"], ["퍔", "pyam"], ["퍌", "pyaL"],
    ["퍆", "pyakk"], ["퍜", "pyak"], ["퍚", "pyaj"], ["퍟", "pyah"], ["퍅", "pyaG"], ["퍹", "pyaet"], ["퍴", "pyaess"], ["퍳", "pyaes"],
    ["퍺", "pyaep"], ["퍵", "pyaeng"], ["퍤", "pyaen"], ["퍰", "pyaem"], ["퍨", "pyaeL"], ["퍢", "pyaekk"], ["퍸", "pyaek"], ["퍶", "pyaej"],
    ["퍻", "pyaeh"], ["퍡", "pyaeG"], ["퍧", "pyaeD"], ["퍱", "pyaeB"], ["퍠", "pyae"], ["퍋", "pyaD"], ["퍕", "pyaB"], ["퍄", "pya"],
    ["퓥", "pwit"], ["퓠", "pwiss"], ["퓟", "pwis"], ["퓦", "pwip"], ["퓡", "pwing"], ["퓐", "pwin"], ["퓜", "pwim"], ["퓔", "pwiL"],
    ["퓎", "pwikk"], ["퓤", "pwik"], ["퓢", "pwij"], ["퓧", "pwih"], ["퓍", "pwiG"], ["퓓", "pwiD"], ["퓝", "pwiB"], ["퓌", "pwi"],
    ["퓉", "pwet"], ["퓄", "pwess"], ["퓃", "pwes"], ["퓊", "pwep"], ["풭", "pwot"], ["풨", "pwoss"], ["풧", "pwos"], ["풮", "pwop"],
    ["풩", "pwong"], ["풘", "pwon"], ["풤", "pwom"], ["풜", "pwoL"], ["풖", "pwokk"], ["풬", "pwok"], ["풪", "pwoj"], ["풯", "pwoh"],
    ["풕", "pwoG"], ["풛", "pwoD"], ["풥", "pwoB"], ["풔", "pwo"], ["퓅", "pweng"], ["풴", "pwen"], ["퓀", "pwem"], ["풸", "pweL"],
    ["풲", "pwekk"], ["퓈", "pwek"], ["퓆", "pwej"], ["퓋", "pweh"], ["풱", "pweG"], ["풷", "pweD"], ["퓁", "pweB"], ["풰", "pwe"],
    ["퐡", "pwat"], ["퐜", "pwass"], ["퐛", "pwas"], ["퐢", "pwap"], ["퐝", "pwang"], ["퐌", "pwan"], ["퐘", "pwam"], ["퐐", "pwaL"],
    ["퐊", "pwakk"], ["퐠", "pwak"], ["퐞", "pwaj"], ["퐣", "pwah"], ["퐉", "pwaG"], ["퐽", "pwaet"], ["퐸", "pwaess"], ["퐷", "pwaes"],
    ["퐾", "pwaep"], ["퐹", "pwaeng"], ["퐨", "pwaen"], ["퐴", "pwaem"], ["퐬", "pwaeL"], ["퐦", "pwaekk"], ["퐼", "pwaek"], ["퐺", "pwaej"],
    ["퐿", "pwaeh"], ["퐥", "pwaeG"], ["퐫", "pwaeD"], ["퐵", "pwaeB"], ["퐤", "pwae"], ["퐏", "pwaD"], ["퐙", "pwaB"], ["퐈", "pwa"],
    ["풑", "put"], ["풌", "puss"], ["풋", "pus"], ["풒", "pup"], ["풍", "pung"], ["푼", "pun"], ["품", "pum"], ["풀", "puL"],
    ["푺", "pukk"], ["풐", "puk"], ["풎", "puj"], ["풓", "puh"], ["푹", "puG"], ["푿", "puD"], ["풉", "puB"], ["푸", "pu"],
    ["퐅", "pot"], ["퐀", "poss"], ["폿", "pos"], ["퐆", "pop"], ["퐁", "pong"], ["폰", "pon"], ["폼", "pom"], ["폴", "poL"],
    ["폮", "pokk"], ["퐄", "pok"], ["퐂", "poj"], ["퐇", "poh"], ["폭", "poG"], ["푙", "poet"], ["푔", "poess"], ["푓", "poes"],
    ["푚", "poep"], ["푕", "poeng"], ["푄", "poen"], ["푐", "poem"], ["푈", "poeL"], ["푂", "poekk"], ["푘", "poek"], ["푖", "poej"],
    ["푛", "poeh"], ["푁", "poeG"], ["푇", "poeD"], ["푑", "poeB"], ["푀", "poe"], ["폳", "poD"], ["폽", "poB"], ["포", "po"],
    ["핕", "pit"], ["핐", "piss"], ["핏", "pis"], ["핖", "pip"], ["핑", "ping"], ["핀", "pin"], ["핌", "pim"], ["필", "piL"],
    ["픾", "pikk"], ["핔", "pik"], ["핒", "pij"], ["핗", "pih"], ["픽", "piG"], ["핃", "piD"], ["핍", "piB"], ["피", "pi"],
    ["픝", "peut"], ["픘", "peuss"], ["픗", "peus"], ["픞", "peup"], ["픙", "peung"], ["픈", "peun"], ["픔", "peum"], ["플", "peuL"],
    ["픆", "peukk"], ["픜", "peuk"], ["픚", "peuj"], ["픟", "peuh"], ["픅", "peuG"], ["픋", "peuD"], ["픕", "peuB"], ["프", "peu"],
    ["펱", "pet"], ["펬", "pess"], ["펫", "pes"], ["펲", "pep"], ["펕", "peot"], ["펐", "peoss"], ["펏", "peos"], ["펖", "peop"],
    ["펑", "peong"], ["펀", "peon"], ["펌", "peom"], ["펄", "peoL"], ["퍾", "peokk"], ["펔", "peok"], ["펒", "peoj"], ["펗", "peoh"],
    ["퍽", "peoG"], ["펃", "peoD"], ["펍", "peoB"], ["퍼", "peo"], ["펭", "peng"], ["펜", "pen"], ["펨", "pem"], ["펠", "peL"],
    ["펚", "pekk"], ["펰", "pek"], ["펮", "pej"], ["펳", "peh"], ["펙", "peG"], ["펟", "peD"], ["펩", "peB"], ["페", "pe"],
    ["팥", "pat"], ["팠", "pass"], ["팟", "pas"], ["팦", "pap"], ["팡", "pang"], ["판", "pan"], ["팜", "pam"], ["팔", "paL"],
    ["팎", "pakk"], ["팤", "pak"], ["팢", "paj"], ["팧", "pah"], ["팍", "paG"], ["퍁", "paet"], ["팼", "paess"], ["팻", "paes"],
    ["퍂", "paep"], ["팽", "paeng"], ["팬", "paen"], ["팸", "paem"], ["팰", "paeL"], ["팪", "paekk"], ["퍀", "paek"], ["팾", "paej"],
    ["퍃", "paeh"], ["팩", "paeG"], ["팯", "paeD"], ["팹", "paeB"], ["패", "pae"], ["팓", "paD"], ["팝", "paB"], ["파", "pa"],
    ["큩", "kyut"], ["큤", "kyuss"], ["큣", "kyus"], ["큪", "kyup"], ["큥", "kyung"], ["큔", "kyun"], ["큠", "kyum"], ["큘", "kyuL"],
    ["큒", "kyukk"], ["큨", "kyuk"], ["큦", "kyuj"], ["큫", "kyuh"], ["큑", "kyuG"], ["큗", "kyuD"], ["큡", "kyuB"], ["큐", "kyu"],
    ["쿝", "kyot"], ["쿘", "kyoss"], ["쿗", "kyos"], ["쿞", "kyop"], ["쿙", "kyong"], ["쿈", "kyon"], ["쿔", "kyom"], ["쿌", "kyoL"],
    ["쿆", "kyokk"], ["쿜", "kyok"], ["쿚", "kyoj"], ["쿟", "kyoh"], ["쿅", "kyoG"], ["쿋", "kyoD"], ["쿕", "kyoB"], ["쿄", "kyo"],
    ["킡", "kuit"], ["킜", "kuiss"], ["킛", "kuis"], ["킢", "kuip"], ["킝", "kuing"], ["킌", "kuin"], ["킘", "kuim"], ["킐", "kuiL"],
    ["킊", "kuikk"], ["킠", "kuik"], ["킞", "kuij"], ["킣", "kuih"], ["킉", "kuiG"], ["킏", "kuiD"], ["킙", "kuiB"], ["킈", "kui"],
    ["콑", "kyet"], ["콌", "kyess"], ["콋", "kyes"], ["콒", "kyep"], ["켵", "kyeot"], ["켰", "kyeoss"], ["켯", "kyeos"], ["켶", "kyeop"],
    ["켱", "kyeong"], ["켠", "kyeon"], ["켬", "kyeom"], ["켤", "kyeoL"], ["켞", "kyeokk"], ["켴", "kyeok"], ["켲", "kyeoj"], ["켷", "kyeoh"],
    ["켝", "kyeoG"], ["켣", "kyeoD"], ["켭", "kyeoB"], ["켜", "kyeo"], ["콍", "kyeng"], ["켼", "kyen"], ["콈", "kyem"], ["콀", "kyeL"],
    ["켺", "kyekk"], ["콐", "kyek"], ["콎", "kyej"], ["콓", "kyeh"], ["켹", "kyeG"], ["켿", "kyeD"], ["콉", "kyeB"], ["켸", "kye"],
    ["컅", "kyat"], ["컀", "kyass"], ["캿", "kyas"], ["컆", "kyap"], ["컁", "kyang"], ["캰", "kyan"], ["캼", "kyam"], ["캴", "kyaL"],
    ["캮", "kyakk"], ["컄", "kyak"], ["컂", "kyaj"], ["컇", "kyah"], ["캭", "kyaG"], ["컡", "kyaet"], ["컜", "kyaess"], ["컛", "kyaes"],
    ["컢", "kyaep"], ["컝", "kyaeng"], ["컌", "kyaen"], ["컘", "kyaem"], ["컐", "kyaeL"], ["컊", "kyaekk"], ["컠", "kyaek"], ["컞", "kyaej"],
    ["컣", "kyaeh"], ["컉", "kyaeG"], ["컏", "kyaeD"], ["컙", "kyaeB"], ["컈", "kyae"], ["캳", "kyaD"], ["캽", "kyaB"], ["캬", "kya"],
    ["큍", "kwit"], ["큈", "kwiss"], ["큇", "kwis"], ["큎", "kwip"], ["큉", "kwing"], ["퀸", "kwin"], ["큄", "kwim"], ["퀼", "kwiL"],
    ["퀶", "kwikk"], ["큌", "kwik"], ["큊", "kwij"], ["큏", "kwih"], ["퀵", "kwiG"], ["퀻", "kwiD"], ["큅", "kwiB"], ["퀴", "kwi"],
    ["퀱", "kwet"], ["퀬", "kwess"], ["퀫", "kwes"], ["퀲", "kwep"], ["퀕", "kwot"], ["퀐", "kwoss"], ["퀏", "kwos"], ["퀖", "kwop"],
    ["퀑", "kwong"], ["퀀", "kwon"], ["퀌", "kwom"], ["퀄", "kwoL"], ["쿾", "kwokk"], ["퀔", "kwok"], ["퀒", "kwoj"], ["퀗", "kwoh"],
    ["쿽", "kwoG"], ["퀃", "kwoD"], ["퀍", "kwoB"], ["쿼", "kwo"], ["퀭", "kweng"], ["퀜", "kwen"], ["퀨", "kwem"], ["퀠", "kweL"],
    ["퀚", "kwekk"], ["퀰", "kwek"], ["퀮", "kwej"], ["퀳", "kweh"], ["퀙", "kweG"], ["퀟", "kweD"], ["퀩", "kweB"], ["퀘", "kwe"],
    ["쾉", "kwat"], ["쾄", "kwass"], ["쾃", "kwas"], ["쾊", "kwap"], ["쾅", "kwang"], ["콴", "kwan"], ["쾀", "kwam"], ["콸", "kwaL"],
    ["콲", "kwakk"], ["쾈", "kwak"], ["쾆", "kwaj"], ["쾋", "kwah"], ["콱", "kwaG"], ["쾥", "kwaet"], ["쾠", "kwaess"], ["쾟", "kwaes"],
    ["쾦", "kwaep"], ["쾡", "kwaeng"], ["쾐", "kwaen"], ["쾜", "kwaem"], ["쾔", "kwaeL"], ["쾎", "kwaekk"], ["쾤", "kwaek"], ["쾢", "kwaej"],
    ["쾧", "kwaeh"], ["쾍", "kwaeG"], ["쾓", "kwaeD"], ["쾝", "kwaeB"], ["쾌", "kwae"], ["콷", "kwaD"], ["쾁", "kwaB"], ["콰", "kwa"],
    ["쿹", "kut"], ["쿴", "kuss"], ["쿳", "kus"], ["쿺", "kup"], ["쿵", "kung"], ["쿤", "kun"], ["쿰", "kum"], ["쿨", "kuL"],
    ["쿢", "kukk"], ["쿸", "kuk"], ["쿶", "kuj"], ["쿻", "kuh"], ["쿡", "kuG"], ["쿧", "kuD"], ["쿱", "kuB"], ["쿠", "ku"],
    ["콭", "kot"], ["콨", "koss"], ["콧", "kos"], ["콮", "kop"], ["콩", "kong"], ["콘", "kon"], ["콤", "kom"], ["콜", "koL"],
    ["콖", "kokk"], ["콬", "kok"], ["콪", "koj"], ["콯", "koh"], ["콕", "koG"], ["쿁", "koet"], ["쾼", "koess"], ["쾻", "koes"],
    ["쿂", "koep"], ["쾽", "koeng"], ["쾬", "koen"], ["쾸", "koem"], ["쾰", "koeL"], ["쾪", "koekk"], ["쿀", "koek"], ["쾾", "koej"],
    ["쿃", "koeh"], ["쾩", "koeG"], ["쾯", "koeD"], ["쾹", "koeB"], ["쾨", "koe"], ["콛", "koD"], ["콥", "koB"], ["코", "ko"],
    ["킽", "kit"], ["킸", "kiss"], ["킷", "kis"], ["킾", "kip"], ["킹", "king"], ["킨", "kin"], ["킴", "kim"], ["킬", "kiL"],
    ["킦", "kikk"], ["킼", "kik"], ["킺", "kij"], ["킿", "kih"], ["킥", "kiG"], ["킫", "kiD"], ["킵", "kiB"], ["키", "ki"],
    ["킅", "keut"], ["킀", "keuss"], ["큿", "keus"], ["킆", "keup"], ["킁", "keung"], ["큰", "keun"], ["큼", "keum"], ["클", "keuL"],
    ["큮", "keukk"], ["킄", "keuk"], ["킂", "keuj"], ["킇", "keuh"], ["큭", "keuG"], ["큳", "keuD"], ["큽", "keuB"], ["크", "keu"],
    ["켙", "ket"], ["켔", "kess"], ["켓", "kes"], ["켚", "kep"], ["컽", "keot"], ["컸", "keoss"], ["컷", "keos"], ["컾", "keop"],
    ["컹", "keong"], ["컨", "keon"], ["컴", "keom"], ["컬", "keoL"], ["컦", "keokk"], ["컼", "keok"], ["컺", "keoj"], ["컿", "keoh"],
    ["컥", "keoG"], ["컫", "keoD"], ["컵", "keoB"], ["커", "keo"], ["켕", "keng"], ["켄", "ken"], ["켐", "kem"], ["켈", "keL"],
    ["켂", "kekk"], ["켘", "kek"], ["켖", "kej"], ["켛", "keh"], ["켁", "keG"], ["켇", "keD"], ["켑", "keB"], ["케", "ke"],
    ["캍", "kat"], ["캈", "kass"], ["캇", "kas"], ["캎", "kap"], ["캉", "kang"], ["칸", "kan"], ["캄", "kam"], ["칼", "kaL"],
    ["칶", "kakk"], ["캌", "kak"], ["캊", "kaj"], ["캏", "kah"], ["칵", "kaG"], ["캩", "kaet"], ["캤", "kaess"], ["캣", "kaes"],
    ["캪", "kaep"], ["캥", "kaeng"], ["캔", "kaen"], ["캠", "kaem"], ["캘", "kaeL"], ["캒", "kaekk"], ["캨", "kaek"], ["캦", "kaej"],
    ["캫", "kaeh"], ["캑", "kaeG"], ["캗", "kaeD"], ["캡", "kaeB"], ["캐", "kae"], ["칻", "kaD"], ["캅", "kaB"], ["카", "ka"],
    ["흍", "hyut"], ["흈", "hyuss"], ["흇", "hyus"], ["흎", "hyup"], ["흉", "hyung"], ["휸", "hyun"], ["흄", "hyum"], ["휼", "hyuL"],
    ["휶", "hyukk"], ["흌", "hyuk"], ["흊", "hyuj"], ["흏", "hyuh"], ["휵", "hyuG"], ["휻", "hyuD"], ["흅", "hyuB"], ["휴", "hyu"],
    ["훁", "hyot"], ["횼", "hyoss"], ["횻", "hyos"], ["훂", "hyop"], ["횽", "hyong"], ["횬", "hyon"], ["횸", "hyom"], ["횰", "hyoL"],
    ["횪", "hyokk"], ["훀", "hyok"], ["횾", "hyoj"], ["훃", "hyoh"], ["횩", "hyoG"], ["횯", "hyoD"], ["횹", "hyoB"], ["효", "hyo"],
    ["힅", "huit"], ["힀", "huiss"], ["흿", "huis"], ["힆", "huip"], ["힁", "huing"], ["흰", "huin"], ["흼", "huim"], ["흴", "huiL"],
    ["흮", "huikk"], ["힄", "huik"], ["힂", "huij"], ["힇", "huih"], ["흭", "huiG"], ["흳", "huiD"], ["흽", "huiB"], ["희", "hui"],
    ["혵", "hyet"], ["혰", "hyess"], ["혯", "hyes"], ["혶", "hyep"], ["혙", "hyeot"], ["혔", "hyeoss"], ["혓", "hyeos"], ["혚", "hyeop"],
    ["형", "hyeong"], ["현", "hyeon"], ["혐", "hyeom"], ["혈", "hyeoL"], ["혂", "hyeokk"], ["혘", "hyeok"], ["혖", "hyeoj"], ["혛", "hyeoh"],
    ["혁", "hyeoG"], ["혇", "hyeoD"], ["협", "hyeoB"], ["혀", "hyeo"], ["혱", "hyeng"], ["혠", "hyen"], ["혬", "hyem"], ["혤", "hyeL"],
    ["혞", "hyekk"], ["혴", "hyek"], ["혲", "hyej"], ["혷", "hyeh"], ["혝", "hyeG"], ["혣", "hyeD"], ["혭", "hyeB"], ["혜", "hye"],
    ["햩", "hyat"], ["햤", "hyass"], ["햣", "hyas"], ["햪", "hyap"], ["향", "hyang"], ["햔", "hyan"], ["햠", "hyam"], ["햘", "hyaL"],
    ["햒", "hyakk"], ["햨", "hyak"], ["햦", "hyaj"], ["햫", "hyah"], ["햑", "hyaG"], ["헅", "hyaet"], ["헀", "hyaess"], ["햿", "hyaes"],
    ["헆", "hyaep"], ["헁", "hyaeng"], ["햰", "hyaen"], ["햼", "hyaem"], ["햴", "hyaeL"], ["햮", "hyaekk"], ["헄", "hyaek"], ["헂", "hyaej"],
    ["헇", "hyaeh"], ["햭", "hyaeG"], ["햳", "hyaeD"], ["햽", "hyaeB"], ["햬", "hyae"], ["햗", "hyaD"], ["햡", "hyaB"], ["햐", "hya"],
    ["휱", "hwit"], ["휬", "hwiss"], ["휫", "hwis"], ["휲", "hwip"], ["휭", "hwing"], ["휜", "hwin"], ["휨", "hwim"], ["휠", "hwiL"],
    ["휚", "hwikk"], ["휰", "hwik"], ["휮", "hwij"], ["휳", "hwih"], ["휙", "hwiG"], ["휟", "hwiD"], ["휩", "hwiB"], ["휘", "hwi"],
    ["휕", "hwet"], ["휐", "hwess"], ["휏", "hwes"], ["휖", "hwep"], ["훹", "hwot"], ["훴", "hwoss"], ["훳", "hwos"], ["훺", "hwop"],
    ["훵", "hwong"], ["훤", "hwon"], ["훰", "hwom"], ["훨", "hwoL"], ["훢", "hwokk"], ["훸", "hwok"], ["훶", "hwoj"], ["훻", "hwoh"],
    ["훡", "hwoG"], ["훧", "hwoD"], ["훱", "hwoB"], ["훠", "hwo"], ["휑", "hweng"], ["휀", "hwen"], ["휌", "hwem"], ["휄", "hweL"],
    ["훾", "hwekk"], ["휔", "hwek"], ["휒", "hwej"], ["휗", "hweh"], ["훽", "hweG"], ["휃", "hweD"], ["휍", "hweB"], ["훼", "hwe"],
    ["홭", "hwat"], ["홨", "hwass"], ["홧", "hwas"], ["홮", "hwap"], ["황", "hwang"], ["환", "hwan"], ["홤", "hwam"], ["활", "hwaL"],
    ["홖", "hwakk"], ["홬", "hwak"], ["홪", "hwaj"], ["홯", "hwah"], ["확", "hwaG"], ["횉", "hwaet"], ["횄", "hwaess"], ["횃", "hwaes"],
    ["횊", "hwaep"], ["횅", "hwaeng"], ["홴", "hwaen"], ["횀", "hwaem"], ["홸", "hwaeL"], ["홲", "hwaekk"], ["횈", "hwaek"], ["횆", "hwaej"],
    ["횋", "hwaeh"], ["홱", "hwaeG"], ["홷", "hwaeD"], ["횁", "hwaeB"], ["홰", "hwae"], ["홛", "hwaD"], ["홥", "hwaB"], ["화", "hwa"],
    ["훝", "hut"], ["훘", "huss"], ["훗", "hus"], ["훞", "hup"], ["훙", "hung"], ["훈", "hun"], ["훔", "hum"], ["훌", "huL"],
    ["훆", "hukk"], ["훜", "huk"], ["훚", "huj"], ["훟", "huh"], ["훅", "huG"], ["훋", "huD"], ["훕", "huB"], ["후", "hu"],
    ["홑", "hot"], ["홌", "hoss"], ["홋", "hos"], ["홒", "hop"], ["홍", "hong"], ["혼", "hon"], ["홈", "hom"], ["홀", "hoL"],
    ["혺", "hokk"], ["홐", "hok"], ["홎", "hoj"], ["홓", "hoh"], ["혹", "hoG"], ["횥", "hoet"], ["횠", "hoess"], ["횟", "hoes"],
    ["횦", "hoep"], ["횡", "hoeng"], ["횐", "hoen"], ["횜", "hoem"], ["횔", "hoeL"], ["횎", "hoekk"], ["횤", "hoek"], ["횢", "hoej"],
    ["횧", "hoeh"], ["획", "hoeG"], ["횓", "hoeD"], ["횝", "hoeB"], ["회", "hoe"], ["혿", "hoD"], ["홉", "hoB"], ["호", "ho"],
    ["힡", "hit"], ["힜", "hiss"], ["힛", "his"], ["힢", "hip"], ["힝", "hing"], ["힌", "hin"], ["힘", "him"], ["힐", "hiL"],
    ["힊", "hikk"], ["힠", "hik"], ["힞", "hij"], ["힣", "hih"], ["힉", "hiG"], ["힏", "hiD"], ["힙", "hiB"], ["히", "hi"],
    ["흩", "heut"], ["흤", "heuss"], ["흣", "heus"], ["흪", "heup"], ["흥", "heung"], ["흔", "heun"], ["흠", "heum"], ["흘", "heuL"],
    ["흒", "heukk"], ["흨", "heuk"], ["흦", "heuj"], ["흫", "heuh"], ["흑", "heuG"], ["흗", "heuD"], ["흡", "heuB"], ["흐", "heu"],
    ["헽", "het"], ["헸", "hess"], ["헷", "hes"], ["헾", "hep"], ["헡", "heot"], ["헜", "heoss"], ["헛", "heos"], ["헢", "heop"],
    ["헝", "heong"], ["헌", "heon"], ["험", "heom"], ["헐", "heoL"], ["헊", "heokk"], ["헠", "heok"], ["헞", "heoj"], ["헣", "heoh"],
    ["헉", "heoG"], ["헏", "heoD"], ["헙", "heoB"], ["허", "heo"], ["헹", "heng"], ["헨", "hen"], ["헴", "hem"], ["헬", "heL"],
    ["헦", "hekk"], ["헼", "hek"], ["헺", "hej"], ["헿", "heh"], ["헥", "heG"], ["헫", "heD"], ["헵", "heB"], ["헤", "he"],
    ["핱", "hat"], ["핬", "hass"], ["핫", "has"], ["핲", "hap"], ["항", "hang"], ["한", "han"], ["함", "ham"], ["할", "haL"],
    ["핚", "hakk"], ["핰", "hak"], ["핮", "haj"], ["핳", "hah"], ["학", "haG"], ["햍", "haet"], ["했", "haess"], ["햇", "haes"],
    ["햎", "haep"], ["행", "haeng"], ["핸", "haen"], ["햄", "haem"], ["핼", "hael"], ["핶", "haekk"], ["햌", "haek"], ["햊", "haej"],
    ["햏", "haeh"], ["핵", "haek"], ["핻", "haeD"], ["햅", "haeB"], ["해", "hae"], ["핟", "hat"], ["합", "hap"], ["하", "ha"],
    ["갉", "galk"], ["갊", "galm"], ["갋", "galp"], ["갌", "gals"], ["갍", "galt"], ["갎", "galp"], ["갏", "galh"], ["갥", "gaelk"],
    ["갦", "gaelm"], ["갧", "gaelp"], ["갨", "gaels"], ["갩", "gaelt"], ["갪", "gaelp"], ["갫", "gaelh"], ["걁", "gyalk"], ["걂", "gyalm"],
    ["걃", "gyalp"], ["걄", "gyals"], ["걅", "gyalt"], ["걆", "gyalp"], ["걇", "gyalh"], ["걝", "gyaelk"], ["걞", "gyaelm"], ["걟", "gyaelp"],
    ["걠", "gyaels"], ["걡", "gyaelt"], ["걢", "gyaelp"], ["걣", "gyaelh"], ["걹", "geolk"], ["걺", "geolm"], ["걻", "geolp"], ["걼", "geols"],
    ["걽", "geolt"], ["걾", "geolp"], ["걿", "geolh"], ["겕", "gelk"], ["겖", "gelm"], ["겗", "gelp"], ["겘", "gels"], ["겙", "gelt"],
    ["겚", "gelp"], ["겛", "gelh"], ["겱", "gyeolk"], ["겲", "gyeolm"], ["겳", "gyeolp"], ["겴", "gyeols"], ["겵", "gyeolt"], ["겶", "gyeolp"],
    ["겷", "gyeolh"], ["곍", "gyelk"], ["곎", "gyelm"], ["곏", "gyelp"], ["곐", "gyels"], ["곑", "gyelt"], ["곒", "gyelp"], ["곓", "gyelh"],
    ["곩", "golk"], ["곪", "golm"], ["곫", "golp"], ["곬", "gols"], ["곭", "golt"], ["곮", "golp"], ["곯", "golh"], ["괅", "gwalk"],
    ["괆", "gwalm"], ["괇", "gwalp"], ["괈", "gwals"], ["괉", "gwalt"], ["괊", "gwalp"], ["괋", "gwalh"], ["괡", "gwaelk"], ["괢", "gwaelm"],
    ["괣", "gwaelp"], ["괤", "gwaels"], ["괥", "gwaelt"], ["괦", "gwaelp"], ["괧", "gwaelh"], ["괽", "goelk"], ["괾", "goelm"], ["괿", "goelp"],
    ["굀", "goels"], ["굁", "goelt"], ["굂", "goelp"], ["굃", "goelh"], ["굙", "gyolk"], ["굚", "gyolm"], ["굛", "gyolp"], ["굜", "gyols"],
    ["굝", "gyolt"], ["굞", "gyolp"], ["굟", "gyolh"], ["굵", "gulk"], ["굶", "gulm"], ["굷", "gulp"], ["굸", "guls"], ["굹", "gult"],
    ["굺", "gulp"], ["굻", "gulh"], ["궑", "gwolk"], ["궒", "gwolm"], ["궓", "gwolp"], ["궔", "gwols"], ["궕", "gwolt"], ["궖", "gwolp"],
    ["궗", "gwolh"], ["궭", "gwelk"], ["궮", "gwelm"], ["궯", "gwelp"], ["궰", "gwels"], ["궱", "gwelt"], ["궲", "gwelp"], ["궳", "gwelh"],
    ["귉", "gwilk"], ["귊", "gwilm"], ["귋", "gwilp"], ["귌", "gwils"], ["귍", "gwilt"], ["귎", "gwilp"], ["귏", "gwilh"], ["귥", "gyulk"],
    ["귦", "gyulm"], ["귧", "gyulp"], ["귨", "gyuls"], ["귩", "gyult"], ["귪", "gyulp"], ["귫", "gyulh"], ["긁", "geulk"], ["긂", "geulm"],
    ["긃", "geulp"], ["긄", "geuls"], ["긅", "geult"], ["긆", "geulp"], ["긇", "geulh"], ["긝", "guilk"], ["긞", "guilm"], ["긟", "guilp"],
    ["긠", "guils"], ["긡", "guilt"], ["긢", "guilp"], ["긣", "guilh"], ["긹", "gilk"], ["긺", "gilm"], ["긻", "gilp"], ["긼", "gils"],
    ["긽", "gilt"], ["긾", "gilp"], ["긿", "gilh"], ["깕", "kkalk"], ["깖", "kkalm"], ["깗", "kkalp"], ["깘", "kkals"], ["깙", "kkalt"],
    ["깚", "kkalp"], ["깛", "kkalh"], ["깱", "kkaelk"], ["깲", "kkaelm"], ["깳", "kkaelp"], ["깴", "kkaels"], ["깵", "kkaelt"], ["깶", "kkaelp"],
    ["깷", "kkaelh"], ["꺍", "kkyalk"], ["꺎", "kkyalm"], ["꺏", "kkyalp"], ["꺐", "kkyals"], ["꺑", "kkyalt"], ["꺒", "kkyalp"], ["꺓", "kkyalh"],
    ["꺩", "kkyaelk"], ["꺪", "kkyaelm"], ["꺫", "kkyaelp"], ["꺬", "kkyaels"], ["꺭", "kkyaelt"], ["꺮", "kkyaelp"], ["꺯", "kkyaelh"], ["껅", "kkeolk"],
    ["껆", "kkeolm"], ["껇", "kkeolp"], ["껈", "kkeols"], ["껉", "kkeolt"], ["껊", "kkeolp"], ["껋", "kkeolh"], ["껡", "kkelk"], ["껢", "kkelm"],
    ["껣", "kkelp"], ["껤", "kkels"], ["껥", "kkelt"], ["껦", "kkelp"], ["껧", "kkelh"], ["껽", "kkyeolk"], ["껾", "kkyeolm"], ["껿", "kkyeolp"],
    ["꼀", "kkyeols"], ["꼁", "kkyeolt"], ["꼂", "kkyeolp"], ["꼃", "kkyeolh"], ["꼙", "kkyelk"], ["꼚", "kkyelm"], ["꼛", "kkyelp"], ["꼜", "kkyels"],
    ["꼝", "kkyelt"], ["꼞", "kkyelp"], ["꼟", "kkyelh"], ["꼵", "kkolk"], ["꼶", "kkolm"], ["꼷", "kkolp"], ["꼸", "kkols"], ["꼹", "kkolt"],
    ["꼺", "kkolp"], ["꼻", "kkolh"], ["꽑", "kkwalk"], ["꽒", "kkwalm"], ["꽓", "kkwalp"], ["꽔", "kkwals"], ["꽕", "kkwalt"], ["꽖", "kkwalp"],
    ["꽗", "kkwalh"], ["꽭", "kkwaelk"], ["꽮", "kkwaelm"], ["꽯", "kkwaelp"], ["꽰", "kkwaels"], ["꽱", "kkwaelt"], ["꽲", "kkwaelp"], ["꽳", "kkwaelh"],
    ["꾉", "kkoelk"], ["꾊", "kkoelm"], ["꾋", "kkoelp"], ["꾌", "kkoels"], ["꾍", "kkoelt"], ["꾎", "kkoelp"], ["꾏", "kkoelh"], ["꾥", "kkyolk"],
    ["꾦", "kkyolm"], ["꾧", "kkyolp"], ["꾨", "kkyols"], ["꾩", "kkyolt"], ["꾪", "kkyolp"], ["꾫", "kkyolh"], ["꿁", "kkulk"], ["꿂", "kkulm"],
    ["꿃", "kkulp"], ["꿄", "kkuls"], ["꿅", "kkult"], ["꿆", "kkulp"], ["꿇", "kkulh"], ["꿝", "kkwolk"], ["꿞", "kkwolm"], ["꿟", "kkwolp"],
    ["꿠", "kkwols"], ["꿡", "kkwolt"], ["꿢", "kkwolp"], ["꿣", "kkwolh"], ["꿹", "kkwelk"], ["꿺", "kkwelm"], ["꿻", "kkwelp"], ["꿼", "kkwels"],
    ["꿽", "kkwelt"], ["꿾", "kkwelp"], ["꿿", "kkwelh"], ["뀕", "kkwilk"], ["뀖", "kkwilm"], ["뀗", "kkwilp"], ["뀘", "kkwils"], ["뀙", "kkwilt"],
    ["뀚", "kkwilp"], ["뀛", "kkwilh"], ["뀱", "kkyulk"], ["뀲", "kkyulm"], ["뀳", "kkyulp"], ["뀴", "kkyuls"], ["뀵", "kkyult"], ["뀶", "kkyulp"],
    ["뀷", "kkyulh"], ["끍", "kkeulk"], ["끎", "kkeulm"], ["끏", "kkeulp"], ["끐", "kkeuls"], ["끑", "kkeult"], ["끒", "kkeulp"], ["끓", "kkeulh"],
    ["끩", "kkuilk"], ["끪", "kkuilm"], ["끫", "kkuilp"], ["끬", "kkuils"], ["끭", "kkuilt"], ["끮", "kkuilp"], ["끯", "kkuilh"], ["낅", "kkilk"],
    ["낆", "kkilm"], ["낇", "kkilp"], ["낈", "kkils"], ["낉", "kkilt"], ["낊", "kkilp"], ["낋", "kkilh"], ["낡", "nalk"], ["낢", "nalm"],
    ["낣", "nalp"], ["낤", "nals"], ["낥", "nalt"], ["낦", "nalp"], ["낧", "nalh"], ["낽", "naelk"], ["낾", "naelm"], ["낿", "naelp"],
    ["냀", "naels"], ["냁", "naelt"], ["냂", "naelp"], ["냃", "naelh"], ["냙", "nyalk"], ["냚", "nyalm"], ["냛", "nyalp"], ["냜", "nyals"],
    ["냝", "nyalt"], ["냞", "nyalp"], ["냟", "nyalh"], ["냵", "nyaelk"], ["냶", "nyaelm"], ["냷", "nyaelp"], ["냸", "nyaels"], ["냹", "nyaelt"],
    ["냺", "nyaelp"], ["냻", "nyaelh"], ["넑", "neolk"], ["넒", "neolm"], ["넓", "neolp"], ["넔", "neols"], ["넕", "neolt"], ["넖", "neolp"],
    ["넗", "neolh"], ["넭", "nelk"], ["넮", "nelm"], ["넯", "nelp"], ["넰", "nels"], ["넱", "nelt"], ["넲", "nelp"], ["넳", "nelh"],
    ["녉", "nyeolk"], ["녊", "nyeolm"], ["녋", "nyeolp"], ["녌", "nyeols"], ["녍", "nyeolt"], ["녎", "nyeolp"], ["녏", "nyeolh"], ["녥", "nyelk"],
    ["녦", "nyelm"], ["녧", "nyelp"], ["녨", "nyels"], ["녩", "nyelt"], ["녪", "nyelp"], ["녫", "nyelh"], ["놁", "nolk"], ["놂", "nolm"],
    ["놃", "nolp"], ["놄", "nols"], ["놅", "nolt"], ["놆", "nolp"], ["놇", "nolh"], ["놝", "nwalk"], ["놞", "nwalm"], ["놟", "nwalp"],
    ["놠", "nwals"], ["놡", "nwalt"], ["놢", "nwalp"], ["놣", "nwalh"], ["놹", "nwaelk"], ["놺", "nwaelm"], ["놻", "nwaelp"], ["놼", "nwaels"],
    ["놽", "nwaelt"], ["놾", "nwaelp"], ["놿", "nwaelh"], ["뇕", "noelk"], ["뇖", "noelm"], ["뇗", "noelp"], ["뇘", "noels"], ["뇙", "noelt"],
    ["뇚", "noelp"], ["뇛", "noelh"], ["뇱", "nyolk"], ["뇲", "nyolm"], ["뇳", "nyolp"], ["뇴", "nyols"], ["뇵", "nyolt"], ["뇶", "nyolp"],
    ["뇷", "nyolh"], ["눍", "nulk"], ["눎", "nulm"], ["눏", "nulp"], ["눐", "nuls"], ["눑", "nult"], ["눒", "nulp"], ["눓", "nulh"],
    ["눩", "nwolk"], ["눪", "nwolm"], ["눫", "nwolp"], ["눬", "nwols"], ["눭", "nwolt"], ["눮", "nwolp"], ["눯", "nwolh"], ["뉅", "nwelk"],
    ["뉆", "nwelm"], ["뉇", "nwelp"], ["뉈", "nwels"], ["뉉", "nwelt"], ["뉊", "nwelp"], ["뉋", "nwelh"], ["뉡", "nwilk"], ["뉢", "nwilm"],
    ["뉣", "nwilp"], ["뉤", "nwils"], ["뉥", "nwilt"], ["뉦", "nwilp"], ["뉧", "nwilh"], ["뉽", "nyulk"], ["뉾", "nyulm"], ["뉿", "nyulp"],
    ["늀", "nyuls"], ["늁", "nyult"], ["늂", "nyulp"], ["늃", "nyulh"], ["늙", "neulk"], ["늚", "neulm"], ["늛", "neulp"], ["늜", "neuls"],
    ["늝", "neult"], ["늞", "neulp"], ["늟", "neulh"], ["늵", "nuilk"], ["늶", "nuilm"], ["늷", "nuilp"], ["늸", "nuils"], ["늹", "nuilt"],
    ["늺", "nuilp"], ["늻", "nuilh"], ["닑", "nilk"], ["닒", "nilm"], ["닓", "nilp"], ["닔", "nils"], ["닕", "nilt"], ["닖", "nilp"],
    ["닗", "nilh"], ["닭", "talk"], ["닮", "talm"], ["닯", "talp"], ["닰", "tals"], ["닱", "talt"], ["닲", "talp"], ["닳", "talh"],
    ["댉", "taelk"], ["댊", "taelm"], ["댋", "taelp"], ["댌", "taels"], ["댍", "taelt"], ["댎", "taelp"], ["댏", "taelh"], ["댥", "tyalk"],
    ["댦", "tyalm"], ["댧", "tyalp"], ["댨", "tyals"], ["댩", "tyalt"], ["댪", "tyalp"], ["댫", "tyalh"], ["덁", "tyaelk"], ["덂", "tyaelm"],
    ["덃", "tyaelp"], ["덄", "tyaels"], ["덅", "tyaelt"], ["덆", "tyaelp"], ["덇", "tyaelh"], ["덝", "teolk"], ["덞", "teolm"], ["덟", "teolp"],
    ["덠", "teols"], ["덡", "teolt"], ["덢", "teolp"], ["덣", "teolh"], ["덹", "telk"], ["덺", "telm"], ["덻", "telp"], ["덼", "tels"],
    ["덽", "telt"], ["덾", "telp"], ["덿", "telh"], ["뎕", "tyeolk"], ["뎖", "tyeolm"], ["뎗", "tyeolp"], ["뎘", "tyeols"], ["뎙", "tyeolt"],
    ["뎚", "tyeolp"], ["뎛", "tyeolh"], ["뎱", "tyelk"], ["뎲", "tyelm"], ["뎳", "tyelp"], ["뎴", "tyels"], ["뎵", "tyelt"], ["뎶", "tyelp"],
    ["뎷", "tyelh"], ["돍", "tolk"], ["돎", "tolm"], ["돏", "tolp"], ["돐", "tols"], ["돑", "tolt"], ["돒", "tolp"], ["돓", "tolh"],
    ["돩", "twalk"], ["돪", "twalm"], ["돫", "twalp"], ["돬", "twals"], ["돭", "twalt"], ["돮", "twalp"], ["돯", "twalh"], ["됅", "twaelk"],
    ["됆", "twaelm"], ["됇", "twaelp"], ["됈", "twaels"], ["됉", "twaelt"], ["됊", "twaelp"], ["됋", "twaelh"], ["됡", "toelk"], ["됢", "toelm"],
    ["됣", "toelp"], ["됤", "toels"], ["됥", "toelt"], ["됦", "toelp"], ["됧", "toelh"], ["됽", "tyolk"], ["됾", "tyolm"], ["됿", "tyolp"],
    ["둀", "tyols"], ["둁", "tyolt"], ["둂", "tyolp"], ["둃", "tyolh"], ["둙", "tulk"], ["둚", "tulm"], ["둛", "tulp"], ["둜", "tuls"],
    ["둝", "tult"], ["둞", "tulp"], ["둟", "tulh"], ["둵", "twolk"], ["둶", "twolm"], ["둷", "twolp"], ["둸", "twols"], ["둹", "twolt"],
    ["둺", "twolp"], ["둻", "twolh"], ["뒑", "twelk"], ["뒒", "twelm"], ["뒓", "twelp"], ["뒔", "twels"], ["뒕", "twelt"], ["뒖", "twelp"],
    ["뒗", "twelh"], ["뒭", "twilk"], ["뒮", "twilm"], ["뒯", "twilp"], ["뒰", "twils"], ["뒱", "twilt"], ["뒲", "twilp"], ["뒳", "twilh"],
    ["듉", "tyulk"], ["듊", "tyulm"], ["듋", "tyulp"], ["듌", "tyuls"], ["듍", "tyult"], ["듎", "tyulp"], ["듏", "tyulh"], ["듥", "teulk"],
    ["듦", "teulm"], ["듧", "teulp"], ["듨", "teuls"], ["듩", "teult"], ["듪", "teulp"], ["듫", "teulh"], ["딁", "tuilk"], ["딂", "tuilm"],
    ["딃", "tuilp"], ["딄", "tuils"], ["딅", "tuilt"], ["딆", "tuilp"], ["딇", "tuilh"], ["딝", "tilk"], ["딞", "tilm"], ["딟", "tilp"],
    ["딠", "tils"], ["딡", "tilt"], ["딢", "tilp"], ["딣", "tilh"], ["딹", "tdalk"], ["딺", "tdalm"], ["딻", "tdalp"], ["딼", "tdals"],
    ["딽", "tdalt"], ["딾", "tdalp"], ["딿", "tdalh"], ["땕", "tdaelk"], ["땖", "tdaelm"], ["땗", "tdaelp"], ["땘", "tdaels"], ["땙", "tdaelt"],
    ["땚", "tdaelp"], ["땛", "tdaelh"], ["땱", "tdyalk"], ["땲", "tdyalm"], ["땳", "tdyalp"], ["땴", "tdyals"], ["땵", "tdyalt"], ["땶", "tdyalp"],
    ["땷", "tdyalh"], ["떍", "tdyaelk"], ["떎", "tdyaelm"], ["떏", "tdyaelp"], ["떐", "tdyaels"], ["떑", "tdyaelt"], ["떒", "tdyaelp"], ["떓", "tdyaelh"],
    ["떩", "tdeolk"], ["떪", "tdeolm"], ["떫", "tdeolp"], ["떬", "tdeols"], ["떭", "tdeolt"], ["떮", "tdeolp"], ["떯", "tdeolh"], ["뗅", "tdelk"],
    ["뗆", "tdelm"], ["뗇", "tdelp"], ["뗈", "tdels"], ["뗉", "tdelt"], ["뗊", "tdelp"], ["뗋", "tdelh"], ["뗡", "tdyeolk"], ["뗢", "tdyeolm"],
    ["뗣", "tdyeolp"], ["뗤", "tdyeols"], ["뗥", "tdyeolt"], ["뗦", "tdyeolp"], ["뗧", "tdyeolh"], ["뗽", "tdyelk"], ["뗾", "tdyelm"], ["뗿", "tdyelp"],
    ["똀", "tdyels"], ["똁", "tdyelt"], ["똂", "tdyelp"], ["똃", "tdyelh"], ["똙", "tdolk"], ["똚", "tdolm"], ["똛", "tdolp"], ["똜", "tdols"],
    ["똝", "tdolt"], ["똞", "tdolp"], ["똟", "tdolh"], ["똵", "tdwalk"], ["똶", "tdwalm"], ["똷", "tdwalp"], ["똸", "tdwals"], ["똹", "tdwalt"],
    ["똺", "tdwalp"], ["똻", "tdwalh"], ["뙑", "tdwaelk"], ["뙒", "tdwaelm"], ["뙓", "tdwaelp"], ["뙔", "tdwaels"], ["뙕", "tdwaelt"], ["뙖", "tdwaelp"],
    ["뙗", "tdwaelh"], ["뙭", "tdoelk"], ["뙮", "tdoelm"], ["뙯", "tdoelp"], ["뙰", "tdoels"], ["뙱", "tdoelt"], ["뙲", "tdoelp"], ["뙳", "tdoelh"],
    ["뚉", "tdyolk"], ["뚊", "tdyolm"], ["뚋", "tdyolp"], ["뚌", "tdyols"], ["뚍", "tdyolt"], ["뚎", "tdyolp"], ["뚏", "tdyolh"], ["뚥", "tdulk"],
    ["뚦", "tdulm"], ["뚧", "tdulp"], ["뚨", "tduls"], ["뚩", "tdult"], ["뚪", "tdulp"], ["뚫", "tdulh"], ["뛁", "tdwolk"], ["뛂", "tdwolm"],
    ["뛃", "tdwolp"], ["뛄", "tdwols"], ["뛅", "tdwolt"], ["뛆", "tdwolp"], ["뛇", "tdwolh"], ["뛝", "tdwelk"], ["뛞", "tdwelm"], ["뛟", "tdwelp"],
    ["뛠", "tdwels"], ["뛡", "tdwelt"], ["뛢", "tdwelp"], ["뛣", "tdwelh"], ["뛹", "tdwilk"], ["뛺", "tdwilm"], ["뛻", "tdwilp"], ["뛼", "tdwils"],
    ["뛽", "tdwilt"], ["뛾", "tdwilp"], ["뛿", "tdwilh"], ["뜕", "tdyulk"], ["뜖", "tdyulm"], ["뜗", "tdyulp"], ["뜘", "tdyuls"], ["뜙", "tdyult"],
    ["뜚", "tdyulp"], ["뜛", "tdyulh"], ["뜱", "tdeulk"], ["뜲", "tdeulm"], ["뜳", "tdeulp"], ["뜴", "tdeuls"], ["뜵", "tdeult"], ["뜶", "tdeulp"],
    ["뜷", "tdeulh"], ["띍", "tduilk"], ["띎", "tduilm"], ["띏", "tduilp"], ["띐", "tduils"], ["띑", "tduilt"], ["띒", "tduilp"], ["띓", "tduilh"],
    ["띩", "tdilk"], ["띪", "tdilm"], ["띫", "tdilp"], ["띬", "tdils"], ["띭", "tdilt"], ["띮", "tdilp"], ["띯", "tdilh"], ["랅", "ralk"],
    ["랆", "ralm"], ["랇", "ralp"], ["랈", "rals"], ["랉", "ralt"], ["랊", "ralp"], ["랋", "ralh"], ["랡", "raelk"], ["랢", "raelm"],
    ["랣", "raelp"], ["랤", "raels"], ["랥", "raelt"], ["랦", "raelp"], ["랧", "raelh"], ["랽", "ryalk"], ["랾", "ryalm"], ["랿", "ryalp"],
    ["럀", "ryals"], ["럁", "ryalt"], ["럂", "ryalp"], ["럃", "ryalh"], ["럙", "ryaelk"], ["럚", "ryaelm"], ["럛", "ryaelp"], ["럜", "ryaels"],
    ["럝", "ryaelt"], ["럞", "ryaelp"], ["럟", "ryaelh"], ["럵", "reolk"], ["럶", "reolm"], ["럷", "reolp"], ["럸", "reols"], ["럹", "reolt"],
    ["럺", "reolp"], ["럻", "reolh"], ["렑", "relk"], ["렒", "relm"], ["렓", "relp"], ["렔", "rels"], ["렕", "relt"], ["렖", "relp"],
    ["렗", "relh"], ["렭", "ryeolk"], ["렮", "ryeolm"], ["렯", "ryeolp"], ["렰", "ryeols"], ["렱", "ryeolt"], ["렲", "ryeolp"], ["렳", "ryeolh"],
    ["롉", "ryelk"], ["롊", "ryelm"], ["롋", "ryelp"], ["롌", "ryels"], ["롍", "ryelt"], ["롎", "ryelp"], ["롏", "ryelh"], ["롥", "rolk"],
    ["롦", "rolm"], ["롧", "rolp"], ["롨", "rols"], ["롩", "rolt"], ["롪", "rolp"], ["롫", "rolh"], ["뢁", "rwalk"], ["뢂", "rwalm"],
    ["뢃", "rwalp"], ["뢄", "rwals"], ["뢅", "rwalt"], ["뢆", "rwalp"], ["뢇", "rwalh"], ["뢝", "rwaelk"], ["뢞", "rwaelm"], ["뢟", "rwaelp"],
    ["뢠", "rwaels"], ["뢡", "rwaelt"], ["뢢", "rwaelp"], ["뢣", "rwaelh"], ["뢹", "roelk"], ["뢺", "roelm"], ["뢻", "roelp"], ["뢼", "roels"],
    ["뢽", "roelt"], ["뢾", "roelp"], ["뢿", "roelh"], ["룕", "ryolk"], ["룖", "ryolm"], ["룗", "ryolp"], ["룘", "ryols"], ["룙", "ryolt"],
    ["룚", "ryolp"], ["룛", "ryolh"], ["룱", "rulk"], ["룲", "rulm"], ["룳", "rulp"], ["룴", "ruls"], ["룵", "rult"], ["룶", "rulp"],
    ["룷", "rulh"], ["뤍", "rwolk"], ["뤎", "rwolm"], ["뤏", "rwolp"], ["뤐", "rwols"], ["뤑", "rwolt"], ["뤒", "rwolp"], ["뤓", "rwolh"],
    ["뤩", "rwelk"], ["뤪", "rwelm"], ["뤫", "rwelp"], ["뤬", "rwels"], ["뤭", "rwelt"], ["뤮", "rwelp"], ["뤯", "rwelh"], ["륅", "rwilk"],
    ["륆", "rwilm"], ["륇", "rwilp"], ["륈", "rwils"], ["륉", "rwilt"], ["륊", "rwilp"], ["륋", "rwilh"], ["륡", "ryulk"], ["륢", "ryulm"],
    ["륣", "ryulp"], ["륤", "ryuls"], ["륥", "ryult"], ["륦", "ryulp"], ["륧", "ryulh"], ["륽", "reulk"], ["륾", "reulm"], ["륿", "reulp"],
    ["릀", "reuls"], ["릁", "reult"], ["릂", "reulp"], ["릃", "reulh"], ["릙", "ruilk"], ["릚", "ruilm"], ["릛", "ruilp"], ["릜", "ruils"],
    ["릝", "ruilt"], ["릞", "ruilp"], ["릟", "ruilh"], ["릵", "rilk"], ["릶", "rilm"], ["릷", "rilp"], ["릸", "rils"], ["릹", "rilt"],
    ["릺", "rilp"], ["릻", "rilh"], ["맑", "malk"], ["맒", "malm"], ["맓", "malp"], ["맔", "mals"], ["맕", "malt"], ["맖", "malp"],
    ["맗", "malh"], ["맭", "maelk"], ["맮", "maelm"], ["맯", "maelp"], ["맰", "maels"], ["맱", "maelt"], ["맲", "maelp"], ["맳", "maelh"],
    ["먉", "myalk"], ["먊", "myalm"], ["먋", "myalp"], ["먌", "myals"], ["먍", "myalt"], ["먎", "myalp"], ["먏", "myalh"], ["먥", "myaelk"],
    ["먦", "myaelm"], ["먧", "myaelp"], ["먨", "myaels"], ["먩", "myaelt"], ["먪", "myaelp"], ["먫", "myaelh"], ["멁", "meolk"], ["멂", "meolm"],
    ["멃", "meolp"], ["멄", "meols"], ["멅", "meolt"], ["멆", "meolp"], ["멇", "meolh"], ["멝", "melk"], ["멞", "melm"], ["멟", "melp"],
    ["멠", "mels"], ["멡", "melt"], ["멢", "melp"], ["멣", "melh"], ["멹", "myeolk"], ["멺", "myeolm"], ["멻", "myeolp"], ["멼", "myeols"],
    ["멽", "myeolt"], ["멾", "myeolp"], ["멿", "myeolh"], ["몕", "myelk"], ["몖", "myelm"], ["몗", "myelp"], ["몘", "myels"], ["몙", "myelt"],
    ["몚", "myelp"], ["몛", "myelh"], ["몱", "molk"], ["몲", "molm"], ["몳", "molp"], ["몴", "mols"], ["몵", "molt"], ["몶", "molp"],
    ["몷", "molh"], ["뫍", "mwalk"], ["뫎", "mwalm"], ["뫏", "mwalp"], ["뫐", "mwals"], ["뫑", "mwalt"], ["뫒", "mwalp"], ["뫓", "mwalh"],
    ["뫩", "mwaelk"], ["뫪", "mwaelm"], ["뫫", "mwaelp"], ["뫬", "mwaels"], ["뫭", "mwaelt"], ["뫮", "mwaelp"], ["뫯", "mwaelh"], ["묅", "moelk"],
    ["묆", "moelm"], ["묇", "moelp"], ["묈", "moels"], ["묉", "moelt"], ["묊", "moelp"], ["묋", "moelh"], ["묡", "myolk"], ["묢", "myolm"],
    ["묣", "myolp"], ["묤", "myols"], ["묥", "myolt"], ["묦", "myolp"], ["묧", "myolh"], ["묽", "mulk"], ["묾", "mulm"], ["묿", "mulp"],
    ["뭀", "muls"], ["뭁", "mult"], ["뭂", "mulp"], ["뭃", "mulh"], ["뭙", "mwolk"], ["뭚", "mwolm"], ["뭛", "mwolp"], ["뭜", "mwols"],
    ["뭝", "mwolt"], ["뭞", "mwolp"], ["뭟", "mwolh"], ["뭵", "mwelk"], ["뭶", "mwelm"], ["뭷", "mwelp"], ["뭸", "mwels"], ["뭹", "mwelt"],
    ["뭺", "mwelp"], ["뭻", "mwelh"], ["뮑", "mwilk"], ["뮒", "mwilm"], ["뮓", "mwilp"], ["뮔", "mwils"], ["뮕", "mwilt"], ["뮖", "mwilp"],
    ["뮗", "mwilh"], ["뮭", "myulk"], ["뮮", "myulm"], ["뮯", "myulp"], ["뮰", "myuls"], ["뮱", "myult"], ["뮲", "myulp"], ["뮳", "myulh"],
    ["믉", "meulk"], ["믊", "meulm"], ["믋", "meulp"], ["믌", "meuls"], ["믍", "meult"], ["믎", "meulp"], ["믏", "meulh"], ["믥", "muilk"],
    ["믦", "muilm"], ["믧", "muilp"], ["믨", "muils"], ["믩", "muilt"], ["믪", "muilp"], ["믫", "muilh"], ["밁", "milk"], ["밂", "milm"],
    ["밃", "milp"], ["밄", "mils"], ["밅", "milt"], ["밆", "milp"], ["밇", "milh"], ["밝", "balk"], ["밞", "balm"], ["밟", "balp"],
    ["밠", "bals"], ["밡", "balt"], ["밢", "balp"], ["밣", "balh"], ["밹", "baelk"], ["밺", "baelm"], ["밻", "baelp"], ["밼", "baels"],
    ["밽", "baelt"], ["밾", "baelp"], ["밿", "baelh"], ["뱕", "byalk"], ["뱖", "byalm"], ["뱗", "byalp"], ["뱘", "byals"], ["뱙", "byalt"],
    ["뱚", "byalp"], ["뱛", "byalh"], ["뱱", "byaelk"], ["뱲", "byaelm"], ["뱳", "byaelp"], ["뱴", "byaels"], ["뱵", "byaelt"], ["뱶", "byaelp"],
    ["뱷", "byaelh"], ["벍", "beolk"], ["벎", "beolm"], ["벏", "beolp"], ["벐", "beols"], ["벑", "beolt"], ["벒", "beolp"], ["벓", "beolh"],
    ["벩", "belk"], ["벪", "belm"], ["벫", "belp"], ["벬", "bels"], ["벭", "belt"], ["벮", "belp"], ["벯", "belh"], ["볅", "byeolk"],
    ["볆", "byeolm"], ["볇", "byeolp"], ["볈", "byeols"], ["볉", "byeolt"], ["볊", "byeolp"], ["볋", "byeolh"], ["볡", "byelk"], ["볢", "byelm"],
    ["볣", "byelp"], ["볤", "byels"], ["볥", "byelt"], ["볦", "byelp"], ["볧", "byelh"], ["볽", "bolk"], ["볾", "bolm"], ["볿", "bolp"],
    ["봀", "bols"], ["봁", "bolt"], ["봂", "bolp"], ["봃", "bolh"], ["봙", "bwalk"], ["봚", "bwalm"], ["봛", "bwalp"], ["봜", "bwals"],
    ["봝", "bwalt"], ["봞", "bwalp"], ["봟", "bwalh"], ["봵", "bwaelk"], ["봶", "bwaelm"], ["봷", "bwaelp"], ["봸", "bwaels"], ["봹", "bwaelt"],
    ["봺", "bwaelp"], ["봻", "bwaelh"], ["뵑", "boelk"], ["뵒", "boelm"], ["뵓", "boelp"], ["뵔", "boels"], ["뵕", "boelt"], ["뵖", "boelp"],
    ["뵗", "boelh"], ["뵭", "byolk"], ["뵮", "byolm"], ["뵯", "byolp"], ["뵰", "byols"], ["뵱", "byolt"], ["뵲", "byolp"], ["뵳", "byolh"],
    ["붉", "bulk"], ["붊", "bulm"], ["붋", "bulp"], ["붌", "buls"], ["붍", "bult"], ["붎", "bulp"], ["붏", "bulh"], ["붥", "bwolk"],
    ["붦", "bwolm"], ["붧", "bwolp"], ["붨", "bwols"], ["붩", "bwolt"], ["붪", "bwolp"], ["붫", "bwolh"], ["뷁", "bwelk"], ["뷂", "bwelm"],
    ["뷃", "bwelp"], ["뷄", "bwels"], ["뷅", "bwelt"], ["뷆", "bwelp"], ["뷇", "bwelh"], ["뷝", "bwilk"], ["뷞", "bwilm"], ["뷟", "bwilp"],
    ["뷠", "bwils"], ["뷡", "bwilt"], ["뷢", "bwilp"], ["뷣", "bwilh"], ["뷹", "byulk"], ["뷺", "byulm"], ["뷻", "byulp"], ["뷼", "byuls"],
    ["뷽", "byult"], ["뷾", "byulp"], ["뷿", "byulh"], ["븕", "beulk"], ["븖", "beulm"], ["븗", "beulp"], ["븘", "beuls"], ["븙", "beult"],
    ["븚", "beulp"], ["븛", "beulh"], ["븱", "builk"], ["븲", "builm"], ["븳", "builp"], ["븴", "buils"], ["븵", "built"], ["븶", "builp"],
    ["븷", "builh"], ["빍", "bilk"], ["빎", "bilm"], ["빏", "bilp"], ["빐", "bils"], ["빑", "bilt"], ["빒", "bilp"], ["빓", "bilh"],
    ["빩", "ppalk"], ["빪", "ppalm"], ["빫", "ppalp"], ["빬", "ppals"], ["빭", "ppalt"], ["빮", "ppalp"], ["빯", "ppalh"], ["뺅", "ppaelk"],
    ["뺆", "ppaelm"], ["뺇", "ppaelp"], ["뺈", "ppaels"], ["뺉", "ppaelt"], ["뺊", "ppaelp"], ["뺋", "ppaelh"], ["뺡", "ppyalk"], ["뺢", "ppyalm"],
    ["뺣", "ppyalp"], ["뺤", "ppyals"], ["뺥", "ppyalt"], ["뺦", "ppyalp"], ["뺧", "ppyalh"], ["뺽", "ppyaelk"], ["뺾", "ppyaelm"], ["뺿", "ppyaelp"],
    ["뻀", "ppyaels"], ["뻁", "ppyaelt"], ["뻂", "ppyaelp"], ["뻃", "ppyaelh"], ["뻙", "ppeolk"], ["뻚", "ppeolm"], ["뻛", "ppeolp"], ["뻜", "ppeols"],
    ["뻝", "ppeolt"], ["뻞", "ppeolp"], ["뻟", "ppeolh"], ["뻵", "ppelk"], ["뻶", "ppelm"], ["뻷", "ppelp"], ["뻸", "ppels"], ["뻹", "ppelt"],
    ["뻺", "ppelp"], ["뻻", "ppelh"], ["뼑", "ppyeolk"], ["뼒", "ppyeolm"], ["뼓", "ppyeolp"], ["뼔", "ppyeols"], ["뼕", "ppyeolt"], ["뼖", "ppyeolp"],
    ["뼗", "ppyeolh"], ["뼭", "ppyelk"], ["뼮", "ppyelm"], ["뼯", "ppyelp"], ["뼰", "ppyels"], ["뼱", "ppyelt"], ["뼲", "ppyelp"], ["뼳", "ppyelh"],
    ["뽉", "ppolk"], ["뽊", "ppolm"], ["뽋", "ppolp"], ["뽌", "ppols"], ["뽍", "ppolt"], ["뽎", "ppolp"], ["뽏", "ppolh"], ["뽥", "ppwalk"],
    ["뽦", "ppwalm"], ["뽧", "ppwalp"], ["뽨", "ppwals"], ["뽩", "ppwalt"], ["뽪", "ppwalp"], ["뽫", "ppwalh"], ["뾁", "ppwaelk"], ["뾂", "ppwaelm"],
    ["뾃", "ppwaelp"], ["뾄", "ppwaels"], ["뾅", "ppwaelt"], ["뾆", "ppwaelp"], ["뾇", "ppwaelh"], ["뾝", "ppoelk"], ["뾞", "ppoelm"], ["뾟", "ppoelp"],
    ["뾠", "ppoels"], ["뾡", "ppoelt"], ["뾢", "ppoelp"], ["뾣", "ppoelh"], ["뾹", "ppyolk"], ["뾺", "ppyolm"], ["뾻", "ppyolp"], ["뾼", "ppyols"],
    ["뾽", "ppyolt"], ["뾾", "ppyolp"], ["뾿", "ppyolh"], ["뿕", "ppulk"], ["뿖", "ppulm"], ["뿗", "ppulp"], ["뿘", "ppuls"], ["뿙", "ppult"],
    ["뿚", "ppulp"], ["뿛", "ppulh"], ["뿱", "ppwolk"], ["뿲", "ppwolm"], ["뿳", "ppwolp"], ["뿴", "ppwols"], ["뿵", "ppwolt"], ["뿶", "ppwolp"],
    ["뿷", "ppwolh"], ["쀍", "ppwelk"], ["쀎", "ppwelm"], ["쀏", "ppwelp"], ["쀐", "ppwels"], ["쀑", "ppwelt"], ["쀒", "ppwelp"], ["쀓", "ppwelh"],
    ["쀩", "ppwilk"], ["쀪", "ppwilm"], ["쀫", "ppwilp"], ["쀬", "ppwils"], ["쀭", "ppwilt"], ["쀮", "ppwilp"], ["쀯", "ppwilh"], ["쁅", "ppyulk"],
    ["쁆", "ppyulm"], ["쁇", "ppyulp"], ["쁈", "ppyuls"], ["쁉", "ppyult"], ["쁊", "ppyulp"], ["쁋", "ppyulh"], ["쁡", "ppeulk"], ["쁢", "ppeulm"],
    ["쁣", "ppeulp"], ["쁤", "ppeuls"], ["쁥", "ppeult"], ["쁦", "ppeulp"], ["쁧", "ppeulh"], ["쁽", "ppuilk"], ["쁾", "ppuilm"], ["쁿", "ppuilp"],
    ["삀", "ppuils"], ["삁", "ppuilt"], ["삂", "ppuilp"], ["삃", "ppuilh"], ["삙", "ppilk"], ["삚", "ppilm"], ["삛", "ppilp"], ["삜", "ppils"],
    ["삝", "ppilt"], ["삞", "ppilp"], ["삟", "ppilh"], ["삵", "salk"], ["삶", "salm"], ["삷", "salp"], ["삸", "sals"], ["삹", "salt"],
    ["삺", "salp"], ["삻", "salh"], ["샑", "saelk"], ["샒", "saelm"], ["샓", "saelp"], ["샔", "saels"], ["샕", "saelt"], ["샖", "saelp"],
    ["샗", "saelh"], ["샭", "syalk"], ["샮", "syalm"], ["샯", "syalp"], ["샰", "syals"], ["샱", "syalt"], ["샲", "syalp"], ["샳", "syalh"],
    ["섉", "syaelk"], ["섊", "syaelm"], ["섋", "syaelp"], ["섌", "syaels"], ["섍", "syaelt"], ["섎", "syaelp"], ["섏", "syaelh"], ["섥", "seolk"],
    ["섦", "seolm"], ["섧", "seolp"], ["섨", "seols"], ["섩", "seolt"], ["섪", "seolp"], ["섫", "seolh"], ["셁", "selk"], ["셂", "selm"],
    ["셃", "selp"], ["셄", "sels"], ["셅", "selt"], ["셆", "selp"], ["셇", "selh"], ["셝", "syeolk"], ["셞", "syeolm"], ["셟", "syeolp"],
    ["셠", "syeols"], ["셡", "syeolt"], ["셢", "syeolp"], ["셣", "syeolh"], ["셹", "syelk"], ["셺", "syelm"], ["셻", "syelp"], ["셼", "syels"],
    ["셽", "syelt"], ["셾", "syelp"], ["셿", "syelh"], ["솕", "solk"], ["솖", "solm"], ["솗", "solp"], ["솘", "sols"], ["솙", "solt"],
    ["솚", "solp"], ["솛", "solh"], ["솱", "swalk"], ["솲", "swalm"], ["솳", "swalp"], ["솴", "swals"], ["솵", "swalt"], ["솶", "swalp"],
    ["솷", "swalh"], ["쇍", "swaelk"], ["쇎", "swaelm"], ["쇏", "swaelp"], ["쇐", "swaels"], ["쇑", "swaelt"], ["쇒", "swaelp"], ["쇓", "swaelh"],
    ["쇩", "soelk"], ["쇪", "soelm"], ["쇫", "soelp"], ["쇬", "soels"], ["쇭", "soelt"], ["쇮", "soelp"], ["쇯", "soelh"], ["숅", "syolk"],
    ["숆", "syolm"], ["숇", "syolp"], ["숈", "syols"], ["숉", "syolt"], ["숊", "syolp"], ["숋", "syolh"], ["숡", "sulk"], ["숢", "sulm"],
    ["숣", "sulp"], ["숤", "suls"], ["숥", "sult"], ["숦", "sulp"], ["숧", "sulh"], ["숽", "swolk"], ["숾", "swolm"], ["숿", "swolp"],
    ["쉀", "swols"], ["쉁", "swolt"], ["쉂", "swolp"], ["쉃", "swolh"], ["쉙", "swelk"], ["쉚", "swelm"], ["쉛", "swelp"], ["쉜", "swels"],
    ["쉝", "swelt"], ["쉞", "swelp"], ["쉟", "swelh"], ["쉵", "swilk"], ["쉶", "swilm"], ["쉷", "swilp"], ["쉸", "swils"], ["쉹", "swilt"],
    ["쉺", "swilp"], ["쉻", "swilh"], ["슑", "syulk"], ["슒", "syulm"], ["슓", "syulp"], ["슔", "syuls"], ["슕", "syult"], ["슖", "syulp"],
    ["슗", "syulh"], ["슭", "seulk"], ["슮", "seulm"], ["슯", "seulp"], ["슰", "seuls"], ["슱", "seult"], ["슲", "seulp"], ["슳", "seulh"],
    ["싉", "suilk"], ["싊", "suilm"], ["싋", "suilp"], ["싌", "suils"], ["싍", "suilt"], ["싎", "suilp"], ["싏", "suilh"], ["싥", "silk"],
    ["싦", "silm"], ["싧", "silp"], ["싨", "sils"], ["싩", "silt"], ["싪", "silp"], ["싫", "silh"], ["쌁", "ssalk"], ["쌂", "ssalm"],
    ["쌃", "ssalp"], ["쌄", "ssals"], ["쌅", "ssalt"], ["쌆", "ssalp"], ["쌇", "ssalh"], ["쌝", "ssaelk"], ["쌞", "ssaelm"], ["쌟", "ssaelp"],
    ["쌠", "ssaels"], ["쌡", "ssaelt"], ["쌢", "ssaelp"], ["쌣", "ssaelh"], ["쌹", "ssyalk"], ["쌺", "ssyalm"], ["쌻", "ssyalp"], ["쌼", "ssyals"],
    ["쌽", "ssyalt"], ["쌾", "ssyalp"], ["쌿", "ssyalh"], ["썕", "ssyaelk"], ["썖", "ssyaelm"], ["썗", "ssyaelp"], ["썘", "ssyaels"], ["썙", "ssyaelt"],
    ["썚", "ssyaelp"], ["썛", "ssyaelh"], ["썱", "sseolk"], ["썲", "sseolm"], ["썳", "sseolp"], ["썴", "sseols"], ["썵", "sseolt"], ["썶", "sseolp"],
    ["썷", "sseolh"], ["쎍", "sselk"], ["쎎", "sselm"], ["쎏", "sselp"], ["쎐", "ssels"], ["쎑", "sselt"], ["쎒", "sselp"], ["쎓", "sselh"],
    ["쎩", "ssyeolk"], ["쎪", "ssyeolm"], ["쎫", "ssyeolp"], ["쎬", "ssyeols"], ["쎭", "ssyeolt"], ["쎮", "ssyeolp"], ["쎯", "ssyeolh"], ["쏅", "ssyelk"],
    ["쏆", "ssyelm"], ["쏇", "ssyelp"], ["쏈", "ssyels"], ["쏉", "ssyelt"], ["쏊", "ssyelp"], ["쏋", "ssyelh"], ["쏡", "ssolk"], ["쏢", "ssolm"],
    ["쏣", "ssolp"], ["쏤", "ssols"], ["쏥", "ssolt"], ["쏦", "ssolp"], ["쏧", "ssolh"], ["쏽", "sswalk"], ["쏾", "sswalm"], ["쏿", "sswalp"],
    ["쐀", "sswals"], ["쐁", "sswalt"], ["쐂", "sswalp"], ["쐃", "sswalh"], ["쐙", "sswaelk"], ["쐚", "sswaelm"], ["쐛", "sswaelp"], ["쐜", "sswaels"],
    ["쐝", "sswaelt"], ["쐞", "sswaelp"], ["쐟", "sswaelh"], ["쐵", "ssoelk"], ["쐶", "ssoelm"], ["쐷", "ssoelp"], ["쐸", "ssoels"], ["쐹", "ssoelt"],
    ["쐺", "ssoelp"], ["쐻", "ssoelh"], ["쑑", "ssyolk"], ["쑒", "ssyolm"], ["쑓", "ssyolp"], ["쑔", "ssyols"], ["쑕", "ssyolt"], ["쑖", "ssyolp"],
    ["쑗", "ssyolh"], ["쑭", "ssulk"], ["쑮", "ssulm"], ["쑯", "ssulp"], ["쑰", "ssuls"], ["쑱", "ssult"], ["쑲", "ssulp"], ["쑳", "ssulh"],
    ["쒉", "sswolk"], ["쒊", "sswolm"], ["쒋", "sswolp"], ["쒌", "sswols"], ["쒍", "sswolt"], ["쒎", "sswolp"], ["쒏", "sswolh"], ["쒥", "sswelk"],
    ["쒦", "sswelm"], ["쒧", "sswelp"], ["쒨", "sswels"], ["쒩", "sswelt"], ["쒪", "sswelp"], ["쒫", "sswelh"], ["쓁", "sswilk"], ["쓂", "sswilm"],
    ["쓃", "sswilp"], ["쓄", "sswils"], ["쓅", "sswilt"], ["쓆", "sswilp"], ["쓇", "sswilh"], ["쓝", "ssyulk"], ["쓞", "ssyulm"], ["쓟", "ssyulp"],
    ["쓠", "ssyuls"], ["쓡", "ssyult"], ["쓢", "ssyulp"], ["쓣", "ssyulh"], ["쓹", "sseulk"], ["쓺", "sseulm"], ["쓻", "sseulp"], ["쓼", "sseuls"],
    ["쓽", "sseult"], ["쓾", "sseulp"], ["쓿", "sseulh"], ["씕", "ssuilk"], ["씖", "ssuilm"], ["씗", "ssuilp"], ["씘", "ssuils"], ["씙", "ssuilt"],
    ["씚", "ssuilp"], ["씛", "ssuilh"], ["씱", "ssilk"], ["씲", "ssilm"], ["씳", "ssilp"], ["씴", "ssils"], ["씵", "ssilt"], ["씶", "ssilp"],
    ["씷", "ssilh"], ["앍", "alk"], ["앎", "alm"], ["앏", "alp"], ["앐", "als"], ["앑", "alt"], ["앒", "alp"], ["앓", "alh"],
    ["앩", "aelk"], ["앪", "aelm"], ["앫", "aelp"], ["앬", "aels"], ["앭", "aelt"], ["앮", "aelp"], ["앯", "aelh"], ["얅", "yalk"],
    ["얆", "yalm"], ["얇", "yalp"], ["얈", "yals"], ["얉", "yalt"], ["얊", "yalp"], ["얋", "yalh"], ["얡", "yaelk"], ["얢", "yaelm"],
    ["얣", "yaelp"], ["얤", "yaels"], ["얥", "yaelt"], ["얦", "yaelp"], ["얧", "yaelh"], ["얽", "eolk"], ["얾", "eolm"], ["얿", "eolp"],
    ["엀", "eols"], ["엁", "eolt"], ["엂", "eolp"], ["엃", "eolh"], ["엙", "elk"], ["엚", "elm"], ["엛", "elp"], ["엜", "els"],
    ["엝", "elt"], ["엞", "elp"], ["엟", "elh"], ["엵", "yeolk"], ["엶", "yeolm"], ["엷", "yeolp"], ["엸", "yeols"], ["엹", "yeolt"],
    ["엺", "yeolp"], ["엻", "yeolh"], ["옑", "yelk"], ["옒", "yelm"], ["옓", "yelp"], ["옔", "yels"], ["옕", "yelt"], ["옖", "yelp"],
    ["옗", "yelh"], ["옭", "olk"], ["옮", "olm"], ["옯", "olp"], ["옰", "ols"], ["옱", "olt"], ["옲", "olp"], ["옳", "olh"],
    ["왉", "walk"], ["왊", "walm"], ["왋", "walp"], ["왌", "wals"], ["왍", "walt"], ["왎", "walp"], ["왏", "walh"], ["왥", "waelk"],
    ["왦", "waelm"], ["왧", "waelp"], ["왨", "waels"], ["왩", "waelt"], ["왪", "waelp"], ["왫", "waelh"], ["욁", "oelk"], ["욂", "oelm"],
    ["욃", "oelp"], ["욄", "oels"], ["욅", "oelt"], ["욆", "oelp"], ["욇", "oelh"], ["욝", "yolk"], ["욞", "yolm"], ["욟", "yolp"],
    ["욠", "yols"], ["욡", "yolt"], ["욢", "yolp"], ["욣", "yolh"], ["욹", "ulk"], ["욺", "ulm"], ["욻", "ulp"], ["욼", "uls"],
    ["욽", "ult"], ["욾", "ulp"], ["욿", "ulh"], ["웕", "wolk"], ["웖", "wolm"], ["웗", "wolp"], ["웘", "wols"], ["웙", "wolt"],
    ["웚", "wolp"], ["웛", "wolh"], ["웱", "welk"], ["웲", "welm"], ["웳", "welp"], ["웴", "wels"], ["웵", "welt"], ["웶", "welp"],
    ["웷", "welh"], ["윍", "wilk"], ["윎", "wilm"], ["윏", "wilp"], ["윐", "wils"], ["윑", "wilt"], ["윒", "wilp"], ["윓", "wilh"],
    ["윩", "yulk"], ["윪", "yulm"], ["윫", "yulp"], ["윬", "yuls"], ["윭", "yult"], ["윮", "yulp"], ["윯", "yulh"], ["읅", "eulk"],
    ["읆", "eulm"], ["읇", "eulp"], ["읈", "euls"], ["읉", "eult"], ["읊", "eulp"], ["읋", "eulh"], ["읡", "uilk"], ["읢", "uilm"],
    ["읣", "uilp"], ["읤", "uils"], ["읥", "uilt"], ["읦", "uilp"], ["읧", "uilh"], ["읽", "ilk"], ["읾", "ilm"], ["읿", "ilp"],
    ["잀", "ils"], ["잁", "ilt"], ["잂", "ilp"], ["잃", "ilh"], ["잙", "jalk"], ["잚", "jalm"], ["잛", "jalp"], ["잜", "jals"],
    ["잝", "jalt"], ["잞", "jalp"], ["잟", "jalh"], ["잵", "jaelk"], ["잶", "jaelm"], ["잷", "jaelp"], ["잸", "jaels"], ["잹", "jaelt"],
    ["잺", "jaelp"], ["잻", "jaelh"], ["쟑", "jyalk"], ["쟒", "jyalm"], ["쟓", "jyalp"], ["쟔", "jyals"], ["쟕", "jyalt"], ["쟖", "jyalp"],
    ["쟗", "jyalh"], ["쟭", "jyaelk"], ["쟮", "jyaelm"], ["쟯", "jyaelp"], ["쟰", "jyaels"], ["쟱", "jyaelt"], ["쟲", "jyaelp"], ["쟳", "jyaelh"],
    ["젉", "jeolk"], ["젊", "jeolm"], ["젋", "jeolp"], ["젌", "jeols"], ["젍", "jeolt"], ["젎", "jeolp"], ["젏", "jeolh"], ["젥", "jelk"],
    ["젦", "jelm"], ["젧", "jelp"], ["젨", "jels"], ["젩", "jelt"], ["젪", "jelp"], ["젫", "jelh"], ["졁", "jyeolk"], ["졂", "jyeolm"],
    ["졃", "jyeolp"], ["졄", "jyeols"], ["졅", "jyeolt"], ["졆", "jyeolp"], ["졇", "jyeolh"], ["졝", "jyelk"], ["졞", "jyelm"], ["졟", "jyelp"],
    ["졠", "jyels"], ["졡", "jyelt"], ["졢", "jyelp"], ["졣", "jyelh"], ["졹", "jolk"], ["졺", "jolm"], ["졻", "jolp"], ["졼", "jols"],
    ["졽", "jolt"], ["졾", "jolp"], ["졿", "jolh"], ["좕", "jwalk"], ["좖", "jwalm"], ["좗", "jwalp"], ["좘", "jwals"], ["좙", "jwalt"],
    ["좚", "jwalp"], ["좛", "jwalh"], ["좱", "jwaelk"], ["좲", "jwaelm"], ["좳", "jwaelp"], ["좴", "jwaels"], ["좵", "jwaelt"], ["좶", "jwaelp"],
    ["좷", "jwaelh"], ["죍", "joelk"], ["죎", "joelm"], ["죏", "joelp"], ["죐", "joels"], ["죑", "joelt"], ["죒", "joelp"], ["죓", "joelh"],
    ["죩", "jyolk"], ["죪", "jyolm"], ["죫", "jyolp"], ["죬", "jyols"], ["죭", "jyolt"], ["죮", "jyolp"], ["죯", "jyolh"], ["줅", "julk"],
    ["줆", "julm"], ["줇", "julp"], ["줈", "juls"], ["줉", "jult"], ["줊", "julp"], ["줋", "julh"], ["줡", "jwolk"], ["줢", "jwolm"],
    ["줣", "jwolp"], ["줤", "jwols"], ["줥", "jwolt"], ["줦", "jwolp"], ["줧", "jwolh"], ["줽", "jwelk"], ["줾", "jwelm"], ["줿", "jwelp"],
    ["쥀", "jwels"], ["쥁", "jwelt"], ["쥂", "jwelp"], ["쥃", "jwelh"], ["쥙", "jwilk"], ["쥚", "jwilm"], ["쥛", "jwilp"], ["쥜", "jwils"],
    ["쥝", "jwilt"], ["쥞", "jwilp"], ["쥟", "jwilh"], ["쥵", "jyulk"], ["쥶", "jyulm"], ["쥷", "jyulp"], ["쥸", "jyuls"], ["쥹", "jyult"],
    ["쥺", "jyulp"], ["쥻", "jyulh"], ["즑", "jeulk"], ["즒", "jeulm"], ["즓", "jeulp"], ["즔", "jeuls"], ["즕", "jeult"], ["즖", "jeulp"],
    ["즗", "jeulh"], ["즭", "juilk"], ["즮", "juilm"], ["즯", "juilp"], ["즰", "juils"], ["즱", "juilt"], ["즲", "juilp"], ["즳", "juilh"],
    ["짉", "jilk"], ["짊", "jilm"], ["짋", "jilp"], ["짌", "jils"], ["짍", "jilt"], ["짎", "jilp"], ["짏", "jilh"], ["짥", "jjalk"],
    ["짦", "jjalm"], ["짧", "jjalp"], ["짨", "jjals"], ["짩", "jjalt"], ["짪", "jjalp"], ["짫", "jjalh"], ["쨁", "jjaelk"], ["쨂", "jjaelm"],
    ["쨃", "jjaelp"], ["쨄", "jjaels"], ["쨅", "jjaelt"], ["쨆", "jjaelp"], ["쨇", "jjaelh"], ["쨝", "jjyalk"], ["쨞", "jjyalm"], ["쨟", "jjyalp"],
    ["쨠", "jjyals"], ["쨡", "jjyalt"], ["쨢", "jjyalp"], ["쨣", "jjyalh"], ["쨹", "jjyaelk"], ["쨺", "jjyaelm"], ["쨻", "jjyaelp"], ["쨼", "jjyaels"],
    ["쨽", "jjyaelt"], ["쨾", "jjyaelp"], ["쨿", "jjyaelh"], ["쩕", "jjeolk"], ["쩖", "jjeolm"], ["쩗", "jjeolp"], ["쩘", "jjeols"], ["쩙", "jjeolt"],
    ["쩚", "jjeolp"], ["쩛", "jjeolh"], ["쩱", "jjelk"], ["쩲", "jjelm"], ["쩳", "jjelp"], ["쩴", "jjels"], ["쩵", "jjelt"], ["쩶", "jjelp"],
    ["쩷", "jjelh"], ["쪍", "jjyeolk"], ["쪎", "jjyeolm"], ["쪏", "jjyeolp"], ["쪐", "jjyeols"], ["쪑", "jjyeolt"], ["쪒", "jjyeolp"], ["쪓", "jjyeolh"],
    ["쪩", "jjyelk"], ["쪪", "jjyelm"], ["쪫", "jjyelp"], ["쪬", "jjyels"], ["쪭", "jjyelt"], ["쪮", "jjyelp"], ["쪯", "jjyelh"], ["쫅", "jjolk"],
    ["쫆", "jjolm"], ["쫇", "jjolp"], ["쫈", "jjols"], ["쫉", "jjolt"], ["쫊", "jjolp"], ["쫋", "jjolh"], ["쫡", "jjwalk"], ["쫢", "jjwalm"],
    ["쫣", "jjwalp"], ["쫤", "jjwals"], ["쫥", "jjwalt"], ["쫦", "jjwalp"], ["쫧", "jjwalh"], ["쫽", "jjwaelk"], ["쫾", "jjwaelm"], ["쫿", "jjwaelp"],
    ["쬀", "jjwaels"], ["쬁", "jjwaelt"], ["쬂", "jjwaelp"], ["쬃", "jjwaelh"], ["쬙", "jjoelk"], ["쬚", "jjoelm"], ["쬛", "jjoelp"], ["쬜", "jjoels"],
    ["쬝", "jjoelt"], ["쬞", "jjoelp"], ["쬟", "jjoelh"], ["쬵", "jjyolk"], ["쬶", "jjyolm"], ["쬷", "jjyolp"], ["쬸", "jjyols"], ["쬹", "jjyolt"],
    ["쬺", "jjyolp"], ["쬻", "jjyolh"], ["쭑", "jjulk"], ["쭒", "jjulm"], ["쭓", "jjulp"], ["쭔", "jjuls"], ["쭕", "jjult"], ["쭖", "jjulp"],
    ["쭗", "jjulh"], ["쭭", "jjwolk"], ["쭮", "jjwolm"], ["쭯", "jjwolp"], ["쭰", "jjwols"], ["쭱", "jjwolt"], ["쭲", "jjwolp"], ["쭳", "jjwolh"],
    ["쮉", "jjwelk"], ["쮊", "jjwelm"], ["쮋", "jjwelp"], ["쮌", "jjwels"], ["쮍", "jjwelt"], ["쮎", "jjwelp"], ["쮏", "jjwelh"], ["쮥", "jjwilk"],
    ["쮦", "jjwilm"], ["쮧", "jjwilp"], ["쮨", "jjwils"], ["쮩", "jjwilt"], ["쮪", "jjwilp"], ["쮫", "jjwilh"], ["쯁", "jjyulk"], ["쯂", "jjyulm"],
    ["쯃", "jjyulp"], ["쯄", "jjyuls"], ["쯅", "jjyult"], ["쯆", "jjyulp"], ["쯇", "jjyulh"], ["쯝", "jjeulk"], ["쯞", "jjeulm"], ["쯟", "jjeulp"],
    ["쯠", "jjeuls"], ["쯡", "jjeult"], ["쯢", "jjeulp"], ["쯣", "jjeulh"], ["쯹", "jjuilk"], ["쯺", "jjuilm"], ["쯻", "jjuilp"], ["쯼", "jjuils"],
    ["쯽", "jjuilt"], ["쯾", "jjuilp"], ["쯿", "jjuilh"], ["찕", "jjilk"], ["찖", "jjilm"], ["찗", "jjilp"], ["찘", "jjils"], ["찙", "jjilt"],
    ["찚", "jjilp"], ["찛", "jjilh"], ["찱", "chalk"], ["찲", "chalm"], ["찳", "chalp"], ["찴", "chals"], ["찵", "chalt"], ["찶", "chalp"],
    ["찷", "chalh"], ["챍", "chaelk"], ["챎", "chaelm"], ["챏", "chaelp"], ["챐", "chaels"], ["챑", "chaelt"], ["챒", "chaelp"], ["챓", "chaelh"],
    ["챩", "chyalk"], ["챪", "chyalm"], ["챫", "chyalp"], ["챬", "chyals"], ["챭", "chyalt"], ["챮", "chyalp"], ["챯", "chyalh"], ["첅", "chyaelk"],
    ["첆", "chyaelm"], ["첇", "chyaelp"], ["첈", "chyaels"], ["첉", "chyaelt"], ["첊", "chyaelp"], ["첋", "chyaelh"], ["첡", "cheolk"], ["첢", "cheolm"],
    ["첣", "cheolp"], ["첤", "cheols"], ["첥", "cheolt"], ["첦", "cheolp"], ["첧", "cheolh"], ["첽", "chelk"], ["첾", "chelm"], ["첿", "chelp"],
    ["쳀", "chels"], ["쳁", "chelt"], ["쳂", "chelp"], ["쳃", "chelh"], ["쳙", "chyeolk"], ["쳚", "chyeolm"], ["쳛", "chyeolp"], ["쳜", "chyeols"],
    ["쳝", "chyeolt"], ["쳞", "chyeolp"], ["쳟", "chyeolh"], ["쳵", "chyelk"], ["쳶", "chyelm"], ["쳷", "chyelp"], ["쳸", "chyels"], ["쳹", "chyelt"],
    ["쳺", "chyelp"], ["쳻", "chyelh"], ["촑", "cholk"], ["촒", "cholm"], ["촓", "cholp"], ["촔", "chols"], ["촕", "cholt"], ["촖", "cholp"],
    ["촗", "cholh"], ["촭", "chwalk"], ["촮", "chwalm"], ["촯", "chwalp"], ["촰", "chwals"], ["촱", "chwalt"], ["촲", "chwalp"], ["촳", "chwalh"],
    ["쵉", "chwaelk"], ["쵊", "chwaelm"], ["쵋", "chwaelp"], ["쵌", "chwaels"], ["쵍", "chwaelt"], ["쵎", "chwaelp"], ["쵏", "chwaelh"], ["쵥", "choelk"],
    ["쵦", "choelm"], ["쵧", "choelp"], ["쵨", "choels"], ["쵩", "choelt"], ["쵪", "choelp"], ["쵫", "choelh"], ["춁", "chyolk"], ["춂", "chyolm"],
    ["춃", "chyolp"], ["춄", "chyols"], ["춅", "chyolt"], ["춆", "chyolp"], ["춇", "chyolh"], ["춝", "chulk"], ["춞", "chulm"], ["춟", "chulp"],
    ["춠", "chuls"], ["춡", "chult"], ["춢", "chulp"], ["춣", "chulh"], ["춹", "chwolk"], ["춺", "chwolm"], ["춻", "chwolp"], ["춼", "chwols"],
    ["춽", "chwolt"], ["춾", "chwolp"], ["춿", "chwolh"], ["췕", "chwelk"], ["췖", "chwelm"], ["췗", "chwelp"], ["췘", "chwels"], ["췙", "chwelt"],
    ["췚", "chwelp"], ["췛", "chwelh"], ["췱", "chwilk"], ["췲", "chwilm"], ["췳", "chwilp"], ["췴", "chwils"], ["췵", "chwilt"], ["췶", "chwilp"],
    ["췷", "chwilh"], ["츍", "chyulk"], ["츎", "chyulm"], ["츏", "chyulp"], ["츐", "chyuls"], ["츑", "chyult"], ["츒", "chyulp"], ["츓", "chyulh"],
    ["츩", "cheulk"], ["츪", "cheulm"], ["츫", "cheulp"], ["츬", "cheuls"], ["츭", "cheult"], ["츮", "cheulp"], ["츯", "cheulh"], ["칅", "chuilk"],
    ["칆", "chuilm"], ["칇", "chuilp"], ["칈", "chuils"], ["칉", "chuilt"], ["칊", "chuilp"], ["칋", "chuilh"], ["칡", "chilk"], ["칢", "chilm"],
    ["칣", "chilp"], ["칤", "chils"], ["칥", "chilt"], ["칦", "chilp"], ["칧", "chilh"], ["칽", "kalk"], ["칾", "kalm"], ["칿", "kalp"],
    ["캀", "kals"], ["캁", "kalt"], ["캂", "kalp"], ["캃", "kalh"], ["캙", "kaelk"], ["캚", "kaelm"], ["캛", "kaelp"], ["캜", "kaels"],
    ["캝", "kaelt"], ["캞", "kaelp"], ["캟", "kaelh"], ["캵", "kyalk"], ["캶", "kyalm"], ["캷", "kyalp"], ["캸", "kyals"], ["캹", "kyalt"],
    ["캺", "kyalp"], ["캻", "kyalh"], ["컑", "kyaelk"], ["컒", "kyaelm"], ["컓", "kyaelp"], ["컔", "kyaels"], ["컕", "kyaelt"], ["컖", "kyaelp"],
    ["컗", "kyaelh"], ["컭", "keolk"], ["컮", "keolm"], ["컯", "keolp"], ["컰", "keols"], ["컱", "keolt"], ["컲", "keolp"], ["컳", "keolh"],
    ["켉", "kelk"], ["켊", "kelm"], ["켋", "kelp"], ["켌", "kels"], ["켍", "kelt"], ["켎", "kelp"], ["켏", "kelh"], ["켥", "kyeolk"],
    ["켦", "kyeolm"], ["켧", "kyeolp"], ["켨", "kyeols"], ["켩", "kyeolt"], ["켪", "kyeolp"], ["켫", "kyeolh"], ["콁", "kyelk"], ["콂", "kyelm"],
    ["콃", "kyelp"], ["콄", "kyels"], ["콅", "kyelt"], ["콆", "kyelp"], ["콇", "kyelh"], ["콝", "kolk"], ["콞", "kolm"], ["콟", "kolp"],
    ["콠", "kols"], ["콡", "kolt"], ["콢", "kolp"], ["콣", "kolh"], ["콹", "kwalk"], ["콺", "kwalm"], ["콻", "kwalp"], ["콼", "kwals"],
    ["콽", "kwalt"], ["콾", "kwalp"], ["콿", "kwalh"], ["쾕", "kwaelk"], ["쾖", "kwaelm"], ["쾗", "kwaelp"], ["쾘", "kwaels"], ["쾙", "kwaelt"],
    ["쾚", "kwaelp"], ["쾛", "kwaelh"], ["쾱", "koelk"], ["쾲", "koelm"], ["쾳", "koelp"], ["쾴", "koels"], ["쾵", "koelt"], ["쾶", "koelp"],
    ["쾷", "koelh"], ["쿍", "kyolk"], ["쿎", "kyolm"], ["쿏", "kyolp"], ["쿐", "kyols"], ["쿑", "kyolt"], ["쿒", "kyolp"], ["쿓", "kyolh"],
    ["쿩", "kulk"], ["쿪", "kulm"], ["쿫", "kulp"], ["쿬", "kuls"], ["쿭", "kult"], ["쿮", "kulp"], ["쿯", "kulh"], ["퀅", "kwolk"],
    ["퀆", "kwolm"], ["퀇", "kwolp"], ["퀈", "kwols"], ["퀉", "kwolt"], ["퀊", "kwolp"], ["퀋", "kwolh"], ["퀡", "kwelk"], ["퀢", "kwelm"],
    ["퀣", "kwelp"], ["퀤", "kwels"], ["퀥", "kwelt"], ["퀦", "kwelp"], ["퀧", "kwelh"], ["퀽", "kwilk"], ["퀾", "kwilm"], ["퀿", "kwilp"],
    ["큀", "kwils"], ["큁", "kwilt"], ["큂", "kwilp"], ["큃", "kwilh"], ["큙", "kyulk"], ["큚", "kyulm"], ["큛", "kyulp"], ["큜", "kyuls"],
    ["큝", "kyult"], ["큞", "kyulp"], ["큟", "kyulh"], ["큵", "keulk"], ["큶", "keulm"], ["큷", "keulp"], ["큸", "keuls"], ["큹", "keult"],
    ["큺", "keulp"], ["큻", "keulh"], ["킑", "kuilk"], ["킒", "kuilm"], ["킓", "kuilp"], ["킔", "kuils"], ["킕", "kuilt"], ["킖", "kuilp"],
    ["킗", "kuilh"], ["킭", "kilk"], ["킮", "kilm"], ["킯", "kilp"], ["킰", "kils"], ["킱", "kilt"], ["킲", "kilp"], ["킳", "kilh"],
    ["탉", "talk"], ["탊", "talm"], ["탋", "talp"], ["탌", "tals"], ["탍", "talt"], ["탎", "talp"], ["탏", "talh"], ["탥", "taelk"],
    ["탦", "taelm"], ["탧", "taelp"], ["탨", "taels"], ["탩", "taelt"], ["탪", "taelp"], ["탫", "taelh"], ["턁", "tyalk"], ["턂", "tyalm"],
    ["턃", "tyalp"], ["턄", "tyals"], ["턅", "tyalt"], ["턆", "tyalp"], ["턇", "tyalh"], ["턝", "tyaelk"], ["턞", "tyaelm"], ["턟", "tyaelp"],
    ["턠", "tyaels"], ["턡", "tyaelt"], ["턢", "tyaelp"], ["턣", "tyaelh"], ["턹", "teolk"], ["턺", "teolm"], ["턻", "teolp"], ["턼", "teols"],
    ["턽", "teolt"], ["턾", "teolp"], ["턿", "teolh"], ["텕", "telk"], ["텖", "telm"], ["텗", "telp"], ["텘", "tels"], ["텙", "telt"],
    ["텚", "telp"], ["텛", "telh"], ["텱", "tyeolk"], ["텲", "tyeolm"], ["텳", "tyeolp"], ["텴", "tyeols"], ["텵", "tyeolt"], ["텶", "tyeolp"],
    ["텷", "tyeolh"], ["톍", "tyelk"], ["톎", "tyelm"], ["톏", "tyelp"], ["톐", "tyels"], ["톑", "tyelt"], ["톒", "tyelp"], ["톓", "tyelh"],
    ["톩", "tolk"], ["톪", "tolm"], ["톫", "tolp"], ["톬", "tols"], ["톭", "tolt"], ["톮", "tolp"], ["톯", "tolh"], ["퇅", "twalk"],
    ["퇆", "twalm"], ["퇇", "twalp"], ["퇈", "twals"], ["퇉", "twalt"], ["퇊", "twalp"], ["퇋", "twalh"], ["퇡", "twaelk"], ["퇢", "twaelm"],
    ["퇣", "twaelp"], ["퇤", "twaels"], ["퇥", "twaelt"], ["퇦", "twaelp"], ["퇧", "twaelh"], ["퇽", "toelk"], ["퇾", "toelm"], ["퇿", "toelp"],
    ["툀", "toels"], ["툁", "toelt"], ["툂", "toelp"], ["툃", "toelh"], ["툙", "tyolk"], ["툚", "tyolm"], ["툛", "tyolp"], ["툜", "tyols"],
    ["툝", "tyolt"], ["툞", "tyolp"], ["툟", "tyolh"], ["툵", "tulk"], ["툶", "tulm"], ["툷", "tulp"], ["툸", "tuls"], ["툹", "tult"],
    ["툺", "tulp"], ["툻", "tulh"], ["퉑", "twolk"], ["퉒", "twolm"], ["퉓", "twolp"], ["퉔", "twols"], ["퉕", "twolt"], ["퉖", "twolp"],
    ["퉗", "twolh"], ["퉭", "twelk"], ["퉮", "twelm"], ["퉯", "twelp"], ["퉰", "twels"], ["퉱", "twelt"], ["퉲", "twelp"], ["퉳", "twelh"],
    ["튉", "twilk"], ["튊", "twilm"], ["튋", "twilp"], ["튌", "twils"], ["튍", "twilt"], ["튎", "twilp"], ["튏", "twilh"], ["튥", "tyulk"],
    ["튦", "tyulm"], ["튧", "tyulp"], ["튨", "tyuls"], ["튩", "tyult"], ["튪", "tyulp"], ["튫", "tyulh"], ["틁", "teulk"], ["틂", "teulm"],
    ["틃", "teulp"], ["틄", "teuls"], ["틅", "teult"], ["틆", "teulp"], ["틇", "teulh"], ["틝", "tuilk"], ["틞", "tuilm"], ["틟", "tuilp"],
    ["틠", "tuils"], ["틡", "tuilt"], ["틢", "tuilp"], ["틣", "tuilh"], ["틹", "tilk"], ["틺", "tilm"], ["틻", "tilp"], ["틼", "tils"],
    ["틽", "tilt"], ["틾", "tilp"], ["틿", "tilh"], ["팕", "palk"], ["팖", "palm"], ["팗", "palp"], ["팘", "pals"], ["팙", "palt"],
    ["팚", "palp"], ["팛", "palh"], ["팱", "paelk"], ["팲", "paelm"], ["팳", "paelp"], ["팴", "paels"], ["팵", "paelt"], ["팶", "paelp"],
    ["팷", "paelh"], ["퍍", "pyalk"], ["퍎", "pyalm"], ["퍏", "pyalp"], ["퍐", "pyals"], ["퍑", "pyalt"], ["퍒", "pyalp"], ["퍓", "pyalh"],
    ["퍩", "pyaelk"], ["퍪", "pyaelm"], ["퍫", "pyaelp"], ["퍬", "pyaels"], ["퍭", "pyaelt"], ["퍮", "pyaelp"], ["퍯", "pyaelh"], ["펅", "peolk"],
    ["펆", "peolm"], ["펇", "peolp"], ["펈", "peols"], ["펉", "peolt"], ["펊", "peolp"], ["펋", "peolh"], ["펡", "pelk"], ["펢", "pelm"],
    ["펣", "pelp"], ["펤", "pels"], ["펥", "pelt"], ["펦", "pelp"], ["펧", "pelh"], ["펽", "pyeolk"], ["펾", "pyeolm"], ["펿", "pyeolp"],
    ["폀", "pyeols"], ["폁", "pyeolt"], ["폂", "pyeolp"], ["폃", "pyeolh"], ["폙", "pyelk"], ["폚", "pyelm"], ["폛", "pyelp"], ["폜", "pyels"],
    ["폝", "pyelt"], ["폞", "pyelp"], ["폟", "pyelh"], ["폵", "polk"], ["폶", "polm"], ["폷", "polp"], ["폸", "pols"], ["폹", "polt"],
    ["폺", "polp"], ["폻", "polh"], ["퐑", "pwalk"], ["퐒", "pwalm"], ["퐓", "pwalp"], ["퐔", "pwals"], ["퐕", "pwalt"], ["퐖", "pwalp"],
    ["퐗", "pwalh"], ["퐭", "pwaelk"], ["퐮", "pwaelm"], ["퐯", "pwaelp"], ["퐰", "pwaels"], ["퐱", "pwaelt"], ["퐲", "pwaelp"], ["퐳", "pwaelh"],
    ["푉", "poelk"], ["푊", "poelm"], ["푋", "poelp"], ["푌", "poels"], ["푍", "poelt"], ["푎", "poelp"], ["푏", "poelh"], ["푥", "pyolk"],
    ["푦", "pyolm"], ["푧", "pyolp"], ["푨", "pyols"], ["푩", "pyolt"], ["푪", "pyolp"], ["푫", "pyolh"], ["풁", "pulk"], ["풂", "pulm"],
    ["풃", "pulp"], ["풄", "puls"], ["풅", "pult"], ["풆", "pulp"], ["풇", "pulh"], ["풝", "pwolk"], ["풞", "pwolm"], ["풟", "pwolp"],
    ["풠", "pwols"], ["풡", "pwolt"], ["풢", "pwolp"], ["풣", "pwolh"], ["풹", "pwelk"], ["풺", "pwelm"], ["풻", "pwelp"], ["풼", "pwels"],
    ["풽", "pwelt"], ["풾", "pwelp"], ["풿", "pwelh"], ["퓕", "pwilk"], ["퓖", "pwilm"], ["퓗", "pwilp"], ["퓘", "pwils"], ["퓙", "pwilt"],
    ["퓚", "pwilp"], ["퓛", "pwilh"], ["퓱", "pyulk"], ["퓲", "pyulm"], ["퓳", "pyulp"], ["퓴", "pyuls"], ["퓵", "pyult"], ["퓶", "pyulp"],
    ["퓷", "pyulh"], ["픍", "peulk"], ["픎", "peulm"], ["픏", "peulp"], ["픐", "peuls"], ["픑", "peult"], ["픒", "peulp"], ["픓", "peulh"],
    ["픩", "puilk"], ["픪", "puilm"], ["픫", "puilp"], ["픬", "puils"], ["픭", "puilt"], ["픮", "puilp"], ["픯", "puilh"], ["핅", "pilk"],
    ["핆", "pilm"], ["핇", "pilp"], ["핈", "pils"], ["핉", "pilt"], ["핊", "pilp"], ["핋", "pilh"], ["핡", "halk"], ["핢", "halm"],
    ["핣", "halp"], ["핤", "hals"], ["핥", "halt"], ["핦", "halp"], ["핧", "halh"], ["핽", "haelk"], ["핾", "haelm"], ["핿", "haelp"],
    ["햀", "haels"], ["햁", "haelt"], ["햂", "haelp"], ["햃", "haelh"], ["햙", "hyalk"], ["햚", "hyalm"], ["햛", "hyalp"], ["햜", "hyals"],
    ["햝", "hyalt"], ["햞", "hyalp"], ["햟", "hyalh"], ["햵", "hyaelk"], ["햶", "hyaelm"], ["햷", "hyaelp"], ["햸", "hyaels"], ["햹", "hyaelt"],
    ["햺", "hyaelp"], ["햻", "hyaelh"], ["헑", "heolk"], ["헒", "heolm"], ["헓", "heolp"], ["헔", "heols"], ["헕", "heolt"], ["헖", "heolp"],
    ["헗", "heolh"], ["헭", "helk"], ["헮", "helm"], ["헯", "help"], ["헰", "hels"], ["헱", "helt"], ["헲", "help"], ["헳", "helh"],
    ["혉", "hyeolk"], ["혊", "hyeolm"], ["혋", "hyeolp"], ["혌", "hyeols"], ["혍", "hyeolt"], ["혎", "hyeolp"], ["혏", "hyeolh"], ["혥", "hyelk"],
    ["혦", "hyelm"], ["혧", "hyelp"], ["혨", "hyels"], ["혩", "hyelt"], ["혪", "hyelp"], ["혫", "hyelh"], ["홁", "holk"], ["홂", "holm"],
    ["홃", "holp"], ["홄", "hols"], ["홅", "holt"], ["홆", "holp"], ["홇", "holh"], ["홝", "hwalk"], ["홞", "hwalm"], ["홟", "hwalp"],
    ["홠", "hwals"], ["홡", "hwalt"], ["홢", "hwalp"], ["홣", "hwalh"], ["홹", "hwaelk"], ["홺", "hwaelm"], ["홻", "hwaelp"], ["홼", "hwaels"],
    ["홽", "hwaelt"], ["홾", "hwaelp"], ["홿", "hwaelh"], ["횕", "hoelk"], ["횖", "hoelm"], ["횗", "hoelp"], ["횘", "hoels"], ["횙", "hoelt"],
    ["횚", "hoelp"], ["횛", "hoelh"], ["횱", "hyolk"], ["횲", "hyolm"], ["횳", "hyolp"], ["횴", "hyols"], ["횵", "hyolt"], ["횶", "hyolp"],
    ["횷", "hyolh"], ["훍", "hulk"], ["훎", "hulm"], ["훏", "hulp"], ["훐", "huls"], ["훑", "hult"], ["훒", "hulp"], ["훓", "hulh"],
    ["훩", "hwolk"], ["훪", "hwolm"], ["훫", "hwolp"], ["훬", "hwols"], ["훭", "hwolt"], ["훮", "hwolp"], ["훯", "hwolh"], ["휅", "hwelk"],
    ["휆", "hwelm"], ["휇", "hwelp"], ["휈", "hwels"], ["휉", "hwelt"], ["휊", "hwelp"], ["휋", "hwelh"], ["휡", "hwilk"], ["휢", "hwilm"],
    ["휣", "hwilp"], ["휤", "hwils"], ["휥", "hwilt"], ["휦", "hwilp"], ["휧", "hwilh"], ["휽", "hyulk"], ["휾", "hyulm"], ["휿", "hyulp"],
    ["흀", "hyuls"], ["흁", "hyult"], ["흂", "hyulp"], ["흃", "hyulh"], ["흙", "heulk"], ["흚", "heulm"], ["흛", "heulp"], ["흜", "heuls"],
    ["흝", "heult"], ["흞", "heulp"], ["흟", "heulh"], ["흵", "huilk"], ["흶", "huilm"], ["흷", "huilp"], ["흸", "huils"], ["흹", "huilt"],
    ["흺", "huilp"], ["흻", "huilh"], ["힑", "hilk"], ["힒", "hilm"], ["힓", "hilp"], ["힔", "hils"], ["힕", "hilt"], ["힖", "hilp"],
    ["힗", "hilh"], ["갃", "gaks"], ["갟", "gaeks"], ["갻", "gyaks"], ["걗", "gyaeks"], ["걳", "geoks"], ["겏", "geks"], ["겫", "gyeoks"],
    ["곇", "gyeks"], ["곣", "goks"], ["곿", "gwaks"], ["괛", "gwaeks"], ["괷", "goeks"], ["굓", "gyoks"], ["굯", "guks"], ["궋", "gwoks"],
    ["궧", "gweks"], ["귃", "gwiks"], ["귟", "gyuks"], ["귻", "geuks"], ["긗", "guiks"], ["긳", "giks"], ["깏", "kkaks"], ["깫", "kkaeks"],
    ["꺇", "kkyaks"], ["꺣", "kkyaeks"], ["꺿", "kkeoks"], ["껛", "kkeks"], ["껷", "kkyeoks"], ["꼓", "kkyeks"], ["꼯", "kkoks"], ["꽋", "kkwaks"],
    ["꽧", "kkwaeks"], ["꾃", "kkoeks"], ["꾟", "kkyoks"], ["꾻", "kkuks"], ["꿗", "kkwoks"], ["꿳", "kkweks"], ["뀏", "kkwiks"], ["뀫", "kkyuks"],
    ["끇", "kkeuks"], ["끣", "kkuiks"], ["끿", "kkiks"], ["낛", "naks"], ["낷", "naeks"], ["냓", "nyaks"], ["냯", "nyaeks"], ["넋", "neoks"],
    ["넧", "neks"], ["녃", "nyeoks"], ["녟", "nyeks"], ["녻", "noks"], ["놗", "nwaks"], ["놳", "nwaeks"], ["뇏", "noeks"], ["뇫", "nyoks"],
    ["눇", "nuks"], ["눣", "nwoks"], ["눿", "nweks"], ["뉛", "nwiks"], ["뉷", "nyuks"], ["늓", "neuks"], ["늯", "nuiks"], ["닋", "niks"],
    ["닧", "taks"], ["댃", "taeks"], ["댟", "tyaks"], ["댻", "tyaeks"], ["덗", "teoks"], ["덳", "teks"], ["뎏", "tyeoks"], ["뎫", "tyeks"],
    ["돇", "toks"], ["돣", "twaks"], ["돿", "twaeks"], ["됛", "toeks"], ["됷", "tyoks"], ["둓", "tuks"], ["둯", "twoks"], ["뒋", "tweks"],
    ["뒧", "twiks"], ["듃", "tyuks"], ["듟", "teuks"], ["듻", "tuiks"], ["딗", "tiks"], ["딳", "tdaks"], ["땏", "tdaeks"], ["땫", "tdyaks"],
    ["떇", "tdyaeks"], ["떣", "tdeoks"], ["떿", "tdeks"], ["뗛", "tdyeoks"], ["뗷", "tdyeks"], ["똓", "tdoks"], ["똯", "tdwaks"], ["뙋", "tdwaeks"],
    ["뙧", "tdoeks"], ["뚃", "tdyoks"], ["뚟", "tduks"], ["뚻", "tdwoks"], ["뛗", "tdweks"], ["뛳", "tdwiks"], ["뜏", "tdyuks"], ["뜫", "tdeuks"],
    ["띇", "tduiks"], ["띣", "tdiks"], ["띿", "raks"], ["랛", "raeks"], ["랷", "ryaks"], ["럓", "ryaeks"], ["럯", "reoks"], ["렋", "reks"],
    ["렧", "ryeoks"], ["롃", "ryeks"], ["롟", "roks"], ["롻", "rwaks"], ["뢗", "rwaeks"], ["뢳", "roeks"], ["룏", "ryoks"], ["룫", "ruks"],
    ["뤇", "rwoks"], ["뤣", "rweks"], ["뤿", "rwiks"], ["륛", "ryuks"], ["륷", "reuks"], ["릓", "ruiks"], ["릯", "riks"], ["맋", "maks"],
    ["맧", "maeks"], ["먃", "myaks"], ["먟", "myaeks"], ["먻", "meoks"], ["멗", "meks"], ["멳", "myeoks"], ["몏", "myeks"], ["몫", "moks"],
    ["뫇", "mwaks"], ["뫣", "mwaeks"], ["뫿", "moeks"], ["묛", "myoks"], ["묷", "muks"], ["뭓", "mwoks"], ["뭯", "mweks"], ["뮋", "mwiks"],
    ["뮧", "myuks"], ["믃", "meuks"], ["믟", "muiks"], ["믻", "miks"], ["밗", "baks"], ["밳", "baeks"], ["뱏", "byaks"], ["뱫", "byaeks"],
    ["벇", "beoks"], ["벣", "beks"], ["벿", "byeoks"], ["볛", "byeks"], ["볷", "boks"], ["봓", "bwaks"], ["봯", "bwaeks"], ["뵋", "boeks"],
    ["뵧", "byoks"], ["붃", "buks"], ["붟", "bwoks"], ["붻", "bweks"], ["뷗", "bwiks"], ["뷳", "byuks"], ["븏", "beuks"], ["븫", "buiks"],
    ["빇", "biks"], ["빣", "ppaks"], ["빿", "ppaeks"], ["뺛", "ppyaks"], ["뺷", "ppyaeks"], ["뻓", "ppeoks"], ["뻯", "ppeks"], ["뼋", "ppyeoks"],
    ["뼧", "ppyeks"], ["뽃", "ppoks"], ["뽟", "ppwaks"], ["뽻", "ppwaeks"], ["뾗", "ppoeks"], ["뾳", "ppyoks"], ["뿏", "ppuks"], ["뿫", "ppwoks"],
    ["쀇", "ppweks"], ["쀣", "ppwiks"], ["쀿", "ppyuks"], ["쁛", "ppeuks"], ["쁷", "ppuiks"], ["삓", "ppiks"], ["삯", "saks"], ["샋", "saeks"],
    ["샧", "syaks"], ["섃", "syaeks"], ["섟", "seoks"], ["섻", "seks"], ["셗", "syeoks"], ["셳", "syeks"], ["솏", "soks"], ["솫", "swaks"],
    ["쇇", "swaeks"], ["쇣", "soeks"], ["쇿", "syoks"], ["숛", "suks"], ["숷", "swoks"], ["쉓", "sweks"], ["쉯", "swiks"], ["슋", "syuks"],
    ["슧", "seuks"], ["싃", "suiks"], ["싟", "siks"], ["싻", "ssaks"], ["쌗", "ssaeks"], ["쌳", "ssyaks"], ["썏", "ssyaeks"], ["썫", "sseoks"],
    ["쎇", "sseks"], ["쎣", "ssyeoks"], ["쎿", "ssyeks"], ["쏛", "ssoks"], ["쏷", "sswaks"], ["쐓", "sswaeks"], ["쐯", "ssoeks"], ["쑋", "ssyoks"],
    ["쑧", "ssuks"], ["쒃", "sswoks"], ["쒟", "ssweks"], ["쒻", "sswiks"], ["쓗", "ssyuks"], ["쓳", "sseuks"], ["씏", "ssuiks"], ["씫", "ssiks"],
    ["앇", "aks"], ["앣", "aeks"], ["앿", "yaks"], ["얛", "yaeks"], ["얷", "eoks"], ["엓", "eks"], ["엯", "yeoks"], ["옋", "yeks"],
    ["옧", "oks"], ["왃", "waks"], ["왟", "waeks"], ["왻", "oeks"], ["욗", "yoks"], ["욳", "uks"], ["웏", "woks"], ["웫", "weks"],
    ["윇", "wiks"], ["윣", "yuks"], ["윿", "euks"], ["읛", "uiks"], ["읷", "iks"], ["잓", "jaks"], ["잯", "jaeks"], ["쟋", "jyaks"],
    ["쟧", "jyaeks"], ["젃", "jeoks"], ["젟", "jeks"], ["젻", "jyeoks"], ["졗", "jyeks"], ["졳", "joks"], ["좏", "jwaks"], ["좫", "jwaeks"],
    ["죇", "joeks"], ["죣", "jyoks"], ["죿", "juks"], ["줛", "jwoks"], ["줷", "jweks"], ["쥓", "jwiks"], ["쥯", "jyuks"], ["즋", "jeuks"],
    ["즧", "juiks"], ["짃", "jiks"], ["짟", "jjaks"], ["짻", "jjaeks"], ["쨗", "jjyaks"], ["쨳", "jjyaeks"], ["쩏", "jjeoks"], ["쩫", "jjeks"],
    ["쪇", "jjyeoks"], ["쪣", "jjyeks"], ["쪿", "jjoks"], ["쫛", "jjwaks"], ["쫷", "jjwaeks"], ["쬓", "jjoeks"], ["쬯", "jjyoks"], ["쭋", "jjuks"],
    ["쭧", "jjwoks"], ["쮃", "jjweks"], ["쮟", "jjwiks"], ["쮻", "jjyuks"], ["쯗", "jjeuks"], ["쯳", "jjuiks"], ["찏", "jjiks"], ["찫", "chaks"],
    ["챇", "chaeks"], ["챣", "chyaks"], ["챿", "chyaeks"], ["첛", "cheoks"], ["첷", "cheks"], ["쳓", "chyeoks"], ["쳯", "chyeks"], ["촋", "choks"],
    ["촧", "chwaks"], ["쵃", "chwaeks"], ["쵟", "choeks"], ["쵻", "chyoks"], ["춗", "chuks"], ["춳", "chwoks"], ["췏", "chweks"], ["췫", "chwiks"],
    ["츇", "chyuks"], ["츣", "cheuks"], ["츿", "chuiks"], ["칛", "chiks"], ["칷", "kaks"], ["캓", "kaeks"], ["캯", "kyaks"], ["컋", "kyaeks"],
    ["컧", "keoks"], ["켃", "keks"], ["켟", "kyeoks"], ["켻", "kyeks"], ["콗", "koks"], ["콳", "kwaks"], ["쾏", "kwaeks"], ["쾫", "koeks"],
    ["쿇", "kyoks"], ["쿣", "kuks"], ["쿿", "kwoks"], ["퀛", "kweks"], ["퀷", "kwiks"], ["큓", "kyuks"], ["큯", "keuks"], ["킋", "kuiks"],
    ["킧", "kiks"], ["탃", "taks"], ["탟", "taeks"], ["탻", "tyaks"], ["턗", "tyaeks"], ["턳", "teoks"], ["텏", "teks"], ["텫", "tyeoks"],
    ["톇", "tyeks"], ["톣", "toks"], ["톿", "twaks"], ["퇛", "twaeks"], ["퇷", "toeks"], ["툓", "tyoks"], ["툯", "tuks"], ["퉋", "twoks"],
    ["퉧", "tweks"], ["튃", "twiks"], ["튟", "tyuks"], ["튻", "teuks"], ["틗", "tuiks"], ["틳", "tiks"], ["팏", "paks"], ["팫", "paeks"],
    ["퍇", "pyaks"], ["퍣", "pyaeks"], ["퍿", "peoks"], ["펛", "peks"], ["펷", "pyeoks"], ["폓", "pyeks"], ["폯", "poks"], ["퐋", "pwaks"],
    ["퐧", "pwaeks"], ["푃", "poeks"], ["푟", "pyoks"], ["푻", "puks"], ["풗", "pwoks"], ["풳", "pweks"], ["퓏", "pwiks"], ["퓫", "pyuks"],
    ["픇", "peuks"], ["픣", "puiks"], ["픿", "piks"], ["핛", "haks"], ["핷", "haeks"], ["햓", "hyaks"], ["햯", "hyaeks"], ["헋", "heoks"],
    ["헧", "heks"], ["혃", "hyeoks"], ["혟", "hyeks"], ["혻", "hoks"], ["홗", "hwaks"], ["홳", "hwaeks"], ["횏", "hoeks"], ["횫", "hyoks"],
    ["훇", "huks"], ["훣", "hwoks"], ["훿", "hweks"], ["휛", "hwiks"], ["휷", "hyuks"], ["흓", "heuks"], ["흯", "huiks"], ["힋", "hiks"],
    ["갗", "gacc"], ["갳", "gaecc"], ["걏", "gyacc"], ["걫", "gyaecc"], ["겇", "geocc"], ["겣", "gecc"], ["겿", "gyeocc"], ["곛", "gyecc"],
    ["곷", "gocc"], ["괓", "gwacc"], ["괯", "gwaecc"], ["굋", "goecc"], ["굧", "gyocc"], ["궃", "gucc"], ["궟", "gwocc"], ["궻", "gwecc"],
    ["귗", "gwicc"], ["귳", "gyucc"], ["긏", "geucc"], ["긫", "guicc"], ["깇", "gicc"], ["깣", "kkacc"], ["깿", "kkaecc"], ["꺛", "kkyacc"],
    ["꺷", "kkyaecc"], ["껓", "kkeocc"], ["껯", "kkecc"], ["꼋", "kkyeocc"], ["꼧", "kkyecc"], ["꽃", "kkocc"], ["꽟", "kkwacc"], ["꽻", "kkwaecc"],
    ["꾗", "kkoecc"], ["꾳", "kkyocc"], ["꿏", "kkucc"], ["꿫", "kkwocc"], ["뀇", "kkwecc"], ["뀣", "kkwicc"], ["뀿", "kkyucc"], ["끛", "kkeucc"],
    ["끷", "kkuicc"], ["낓", "kkicc"], ["낯", "nacc"], ["냋", "naecc"], ["냧", "nyacc"], ["넃", "nyaecc"], ["넟", "neocc"], ["넻", "necc"],
    ["녗", "nyeocc"], ["녳", "nyecc"], ["놏", "nocc"], ["놫", "nwacc"], ["뇇", "nwaecc"], ["뇣", "noecc"], ["뇿", "nyocc"], ["눛", "nucc"],
    ["눷", "nwocc"], ["뉓", "nwecc"], ["뉯", "nwicc"], ["늋", "nyucc"], ["늧", "neucc"], ["닃", "nuicc"], ["닟", "nicc"], ["닻", "tacc"],
    ["댗", "taecc"], ["댳", "tyacc"], ["덏", "tyaecc"], ["덫", "teocc"], ["뎇", "tecc"], ["뎣", "tyeocc"], ["뎿", "tyecc"], ["돛", "tocc"],
    ["돷", "twacc"], ["됓", "twaecc"], ["됯", "toecc"], ["둋", "tyocc"], ["둧", "tucc"], ["뒃", "twocc"], ["뒟", "twecc"], ["뒻", "twicc"],
    ["듗", "tyucc"], ["듳", "teucc"], ["딏", "tuicc"], ["딫", "ticc"], ["땇", "tdacc"], ["땣", "tdaecc"], ["땿", "tdyacc"], ["떛", "tdyaecc"],
    ["떷", "tdeocc"], ["뗓", "tdecc"], ["뗯", "tdyeocc"], ["똋", "tdyecc"], ["똧", "tdocc"], ["뙃", "tdwacc"], ["뙟", "tdwaecc"], ["뙻", "tdoecc"],
    ["뚗", "tdyocc"], ["뚳", "tducc"], ["뛏", "tdwocc"], ["뛫", "tdwecc"], ["뜇", "tdwicc"], ["뜣", "tdyucc"], ["뜿", "tdeucc"], ["띛", "tduicc"],
    ["띷", "tdicc"], ["랓", "racc"], ["랯", "raecc"], ["럋", "ryacc"], ["럧", "ryaecc"], ["렃", "reocc"], ["렟", "recc"], ["렻", "ryeocc"],
    ["롗", "ryecc"], ["롳", "rocc"], ["뢏", "rwacc"], ["뢫", "rwaecc"], ["룇", "roecc"], ["룣", "ryocc"], ["룿", "rucc"], ["뤛", "rwocc"],
    ["뤷", "rwecc"], ["륓", "rwicc"], ["륯", "ryucc"], ["릋", "reucc"], ["릧", "ruicc"], ["맃", "ricc"], ["맟", "macc"], ["맻", "maecc"],
    ["먗", "myacc"], ["먳", "myaecc"], ["멏", "meocc"], ["멫", "mecc"], ["몇", "myeocc"], ["몣", "myecc"], ["몿", "mocc"], ["뫛", "mwacc"],
    ["뫷", "mwaecc"], ["묓", "moecc"], ["묯", "myocc"], ["뭋", "mucc"], ["뭧", "mwocc"], ["뮃", "mwecc"], ["뮟", "mwicc"], ["뮻", "myucc"],
    ["믗", "meucc"], ["믳", "muicc"], ["및", "micc"], ["밫", "bacc"], ["뱇", "baecc"], ["뱣", "byacc"], ["뱿", "byaecc"], ["벛", "beocc"],
    ["벷", "becc"], ["볓", "byeocc"], ["볯", "byecc"], ["봋", "bocc"], ["봧", "bwacc"], ["뵃", "bwaecc"], ["뵟", "boecc"], ["뵻", "byocc"],
    ["붗", "bucc"], ["붳", "bwocc"], ["뷏", "bwecc"], ["뷫", "bwicc"], ["븇", "byucc"], ["븣", "beucc"], ["븿", "buicc"], ["빛", "bicc"],
    ["빷", "ppacc"], ["뺓", "ppaecc"], ["뺯", "ppyacc"], ["뻋", "ppyaecc"], ["뻧", "ppeocc"], ["뼃", "ppecc"], ["뼟", "ppyeocc"], ["뼻", "ppyecc"],
    ["뽗", "ppocc"], ["뽳", "ppwacc"], ["뾏", "ppwaecc"], ["뾫", "ppoecc"], ["뿇", "ppyocc"], ["뿣", "ppucc"], ["뿿", "ppwocc"], ["쀛", "ppwecc"],
    ["쀷", "ppwicc"], ["쁓", "ppyucc"], ["쁯", "ppeucc"], ["삋", "ppuicc"], ["삧", "ppicc"], ["샃", "sacc"], ["샟", "saecc"], ["샻", "syacc"],
    ["섗", "syaecc"], ["섳", "seocc"], ["셏", "secc"], ["셫", "syeocc"], ["솇", "syecc"], ["솣", "socc"], ["솿", "swacc"], ["쇛", "swaecc"],
    ["쇷", "soecc"], ["숓", "syocc"], ["숯", "succ"], ["쉋", "swocc"], ["쉧", "swecc"], ["슃", "swicc"], ["슟", "syucc"], ["슻", "seucc"],
    ["싗", "suicc"], ["싳", "sicc"], ["쌏", "ssacc"], ["쌫", "ssaecc"], ["썇", "ssyacc"], ["썣", "ssyaecc"], ["썿", "sseocc"], ["쎛", "ssecc"],
    ["쎷", "ssyeocc"], ["쏓", "ssyecc"], ["쏯", "ssocc"], ["쐋", "sswacc"], ["쐧", "sswaecc"], ["쑃", "ssoecc"], ["쑟", "ssyocc"], ["쑻", "ssucc"],
    ["쒗", "sswocc"], ["쒳", "sswecc"], ["쓏", "sswicc"], ["쓫", "ssyucc"], ["씇", "sseucc"], ["씣", "ssuicc"], ["씿", "ssicc"], ["앛", "acc"],
    ["앷", "aecc"], ["얓", "yacc"], ["얯", "yaecc"], ["엋", "eocc"], ["엧", "ecc"], ["옃", "yeocc"], ["옟", "yecc"], ["옻", "occ"],
    ["왗", "wacc"], ["왳", "waecc"], ["욏", "oecc"], ["욫", "yocc"], ["웇", "ucc"], ["웣", "wocc"], ["웿", "wecc"], ["윛", "wicc"],
    ["윷", "yucc"], ["읓", "eucc"], ["읯", "uicc"], ["잋", "icc"], ["잧", "jacc"], ["쟃", "jaecc"], ["쟟", "jyacc"], ["쟻", "jyaecc"],
    ["젗", "jeocc"], ["젳", "jecc"], ["졏", "jyeocc"], ["졫", "jyecc"], ["좇", "jocc"], ["좣", "jwacc"], ["좿", "jwaecc"], ["죛", "joecc"],
    ["죷", "jyocc"], ["줓", "jucc"], ["줯", "jwocc"], ["쥋", "jwecc"], ["쥧", "jwicc"], ["즃", "jyucc"], ["즟", "jeucc"], ["즻", "juicc"],
    ["짗", "jicc"], ["짳", "jjacc"], ["쨏", "jjaecc"], ["쨫", "jjyacc"], ["쩇", "jjyaecc"], ["쩣", "jjeocc"], ["쩿", "jjecc"], ["쪛", "jjyeocc"],
    ["쪷", "jjyecc"], ["쫓", "jjocc"], ["쫯", "jjwacc"], ["쬋", "jjwaecc"], ["쬧", "jjoecc"], ["쭃", "jjyocc"], ["쭟", "jjucc"], ["쭻", "jjwocc"],
    ["쮗", "jjwecc"], ["쮳", "jjwicc"], ["쯏", "jjyucc"], ["쯫", "jjeucc"], ["찇", "jjuicc"], ["찣", "jjicc"], ["찿", "chacc"], ["챛", "chaecc"],
    ["챷", "chyacc"], ["첓", "chyaecc"], ["첯", "cheocc"], ["쳋", "checc"], ["쳧", "chyeocc"], ["촃", "chyecc"], ["촟", "chocc"], ["촻", "chwacc"],
    ["쵗", "chwaecc"], ["쵳", "choecc"], ["춏", "chyocc"], ["춫", "chucc"], ["췇", "chwocc"], ["췣", "chwecc"], ["췿", "chwicc"], ["츛", "chyucc"],
    ["츷", "cheucc"], ["칓", "chuicc"], ["칯", "chicc"], ["캋", "kacc"], ["캧", "kaecc"], ["컃", "kyacc"], ["컟", "kyaecc"], ["컻", "keocc"],
    ["켗", "kecc"], ["켳", "kyeocc"], ["콏", "kyecc"], ["콫", "kocc"], ["쾇", "kwacc"], ["쾣", "kwaecc"], ["쾿", "koecc"], ["쿛", "kyocc"],
    ["쿷", "kucc"], ["퀓", "kwocc"], ["퀯", "kwecc"], ["큋", "kwicc"], ["큧", "kyucc"], ["킃", "keucc"], ["킟", "kuicc"], ["킻", "kicc"],
    ["탗", "tacc"], ["탳", "taecc"], ["턏", "tyacc"], ["턫", "tyaecc"], ["텇", "teocc"], ["텣", "tecc"], ["텿", "tyeocc"], ["톛", "tyecc"],
    ["톷", "tocc"], ["퇓", "twacc"], ["퇯", "twaecc"], ["툋", "toecc"], ["툧", "tyocc"], ["퉃", "tucc"], ["퉟", "twocc"], ["퉻", "twecc"],
    ["튗", "twicc"], ["튳", "tyucc"], ["틏", "teucc"], ["틫", "tuicc"], ["팇", "ticc"], ["팣", "pacc"], ["팿", "paecc"], ["퍛", "pyacc"],
    ["퍷", "pyaecc"], ["펓", "peocc"], ["펯", "pecc"], ["폋", "pyeocc"], ["폧", "pyecc"], ["퐃", "pocc"], ["퐟", "pwacc"], ["퐻", "pwaecc"],
    ["푗", "poecc"], ["푳", "pyocc"], ["풏", "pucc"], ["풫", "pwocc"], ["퓇", "pwecc"], ["퓣", "pwicc"], ["퓿", "pyucc"], ["픛", "peucc"],
    ["픷", "puicc"], ["핓", "picc"], ["핯", "hacc"], ["햋", "haecc"], ["햧", "hyacc"], ["헃", "hyaecc"], ["헟", "heocc"], ["헻", "hecc"],
    ["혗", "hyeocc"], ["혳", "hyecc"], ["홏", "hocc"], ["홫", "hwacc"], ["횇", "hwaecc"], ["횣", "hoecc"], ["횿", "hyocc"], ["훛", "hucc"],
    ["훷", "hwocc"], ["휓", "hwecc"], ["휯", "hwicc"], ["흋", "hyucc"], ["흧", "heucc"], ["힃", "huicc"], ["힟", "hicc"], ["값", "gaps"],
    ["갮", "gaeps"], ["걊", "gyaps"], ["걦", "gyaeps"], ["겂", "geops"], ["겞", "geps"], ["겺", "gyeops"], ["곖", "gyeps"], ["곲", "gops"],
    ["괎", "gwaps"], ["괪", "gwaeps"], ["굆", "goeps"], ["굢", "gyops"], ["굾", "gups"], ["궚", "gwops"], ["궶", "gweps"], ["귒", "gwips"],
    ["귮", "gyups"], ["긊", "geups"], ["긦", "guips"], ["깂", "gips"], ["깞", "kkaps"], ["깺", "kkaeps"], ["꺖", "kkyaps"], ["꺲", "kkyaeps"],
    ["껎", "kkeops"], ["껪", "kkeps"], ["꼆", "kkyeops"], ["꼢", "kkyeps"], ["꼾", "kkops"], ["꽚", "kkwaps"], ["꽶", "kkwaeps"], ["꾒", "kkoeps"],
    ["꾮", "kkyops"], ["꿊", "kkups"], ["꿦", "kkwops"], ["뀂", "kkweps"], ["뀞", "kkwips"], ["뀺", "kkyups"], ["끖", "kkeups"], ["끲", "kkuips"],
    ["낎", "kkips"], ["낪", "naps"], ["냆", "naeps"], ["냢", "nyaps"], ["냾", "nyaeps"], ["넚", "neops"], ["넶", "neps"], ["녒", "nyeops"],
    ["녮", "nyeps"], ["놊", "nops"], ["놦", "nwaps"], ["뇂", "nwaeps"], ["뇞", "noeps"], ["뇺", "nyops"], ["눖", "nups"], ["눲", "nwops"],
    ["뉎", "nweps"], ["뉪", "nwips"], ["늆", "nyups"], ["늢", "neups"], ["늾", "nuips"], ["닚", "nips"], ["닶", "taps"], ["댒", "taeps"],
    ["댮", "tyaps"], ["덊", "tyaeps"], ["덦", "teops"], ["뎂", "teps"], ["뎞", "tyeops"], ["뎺", "tyeps"], ["돖", "tops"], ["돲", "twaps"],
    ["됎", "twaeps"], ["됪", "toeps"], ["둆", "tyops"], ["둢", "tups"], ["둾", "twops"], ["뒚", "tweps"], ["뒶", "twips"], ["듒", "tyups"],
    ["듮", "teups"], ["딊", "tuips"], ["딦", "tips"], ["땂", "tdaps"], ["땞", "tdaeps"], ["땺", "tdyaps"], ["떖", "tdyaeps"], ["떲", "tdeops"],
    ["뗎", "tdeps"], ["뗪", "tdyeops"], ["똆", "tdyeps"], ["똢", "tdops"], ["똾", "tdwaps"], ["뙚", "tdwaeps"], ["뙶", "tdoeps"], ["뚒", "tdyops"],
    ["뚮", "tdups"], ["뛊", "tdwops"], ["뛦", "tdweps"], ["뜂", "tdwips"], ["뜞", "tdyups"], ["뜺", "tdeups"], ["띖", "tduips"], ["띲", "tdips"],
    ["랎", "raps"], ["랪", "raeps"], ["럆", "ryaps"], ["럢", "ryaeps"], ["럾", "reops"], ["렚", "reps"], ["렶", "ryeops"], ["롒", "ryeps"],
    ["롮", "rops"], ["뢊", "rwaps"], ["뢦", "rwaeps"], ["룂", "roeps"], ["룞", "ryops"], ["룺", "rups"], ["뤖", "rwops"], ["뤲", "rweps"],
    ["륎", "rwips"], ["륪", "ryups"], ["릆", "reups"], ["릢", "ruips"], ["릾", "rips"], ["맚", "maps"], ["맶", "maeps"], ["먒", "myaps"],
    ["먮", "myaeps"], ["멊", "meops"], ["멦", "meps"], ["몂", "myeops"], ["몞", "myeps"], ["몺", "mops"], ["뫖", "mwaps"], ["뫲", "mwaeps"],
    ["묎", "moeps"], ["묪", "myops"], ["뭆", "mups"], ["뭢", "mwops"], ["뭾", "mweps"], ["뮚", "mwips"], ["뮶", "myups"], ["믒", "meups"],
    ["믮", "muips"], ["밊", "mips"], ["밦", "baps"], ["뱂", "baeps"], ["뱞", "byaps"], ["뱺", "byaeps"], ["벖", "beops"], ["벲", "beps"],
    ["볎", "byeops"], ["볪", "byeps"], ["봆", "bops"], ["봢", "bwaps"], ["봾", "bwaeps"], ["뵚", "boeps"], ["뵶", "byops"], ["붒", "bups"],
    ["붮", "bwops"], ["뷊", "bweps"], ["뷦", "bwips"], ["븂", "byups"], ["븞", "beups"], ["븺", "buips"], ["빖", "bips"], ["빲", "ppaps"],
    ["뺎", "ppaeps"], ["뺪", "ppyaps"], ["뻆", "ppyaeps"], ["뻢", "ppeops"], ["뻾", "ppeps"], ["뼚", "ppyeops"], ["뼶", "ppyeps"], ["뽒", "ppops"],
    ["뽮", "ppwaps"], ["뾊", "ppwaeps"], ["뾦", "ppoeps"], ["뿂", "ppyops"], ["뿞", "ppups"], ["뿺", "ppwops"], ["쀖", "ppweps"], ["쀲", "ppwips"],
    ["쁎", "ppyups"], ["쁪", "ppeups"], ["삆", "ppuips"], ["삢", "ppips"], ["삾", "saps"], ["샚", "saeps"], ["샶", "syaps"], ["섒", "syaeps"],
    ["섮", "seops"], ["셊", "seps"], ["셦", "syeops"], ["솂", "syeps"], ["솞", "sops"], ["솺", "swaps"], ["쇖", "swaeps"], ["쇲", "soeps"],
    ["숎", "syops"], ["숪", "sups"], ["쉆", "swops"], ["쉢", "sweps"], ["쉾", "swips"], ["슚", "syups"], ["슶", "seups"], ["싒", "suips"],
    ["싮", "sips"], ["쌊", "ssaps"], ["쌦", "ssaeps"], ["썂", "ssyaps"], ["썞", "ssyaeps"], ["썺", "sseops"], ["쎖", "sseps"], ["쎲", "ssyeops"],
    ["쏎", "ssyeps"], ["쏪", "ssops"], ["쐆", "sswaps"], ["쐢", "sswaeps"], ["쐾", "ssoeps"], ["쑚", "ssyops"], ["쑶", "ssups"], ["쒒", "sswops"],
    ["쒮", "ssweps"], ["쓊", "sswips"], ["쓦", "ssyups"], ["씂", "sseups"], ["씞", "ssuips"], ["씺", "ssips"], ["앖", "aps"], ["앲", "aeps"],
    ["얎", "yaps"], ["얪", "yaeps"], ["없", "eops"], ["엢", "eps"], ["엾", "yeops"], ["옚", "yeps"], ["옶", "ops"], ["왒", "waps"],
    ["왮", "waeps"], ["욊", "oeps"], ["욦", "yops"], ["웂", "ups"], ["웞", "wops"], ["웺", "weps"], ["윖", "wips"], ["윲", "yups"],
    ["읎", "eups"], ["읪", "uips"], ["잆", "ips"], ["잢", "japs"], ["잾", "jaeps"], ["쟚", "jyaps"], ["쟶", "jyaeps"], ["젒", "jeops"],
    ["젮", "jeps"], ["졊", "jyeops"], ["졦", "jyeps"], ["좂", "jops"], ["좞", "jwaps"], ["좺", "jwaeps"], ["죖", "joeps"], ["죲", "jyops"],
    ["줎", "jups"], ["줪", "jwops"], ["쥆", "jweps"], ["쥢", "jwips"], ["쥾", "jyups"], ["즚", "jeups"], ["즶", "juips"], ["짒", "jips"],
    ["짮", "jjaps"], ["쨊", "jjaeps"], ["쨦", "jjyaps"], ["쩂", "jjyaeps"], ["쩞", "jjeops"], ["쩺", "jjeps"], ["쪖", "jjyeops"], ["쪲", "jjyeps"],
    ["쫎", "jjops"], ["쫪", "jjwaps"], ["쬆", "jjwaeps"], ["쬢", "jjoeps"], ["쬾", "jjyops"], ["쭚", "jjups"], ["쭶", "jjwops"], ["쮒", "jjweps"],
    ["쮮", "jjwips"], ["쯊", "jjyups"], ["쯦", "jjeups"], ["찂", "jjuips"], ["찞", "jjips"], ["찺", "chaps"], ["챖", "chaeps"], ["챲", "chyaps"],
    ["첎", "chyaeps"], ["첪", "cheops"], ["쳆", "cheps"], ["쳢", "chyeops"], ["쳾", "chyeps"], ["촚", "chops"], ["촶", "chwaps"], ["쵒", "chwaeps"],
    ["쵮", "choeps"], ["춊", "chyops"], ["춦", "chups"], ["췂", "chwops"], ["췞", "chweps"], ["췺", "chwips"], ["츖", "chyups"], ["츲", "cheups"],
    ["칎", "chuips"], ["칪", "chips"], ["캆", "kaps"], ["캢", "kaeps"], ["캾", "kyaps"], ["컚", "kyaeps"], ["컶", "keops"], ["켒", "keps"],
    ["켮", "kyeops"], ["콊", "kyeps"], ["콦", "kops"], ["쾂", "kwaps"], ["쾞", "kwaeps"], ["쾺", "koeps"], ["쿖", "kyops"], ["쿲", "kups"],
    ["퀎", "kwops"], ["퀪", "kweps"], ["큆", "kwips"], ["큢", "kyups"], ["큾", "keups"], ["킚", "kuips"], ["킶", "kips"], ["탒", "taps"],
    ["탮", "taeps"], ["턊", "tyaps"], ["턦", "tyaeps"], ["텂", "teops"], ["텞", "teps"], ["텺", "tyeops"], ["톖", "tyeps"], ["톲", "tops"],
    ["퇎", "twaps"], ["퇪", "twaeps"], ["툆", "toeps"], ["툢", "tyops"], ["툾", "tups"], ["퉚", "twops"], ["퉶", "tweps"], ["튒", "twips"],
    ["튮", "tyups"], ["틊", "teups"], ["틦", "tuips"], ["팂", "tips"], ["팞", "paps"], ["팺", "paeps"], ["퍖", "pyaps"], ["퍲", "pyaeps"],
    ["펎", "peops"], ["펪", "peps"], ["폆", "pyeops"], ["폢", "pyeps"], ["폾", "pops"], ["퐚", "pwaps"], ["퐶", "pwaeps"], ["푒", "poeps"],
    ["푮", "pyops"], ["풊", "pups"], ["풦", "pwops"], ["퓂", "pweps"], ["퓞", "pwips"], ["퓺", "pyups"], ["픖", "peups"], ["픲", "puips"],
    ["핎", "pips"], ["핪", "haps"], ["햆", "haeps"], ["햢", "hyaps"], ["햾", "hyaeps"], ["헚", "heops"], ["헶", "heps"], ["혒", "hyeops"],
    ["혮", "hyeps"], ["홊", "hops"], ["홦", "hwaps"], ["횂", "hwaeps"], ["횞", "hoeps"], ["횺", "hyops"], ["훖", "hups"], ["훲", "hwops"],
    ["휎", "hweps"], ["휪", "hwips"], ["흆", "hyups"], ["흢", "heups"], ["흾", "huips"], ["힚", "hips"], ["갅", "ganj"], ["갡", "gaenj"],
    ["갽", "gyanj"], ["걙", "gyaenj"], ["걵", "geonj"], ["겑", "genj"], ["겭", "gyeonj"], ["곉", "gyenj"], ["곥", "gonj"], ["괁", "gwanj"],
    ["괝", "gwaenj"], ["괹", "goenj"], ["굕", "gyonj"], ["굱", "gunj"], ["궍", "gwonj"], ["궩", "gwenj"], ["귅", "gwinj"], ["귡", "gyunj"],
    ["귽", "geunj"], ["긙", "guinj"], ["긵", "ginj"], ["깑", "kkanj"], ["깭", "kkaenj"], ["꺉", "kkyanj"], ["꺥", "kkyaenj"], ["껁", "kkeonj"],
    ["껝", "kkenj"], ["껹", "kkyeonj"], ["꼕", "kkyenj"], ["꼱", "kkonj"], ["꽍", "kkwanj"], ["꽩", "kkwaenj"], ["꾅", "kkoenj"], ["꾡", "kkyonj"],
    ["꾽", "kkunj"], ["꿙", "kkwonj"], ["꿵", "kkwenj"], ["뀑", "kkwinj"], ["뀭", "kkyunj"], ["끉", "kkeunj"], ["끥", "kkuinj"], ["낁", "kkinj"],
    ["낝", "nanj"], ["낹", "naenj"], ["냕", "nyanj"], ["냱", "nyaenj"], ["넍", "neonj"], ["넩", "nenj"], ["녅", "nyeonj"], ["녡", "nyenj"],
    ["녽", "nonj"], ["놙", "nwanj"], ["놵", "nwaenj"], ["뇑", "noenj"], ["뇭", "nyonj"], ["눉", "nunj"], ["눥", "nwonj"], ["뉁", "nwenj"],
    ["뉝", "nwinj"], ["뉹", "nyunj"], ["늕", "neunj"], ["늱", "nuinj"], ["닍", "ninj"], ["닩", "tanj"], ["댅", "taenj"], ["댡", "tyanj"],
    ["댽", "tyaenj"], ["덙", "teonj"], ["덵", "tenj"], ["뎑", "tyeonj"], ["뎭", "tyenj"], ["돉", "tonj"], ["돥", "twanj"], ["됁", "twaenj"],
    ["됝", "toenj"], ["됹", "tyonj"], ["둕", "tunj"], ["둱", "twonj"], ["뒍", "twenj"], ["뒩", "twinj"], ["듅", "tyunj"], ["듡", "teunj"],
    ["듽", "tuinj"], ["딙", "tinj"], ["딵", "tdanj"], ["땑", "tdaenj"], ["땭", "tdyanj"], ["떉", "tdyaenj"], ["떥", "tdeonj"], ["뗁", "tdenj"],
    ["뗝", "tdyeonj"], ["뗹", "tdyenj"], ["똕", "tdonj"], ["똱", "tdwanj"], ["뙍", "tdwaenj"], ["뙩", "tdoenj"], ["뚅", "tdyonj"], ["뚡", "tdunj"],
    ["뚽", "tdwonj"], ["뛙", "tdwenj"], ["뛵", "tdwinj"], ["뜑", "tdyunj"], ["뜭", "tdeunj"], ["띉", "tduinj"], ["띥", "tdinj"], ["랁", "ranj"],
    ["랝", "raenj"], ["랹", "ryanj"], ["럕", "ryaenj"], ["럱", "reonj"], ["렍", "renj"], ["렩", "ryeonj"], ["롅", "ryenj"], ["롡", "ronj"],
    ["롽", "rwanj"], ["뢙", "rwaenj"], ["뢵", "roenj"], ["룑", "ryonj"], ["룭", "runj"], ["뤉", "rwonj"], ["뤥", "rwenj"], ["륁", "rwinj"],
    ["륝", "ryunj"], ["륹", "reunj"], ["릕", "ruinj"], ["릱", "rinj"], ["맍", "manj"], ["맩", "maenj"], ["먅", "myanj"], ["먡", "myaenj"],
    ["먽", "meonj"], ["멙", "menj"], ["멵", "myeonj"], ["몑", "myenj"], ["몭", "monj"], ["뫉", "mwanj"], ["뫥", "mwaenj"], ["묁", "moenj"],
    ["묝", "myonj"], ["묹", "munj"], ["뭕", "mwonj"], ["뭱", "mwenj"], ["뮍", "mwinj"], ["뮩", "myunj"], ["믅", "meunj"], ["믡", "muinj"],
    ["믽", "minj"], ["밙", "banj"], ["밵", "baenj"], ["뱑", "byanj"], ["뱭", "byaenj"], ["벉", "beonj"], ["벥", "benj"], ["볁", "byeonj"],
    ["볝", "byenj"], ["볹", "bonj"], ["봕", "bwanj"], ["봱", "bwaenj"], ["뵍", "boenj"], ["뵩", "byonj"], ["붅", "bunj"], ["붡", "bwonj"],
    ["붽", "bwenj"], ["뷙", "bwinj"], ["뷵", "byunj"], ["븑", "beunj"], ["븭", "buinj"], ["빉", "binj"], ["빥", "ppanj"], ["뺁", "ppaenj"],
    ["뺝", "ppyanj"], ["뺹", "ppyaenj"], ["뻕", "ppeonj"], ["뻱", "ppenj"], ["뼍", "ppyeonj"], ["뼩", "ppyenj"], ["뽅", "pponj"], ["뽡", "ppwanj"],
    ["뽽", "ppwaenj"], ["뾙", "ppoenj"], ["뾵", "ppyonj"], ["뿑", "ppunj"], ["뿭", "ppwonj"], ["쀉", "ppwenj"], ["쀥", "ppwinj"], ["쁁", "ppyunj"],
    ["쁝", "ppeunj"], ["쁹", "ppuinj"], ["삕", "ppinj"], ["삱", "sanj"], ["샍", "saenj"], ["샩", "syanj"], ["섅", "syaenj"], ["섡", "seonj"],
    ["섽", "senj"], ["셙", "syeonj"], ["셵", "syenj"], ["솑", "sonj"], ["솭", "swanj"], ["쇉", "swaenj"], ["쇥", "soenj"], ["숁", "syonj"],
    ["숝", "sunj"], ["숹", "swonj"], ["쉕", "swenj"], ["쉱", "swinj"], ["슍", "syunj"], ["슩", "seunj"], ["싅", "suinj"], ["싡", "sinj"],
    ["싽", "ssanj"], ["쌙", "ssaenj"], ["쌵", "ssyanj"], ["썑", "ssyaenj"], ["썭", "sseonj"], ["쎉", "ssenj"], ["쎥", "ssyeonj"], ["쏁", "ssyenj"],
    ["쏝", "ssonj"], ["쏹", "sswanj"], ["쐕", "sswaenj"], ["쐱", "ssoenj"], ["쑍", "ssyonj"], ["쑩", "ssunj"], ["쒅", "sswonj"], ["쒡", "sswenj"],
    ["쒽", "sswinj"], ["쓙", "ssyunj"], ["쓵", "sseunj"], ["씑", "ssuinj"], ["씭", "ssinj"], ["앉", "anj"], ["앥", "aenj"], ["얁", "yanj"],
    ["얝", "yaenj"], ["얹", "eonj"], ["엕", "enj"], ["엱", "yeonj"], ["옍", "yenj"], ["옩", "onj"], ["왅", "wanj"], ["왡", "waenj"],
    ["왽", "oenj"], ["욙", "yonj"], ["욵", "unj"], ["웑", "wonj"], ["웭", "wenj"], ["윉", "winj"], ["윥", "yunj"], ["읁", "eunj"],
    ["읝", "uinj"], ["읹", "inj"], ["잕", "janj"], ["잱", "jaenj"], ["쟍", "jyanj"], ["쟩", "jyaenj"], ["젅", "jeonj"], ["젡", "jenj"],
    ["젽", "jyeonj"], ["졙", "jyenj"], ["졵", "jonj"], ["좑", "jwanj"], ["좭", "jwaenj"], ["죉", "joenj"], ["죥", "jyonj"], ["줁", "junj"],
    ["줝", "jwonj"], ["줹", "jwenj"], ["쥕", "jwinj"], ["쥱", "jyunj"], ["즍", "jeunj"], ["즩", "juinj"], ["짅", "jinj"], ["짡", "jjanj"],
    ["짽", "jjaenj"], ["쨙", "jjyanj"], ["쨵", "jjyaenj"], ["쩑", "jjeonj"], ["쩭", "jjenj"], ["쪉", "jjyeonj"], ["쪥", "jjyenj"], ["쫁", "jjonj"],
    ["쫝", "jjwanj"], ["쫹", "jjwaenj"], ["쬕", "jjoenj"], ["쬱", "jjyonj"], ["쭍", "jjunj"], ["쭩", "jjwonj"], ["쮅", "jjwenj"], ["쮡", "jjwinj"],
    ["쮽", "jjyunj"], ["쯙", "jjeunj"], ["쯵", "jjuinj"], ["찑", "jjinj"], ["찭", "chanj"], ["챉", "chaenj"], ["챥", "chyanj"], ["첁", "chyaenj"],
    ["첝", "cheonj"], ["첹", "chenj"], ["쳕", "chyeonj"], ["쳱", "chyenj"], ["촍", "chonj"], ["촩", "chwanj"], ["쵅", "chwaenj"], ["쵡", "choenj"],
    ["쵽", "chyonj"], ["춙", "chunj"], ["춵", "chwonj"], ["췑", "chwenj"], ["췭", "chwinj"], ["츉", "chyunj"], ["츥", "cheunj"], ["칁", "chuinj"],
    ["칝", "chinj"], ["칹", "kanj"], ["캕", "kaenj"], ["캱", "kyanj"], ["컍", "kyaenj"], ["컩", "keonj"], ["켅", "kenj"], ["켡", "kyeonj"],
    ["켽", "kyenj"], ["콙", "konj"], ["콵", "kwanj"], ["쾑", "kwaenj"], ["쾭", "koenj"], ["쿉", "kyonj"], ["쿥", "kunj"], ["퀁", "kwonj"],
    ["퀝", "kwenj"], ["퀹", "kwinj"], ["큕", "kyunj"], ["큱", "keunj"], ["킍", "kuinj"], ["킩", "kinj"], ["탅", "tanj"], ["탡", "taenj"],
    ["탽", "tyanj"], ["턙", "tyaenj"], ["턵", "teonj"], ["텑", "tenj"], ["텭", "tyeonj"], ["톉", "tyenj"], ["톥", "tonj"], ["퇁", "twanj"],
    ["퇝", "twaenj"], ["퇹", "toenj"], ["툕", "tyonj"], ["툱", "tunj"], ["퉍", "twonj"], ["퉩", "twenj"], ["튅", "twinj"], ["튡", "tyunj"],
    ["튽", "teunj"], ["틙", "tuinj"], ["틵", "tinj"], ["팑", "panj"], ["팭", "paenj"], ["퍉", "pyanj"], ["퍥", "pyaenj"], ["펁", "peonj"],
    ["펝", "penj"], ["펹", "pyeonj"], ["폕", "pyenj"], ["폱", "ponj"], ["퐍", "pwanj"], ["퐩", "pwaenj"], ["푅", "poenj"], ["푡", "pyonj"],
    ["푽", "punj"], ["풙", "pwonj"], ["풵", "pwenj"], ["퓑", "pwinj"], ["퓭", "pyunj"], ["픉", "peunj"], ["픥", "puinj"], ["핁", "pinj"],
    ["핝", "hanj"], ["핹", "haenj"], ["햕", "hyanj"], ["햱", "hyaenj"], ["헍", "heonj"], ["헩", "henj"], ["혅", "hyeonj"], ["혡", "hyenj"],
    ["혽", "honj"], ["홙", "hwanj"], ["홵", "hwaenj"], ["횑", "hoenj"], ["횭", "hyonj"], ["훉", "hunj"], ["훥", "hwonj"], ["휁", "hwenj"],
    ["휝", "hwinj"], ["휹", "hyunj"], ["흕", "heunj"], ["흱", "huinj"], ["힍", "hinj"], ["갆", "ganh"], ["갢", "gaenh"], ["갾", "gyanh"],
    ["걚", "gyaenh"], ["걶", "geonh"], ["겒", "genh"], ["겮", "gyeonh"], ["곊", "gyenh"], ["곦", "gonh"], ["괂", "gwanh"], ["괞", "gwaenh"],
    ["괺", "goenh"], ["굖", "gyonh"], ["굲", "gunh"], ["궎", "gwonh"], ["궪", "gwenh"], ["귆", "gwinh"], ["귢", "gyunh"], ["귾", "geunh"],
    ["긚", "guinh"], ["긶", "ginh"], ["깒", "kkanh"], ["깮", "kkaenh"], ["꺊", "kkyanh"], ["꺦", "kkyaenh"], ["껂", "kkeonh"], ["껞", "kkenh"],
    ["껺", "kkyeonh"], ["꼖", "kkyenh"], ["꼲", "kkonh"], ["꽎", "kkwanh"], ["꽪", "kkwaenh"], ["꾆", "kkoenh"], ["꾢", "kkyonh"], ["꾾", "kkunh"],
    ["꿚", "kkwonh"], ["꿶", "kkwenh"], ["뀒", "kkwinh"], ["뀮", "kkyunh"], ["끊", "kkeunh"], ["끦", "kkuinh"], ["낂", "kkinh"], ["낞", "nanh"],
    ["낺", "naenh"], ["냖", "nyanh"], ["냲", "nyaenh"], ["넎", "neonh"], ["넪", "nenh"], ["녆", "nyeonh"], ["녢", "nyenh"], ["녾", "nonh"],
    ["놚", "nwanh"], ["놶", "nwaenh"], ["뇒", "noenh"], ["뇮", "nyonh"], ["눊", "nunh"], ["눦", "nwonh"], ["뉂", "nwenh"], ["뉞", "nwinh"],
    ["뉺", "nyunh"], ["늖", "neunh"], ["늲", "nuinh"], ["닎", "ninh"], ["닪", "tanh"], ["댆", "taenh"], ["댢", "tyanh"], ["댾", "tyaenh"],
    ["덚", "teonh"], ["덶", "tenh"], ["뎒", "tyeonh"], ["뎮", "tyenh"], ["돊", "tonh"], ["돦", "twanh"], ["됂", "twaenh"], ["됞", "toenh"],
    ["됺", "tyonh"], ["둖", "tunh"], ["둲", "twonh"], ["뒎", "twenh"], ["뒪", "twinh"], ["듆", "tyunh"], ["듢", "teunh"], ["듾", "tuinh"],
    ["딚", "tinh"], ["딶", "tdanh"], ["땒", "tdaenh"], ["땮", "tdyanh"], ["떊", "tdyaenh"], ["떦", "tdeonh"], ["뗂", "tdenh"], ["뗞", "tdyeonh"],
    ["뗺", "tdyenh"], ["똖", "tdonh"], ["똲", "tdwanh"], ["뙎", "tdwaenh"], ["뙪", "tdoenh"], ["뚆", "tdyonh"], ["뚢", "tdunh"], ["뚾", "tdwonh"],
    ["뛚", "tdwenh"], ["뛶", "tdwinh"], ["뜒", "tdyunh"], ["뜮", "tdeunh"], ["띊", "tduinh"], ["띦", "tdinh"], ["랂", "ranh"], ["랞", "raenh"],
    ["랺", "ryanh"], ["럖", "ryaenh"], ["럲", "reonh"], ["렎", "renh"], ["렪", "ryeonh"], ["롆", "ryenh"], ["롢", "ronh"], ["롾", "rwanh"],
    ["뢚", "rwaenh"], ["뢶", "roenh"], ["룒", "ryonh"], ["룮", "runh"], ["뤊", "rwonh"], ["뤦", "rwenh"], ["륂", "rwinh"], ["륞", "ryunh"],
    ["륺", "reunh"], ["릖", "ruinh"], ["릲", "rinh"], ["많", "manh"], ["맪", "maenh"], ["먆", "myanh"], ["먢", "myaenh"], ["먾", "meonh"],
    ["멚", "menh"], ["멶", "myeonh"], ["몒", "myenh"], ["몮", "monh"], ["뫊", "mwanh"], ["뫦", "mwaenh"], ["묂", "moenh"], ["묞", "myonh"],
    ["묺", "munh"], ["뭖", "mwonh"], ["뭲", "mwenh"], ["뮎", "mwinh"], ["뮪", "myunh"], ["믆", "meunh"], ["믢", "muinh"], ["믾", "minh"],
    ["밚", "banh"], ["밶", "baenh"], ["뱒", "byanh"], ["뱮", "byaenh"], ["벊", "beonh"], ["벦", "benh"], ["볂", "byeonh"], ["볞", "byenh"],
    ["볺", "bonh"], ["봖", "bwanh"], ["봲", "bwaenh"], ["뵎", "boenh"], ["뵪", "byonh"], ["붆", "bunh"], ["붢", "bwonh"], ["붾", "bwenh"],
    ["뷚", "bwinh"], ["뷶", "byunh"], ["븒", "beunh"], ["븮", "buinh"], ["빊", "binh"], ["빦", "ppanh"], ["뺂", "ppaenh"], ["뺞", "ppyanh"],
    ["뺺", "ppyaenh"], ["뻖", "ppeonh"], ["뻲", "ppenh"], ["뼎", "ppyeonh"], ["뼪", "ppyenh"], ["뽆", "pponh"], ["뽢", "ppwanh"], ["뽾", "ppwaenh"],
    ["뾚", "ppoenh"], ["뾶", "ppyonh"], ["뿒", "ppunh"], ["뿮", "ppwonh"], ["쀊", "ppwenh"], ["쀦", "ppwinh"], ["쁂", "ppyunh"], ["쁞", "ppeunh"],
    ["쁺", "ppuinh"], ["삖", "ppinh"], ["삲", "sanh"], ["샎", "saenh"], ["샪", "syanh"], ["섆", "syaenh"], ["섢", "seonh"], ["섾", "senh"],
    ["셚", "syeonh"], ["셶", "syenh"], ["솒", "sonh"], ["솮", "swanh"], ["쇊", "swaenh"], ["쇦", "soenh"], ["숂", "syonh"], ["숞", "sunh"],
    ["숺", "swonh"], ["쉖", "swenh"], ["쉲", "swinh"], ["슎", "syunh"], ["슪", "seunh"], ["싆", "suinh"], ["싢", "sinh"], ["싾", "ssanh"],
    ["쌚", "ssaenh"], ["쌶", "ssyanh"], ["썒", "ssyaenh"], ["썮", "sseonh"], ["쎊", "ssenh"], ["쎦", "ssyeonh"], ["쏂", "ssyenh"], ["쏞", "ssonh"],
    ["쏺", "sswanh"], ["쐖", "sswaenh"], ["쐲", "ssoenh"], ["쑎", "ssyonh"], ["쑪", "ssunh"], ["쒆", "sswonh"], ["쒢", "sswenh"], ["쒾", "sswinh"],
    ["쓚", "ssyunh"], ["쓶", "sseunh"], ["씒", "ssuinh"], ["씮", "ssinh"], ["않", "anh"], ["앦", "aenh"], ["얂", "yanh"], ["얞", "yaenh"],
    ["얺", "eonh"], ["엖", "enh"], ["엲", "yeonh"], ["옎", "yenh"], ["옪", "onh"], ["왆", "wanh"], ["왢", "waenh"], ["왾", "oenh"],
    ["욚", "yonh"], ["욶", "unh"], ["웒", "wonh"], ["웮", "wenh"], ["윊", "winh"], ["윦", "yunh"], ["읂", "eunh"], ["읞", "uinh"],
    ["읺", "inh"], ["잖", "janh"], ["잲", "jaenh"], ["쟎", "jyanh"], ["쟪", "jyaenh"], ["젆", "jeonh"], ["젢", "jenh"], ["젾", "jyeonh"],
    ["졚", "jyenh"], ["졶", "jonh"], ["좒", "jwanh"], ["좮", "jwaenh"], ["죊", "joenh"], ["죦", "jyonh"], ["줂", "junh"], ["줞", "jwonh"],
    ["줺", "jwenh"], ["쥖", "jwinh"], ["쥲", "jyunh"], ["즎", "jeunh"], ["즪", "juinh"], ["짆", "jinh"], ["짢", "jjanh"], ["짾", "jjaenh"],
    ["쨚", "jjyanh"], ["쨶", "jjyaenh"], ["쩒", "jjeonh"], ["쩮", "jjenh"], ["쪊", "jjyeonh"], ["쪦", "jjyenh"], ["쫂", "jjonh"], ["쫞", "jjwanh"],
    ["쫺", "jjwaenh"], ["쬖", "jjoenh"], ["쬲", "jjyonh"], ["쭎", "jjunh"], ["쭪", "jjwonh"], ["쮆", "jjwenh"], ["쮢", "jjwinh"], ["쮾", "jjyunh"],
    ["쯚", "jjeunh"], ["쯶", "jjuinh"], ["찒", "jjinh"], ["찮", "chanh"], ["챊", "chaenh"], ["챦", "chyanh"], ["첂", "chyaenh"], ["첞", "cheonh"],
    ["첺", "chenh"], ["쳖", "chyeonh"], ["쳲", "chyenh"], ["촎", "chonh"], ["촪", "chwanh"], ["쵆", "chwaenh"], ["쵢", "choenh"], ["쵾", "chyonh"],
    ["춚", "chunh"], ["춶", "chwonh"], ["췒", "chwenh"], ["췮", "chwinh"], ["츊", "chyunh"], ["츦", "cheunh"], ["칂", "chuinh"], ["칞", "chinh"],
    ["칺", "kanh"], ["캖", "kaenh"], ["캲", "kyanh"], ["컎", "kyaenh"], ["컪", "keonh"], ["켆", "kenh"], ["켢", "kyeonh"], ["켾", "kyenh"],
    ["콚", "konh"], ["콶", "kwanh"], ["쾒", "kwaenh"], ["쾮", "koenh"], ["쿊", "kyonh"], ["쿦", "kunh"], ["퀂", "kwonh"], ["퀞", "kwenh"],
    ["퀺", "kwinh"], ["큖", "kyunh"], ["큲", "keunh"], ["킎", "kuinh"], ["킪", "kinh"], ["탆", "tanh"], ["탢", "taenh"], ["탾", "tyanh"],
    ["턚", "tyaenh"], ["턶", "teonh"], ["텒", "tenh"], ["텮", "tyeonh"], ["톊", "tyenh"], ["톦", "tonh"], ["퇂", "twanh"], ["퇞", "twaenh"],
    ["퇺", "toenh"], ["툖", "tyonh"], ["툲", "tunh"], ["퉎", "twonh"], ["퉪", "twenh"], ["튆", "twinh"], ["튢", "tyunh"], ["튾", "teunh"],
    ["틚", "tuinh"], ["틶", "tinh"], ["팒", "panh"], ["팮", "paenh"], ["퍊", "pyanh"], ["퍦", "pyaenh"], ["펂", "peonh"], ["펞", "penh"],
    ["펺", "pyeonh"], ["폖", "pyenh"], ["폲", "ponh"], ["퐎", "pwanh"], ["퐪", "pwaenh"], ["푆", "poenh"], ["푢", "pyonh"], ["푾", "punh"],
    ["풚", "pwonh"], ["풶", "pwenh"], ["퓒", "pwinh"], ["퓮", "pyunh"], ["픊", "peunh"], ["픦", "puinh"], ["핂", "pinh"], ["핞", "hanh"],
    ["핺", "haenh"], ["햖", "hyanh"], ["햲", "hyaenh"], ["헎", "heonh"], ["헪", "henh"], ["혆", "hyeonh"], ["혢", "hyenh"], ["혾", "honh"],
    ["홚", "hwanh"], ["홶", "hwaenh"], ["횒", "hoenh"], ["횮", "hyonh"], ["훊", "hunh"], ["훦", "hwonh"], ["휂", "hwenh"], ["휞", "hwinh"],
    ["휺", "hyunh"], ["흖", "heunh"], ["흲", "huinh"], ["힎", "hinh"],

    [
        '헌법재판소 재판관은 탄핵 또는 금고 이상의 형의 선고에 의하지 아니하고는 파면되지 아니한다.',
        'heonbeopjaepanso jaepangwaneun tanhaek ttoneun geumgo isangui hyeongui seongoe uihaji anihagoneun pamyeondoeji anihanda.'
    ],
    [
        '정당의 설립은 자유이며, 복수정당제는 보장된다.',
        'jeongdangui seollibeun jayuimyeo, boksujeongdangjeneun bojangdoenda.'
    ],
    [
        '국회의 정기회는 법률이 정하는 바에 의하여 매년 1회 집회되며, 국회의 임시회는 대통령 또는 국회재적의원 4분의 1 이상의 요구에 의하여 집회된다.',
        'gukhoeui jeonggihoeneun beopryuri jeonghaneun bae uihayeo maenyeon 1hoe jiphoedoemyeo, gukhoeui imsihoeneun daetongryeong ttoneun gukhoejaejeoguiwon 4bunui 1 isangui yogue uihayeo jiphoedoenda.'
    ],
    [
        '법률은 특별한 규정이 없는 한 공포한 날로부터 20일을 경과함으로써 효력을 발생한다.',
        'beopryureun teukbyeolhan gyujeongi eopsneun han gongpohan nallobuteo 20ireul gyeonggwahameurosseo hyoryeogeul balsaenghanda.'
    ],
    [
        '법관은 탄핵 또는 금고 이상의 형의 선고에 의하지 아니하고는 파면되지 아니하며, 징계처분에 의하지 아니하고는 정직·감봉 기타 불리한 처분을 받지 아니한다.',
        'beopgwaneun tanhaek ttoneun geumgo isangui hyeongui seongoe uihaji anihagoneun pamyeondoeji anihamyeo, jinggyecheobune uihaji anihagoneun jeongjik·gambong gita bullihan cheobuneul batji anihanda.'
    ],
    [
        '위백키과의 우뇽은 빏옇릷 단쳬읜 윜희믜듸어 잷닩읿 하고 있닯. 2016뇬 5월 긔준, 용어판 532맍엷 갧, 한구거판 465,238걜흘 븰호타요 300엷 언판어을 합하묜 4천만 갧 의상의 긅읿 숣롞됣얿 의쓰묘 꿃줁힓 성장하고 있닯. 윏킯밲괇읣 저자꿔는 클희예의틔브 커먼즈 라의선스와 GNU 잛윫 묹섧읣 2중 라의선슬흘 딸흔다. 듀 랇읿섡슯 몳둛 잛윫 콙텑츫릁 위한 겄읇롧 잁젛핝 욟걵읉 갅춟멵 삷욯엛 졔야글 받즤 않늕닯.',
        'wibaekkigwaui unyongeun bilpyeohrilp danchyeuin wikhuimuiduieo jaelpdanjilp hago issdalp. 2016nyon 5wol guijun, yongeopan 532manjyeolp gaelp, hangugeopan 465,238gyaelheul builhotayo 300yeolp eonpaneoeul haphamyon 4cheonman gaelp uisangui geultilp sulprokkdoelpeolp uisseumyo kkulpjunjhilp seongjanghago issdalp. wilpkilpbaekkgwalpuilp jeojakkwoneun keulhuiyeuituibeu keomeonjeu rauiseonseuwa kNU jalpyulp munjseolpuilp 2jung rauiseonseulheul ttalheunda. dyu ralpilpseonjseulp molpdulp jalpyulp konjtenjcheulpreult wihan geosseulprolp iltjeohhant yolpgeonjeult ganjchulpmyeont salpyohelp jyeyageul batjui anhneunjdalp.'
    ]
];

describe('pronunciation conversion', function () {
    for (var i in testCase) {
        it('"' + testCase[i][0] + '" should convert to "' + testCase[i][1] + '"', function () {
            assert.equal(window.jQuery.pronKorean(testCase[i][0]), testCase[i][1]);
        });
    }
});
