/*!
 * A jQuery Plugin to read magnetic cards of 1, 2 and 3 trails v1.0.0 (https://github.com/AndersonFriaca/jQuery-Magnetic-Card-Reader/)
 * See all contribuitors in https://github.com/AndersonFriaca/jQuery-Magnetic-Card-Reader/blob/master/CONTRIBUTORS.md

 * MIT License
 * Copyright (c) 2019 Anderson Friaça
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */

!function(t,i){"use strict";"function"==typeof define&&define.amd?define(["jquery"],t):"object"==typeof exports?module.exports=t(require("jquery")):t(i)}(function(o){"use strict";var n=function(t,i){this.captured={firstTrail:null,secondTrail:null,thirdTrail:null},this.element=t,this.options=i,this.parentForm=null,this.timer=null,this.timerLimit=this.options.timerLimit,this.init()};function e(t,i){return void 0===t.data("magnetic-card-reader-instance")?t.data("magnetic-card-reader-instance",new n(t,i)):t}o.extend(n.prototype,{animationOnCompleteDefault:function(){this.element.css("color",this.options.colorToShow),this.element.css("cursor","auto")},animationOnInitDefault:function(){this.element.css("color",this.options.colorToHide),this.element.css("cursor",this.options.styleCursorOnInit)},binds:function(){this.animationOnInitDefault.bind(this),this.animationOnCompleteDefault.bind(this),this.clearInformations.bind(this),this.dispatchEvent.bind(this),this.initTimeout.bind(this)},blockSubmitFormFromElement:function(){var i=this;this.parentForm.on("submit",function(t){if(void 0!==t.originalEvent&&t.originalEvent.explicitOriginalTarget===i.element.get(0))return t.preventDefault(),!1})},captureTrail:function(t,i){var n=i.match(t);return null===n||void 0===n[1]?null:n[1]},clearInformations:function(){this.captured={firstTrail:null,secondTrail:null,thirdTrail:null}},dispatchEvent:function(t,i){var n=o.Event(this.generateEventName(t));this.element.trigger(n,i)},generateEventName:function(t){return t+".magnetic-card-reader"},init:function(){this.validateOptions(),this.parentForm=this.searchParentForm(),this.binds(),this.blockSubmitFormFromElement(),this.watchEnterKey(),this.watchCompleted(),this.watchCallback()},initTimeout:function(){var t=this;null!==this.options.animationOnInit?this.options.animationOnInit():this.animationOnInitDefault(),null!==this.timer&&clearTimeout(this.timer),this.timer=setTimeout(function(){t.dispatchEvent("completed",t.captured),null!==t.options.animationOnComplete?t.options.animationOnComplete():t.animationOnCompleteDefault(),t.clearInformations()},this.timerLimit)},isColor:function(t){return/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(t)},isFunction:function(t){return t&&"[object Function]"==={}.toString.call(t)},isInputElement:function(t){return t.is("input:text")},isPressedEnterKey:function(t){return 13===t.keyCode||13===t.which},isRegExp:function(t){return null!=t&&("object"==typeof t&&"RegExp"===t.constructor.name)},searchParentForm:function(){var t=this.element.parent("form");return t.length?t:null},validateOptions:function(){if(!this.isInputElement(this.element))throw new Error("This plugin can be used only with input text");if(null===this.searchParentForm())throw new Error("Can not initialize MagneticCardReader plugin, must be have an parent form");if(null===this.options.eventKeyType||-1===o.inArray(this.options.eventKeyType,["keydown","keypress","keyup"]))throw new Error("The value of option eventKeyType must be one of: keydown, keypress or keyup");if(null===this.options.regExpSecondTrail)throw new Error("The option regExpSecondTrail must be provided");if(null!==this.options.regExpFirstTrail&&!this.isRegExp(this.options.regExpFirstTrail))throw new Error("The option regExpFirstTrail is not a RegExp");if(null!==this.options.regExpSecondTrail&&!this.isRegExp(this.options.regExpSecondTrail))throw new Error("The option regExpSecondTrail is not a RegExp");if(null!==this.options.regExpThirdTrail&&!this.isRegExp(this.options.regExpThirdTrail))throw new Error("The option regExpThirdTrail is not a RegExp");if(null===this.options.callback)throw new Error("The option callback must be provided");if(!this.isFunction(this.options.callback))throw new Error("The option callback must be a function");if(null!==this.options.buildDataFirstTrail&&!this.isFunction(this.options.buildDataFirstTrail))throw new Error("The options buildDataFirstTrail must be a function");if(null!==this.options.buildDataSecondTrail&&!this.isFunction(this.options.buildDataSecondTrail))throw new Error("The options buildDataSecondTrail must be a function");if(null!==this.options.buildDataThirdTrail&&!this.isFunction(this.options.buildDataThirdTrail))throw new Error("The options buildDataThirdTrail must be a function");if(null!==this.options.animationOnInit&&!this.isFunction(this.options.animationOnInit))throw new Error("The option animationOnInit must be a function");if(null!==this.options.animationOnComplete&&!this.isFunction(this.options.animationOnComplete))throw new Error("The option animationOnComplete must be a function");if(null===this.options.colorToHide||"string"!=typeof this.options.colorToHide||""!==this.options.colorToHide&&!this.isColor(this.options.colorToHide))throw new Error("The option colorToHide must be a valid color or empty string");if(null===this.options.colorToShow||"string"!=typeof this.options.colorToShow||""!==this.options.colorToShow&&!this.isColor(this.options.colorToShow))throw new Error("The option colorToShow must be a valid color or empty string");if(null===this.options.styleCursorOnInit||"string"!=typeof this.options.styleCursorOnInit)throw new Error("The option styleCursorOnInit must be a string");if(null===this.options.timerLimit||!/^\+?(0|[1-9]\d*)$/.test(this.options.timerLimit))throw new Error("The option timerLimit must be a number")},watchCallback:function(){this.element.on(this.generateEventName("callback"),this.options.callback)},watchCompleted:function(){var s=this;this.element.on(this.generateEventName("completed"),function(t,i){var n=null,o=null,e=null;null!==i.firstTrail&&null!==s.options.buildDataFirstTrail&&(n=s.options.buildDataFirstTrail(i.firstTrail)),null!==i.secondTrail&&null!==s.options.buildDataSecondTrail&&(o=s.options.buildDataSecondTrail(i.secondTrail)),null!==i.thirdTrail&&null!==s.options.buildDataThirdTrail&&(e=s.options.buildDataThirdTrail(i.thirdTrail));var r={captured:i.firstTrail,data:n},a={captured:i.secondTrail,data:o},l={captured:i.thirdTrail,data:e};s.dispatchEvent("callback",[r,a,l])})},watchEnterKey:function(){var o=this;this.element.on(this.options.eventKeyType,function(t){if(o.isPressedEnterKey(t)){o.initTimeout();var i=o.element.val(),n=!1;null!==o.captured.firstTrail||null===o.options.regExpFirstTrail||n||(o.captured.firstTrail=o.captureTrail(o.options.regExpFirstTrail,i),null!==o.captured.firstTrail&&(n=!0)),null!==o.captured.secondTrail||n||(o.captured.secondTrail=o.captureTrail(o.options.regExpSecondTrail,i),null!==o.captured.secondTrail&&(n=!0)),null!==o.captured.thirdTrail||null===o.options.regExpThirdTrail||n||(o.captured.thirdTrail=o.captureTrail(o.options.regExpThirdTrail,i),null!==o.captured.thirdTrail&&(n=!0)),o.element.val("")}})}}),o.fn.magneticCardReader=function(t){return t=o.extend({},o.magneticCardReader.defaultOptions,t),this.each(function(){return e(o(this),t)})},o.magneticCardReader=function(t,i){return i=o.extend({},o.magneticCardReader.defaultOptions,i),o(t).each(function(){return e(o(this),i)})},o.magneticCardReader.defaultOptions={animationOnInit:null,animationOnComplete:null,buildDataFirstTrail:null,buildDataSecondTrail:null,buildDataThirdTrail:null,callback:null,colorToHide:"#FFF",colorToShow:"",eventKeyType:"keydown",regExpFirstTrail:null,regExpSecondTrail:null,regExpThirdTrail:null,styleCursorOnInit:"wait",timerLimit:200}},window.jQuery);