# PowerTip

PowerTip is a jQuery tooltip plugin with some advanced features like **hover intent testing**, **tooltip queueing**, and **support for complex data**. It also has that rarest of features in jQuery plugins, it's not abandonware.

[![Build Status](https://travis-ci.org/stevenbenner/jquery-powertip.svg?branch=master)](https://travis-ci.org/stevenbenner/jquery-powertip)
[![Dependency Status](https://gemnasium.com/stevenbenner/jquery-powertip.svg)](https://gemnasium.com/stevenbenner/jquery-powertip)
[![Release Version](http://img.shields.io/github/release/stevenbenner/jquery-powertip.svg)][projectpage]

## Getting Started

* Download the latest stable release from the [PowerTip web site][projectpage].
* Add the JavaScript and CSS file references to your web site.
* Add a title or data-powertip attribute to the elements you want to show tooltips for.
* Run the `powerTip()` method on those elements.

## Documentation

You can find the documentation for the **latest release version** on the [PowerTip web site][projectpage]. You will find the documentation for the **latest in-development version** in the [doc folder][docs] in this repository.

[projectpage]: http://stevenbenner.github.io/jquery-powertip/
[docs]: https://github.com/stevenbenner/jquery-powertip/tree/master/doc

## Reporting Bugs

For bug reports, questions, feature requests, or other suggestions the best way to contact me is to [create an issue][newissue] on GitHub. If you don't want to use GitHub please feel free to contact me via twitter at [@stevenbenner][twitter]. As with all open source projects: pull request > bug report > tweet.

[newissue]: https://github.com/stevenbenner/jquery-powertip/issues/new
[twitter]: https://twitter.com/stevenbenner

## Contributor Guide

Make PowerTip better! Join the [league of awesome][contributors] today by submitting a patch! The best way to submit patches is to [fork this project][fork] on GitHub and submit a pull request. But if you are unwilling or unable to use GitHub I will accept patches in any way you can get them to me (jsFiddle, pastebin, text file, whatever).

[contributors]: https://github.com/stevenbenner/jquery-powertip/graphs/contributors
[fork]: https://github.com/stevenbenner/jquery-powertip/fork

### Style Guide

These are general guidelines, not rules. I won't refuse a pull request just because it isn't the style that I use.

* Style guide: In general, follow the [Google JavaScript Style Guide][styleguide].
* Line wrap: Soft-wrap at 80 characters (go further if wrapping makes code less readable).
* Indentation: Use tabs for indentation.
* JSDoc comments: Use [closure compiler annotations][jsdoc].
* Method chaining: Avoid long chained method statements, two or three max.

[styleguide]: https://google-styleguide.googlecode.com/svn/trunk/javascriptguide.xml
[jsdoc]: https://developers.google.com/closure/compiler/docs/js-for-compiler

## License

*(This project is released under the [MIT license](https://raw.github.com/stevenbenner/jquery-powertip/master/LICENSE.txt).)*

Copyright (c) 2014 Steven Benner (http://stevenbenner.com/)

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
