/*jshint curly:true, eqeqeq:true, laxbreak:true, noempty:false */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2017 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/

function InputScanner(input) {
  var _input = input || '';
  var _input_length = _input.length;
  var _position = 0;

  this.back = function() {
    _position -= 1;
  };

  this.hasNext = function() {
    return _position < _input_length;
  };

  this.next = function() {
    var val = null;
    if (this.hasNext()) {
      val = _input.charAt(_position);
      _position += 1;
    }
    return val;
  };

  this.peek = function(index) {
    var val = null;
    index = index || 0;
    index += _position;
    if (index >= 0 && index < _input_length) {
      val = _input.charAt(index);
    }
    return val;
  };

  this.peekCharCode = function(index) {
    var val = 0;
    index = index || 0;
    index += _position;
    if (index >= 0 && index < _input_length) {
      val = _input.charCodeAt(index);
    }
    return val;
  };

  this.test = function(pattern, index) {
    index = index || 0;
    pattern.lastIndex = _position + index;
    return pattern.test(_input);
  };

  this.testChar = function(pattern, index) {
    var val = this.peek(index);
    return val !== null && pattern.test(val);
  };

  this.match = function(pattern) {
    pattern.lastIndex = _position;
    var pattern_match = pattern.exec(_input);
    if (pattern_match && pattern_match.index === _position) {
      _position += pattern_match[0].length;
    } else {
      pattern_match = null;
    }
    return pattern_match;
  };
}


module.exports.InputScanner = InputScanner;