/**
 * pbkdf
 */
import { HashTypes } from './params';
/**
 * Password-based key derivation function 2.
 * Detailed specification is given in RFC8018 Section 5.2 {@link https://tools.ietf.org/html/rfc8018#section-5.2}.
 * @param {Uint8Array|String} p - Byte array or string of password. if string is given, it will be converted to Uint8Array.
 * @param {Uint8Array} s - Byte array of salt.
 * @param {Number} c - Iteration count.
 * @param {Number} dkLen - Intended output key length in octet.
 * @param {String} hash - Name of underlying hash function for HMAC like 'SHA-256', used as a pseudorandom function.
 * @return {Promise<Uint8Array>} - Derived key.
 * @throws {Error} - Throws if the intended key length is too long.
 */
export declare const pbkdf2: (p: string | Uint8Array, s: Uint8Array, c: number, dkLen: number, hash: HashTypes) => Promise<Uint8Array>;
/**
 * Password-based key derivation function 1.
 * Detailed specification is given in RFC8018 Section 5.1 {@link https://tools.ietf.org/html/rfc8018#section-5.1}.
 * @param {Uint8Array|String} p - Byte array or string of password. if string is given, it will be converted to Uint8Array.
 * @param {Uint8Array} s - Byte array of salt.
 * @param {Number} c - Iteration count.
 * @param {Number} dkLen - Intended output key length in octet.
 * @param {String} hash - Name of underlying hash function for HMAC like 'SHA-256'
 * @return {Promise<Uint8Array>} - Derived key.
 * @throws {Error} - Throws if the intended key length is too long.
 */
export declare const pbkdf1: (p: string | Uint8Array, s: Uint8Array, c: number, dkLen: number, hash: HashTypes) => Promise<Uint8Array>;
