"use strict";
/**
 * pbkdf
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.pbkdf1 = exports.pbkdf2 = void 0;
var js_encoding_utils_1 = __importDefault(require("js-encoding-utils"));
var js_crypto_hash_1 = __importDefault(require("js-crypto-hash"));
var js_crypto_hmac_1 = __importDefault(require("js-crypto-hmac"));
var params_1 = __importDefault(require("./params"));
/**
 * Password-based key derivation function 2.
 * Detailed specification is given in RFC8018 Section 5.2 {@link https://tools.ietf.org/html/rfc8018#section-5.2}.
 * @param {Uint8Array|String} p - Byte array or string of password. if string is given, it will be converted to Uint8Array.
 * @param {Uint8Array} s - Byte array of salt.
 * @param {Number} c - Iteration count.
 * @param {Number} dkLen - Intended output key length in octet.
 * @param {String} hash - Name of underlying hash function for HMAC like 'SHA-256', used as a pseudorandom function.
 * @return {Promise<Uint8Array>} - Derived key.
 * @throws {Error} - Throws if the intended key length is too long.
 */
exports.pbkdf2 = function (p, s, c, dkLen, hash) { return __awaiter(void 0, void 0, void 0, function () {
    var uintP, hLen, l, r, funcF, Tis, DK, i, TisResolved;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (c <= 0)
                    throw new Error('InvalidIterationCount');
                if (dkLen <= 0)
                    throw new Error('InvalidDerivedKeyLength');
                uintP = (typeof p === 'string') ? js_encoding_utils_1.default.encoder.stringToArrayBuffer(p) : p;
                hLen = params_1.default.hashes[hash].hashSize;
                if (dkLen > (Math.pow(2, 32) - 1) * hLen)
                    throw new Error('DerivedKeyTooLong');
                l = Math.ceil(dkLen / hLen);
                r = dkLen - (l - 1) * hLen;
                funcF = function (i) { return __awaiter(void 0, void 0, void 0, function () {
                    var seed, u, outputF, j;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                seed = new Uint8Array(s.length + 4);
                                seed.set(s);
                                seed.set(nwbo(i + 1, 4), s.length);
                                return [4 /*yield*/, js_crypto_hmac_1.default.compute(uintP, seed, hash)];
                            case 1:
                                u = _a.sent();
                                outputF = new Uint8Array(u);
                                j = 1;
                                _a.label = 2;
                            case 2:
                                if (!(j < c)) return [3 /*break*/, 5];
                                return [4 /*yield*/, js_crypto_hmac_1.default.compute(uintP, u, hash)];
                            case 3:
                                u = _a.sent();
                                outputF = u.map(function (elem, idx) { return elem ^ outputF[idx]; });
                                _a.label = 4;
                            case 4:
                                j++;
                                return [3 /*break*/, 2];
                            case 5: return [2 /*return*/, { index: i, value: outputF }];
                        }
                    });
                }); };
                Tis = [];
                DK = new Uint8Array(dkLen);
                for (i = 0; i < l; i++)
                    Tis.push(funcF(i));
                return [4 /*yield*/, Promise.all(Tis)];
            case 1:
                TisResolved = _a.sent();
                TisResolved.forEach(function (elem) {
                    if (elem.index !== l - 1)
                        DK.set(elem.value, elem.index * hLen);
                    else
                        DK.set(elem.value.slice(0, r), elem.index * hLen);
                });
                return [2 /*return*/, DK];
        }
    });
}); };
// network byte order
var nwbo = function (num, len) {
    var arr = new Uint8Array(len);
    for (var i = 0; i < len; i++)
        arr[i] = 0xFF && (num >> ((len - i - 1) * 8));
    return arr;
};
/**
 * Password-based key derivation function 1.
 * Detailed specification is given in RFC8018 Section 5.1 {@link https://tools.ietf.org/html/rfc8018#section-5.1}.
 * @param {Uint8Array|String} p - Byte array or string of password. if string is given, it will be converted to Uint8Array.
 * @param {Uint8Array} s - Byte array of salt.
 * @param {Number} c - Iteration count.
 * @param {Number} dkLen - Intended output key length in octet.
 * @param {String} hash - Name of underlying hash function for HMAC like 'SHA-256'
 * @return {Promise<Uint8Array>} - Derived key.
 * @throws {Error} - Throws if the intended key length is too long.
 */
exports.pbkdf1 = function (p, s, c, dkLen, hash) { return __awaiter(void 0, void 0, void 0, function () {
    var seed, i;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (c <= 0)
                    throw new Error('InvalidIterationCount');
                if (dkLen <= 0)
                    throw new Error('InvalidDerivedKeyLength');
                if (typeof p === 'string')
                    p = js_encoding_utils_1.default.encoder.stringToArrayBuffer(p);
                if (dkLen > params_1.default.hashes[hash].hashSize)
                    throw new Error('DerivedKeyTooLong');
                seed = new Uint8Array(p.length + s.length);
                seed.set(p);
                seed.set(s, p.length);
                i = 0;
                _a.label = 1;
            case 1:
                if (!(i < c)) return [3 /*break*/, 4];
                return [4 /*yield*/, js_crypto_hash_1.default.compute(seed, hash)];
            case 2:
                seed = _a.sent();
                _a.label = 3;
            case 3:
                i++;
                return [3 /*break*/, 1];
            case 4: return [2 /*return*/, seed.slice(0, dkLen)];
        }
    });
}); };
//# sourceMappingURL=pbkdf.js.map