/**
 * random.js
 */
/**
 * Secure random string generator based on getRandomBytes,
 * which is composed of uppercase or lowercase alphanumeric characters;
 * @param {Number} len - Length of string.
 * @return {String} - Generated random ASCII string.
 */
export declare const getRandomString: (len: number) => string;
/**
 * Secure random 'ASCII' string generator based on getRandomBytes;
 * @param {Number} len - Length of ASCII string.
 * @return {String} - Generated random ASCII string.
 */
export declare const getRandomAsciiString: (len: number) => string;
/**
 * Secure random string generator based on getRandomBytes,
 * which is composed of givin character candidates;
 * @param {Number} len - Length of string.
 * @param {String} candidates - Candidates string to sample randomly.
 * @return {String} - Generated random string.
 */
export declare const getRandomSampledString: (len: number, candidates: string) => string;
/**
 * Secure random generator that returns a byte array filled with cryptographically secure random bytes
 * @param {Number} len - Byte length of random sequence.
 * @return {Uint8Array} - Generated random sequence.
 * @throws {Error} - Throws if UnsupportedEnvironment.
 */
export declare const getRandomBytes: (len: number) => Uint8Array;
